<?php
namespace App\Http\Controllers\Api\AdminDashboard\Violation;

use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\Violation\GradeViolationStoreRequest;
use App\Http\Requests\Violation\GradeViolationUpdateRequest;
use App\Models\GradeViolation;
use App\Http\Resources\Violation\GradeViolationResource;
use App\Traits\LogsActivity;
use Helper;

class GradeViolationController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:violationGrades']);
    }


    /* this method will stord data to DB Model*/
    public function store(GradeViolationStoreRequest $request){
        $grade_violation = GradeViolation::create(['name'=> $request->name, 'violation_id' => $request->violation_category_id]);
        $this->AdminlogActivity('GradeViolation', 'store', '/violations/grade/' . $grade_violation->id);

        return response()->json(['message'=>trans('api.record stored successflly') ]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(GradeViolationUpdateRequest $request,$id){
        GradeViolation::findOrFail($id)->update($request->all());
        $this->AdminlogActivity('GradeViolation', 'update', '/violations/grade/' . $id);
        return response()->json(['message'=>trans('api.record updated successflly') ]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id){
        GradeViolation::findOrFail($id)->delete();
        $this->AdminlogActivity('GradeViolation', 'archive');
        return response()->json(['message'=>trans('api.record archived successflly') ]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id){
        GradeViolation::findOrFail($id)->forceDelete();
        $this->AdminlogActivity('GradeViolation', 'delete');
        return response()->json(['message'=>trans('api.record deleted successflly') ]);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id){
        GradeViolation::withTrashed()->findOrFail($id)->restore();
        $this->AdminlogActivity('GradeViolation', 'restore');
        return response()->json(['message'=>trans('api.record restored successflly') ]);
    }
    
}