<?php

namespace App\Http\Controllers\Api\AdminDashboard\Marketing;

use App\Exports\StudentExport;
use App\Http\Controllers\Controller;
use App\Http\Resources\School\SchoolStudentResource;
use JWTAuth;

use Illuminate\Http\Request;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\Student;

use App\Helpers\Helper;
use App\Traits\LogsActivity;
use Maatwebsite\Excel\Facades\Excel;


class MarketingController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api',,'permission:marketing']);
    }

    /** fundtion return all schools students */
    public function getAll(Request $request){

        // Start with the base query
        $data = Student::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\Student', $queryParams);
        }
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolStudentResource::collection($data->paginate($perPage));
        
        return response()->json(['students' => $filterData, 'message' => trans('api.list of all available records')]);
    }

    /** fundtion return all schools students */
    public function filterStudentsData(Request $request){
        $data = Student::query();

        /** filter by school city ids */
        if($request->city_ids){
            $city_ids = explode(",", $request->city_ids);
            $schoolIds = School::whereIn('city_id',$city_ids)->pluck('id')->toArray();
            $filterData = $data->whereIn('school_id',$schoolIds);
        }

        /** filter by school  */
        if($request->school_id){
            $filterData = $data->where('school_id',$request->school_id);
        }

        /** filter by grade  */
        if($request->grade_id){
            $schoolIds = School::where('grade_id',$request->grade_id)->pluck('id')->toArray();
            $filterData = $data->whereIn('school_id',$schoolIds);
        }

        /** filter by class name  */
        if($request->class_name_id){
        }

        /** filter by nationality */
        if($request->nationality){
            $filterData = $data->where('nationality', 'like', "%$request->nationality%");
        }

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolStudentResource::collection($filterData->paginate($perPage));

        return response()->json(['students' => $filterData, 'message' => trans('api.list of all available records')]);
    }

    public function exportStudents(Request $request){
        $startDate = $request->input('start_date'); 
        $endDate = $request->input('end_date');
    
        /** if we need to save file  */

        /*$fileName = 'marketing_students_' . time() . '.xlsx';
        Excel::store(new StudentExport($startDate, $endDate), 'exports/' . $fileName, 'public');
        $fileUrl = asset('public/storage/exports/' . $fileName);
        return response()->json([
            'file_url' => $fileUrl
        ]); */

        /** download file direct */
        return Excel::download(new StudentExport($startDate, $endDate), 'users.xlsx', \Maatwebsite\Excel\Excel::XLSX, [
            'Content-Disposition' => 'attachment; filename="marketing_students_' . time() . '.xlsx"',
        ]);
    }

}
