<?php

namespace App\Http\Controllers\Api\AdminDashboard\Logs;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\AdminDashboard\Logs\LogResource;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Mockery\Undefined;
use Spatie\Activitylog\Models\Activity;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class LogsController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:logs']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request)
    {
     
        // Start with the base query
        $data = Activity::with('causer')->whereNull('properties->school_id')->orderBy('created_at','Desc');
        $queryParams = $request->query();

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        if (isset($queryParams['date_type']) && isset($queryParams['date'])) {
            $date = $queryParams['date'];

            if ($queryParams['date_type'] == "hijri") {
                $date = Helper::getCoptic($queryParams['date']);
            }
            $date = Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d');
            $data = $data->where('created_at', 'like', "%$date%");
        }

        $filterData = LogResource::collection($data->paginate($perPage));
        return response()->json([
            'logs' => $filterData,
            'message' => 'logs_data',
        ]);
    }



    public function delete(Request $request)
    {
        $logs = Activity::whereIn('id',$request->ids)->get();
        if(count($logs)==0){
            return response()->json(['message' => trans('api.no data found to this id')], 404);
        }
        $logs->each->delete();
        return response()->json(['message' => trans('api.record deleted successflly')]);

    }
}
