<?php
namespace App\Http\Controllers\Api\AdminDashboard\Barcode;

use App\Http\Controllers\Controller;
use App\Http\Requests\Barcode\BarcodeUpdateRequest;

use Illuminate\Http\Request;
use App\Models\Barcode;
use App\Traits\LogsActivity;

class BarcodeController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify','permission:barcode']);
    }

    public function getAll(Request $request){
        $data = Barcode::first();
        return response()->json([
            'data' => ['link'=> $data->link],
            'message' => trans('api.list of all available records'),
        ]);
    }

    public function update(BarcodeUpdateRequest $request){

        Barcode::first()->update($request->all());
        $this->AdminlogActivity('BarCode', 'update', '/barcode/get-barcode');
        return response()->json(['message'=>trans('api.record updated successflly') ]);

    }
    
}