<?php

namespace App\Helpers;

use File;
use Image;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
use Alkoumi\LaravelHijriDate\Hijri;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use App\Models\Page;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class Helper
{
    public static function uploadedFilesPath($model, $file)
    {
        return url("public/uploads/$model/files/$file");
    }

    public static function uploadedImagesPath($model, $image)
    {
        return url('public/uploads/' . $model . '/' . $image, false);
    }


    public static function uploadImage($model, $image)
    {
        if ($image) {
            $extension = pathinfo($image->getClientOriginalName(), PATHINFO_EXTENSION);
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

            $path = public_path("uploads/$model/");

            $manager = new ImageManager(new Driver());

            $image = $manager->read($image);

            $image->save($path . $fileName);

            return  $fileName;
        } else {
            return NULL;
        }
    }

    public static function removeImage($imagePath)
    {
        if (file_exists($imagePath)) {
            unlink($imagePath);
        }
    }

    public static function updateUploadedImage($model, $image, $oldImage)
    {
        if ($image) {
            // Remove the old image
            $oldImagePath = url("uploads/$model/$oldImage");
            if ($oldImage && file_exists($oldImagePath)) {
                unlink($oldImagePath);
            }
            $extension = pathinfo($image->getClientOriginalName(), PATHINFO_EXTENSION);
            $fileName = rand(11111, 99999) . '.' . $extension; // renaming image
            $path = public_path("uploads/$model/$fileName");
            $manager = new ImageManager(new Driver());
            $image = $manager->read($image);
            $image->save($path);
            return $fileName;
        } else {
            return null;
        }
    }

    public static function uploadFile($model, $file)
    {
        if ($file) {
            $size = round($file->getSize() / (1024 * 1024), 2);
            $extension = pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION);
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing file
            $path = public_path("uploads/$model/files/");
            $file->move($path, $fileName);
            return ['file_name' => $fileName, 'file_size' => $size];
        } else {
            return NULL;
        }
    }

    public static function updateUploadFile($model, $file, $oldFile)
    {
        if ($file) {
            ///////remove the old image///////
            
            $oldFile ? $oldFile = $path = public_path() . "/uploads/$model/files/" . $oldFile : $oldFile = null;
            if (file_exists($oldFile)) {
                unlink($oldFile);
            }
            $size = round($file->getSize() / (1024 * 1024), 2);
            $extension = pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION);
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing file
            $path = public_path("uploads/$model/files/");
            $file->move($path, $fileName);
            return ['file_name' => $fileName, 'file_size' => $size];
        } else {
            return NULL;
        }
    }



    public static function numberToWord($number, $lang = 'ar')
    {
        $words = [
            'ar' => [
                'ones' => [
                    1 => 'الأول',
                    2 => 'الثاني',
                    3 => 'الثالث',
                    4 => 'الرابع',
                    5 => 'الخامس',
                    6 => 'السادس',
                    7 => 'السابع',
                    8 => 'الثامن',
                    9 => 'التاسع',
                    10 => 'العاشر'
                ],
                'teens' => [
                    11 => 'الحادي عشر',
                    12 => 'الثاني عشر',
                    13 => 'الثالث عشر',
                    14 => 'الرابع عشر',
                    15 => 'الخامس عشر',
                    16 => 'السادس عشر',
                    17 => 'السابع عشر',
                    18 => 'الثامن عشر',
                    19 => 'التاسع عشر'
                ],
                'tens' => [
                    20 => 'العشرون',
                    30 => 'الثلاثون',
                    40 => 'الأربعون',
                    50 => 'الخمسون',
                    60 => 'الستون',
                    70 => 'السبعون',
                    80 => 'الثمانون',
                    90 => 'التسعون'
                ],
                'and' => ' و'
            ],
            'en' => [
                'ones' => [
                    1 => 'first',
                    2 => 'second',
                    3 => 'third',
                    4 => 'fourth',
                    5 => 'fifth',
                    6 => 'sixth',
                    7 => 'seventh',
                    8 => 'eighth',
                    9 => 'ninth',
                    10 => 'tenth'
                ],
                'teens' => [
                    11 => 'eleventh',
                    12 => 'twelfth',
                    13 => 'thirteenth',
                    14 => 'fourteenth',
                    15 => 'fifteenth',
                    16 => 'sixteenth',
                    17 => 'seventeenth',
                    18 => 'eighteenth',
                    19 => 'nineteenth'
                ],
                'tens' => [
                    20 => 'twentieth',
                    30 => 'thirtieth',
                    40 => 'fortieth',
                    50 => 'fiftieth',
                    60 => 'sixtieth',
                    70 => 'seventieth',
                    80 => 'eightieth',
                    90 => 'ninetieth'
                ],
                'and' => ' and '
            ]
        ];

        if ($number <= 10) {
            return $words[$lang]['ones'][$number];
        } elseif ($number < 20) {
            return $words[$lang]['teens'][$number];
        } else {
            $ten = floor($number / 10) * 10;
            $one = $number % 10;
            if ($one == 0) {
                return $words[$lang]['tens'][$ten];
            } else {
                return $words[$lang]['tens'][$ten] . $words[$lang]['and'] . $words[$lang]['ones'][$one];
            }
        }
    }
    /**  العام الدرراسي الحالي */
    public static function getSchoolYear()
    {
        $currentHijriYear = Hijri::Date('Y');
        $nextHijriYear = $currentHijriYear + 1;
        $schoolYear = $currentHijriYear . '-' . $nextHijriYear;
        return $schoolYear;
    }
    // $type is what date you send 
    public static function getDateOptions($date, $type)
    {
        list($day, $month, $year) = explode('/', $date);
        if ($type == "hijri") {
            // Convert Hijri date to coptic
            $coptic = Hijri::DateToGregorianFromDMY((int)$day, (int)$month, (int)$year);
            $coptic = Carbon::createFromFormat('Y/m/d', $coptic)->format('d/m/Y');
            return ['coptic' => $coptic, 'hijri' => $date];
        } else {
            // // Convert coptic date to Hijri
            $hijri = Hijri::DateFromGregorianDMY((int)$day, (int)$month, (int)$year);
            $westernHijri = static::convertArabicToWesternNumerals($hijri);
            $hijriParts = explode('/', str_replace(['هـ', ' '], '', $westernHijri)); // Remove "هـ" and any spaces
            $hijriFormatted = sprintf("%02d/%02d/%04d", (int)$hijriParts[2], (int)$hijriParts[1], (int)$hijriParts[0]);
            return  ['coptic' => $date, 'hijri' => $hijriFormatted];
        }
    }
    // convert to coptic
    public static function getCoptic($date)
    {
        list($day, $month, $year) = explode('/', $date);
        // Convert Hijri date to coptic
        $coptic = Hijri::DateToGregorianFromDMY((int)$day, (int)$month, (int)$year);
        $coptic = Carbon::createFromFormat('Y/m/d', $coptic)->format('d/m/Y');
        return  $coptic;
    }

    public static function filterData($modelName, array $filterData, array $with = [])
    {
        $excludedParams = ['page', 'per_page', 'date_type', 'date'];
        $query = $modelName::query();
        if (!empty($with)) {
            $query->with($with);
        }
        $columns = Schema::getColumnListing((new $modelName)->getTable());

        foreach ($filterData as $attr => $value) {
            if (in_array($attr, $excludedParams)) {
                continue;
            }
            if (! in_array($attr, $columns)) {
                throw new \InvalidArgumentException("Attribute '{$attr}' does not exist in the table.");
            }

            if (is_array($value)) {
                $query->whereIn($attr, $value);
            } else {
                $query->where($attr, 'like', "%$value%");
            }
        }
        return $query;
    }

    public static function saveSemesterWeekDays($semesterId, $startDate, $endDate){
        
        $start = Carbon::createFromFormat('d/m/Y', $startDate);
        $end = Carbon::createFromFormat('d/m/Y', $endDate);
        
        // Loop through the 13 weeks
        for ($week = 1; $week <= 13; $week++) {
            // Loop through the 5 days (Sunday to Thursday)
            for ($day = 1; $day <= 5; $day++) {
                // Calculate the day date
                $currentDay = $start->copy()->addWeeks($week - 1)->addDays($day - 1);
    
                // Ensure the day is within the semester period
                if ($currentDay->greaterThan($end)) {
                    break;
                }
    
                // Save the data to the database
                DB::table('semester_week_days')->insert([
                    'semester_id' => $semesterId,
                    'week_id' => $week,
                    'day_id' => $day, // 1: Sunday, 2: Monday, ..., 5: Thursday
                    'date' => $currentDay->format('d/m/Y'),
                    'date_type' => 'coptic', // Adjust as needed
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }

    public static function saveShiftSchedules($semesterId, $startDate, $endDate){
        
        $start = Carbon::createFromFormat('d/m/Y', $startDate);
        $end = Carbon::createFromFormat('d/m/Y', $endDate);
    
        // Loop through the 13 weeks to add shifts tables
        for ($week = 1; $week <= 13; $week++) {
            // Save the data to the database
            DB::table('shift_schedules')->insert([
                'semester_id' => $semesterId,
                'week_id' => $week,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $shiftSchedules = ShiftSchedule::get();
        
        foreach($shiftSchedules as $shiftSchedule){
         
            $weekDays= SemesterWeekDay::where('semester_id',$shiftSchedule->semester_id)->where('week_id',$shiftSchedule->week_id)->get();
            foreach($weekDays as $weekDay){
                DB::table('shift_schedule_days')->insert([
                    'shift_schedule_id' => $shiftSchedule->id,
                    'semester_week_day_id' => $weekDay->id,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
    
    public static function saveTeacherSchedules($schoolId){
        $schoolSemesters = SchoolSemester::get();
        $school = School::findOrFail($schoolId);
        $classes = SchoolClass::where('school_id',$school->id)->get();

        foreach($schoolSemesters as $schoolSemester){
            foreach($classes as $class){
                // Save the data to the database
                DB::table('teacher_schedules')->insert([
                    'school_id' => $schoolId,
                    'semester_id' => $schoolSemester->id,
                    'school_class_id' =>$class->id,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }

    public static function saveSupervisionSchedules($schoolId){
        $schoolSemesters = SchoolSemester::get();
        foreach($schoolSemesters as $schoolSemester){
            // Save the data to the database
            DB::table('supervision_schedules')->insert([
                'title' => 'جدول الأشراف الأسبوعي',
                'school_id' => $schoolId,
                'semester_id' => $schoolSemester->id,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    private static function convertArabicToWesternNumerals($arabicNumber)
    {
        $westernNumbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        $arabicNumbers = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];

        return str_replace($arabicNumbers, $westernNumbers, $arabicNumber);
    }

    public static function getCurrentSchoolSemester(){
        
    }
}
