<?php
namespace App\Exports;

use App\Models\AdminDashboard\School\Student;
use Maatwebsite\Excel\Concerns\FromCollection;

class StudentExport implements FromCollection
{
    protected $startDate;
    protected $endDate;

    public function __construct($startDate = null, $endDate = null){
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    /**
     * Return data from the users table based on conditions.
     *
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        // Build query with optional conditions
        $query = Student::query();

        if (!is_null($this->startDate) && !is_null($this->endDate)) {
            $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
        }

        // Execute the query and return the result
        return $query->get();
    }
}
