

<?php $__env->startSection('title', 'Statistics | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Statistics'); ?>


<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-between mb-3">

        <span class="mb-0 me-1">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?>

                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.patient.index')); ?>"><?php echo e(__('basic.patients')); ?> | </a>
            <a class="text-gray-300"><?php echo e(__('patientappo.patients statistics')); ?></a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">

            <a class="main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                data-bs-target="#new_record"><i class="fas fa-filter fa-sm me-1"></i> Filter</a>

            <!-- Modal for search filtering -->
            <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.pat_allstatcs')); ?>" method="GET"
                        style="display: contents">

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                                    Search Filter</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Branch
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="branch" name="branch">
                                            <option value="all">
                                                All
                                            </option>
                                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php if($branch==$item->id): ?> selected <?php endif; ?>
                                                <?php if($branch == $item->id): ?> selected <?php endif; ?>>
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Type
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="type" name="type">
                                            <option value="all">
                                                All Patients
                                            </option>
                                            <option value="1">
                                                Real patients
                                            </option>
                                            <option value="2">
                                                All leads
                                            </option>
                                            <option value="3">
                                                All leads (Interested)
                                            </option>
                                            <option value="4">
                                                All leads (Not Interested)
                                            </option>
                                            <option value="5">
                                                <?php echo e(__('basic.vip patients')); ?>

                                            </option>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">From
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="from" type="text" class="form-control hasdatetimepicker"
                                                value="<?php echo e($from); ?>" placeholder="YYYY/MM">
                                        </div>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">To
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="to" type="text" class="form-control hasdatetimepicker"
                                                value="<?php echo e($to); ?>" placeholder="YYYY/MM">
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>

    </div>

    <div class="row">

        <div class="col-12">
            <div class="card card-input shadow mb-3 pb-3">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-chart-bar me-1"></i>
                        <?php echo e(__('patientappo.patients statistics')); ?></h6>
                </div>

                <!-- Card Body -->
                <div class="card-body">

                    <ul class="nav nav-tabs mb-5" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="patient-tab" data-bs-toggle="tab"
                                data-bs-target="#patient" type="button" role="tab" aria-controls="patient"
                                aria-selected="true" class="text-gray-500"><i class="fas fa-user me-1"></i>
                                <?php echo e(__('patientappo.total patients')); ?></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                                type="button" role="tab" aria-controls="branches" aria-selected="false"
                                class="main-color"><i class="fas fa-globe-americas me-1"></i>
                                Branches</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="home-tab" data-bs-toggle="tab" data-bs-target="#home"
                                type="button" role="tab" aria-controls="home" aria-selected="true"
                                class="text-gray-500"><i class="fas fa-user me-1"></i>
                                <?php echo e(__('patientappo.gender resource')); ?></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="country-tab" data-bs-toggle="tab" data-bs-target="#country"
                                type="button" role="tab" aria-controls="country" aria-selected="false"
                                class="main-color"><i class="fas fa-globe-americas me-1"></i>
                                <?php echo e(__('patientappo.country city')); ?></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="examinations-tab" data-bs-toggle="tab"
                                data-bs-target="#examinations-treatment" type="button" role="tab"
                                aria-controls="examinations-treatment" aria-selected="false" class="main-color"><i
                                    class="fas fa-stethoscope me-1"></i>
                                Examinations | Treatment | Medicines</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="text-gray-300" href="<?php echo e(route('sett.pat_show_all_patients')); ?>">
                                <button class="nav-link" id="examinations-tab" type="button" role="tab"
                                    aria-controls="examinations-treatment" aria-selected="false" class="main-color"><i
                                        class="fas fa-users me-1"></i>
                                    Smart Search</button></a>
                        </li>
                    </ul>

                    <div class="tab-content" id="myTabContent">


                        <div class="tab-pane fade show active" id="patient" role="tabpanel" aria-labelledby="patient">

                            <div class="row mb-1 justify-content-center">

                                <div class="col-12 mb-5">
                                    <div>
                                        <div class="text-center small">
                                            <span class="me-2">
                                                <i class="fas fa-circle text-success"></i> <?php echo e(__('basic.patients')); ?>

                                            </span>
                                        </div>

                                        <canvas id="myChart-patient">
                                            <!-- the code and its style is printed from js -->

                                        </canvas>
                                    </div>
                                </div>

                                <div class="col-12 my-2 text-center">
                                    <div class="row">
                                        <div class="col-12 col-md-6 border-flex mb-3">
                                            <h5 class="text-center text-gray-300">
                                                Patient Per Branch <?php if($from !== 'all'): ?>
                                                in the given date
                                                <?php endif; ?>
                                            </h5>
                                            <div class="chart-pie px-1 pb-3">
                                                <canvas id="each_branch">
                                                    <!-- the code and its style is printed from js -->
                                                </canvas>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 align-self-center">
                                            <h6 class="text-gray-400">Total Patient <?php if($from !== 'all'): ?>
                                                in the given date
                                                <?php endif; ?>
                                            </h6>
                                            <span class="fs-1"><?php echo e($patient_total); ?><small
                                                    class="text-gray-300 text-xxxs">
                                                    <?php echo e(__('basic.patients')); ?></small></span>
                                        </div>
                                    </div>


                                </div>

                            </div>

                        </div>


                        <div class="tab-pane fade" id="branches" role="tabpanel" aria-labelledby="branches-tab">

                            <div class="row mb-2">

                                <div class="col-12 mb-5">
                                    <div>
                                        <canvas id="branches_line">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>

                            </div>
                        </div>


                        <div class="tab-pane fade" id="home" role="tabpanel" aria-labelledby="home-tab">

                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300"><?php echo e(__('patientappo.patient by gender')); ?>

                                        <?php if($from !== 'all'): ?>
                                        in the given date
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <h5 class="text-center text-gray-300"><?php echo e(__('patientappo.patient by resource')); ?>

                                        <?php if($from !== 'all'): ?>
                                        in the given date
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1">
                                        <canvas id="myChart-resource">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade" id="country" role="tabpanel" aria-labelledby="country-tab">

                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300"><?php echo e(__('patientappo.patient by country')); ?>

                                        <?php if($from !== 'all'): ?>
                                        in the given date
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-country">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <h5 class="text-center text-gray-300"><?php echo e(__('patientappo.patient by city')); ?>

                                        <?php if($from !== 'all'): ?>
                                        in the given date
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1">
                                        <canvas id="myChart-city">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade" id="examinations-treatment" role="tabpanel"
                            aria-labelledby="examinations-tab">

                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">Most Examination | Diseases <?php if($from !==
                                        'all'): ?>
                                        in the given date
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-examination">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <h5 class="text-center text-gray-300">Most Treatments <?php if($from !== 'all'): ?>
                                        in the given date
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1">
                                        <canvas id="myChart-treatment">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">Most Medicines <?php if($from !== 'all'): ?>
                                        in the given date
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-medicine">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <h5 class="text-center text-gray-300">Most Pulses <?php if($from !== 'all'): ?>
                                        in the given date
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-pulses">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>


    </div>



    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>


    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {

                $(".myselect2-record-insert").select2({
                    dropdownParent: $("#new_record")
                });

                //hide search
                $('.myselect2-record-insert-nosearch').select2({
                    dropdownParent: $("#new_record"),
                    minimumResultsForSearch: -1
                });

            })
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "mm-yyyy",
                    viewMode: "months",
                    minViewMode: "months",
                    autoclose: true,
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>
    <?php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2'];
    ?>
    <script>
        const actions = [{
                    name: 'Randomize',
                    handler(chart) {
                        chart.data.datasets.forEach(dataset => {
                            dataset.data = Utils.numbers({
                                count: chart.data.labels.length,
                                min: -100,
                                max: 100
                            });
                        });
                        chart.update();
                    }
                },
                {
                    name: 'Add Dataset',
                    handler(chart) {
                        const data = chart.data;
                        const dsColor = Utils.namedColor(chart.data.datasets.length);
                        const newDataset = {
                            label: 'Dataset ' + (data.datasets.length + 1),
                            backgroundColor: Utils.transparentize(dsColor, 0.5),
                            borderColor: dsColor,
                            data: Utils.numbers({
                                count: data.labels.length,
                                min: -100,
                                max: 100
                            }),
                        };
                        chart.data.datasets.push(newDataset);
                        chart.update();
                    }
                },
                {
                    name: 'Add Data',
                    handler(chart) {
                        const data = chart.data;
                        if (data.datasets.length > 0) {
                            data.labels = Utils.months({
                                count: data.labels.length + 1
                            });

                            for (let index = 0; index < data.datasets.length; ++index) {
                                data.datasets[index].data.push(Utils.rand(-100, 100));
                            }

                            chart.update();
                        }
                    }
                },
                {
                    name: 'Remove Dataset',
                    handler(chart) {
                        chart.data.datasets.pop();
                        chart.update();
                    }
                },
                {
                    name: 'Remove Data',
                    handler(chart) {
                        chart.data.labels.splice(-1, 1); // remove the label first

                        chart.data.datasets.forEach(dataset => {
                            dataset.data.pop();
                        });

                        chart.update();
                    }
                }
            ];
    </script>



    <script>
        function number_format(number, decimals, dec_point, thousands_sep) {
                // *     example: number_format(1234.56, 2, ',', ' ');
                // *     return: '1 234,56'
                number = (number + '').replace(',', '').replace(' ', '');
                var n = !isFinite(+number) ? 0 : +number,
                    prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
                    sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
                    dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
                    s = '',
                    toFixedFix = function(n, prec) {
                        var k = Math.pow(10, prec);
                        return '' + Math.round(n * k) / k;
                    };
                // Fix for IE parseFloat(0.55).toFixed(0) = 0;
                s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
                if (s[0].length > 3) {
                    s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
                }
                if ((s[1] || '').length < prec) {
                    s[1] = s[1] || '';
                    s[1] += new Array(prec - s[1].length + 1).join('0');
                }
                return s.join(dec);
            }

            // Area Chart Example
            var ctx = document.getElementById("myChart-patient");
            var myLineChart_patient = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [{
                        label: "Patient",
                        lineTension: 0.5,
                        backgroundColor: "#1cc88a",
                        borderColor: "#1cc88a",
                        pointRadius: 3,
                        pointBackgroundColor: "#1cc88a",
                        pointBorderColor: "#1cc88a",
                        pointHoverRadius: 3,
                        pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                        pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                        pointHitRadius: 10,
                        pointBorderWidth: 2,
                        data: [
                            <?php $__currentLoopData = $patient_date; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }, ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });


            // Area Chart for each branch
            var ctx = document.getElementById("branches_line");
            var myLineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [
                        <?php
                            $i = 0;
                        ?>
                        <?php $__currentLoopData = $patient_branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            {
                                label: "<?php echo e($item->name); ?>",
                                lineTension: 0.5,
                                backgroundColor: '<?php echo e($chart_color[$i]); ?>',
                                borderColor: '<?php echo e($chart_color[$i]); ?>',
                                pointRadius: 3,
                                pointBackgroundColor: '<?php echo e($chart_color[$i]); ?>',
                                pointBorderColor: '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                                pointHoverRadius: 3,
                                pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                                pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                                pointHitRadius: 10,
                                pointBorderWidth: 2,
                                data: [
                                    <?php $__currentLoopData = $item->total; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item4): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($item4 . ','); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                ],
                            },
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: true
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });
    </script>

    <script>
        // Pie Chart Example
            var ctx = document.getElementById("myChart");
            var myPieChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $gendar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->gendar); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $gendar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        backgroundColor: ['#1cc88a', '#4e73df'],
                        hoverBackgroundColor: ['#17a673', '#2e59d9'],
                        hoverBorderColor: "rgba(234, 236, 244, 1)",
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        }
                    },
                    cutoutPercentage: 80,
                },
            });


            // --------- resource chart ---------
            var ctx_recourse = document.getElementById("each_branch");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $each_branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->branch->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $each_branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $each_branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- resource chart ---------
            var ctx_recourse = document.getElementById("myChart-resource");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $resource; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->recourse->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $resource; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $resource; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- country chart ---------
            var ctx_recourse = document.getElementById("myChart-country");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $country; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->country->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $country; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $country; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });


            // --------- city chart ---------
            var ctx_recourse = document.getElementById("myChart-city");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $city; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->city->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $city; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $city; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- city chart ---------
            var ctx_recourse = document.getElementById("myChart-examination");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $diseases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->diseasecats->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $diseases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $diseases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- city chart ---------
            var ctx_recourse = document.getElementById("myChart-treatment");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->treatment_cat->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- med chart ---------
            var ctx_recourse = document.getElementById("myChart-medicine");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $medicine; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->medicinescats->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $medicine; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $medicine; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            var ctx_recourse = document.getElementById("myChart-pulses");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $pulses_count; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item['area']); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $pulses_count; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item['count'] . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $pulses_count; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>


    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digiflydev/public_html/dev.mdex/resources/views/patient/allstatcs.blade.php ENDPATH**/ ?>