

<?php $__env->startSection('title', 'Create Op Follow up | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Op Follow up'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('fixedcontent'); ?>

<!-- session successful message -->
<?php if(Session::has('success')): ?>
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-0 px-md-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?>

                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.op_follow_up')); ?>">Op Follow up |
            </a>
            <a class="text-gray-300"><?php echo e(__('basic.new op follow up')); ?></a>
        </span>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-capsules me-1"></i>
                <?php echo e(__('basic.new op follow up')); ?></h6>
        </div>


        <!-- Card Body -->
        <div class="card-body px-4 px-md-5">

            <form id="myform" method="POST" action="<?php echo e(route('sett.op_follow_up_file_update', $op->follow_up->id)); ?>">
                <?php echo e(method_field('PUT')); ?>

                <?php echo csrf_field(); ?>

                <div class="row mb-1 justify-content-center">

                    <div class="row mb-2">
                        <div class="col-12 col-md-8">
                            <div class="d-flex">
                                <i class="fas fs-1 fa-procedures me-2 align-self-center text-gray-400"></i>
                                <div>
                                    <p class="text-xxs mb-0 text-gray-300">
                                        <?php echo e(date('h:i a Y-m-d', strtotime($op->start_at))); ?></p>
                                    <h6 class="mb-0 fw-bold"><?php echo e($op->service_item->name); ?>

                                    </h6>
                                    <p class="text-xxs mb-0 text-gray-300">Op place: <?php echo e($op->place->name); ?>

                                        <?php if(isset($op->doctor->first_name)): ?>
                                        with
                                        docotr <span class="fw-bold"><?php echo e($op->doctor->first_name); ?></span>
                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-4 text-center">
                            <p class="text-xs text-gray-200 mb-1">Patient</p>
                            <h6 class="text-s text-gray-400 text-truncate">
                                <?php echo e($op->patient->first_name . ' ' . $op->patient->second_name); ?>

                            </h6>
                        </div>
                    </div>
                    <hr class="my-2">

                    <div class="col-12 col-md-10 col-lg-7">

                        <div class="row mb-2 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Responsible</label>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <p class="mb-0">
                                    <?php echo e($op->follow_up->doctor->first_name . ' ' . $op->follow_up->doctor->second_name); ?>

                                </p>
                            </div>
                        </div>

                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Day 1
                                    <small>(required)</small></label>
                                <h6 class="text-gray-300 text-xs">
                                    <?php if($op->follow_up->day_1): ?>
                                    <?php echo e(date('d M Y', strtotime($op->follow_up->day_1))); ?>

                                    <?php endif; ?>
                                </h6>
                            </div>
                            <div class="col-3 col-md-3 text-center">

                            </div>
                        </div>

                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Day 3
                                    <small>(optional)</small></label>
                                <h6 class="text-gray-300 text-xs">
                                    <?php if($op->follow_up->day_3): ?>
                                    <?php echo e(date('d M Y', strtotime($op->follow_up->day_3))); ?>

                                    <?php endif; ?>
                                </h6>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="day_3" <?php if($op->follow_up->day_3): ?> checked <?php endif; ?>
                                    type="checkbox"
                                    value="<?php echo e(date('Y-m-d')); ?>" id="day3"><label for="day3"
                                        class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Week 1
                                    <small>(optional)</small></label>
                                <h6 class="text-gray-300 text-xs">
                                    <?php if($op->follow_up->week_1): ?>
                                    <?php echo e(date('d M Y', strtotime($op->follow_up->week_1))); ?>

                                    <?php endif; ?>
                                </h6>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="week_1" <?php if($op->follow_up->week_1): ?> checked <?php endif; ?>
                                    type="checkbox"
                                    value="<?php echo e(date('Y-m-d')); ?>" id="week_1"><label for="week_1"
                                        class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Week 2
                                    <small>(optional)</small></label>
                                <h6 class="text-gray-300 text-xs">
                                    <?php if($op->follow_up->week_2): ?>
                                    <?php echo e(date('d M Y', strtotime($op->follow_up->week_2))); ?>

                                    <?php endif; ?>
                                </h6>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="week_2" <?php if($op->follow_up->week_2): ?> checked <?php endif; ?>
                                    type="checkbox"
                                    value="<?php echo e(date('Y-m-d')); ?>" id="week_2"><label for="week_2"
                                        class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Month 1
                                    <small>(optional)</small></label>
                                <h6 class="text-gray-300 text-xs">
                                    <?php if($op->follow_up->month_1): ?>
                                    <?php echo e(date('d M Y', strtotime($op->follow_up->month_1))); ?>

                                    <?php endif; ?>
                                </h6>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="month_1" <?php if($op->follow_up->month_1): ?> checked <?php endif; ?>
                                    type="checkbox"
                                    value="<?php echo e(date('Y-m-d')); ?>" id="month_1"><label for="month_1"
                                        class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Month 2
                                    <small>(optional)</small></label>
                                <h6 class="text-gray-300 text-xs">
                                    <?php if($op->follow_up->month_2): ?>
                                    <?php echo e(date('d M Y', strtotime($op->follow_up->month_2))); ?>

                                    <?php endif; ?>
                                </h6>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="month_2" <?php if($op->follow_up->month_2): ?> checked <?php endif; ?>
                                    type="checkbox"
                                    value="<?php echo e(date('Y-m-d')); ?>" id="month_2"><label for="month_2"
                                        class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Month 4
                                    <small>(optional)</small></label>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="month_4" <?php if($op->follow_up->month_4): ?> checked <?php endif; ?>
                                    type="checkbox"
                                    value="<?php echo e(date('Y-m-d')); ?>" id="month_4"><label for="month_4"
                                        class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Month 6
                                    <small>(optional)</small></label>
                                <h6 class="text-gray-300 text-xs">
                                    <?php if($op->follow_up->month_6): ?>
                                    <?php echo e(date('d M Y', strtotime($op->follow_up->month_6))); ?>

                                    <?php endif; ?>
                                </h6>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="month_6" <?php if($op->follow_up->month_6): ?> checked <?php endif; ?>
                                    type="checkbox"
                                    value="<?php echo e(date('Y-m-d')); ?>" id="month_6"><label for="month_6"
                                        class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 mb-2">
                            <label class="form-label"><?php echo e(__('basic.note')); ?>

                                <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                            <textarea name="note" class="form-control" placeholder="Write here your notes .." rows="4"
                                spellcheck="false"><?php echo e($op->note); ?></textarea>

                            <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-end mt-2 mb-2">
                    <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                        value="<?php echo e(__('basic.update')); ?>">
                </div>

            </form>
        </div>

    </div>

</div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

<!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
        var $validator = $('#myform').validate({
            rules: {
                name: {
                    minlength: 3,
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'gendar':
                        error.insertAfter($("#gendar-js-error-valid"));
                        break;
                    default:
                        error.insertAfter(element);
                }

            },
        });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digiflydev/public_html/dev.mdex/resources/views/branch/operation/op_follow_up_show.blade.php ENDPATH**/ ?>