<?php $__env->startSection('title', 'Workers | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Workers'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- -- datatables plugin -- -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">

<?php $__env->stopSection(); ?>


<?php $__env->startSection('fixedcontent'); ?>

    <!-- session successful message -->
    <?php if(Session::has('success')): ?>
        <div id="flash-msg" class="shadow pt-3">
            <div class="d-flex justify-content-between mb-2">
                <i class="fas fs-1 fa-check"></i>
                <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
            </div>
            <h3>Sent Successfully</h3>
            <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
        </div>
    <?php endif; ?>

    <!-- session successful message -->
    <?php if(Session::has('error_delete')): ?>
        <div id="flash-msg" class="shadow pt-3" style="background-color:#ff4152;">
            <div class="d-flex justify-content-between mb-2">
                <i class="fas fs-1 fa-times"></i>
                <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"
                        style="color:#ffb4bc"></i></a>
            </div>
            <h3>We can't do it!</h3>
            <p style="color:#ffb4bc"><?php echo e(Session::get('error_delete')); ?></p>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-2 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
                <a class="text-gray-300">Users</a>
            </span>

            <div class="d-flex justify-content-center">
                <a href="<?php echo e(route('sett.hr_create_attendance_admin')); ?>"
                    class=" text-gray-400 bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1"><i
                        class="fas fa-person-booth fa-sm me-1"></i> New Attendance</a>

                <a href="<?php echo e(route('sett.admin.create')); ?>"
                    class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1"><i
                        class="fas fa-plus fa-sm me-1"></i> New Worker</a>
            </div>
        </div>

        <div class="card shadow mb-3 pb-2">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-users me-2"></i> All workers</h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                        aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">Action:</div>
                        <a class="dropdown-item" href="<?php echo e(route('sett.admin.create')); ?>"><i class="fas fa-user me-1"></i>
                            new user</a>
                        <a class="dropdown-item" href="<?php echo e(route('sett.role.index')); ?>"><i class="fas fa-plus me-1"></i>
                            roles</a>
                        <a class="dropdown-item" href="<?php echo e(route('sett.role.create')); ?>"><i class="fas fa-plus me-1"></i>
                            new roles</a>
                    </div>
                </div>
            </div>

            <!-- Card Body -->
            <div class="card-body">

                <div class="table-responsive">
                    <table class="table display datatable-modal" id="p-lab-table" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th class="text-xxs">NAME</th>
                                <th class="text-xxs text-center">BRANCH</th>
                                <th class="text-xxs text-center">ROLE</th>
                                <th class="text-xxs text-center">ACTIVATION</th>
                                <th class="text-xxs text-center">HANDLE</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a class="d-flex align-items-center"
                                            href="<?php echo e(route('sett.invo_debtor_doctor', $iteam->id)); ?>">
                                            <img class="rounded-circle avatar-small me-2"
                                                src="<?php echo e(URL::asset('img/useravatar/' . $iteam->avatar)); ?>">
                                            <div class="">
                                                <h6
                                                    class=" mb-1
                                                text-s fw-bold text-gray-mixed-400">
                                                    <?php echo e($iteam->first_name . ' ' . $iteam->second_name); ?></h6>
                                                <p class="mb-0 text-xs text-gray-300"><?php echo e($iteam->started_work); ?></p>
                                            </div>
                                        </a>
                                    </td>
                                    <td class="text-center">
                                        <?php if($iteam->branch_id == 0): ?>
                                            ALL
                                        <?php elseif(!count($iteam->branches)): ?>
                                            <?php echo e($iteam->branch['name']); ?>

                                        <?php else: ?>
                                            <?php $__currentLoopData = $iteam->branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($branch['name'].','.' '); ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php endif; ?>
                                    </td>

                                    <td class="text-center">
                                        <?php $__currentLoopData = $iteam->getRoleNames(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roles): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge rounded-pill pend-color-btn badge-padd-l">
                                                <?php echo e($roles); ?>

                                            </span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>

                                    <td class="text-center">
                                        <?php if($iteam->deactivate == 0): ?>
                                            <i class="fas fa-circle me-2 text-xxs mb-0 main-color"></i><span
                                                class="main-color fw-bold">Actived</span>
                                        <?php else: ?>
                                            <i class="fas fa-circle me-2 text-xxs mb-0 text-red"></i><span
                                                class="text-red fw-bold">deactivate</span>
                                        <?php endif; ?>
                                    </td>

                                    <td class="text-center">
                                        <a href="<?php echo e(route('sett.admin.edit', $iteam->id)); ?>"
                                            class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1"
                                            title="delete"><i class="fas fa-pencil-alt"></i> Edit </a>
                                        <!-- <a class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 delete-conf"
                                                                                                                                                                                title="delete" data-effect="effect-scale" data-user_id="<?php echo e($iteam->id); ?>"
                                                                                                                                                                                data-username="<?php echo e($iteam->first_name); ?>" data-bs-toggle="modal"
                                                                                                                                                                                data-bs-target="#delete1"><i class="fas fa-trash"></i> Delete
                                                                                                                                                                </a> -->

                                        <a href="<?php echo e(route('sett.hr_attendance', $iteam->id)); ?>"
                                            class="status-col-link main-color-btn text-white clickable-item-pointer shadow-sm b-r-l-cont rate-appointment p-2 px-3">
                                            <i class="fas fa-person-booth fa-sm"></i>
                                            <?php echo e(__('basic.attendance')); ?>

                                        </a>
                                    </td>

                                    <!-- Modal -->
                                    <div class="modal fade" id="delete1" tabindex="-1"
                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable ">
                                            <div class="modal-content b-r-s-cont border-0">

                                                <div class="modal-header">
                                                    <div class="modal-title" id="exampleModalLabel"><i
                                                            class="fas fa-trash me-1"></i>
                                                        User delete</div>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>

                                                <form action="<?php echo e(route('sett.admin.destroy', 'test')); ?>"
                                                    method="post">
                                                    <?php echo e(method_field('delete')); ?>

                                                    <?php echo e(csrf_field()); ?>


                                                    <!-- Modal content -->
                                                    <div class="modal-body px-4">

                                                        <div class="modal-body delete-conf-input text-center py-0">
                                                            <p class="mb-0">ِAre you sure you want to delete
                                                                this
                                                                user?</p><br>
                                                            <input type="hidden" name="user_id" value="">
                                                        </div>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <div class="left-side">
                                                            <button type="button" class="btn btn-default btn-link"
                                                                data-bs-dismiss="modal">Never Mind</button>
                                                        </div>
                                                        <div class="divider"></div>
                                                        <div class="right-side">
                                                            <button type="submit"
                                                                class="btn btn-default btn-link text-red">Delete
                                                            </button>
                                                        </div>

                                                    </div>
                                                </form>

                                            </div>
                                        </div>
                                    </div>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>


<!-- js insert -->
<?php $__env->startSection('js'); ?>

    <!-- delete confirmation modal -->
    <script>
        $('.delete-conf').click(function(event) {


            var user_id = $(this).data("user_id");
            var username = $(this).data("username");
            console.log(user_id);
            var modal = $('.delete-conf-input [name="user_id"]')
            modal.val(user_id);
            $('#username').val(username);
        })
    </script>

    <script>
        $(document).ready(function() {
            var table = $('#p-lab-table').DataTable({
                lengthChange: true,
                buttons: [{
                    extend: 'csv',
                    split: ['pdf', 'excel'],
                }]
            });
        });
    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.print.min.js"></script>
    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.colVis.min.js"></script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digiflydev/public_html/dev.mdex/resources/views/admins/index.blade.php ENDPATH**/ ?>