

<?php $__env->startSection('title', 'Edit Patient | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Edit Patient'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- international telephone input -->
<link href="<?php echo e(URL::asset('plugins/intltelinput/intlTelInput.css')); ?>" rel="stylesheet">


<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.patient.index')); ?>">Patient | </a>
            <a class="text-gray-300">Edit Patient</a>
        </span>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-user-edit me-2"></i> Edit
                <?php echo e($patient->first_name); ?>

                Profile
            </h6>
        </div>


        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="text-red"><i class="fas fa-exclamation me-1"></i> <?php echo e($error); ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        <!-- Card Body -->
        <div class="card-body px-3">

            <div class="multi-setps-form-calander col-12">

                <form id="myform" method="POST" action="<?php echo e(route('sett.patient.update', $patient->id)); ?>"
                    enctype="multipart/form-data">

                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <!-- progressbar -->
                    <ul class="ps-0 progressbar" id="progressbar">
                        <li class="active">
                            <a>
                                <!-- in case we want to use prog selector href="#clinics" -->
                                <div class="icon-circle checked d-flex align-items-center justify-content-center">
                                    <i class="bi bi-gear"></i>
                                </div>
                                Basic
                            </a>
                        </li>

                        <li>
                            <a>
                                <div class="icon-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-person"></i>
                                </div>
                                Personal
                            </a>
                        </li>

                        <li>
                            <a>
                                <div class="icon-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-pin-map"></i>
                                </div>
                                Medical
                            </a>
                        </li>
                        <li>
                            <a>
                                <div class="icon-circle d-flex align-items-center justify-content-center">
                                    <i class="far fa-paper-plane"></i>
                                </div>
                                Sending
                            </a>
                        </li>
                    </ul>

                    <!-- content -->

                    <div class="cont_tap " id="clinics">

                        <div class="row mb-1">
                            <div class="col-12 col-md-5 align-self-center mb-2">

                                <div class="avatar-update-container">
                                    <div class="picture">
                                        <img src="<?php echo e(URL::asset('img/useravatar/' . $patient->avatar)); ?>"
                                            class="picture-src" id="mib_PicturePreview" title="" />
                                        <input type="file" name='avatar' accept="image/*" id="mib_img_input">
                                    </div>
                                    <h6 class="text-gray-300">Choose Picture</h6>

                                    <?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-msg-form">
                                        <?php echo e($message); ?>

                                    </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                            </div>

                            <div class="col-12 col-md-7 mb-2">

                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('patientappo.first name')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <input name="first_name" type="text"
                                        class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write your first name here" autofocus required
                                        value="<?php echo e($patient->first_name); ?>">
                                </div>

                                <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('patientappo.second name')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <input name="second_name" type="text"
                                        class="form-control <?php $__errorArgs = ['second_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write your second name here" required
                                        value="<?php echo e($patient->second_name); ?>">
                                </div>

                                <?php $__errorArgs = ['second_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>
                        </div>

                        <div class="row mb-2">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Email <small>(optional)</small></label>
                                <input name="email" type="text"
                                    class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Yousef@yahoo.com" value="<?php echo e($patient->email); ?>">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <input name="old_email" type="hidden" value="<?php echo e($patient->email); ?>">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Mother Name
                                    <small>(optional)</small></label>
                                <input name="mother_name" type="text"
                                    class="form-control <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e($patient->mother_name); ?>" placeholder="Write your mother's name here">

                                <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                        </div>

                        <div class="row mb-2">
                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">New Password newpassword<small>(required)</small></label>
                                <input id="password" name="newpassword" type="password"
                                    class="form-control <?php $__errorArgs = ['newpassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Wrtie your password here...">

                                <?php if($errors->has('newpassword')): ?>
                                <span class="error-msg-form">
                                    <?php echo e($errors->first('newpassword')); ?>

                                </span>
                                <?php else: ?>
                                <div class="form-text text-gray-200">Leave it empty if you do not want to change it.
                                </div>
                                <?php endif; ?>
                            </div>

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Confirm New password <small>(required)</small></label>
                                <input name="newpassword_confirmation" type="password" class="form-control"
                                    placeholder="Confirm your password..." id="password-confirm">
                            </div>

                        </div>

                        <div class="d-flex justify-content-end mt-3">
                            <input type="button" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="Continue" />
                        </div>
                    </div>


                    <div class="cont_tap" id="time">

                        <div class="row mb-2">

                            <div class="col-12 col-md-3 mb-2">
                                <label class="form-label">Status <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="status" required>
                                    <option value="1" <?php if($patient->type == 1): ?> selected <?php endif; ?>>New</option>
                                    <option value="2" <?php if($patient->type == 2): ?> selected <?php endif; ?>>Old</option>
                                    <option value="5" <?php if($patient->type == 5): ?> selected <?php endif; ?>><?php echo e(__('basic.vip_patient')); ?></option>
                                </select>
                                <div id="status-js-error-valid"></div>

                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>


                            <div class="col-12 col-md-3 mb-2">
                                <label class="form-label"><?php echo e(__('basic.main ask for')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['ask_for_main_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="ask_for_main_id" required>
                                    <?php $__currentLoopData = $ask_for_main; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php if($patient->ask_for_main_id == $item->id): ?> selected <?php endif; ?> value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div id="main_ask_for_id-js-error-valid"></div>

                                <?php $__errorArgs = ['ask_for_main_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 col-md-3 mb-2">
                                <label class="form-label"><?php echo e(__('basic.ask for')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                <select
                                    class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['ask_for_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="ask_for_id" required>
                                    <?php if($patient->ask_for): ?>
                                    <option value="<?php echo e($patient->ask_for['id']); ?>" selected>
                                        <?php echo e($patient->ask_for['name']); ?>

                                    </option>
                                    <?php else: ?>
                                    <option value="" selected>
                                        - Select Main Ask for first -
                                    </option>
                                    <?php endif; ?>

                                </select>

                                <div id="ask_for_id-js-error-valid"></div>

                                <?php if($errors->has('ask_for_id')): ?>
                                <span class="error-msg-form">
                                    <?php echo e($errors->first('ask_for_id')); ?>

                                </span>
                                <?php else: ?>
                                <div class="form-text text-gray-200">Select the main ask for first</div>
                                <?php endif; ?>
                            </div>

                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
                            <div class="col-12 col-md-3 mb-2">
                                <label class="form-label">Branch <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['first_branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="first_branch_id" required>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>" <?php if($patient->first_branch_id == $item->id): ?>
                                        selected <?php endif; ?>>
                                        <?php echo e($item->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div id="first_branch_id-js-error-valid"></div>

                                <?php $__errorArgs = ['first_branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <?php endif; ?>

                        </div>

                        <hr>

                        <div class="row mb-2">
                            <div class="code-container col-12 col-md-6 mb-2">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('patientappo.code')); ?>

                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                    <input name="code" type="text"
                                        class="form-control <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write the patient code here" required
                                        value="<?php echo e(old('code')); ?>">
                                </div>

                                <?php if($errors->has('code')): ?>
                                <span class="error-msg-form">
                                    <?php echo e($errors->first('code')); ?>

                                </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Gendar <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['gendar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="gendar" required>
                                    <option value="male" <?php if($patient->gendar === 'male'): ?> selected <?php endif; ?>>Male
                                    </option>
                                    <option value="female" <?php if($patient->gendar === 'female'): ?> selected <?php endif; ?>>Female
                                    </option>
                                </select>
                                <div id="gendar-js-error-valid"></div>

                                <?php $__errorArgs = ['gendar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 col-md-6 mb-2">

                                <label class="form-label">Birthday <small>(required)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i> </div>
                                    </div>
                                    <input name="birthday" type="text"
                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['birthday'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD" value="<?php echo e($patient->birthday); ?>" required>
                                </div>
                                <div id="birthday-js-error-valid"></div>

                                <?php $__errorArgs = ['birthday'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                        </div>

                        <hr>

                        <div class="row mb-2">

                            <div class="col-12 col-md-4 mb-2">
                                <label class="form-label">Country <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['country_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="country_id" required>
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($iteam->id); ?>" <?php if($patient->country_id == $iteam->id): ?> selected
                                        <?php endif; ?>>
                                        <?php echo e($iteam->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div id="country-js-error-valid"></div>

                                <?php $__errorArgs = ['country_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 col-md-4 mb-2">
                                <label class="form-label">City <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="city_id" required>
                                    <option value="<?php echo e($patient->city['id']); ?>" selected>
                                        <?php echo e($patient->city['name']); ?>

                                    </option>
                                </select>

                                <div id="city-js-error-valid"></div>

                                <?php if($errors->has('city_id')): ?>
                                <span class="error-msg-form">
                                    <?php echo e($errors->first('city_id')); ?>

                                </span>
                                <?php else: ?>
                                <div class="form-text text-gray-200">Select the country first
                                </div>
                                <?php endif; ?>
                            </div>


                            <div class="col-12 col-md-4 mb-2">
                                <label class="form-label">How do you know us? <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['from_recourse_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="from_recourse_id" required>
                                    <?php $__currentLoopData = $from_recourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($iteam->id); ?>" <?php if($patient->from_recourse_id == $iteam->id): ?>
                                        selected <?php endif; ?>>
                                        <?php echo e($iteam->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div id="from_recourse_id-js-error-valid"></div>

                                <?php $__errorArgs = ['from_recourse_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                        </div>

                        <hr>

                        <div class="row mb-2">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Phone Number <small>(required)</small></label>
                                <input id="int-miphone" name="phone_number" type="tel"
                                    class="form-control <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e($patient->phone_number); ?>" required>

                                <input name="old_phone_number" type="hidden" value="<?php echo e($patient->phone_number); ?>">

                                <div id="phonenumber-js-error-valid">
                                </div>

                                <?php if($errors->has('phone_number')): ?>
                                <span class="error-msg-form">
                                    <?php echo e($errors->first('phone_number')); ?>

                                </span>
                                <?php else: ?>
                                <div class="form-text text-gray-200">We'll never share your email with anyone else.
                                </div>
                                <?php endif; ?>
                            </div>



                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Second Phone Number <small>(optional)</small></label>
                                <input id="int-miphone2" name="sec_phone_number" type="tel"
                                    class="form-control <?php $__errorArgs = ['sec_phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e($patient->sec_phone_number); ?>">

                                <div id="secphonenumber-js-error-valid"></div>

                                <?php $__errorArgs = ['sec_phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                            </div>


                        </div>

                        <div class="d-flex justify-content-between p-4">
                            <input type="button" name="previous"
                                class="previous-form-steps btn btn-secondary action-button-previous" value="Previous" />
                            <input type="button" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="Continue" />
                        </div>
                    </div>

                    <div class="cont_tap" id="about">


                        <div class="row mb-2">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Height <small>(optional)</small></label>
                                <input name="height" type="text" value="<?php echo e($patient->height); ?>"
                                    class="form-control <?php $__errorArgs = ['height'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write your height here">

                                <?php $__errorArgs = ['height'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Weight <small>(optional)</small></label>
                                <input name="weight" type="text" value="<?php echo e($patient->weight); ?>"
                                    class="form-control <?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write your weight here">

                                <?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>


                        </div>

                        <div class="row mb-2">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Blood type <small>(optional)</small></label>
                                <input name="blood_type" type="text" value="<?php echo e($patient->blood_type); ?>"
                                    class="form-control <?php $__errorArgs = ['blood_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write your blood type here">

                                <?php $__errorArgs = ['blood_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Insurance<small>(optional)</small></label>
                                <input name="insurance" type="text" value="<?php echo e($patient->insurance); ?>"
                                    class="form-control <?php $__errorArgs = ['insurance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write your insurance company here">

                                <?php $__errorArgs = ['insurance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="mb-3">
                                <label class="form-label">Note <small>(optional)</small></label>
                                <textarea name="note" class="form-control" placeholder="Write here your notes .."
                                    rows="4" spellcheck="false"><?php echo e($patient->note); ?></textarea>
                            </div>

                            <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="d-flex justify-content-between p-4">
                            <input type="button" name="previous"
                                class="previous-form-steps btn btn-secondary action-button-previous" value="Previous" />
                            <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="Continue" />
                        </div>
                    </div>

                    <div class="cont_tap" id="sending">
                        <div class="d-flex justify-content-center p2">
                            <img src="<?php echo e(URL::asset('img/dashboard/system/loading-dash.svg')); ?>" style="width: 195px;"
                                alt="Loading" />
                        </div>
                    </div>

                </form>
            </div>

        </div>

    </div>
</div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.js-example-basic-single').select2();
        //hide search
        $('.select2-no-search').select2({
            minimumResultsForSearch: -1
        });
    });

</script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
        $('.hasdatetimepicker').datepicker({
            todayHighlight: true
            , format: "yyyy-mm-dd"
        , });
    });

</script>

<!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
    var $validator = $('#myform').validate({
        rules: {
            code: {
                minlength: 7,
                number: true,
                required: false
            , }
            ,first_name: {
                minlength: 3
            , }
            , second_name: {
                minlength: 3
            , }
            , email: {
                email: true
            , }
            , newpassword: {
                minlength: 7
                , maxlength: 100
            , }
            , newpassword_confirmation: {
                minlength: 7
                , maxlength: 100
                , equalTo: '#password'
            , }
        , }
        , messages: {
            email: {
                required: "We need your email address to contact you"
                , email: "Your email address must be in the format of name@domain.com"
            }
            , password_confirmation: {
                equalTo: "Password does not match"
            , }
        },
        //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
        errorPlacement: function(error, element) {
            switch (element.attr("name")) {
                case 'role':
                    error.insertAfter($("#role-js-error-valid"));
                    break;
                case 'first_branch_id':
                    error.insertAfter($("#first_branch_id-js-error-valid"));
                    break;
                case 'gendar':
                    error.insertAfter($("#gendar-js-error-valid"));
                    break;
                case 'birthday':
                    error.insertAfter($("#birthday-js-error-valid"));
                    break;
                case 'country_id':
                    error.insertAfter($("#country-js-error-valid"));
                    break;
                case 'city_id':
                    error.insertAfter($("#city-js-error-valid"));
                    break;

                case 'started_work':
                    error.insertAfter($("#startedwork-js-error-valid"));
                    break;
                case 'phone_number':
                    error.insertAfter($("#phonenumber-js-error-valid"));
                    break;
                case 'sec_phone_number':
                    error.insertAfter($("#secphonenumber-js-error-valid"));
                    break;
                case 'deactivate':
                    error.insertAfter($("#deactivate-js-error-valid"));
                    break;

                default:
                    error.insertAfter(element);
            }

        }
    , });

</script>
<script>
    $("input[name='code']").on('input', async(e)=>{
        branch = $("select[name='first_branch_id']").val();
        code = e.target.value;
        console.log(code,branch);
        span = document.querySelector('.code-error');
        if (span){
            document.querySelector('.code-container').removeChild(span);
        }
        if (code.length >= 7 && $.isNumeric(code)) {
            let codeStatus = await checkCode(code,branch);
            if(codeStatus.exists){
                const span = document.createElement('span');
                span.classList.add('error-msg-form');
                span.classList.add('code-error');
                span.append(codeStatus.message);
                document.querySelector('.code-container').appendChild(span);
            }
        } else {
            console.log(code,branch);
        }
    });

    async function checkCode(code,branch){
        let url = "<?php echo e(route('sett.pat_check_code_ajax')); ?>";
            try {
                const response = await $.ajax({
                url
                , type: "POST"
                ,data: {
                        '_token': "<?php echo e(csrf_token()); ?>",
                        'code': code,
                        'branch': branch

                    }
                });
                return response;

            } catch (error) {
                console.error("Error occurred:", error);
                throw error;
            }
    }
</script>
<script>
    //for country and cities ajax inputs
    $('select[name="country_id"]').on('change', function(e) {
        e.preventDefault();

        var countryID = $(this).val();

        var url = "<?php echo e(route('sett.pat_createcityajax', ':id')); ?>";
        url = url.replace(':id', encodeURI(countryID));

        if (countryID) {
            $.ajax({
                url: url
                , type: "GET"
                , dataType: "json"
                , success: function(data) {
                    $('select[name="city_id"]').empty();
                    $.each(data, function(key, value) {
                        $('select[name="city_id"]').append('<option value="' +
                            value.id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('select[name="city_id"]').empty();
        }
    });


    fetchAskFor();

    //for country and cities ajax inputs
    function fetchAskFor(ask_for_main_id = $('select[name="ask_for_main_id"]').val()) {

        var url = "<?php echo e(route('sett.pat_create_askfor_ajax', ':id')); ?>";
        url = url.replace(':id', ask_for_main_id);

        if (ask_for_main_id) {
            $.ajax({
                url: url
                , type: "GET"
                , dataType: "json"
                , success: function(data) {
                    $('select[name="ask_for_id"]').empty();
                    $.each(data, function(key, value) {
                        $('select[name="ask_for_id"]').append('<option value="' +
                            value.id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('select[name="ask_for_id"]').empty();
        }
    }

    $('select[name="ask_for_main_id"]').on('change', function(e) {
        var ask_for_main_id = $(this).val();
        fetchAskFor(ask_for_main_id)
    });

</script>
<script>
    function fetch_from_resource(branchID) {
        var url = "<?php echo e(route('sett.app_fetch_from_resource_ajax', ':id')); ?>";
            url = url.replace(':id', branchID);

            if (branchID) {
                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('select[name="from_recourse_id"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="from_recourse_id"]').append('<option value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            } else {
                $('select[name="from_recourse"]').empty();
            }

    }
    fetch_from_resource($('select[name="first_branch_id"]').val());
    //for from resource inputs
        $('select[name="first_branch_id"]').on('change', function(e) {
            e.preventDefault();

            var branchID = $(this).val();
            fetch_from_resource(branchID);

        });
</script>

<!-- international telephone input -->
<script src="<?php echo e(URL::asset('plugins/intltelinput/intlTelInput.min.js')); ?>"></script>

<script>
    //to enable international telephone input (#int-miphone) is where we need to insert it
    const phoneInputField = document.querySelector("#int-miphone");
    const phoneInput = window.intlTelInput(phoneInputField, {
        //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
        preferredCountries: ["eg", "sa", "ae", "qa"]
        , utilsScript: "<?php echo e(URL::asset('plugins/intltelinput/utils.js')); ?>"
    , });
    const phoneInputField2 = document.querySelector("#int-miphone2");
    const phoneInput2 = window.intlTelInput(phoneInputField2, {
        //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
        preferredCountries: ["eg", "sa", "ae", "qa"]
        , utilsScript: "<?php echo e(URL::asset('plugins/intltelinput/utils.js')); ?>"
    , });

</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digiflydev/public_html/dev.mdex/resources/views/patient/edit.blade.php ENDPATH**/ ?>