<?php
use App\Http\Controllers\Branch\InvoiceController;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

Route::group(
    [
         'prefix' => LaravelLocalization::setLocale(),
         'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
    ],
    function () {

        Route::prefix('prox')->name('sett.')->group(function () {
            /*
                |--------------------------------------------------------------------------
                | Invoice Operations
                |--------------------------------------------------------------------------
                */

                Route::prefix('invo')->group(function () {
                    //MAIN appointments resource routes
                        //main invoice
                        Route::resource('/invoice', InvoiceController::class)->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist|Operation_accountant']);

                    //Appointment API routes
                    //GET Routes
                        //get the latsest results
                        Route::get('/invoice_result_index/{branch}', [InvoiceController::class, 'invoice_result_index'])->name('invo_invoice_result_index')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
                        //get the latsest results for no pay
                        Route::get('/invoice_result_nopay_index/{branch}', [InvoiceController::class, 'invoice_result_nopay_index'])->name('invo_invoice_result_nopay_index')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
                        //search engine for invoice
                        Route::get('/invoice_search/{search_query}', [InvoiceController::class, 'invoice_search'])->name('invo_invoice_search')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist|Operation_accountant']);

                        //Coupon search
                        Route::get('/coupon_search/{search_query}/{patient_id}/{total_price}', [InvoiceController::class, 'coupon_search'])->name('invo_coupon_search')->middleware(['role:Super-admin|Accountant|Doctor|Branch-manager|Receptionist|Call-center']);
                        //search engine for debtors
                        Route::get('/debtor_search/{search_query}', [InvoiceController::class, 'debtor_search'])->name('invo_debtor_search')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                        //search engine for doctors
                        Route::get('/doctor_search/{search_query}', [InvoiceController::class, 'doctor_search'])->name('invo_doctor_search')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);



                    //PUT/PATCH/POST Requests Routes
                        //store income
                        Route::post('/store_income', [InvoiceController::class, 'store_income'])->name('invo_store_income')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
                        //delete material in invoice
                        Route::delete('/delete_inv_material/{id}', [InvoiceController::class, 'delete_inv_material'])->name('delete_inv_material');

                        //refund invoice
                        Route::post('/refund_inv/{id}', [InvoiceController::class, 'refund_inv'])->name('refund_inv')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                        //pay installments
                        Route::PATCH('/pay_installment/{id}', [InvoiceController::class, 'pay_installment'])->name('pay_installment');

                        //insert installments
                        Route::PATCH('/insert_installment/{id}', [InvoiceController::class, 'insert_installment'])->name('insert_installment');

                        //delete payment
                        Route::delete('/delete_inv_payment/{id}', [InvoiceController::class, 'delete_inv_payment'])->name('delete_inv_payment');

                        //edit payment
                        Route::PATCH('/edit_inv_payment/{id}', [InvoiceController::class, 'edit_inv_payment'])->name('edit_inv_payment');

                        //to pay installemnt
                        Route::PATCH('/invoice_pay_installment/{id}', [InvoiceController::class, 'invoice_pay_installment'])->name('invoice_pay_installment');

                        //to pay for first time
                        Route::PATCH('/invoice_pay/{id}', [InvoiceController::class, 'invoice_pay'])->name('invo_invoice_pay');

                        //add new items to the invoice
                        Route::post('/add_items/{invoice_id}', [InvoiceController::class, 'add_items'])->name('invo_add_items')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                        //add new material to the invoice
                        Route::post('/invo_add_material/{invoice_id}', [InvoiceController::class, 'invo_add_material'])->name('invo_add_material')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
                        Route::PATCH('/inv_edit_item/{id}', [InvoiceController::class, 'inv_edit_item'])->name('inv_edit_item');
                        Route::PUT('/inv_edit_note/{id}', [InvoiceController::class, 'inv_edit_note'])->name('inv_edit_note');
                        //update attched img
                        Route::PATCH('/invoice_edit_attched/{id}', [InvoiceController::class, 'invoice_edit_attched'])->name('invoice_edit_attched');


                    //Invoice routes that return VIEWS

                        //today installment
                        Route::get('/today_installment/{date?}', [InvoiceController::class, 'today_installment'])->name('today_installment')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                        //doctor comm profile monthly
                        Route::get('/doctor_profile_comm_service_month/{id}/{date?}', [InvoiceController::class, 'doctor_profile_comm_service_month'])->name('doctor_profile_comm_service_month')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);


                        //doctor comm monthly
                        Route::get('/doctor_comm_service_month/{date?}', [InvoiceController::class, 'doctor_comm_service_month'])->name('doctor_comm_service_month')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                        //doctor comm daily
                        Route::get('/doctor_comm_service/{date?}', [InvoiceController::class, 'doctor_comm_service'])->name('doctor_comm_service')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                        //doctor comm daily
                        Route::get('/all_doctor_comm_day/{date?}', [InvoiceController::class, 'all_doctor_comm_day'])->name('all_doctor_comm_day')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                        //doctor comm
                        Route::get('/all_doctor_comm/{date?}', [InvoiceController::class, 'all_doctor_comm'])->name('all_doctor_comm')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
                        //show debtor profile
                        Route::get('/debtor/{id?}', [InvoiceController::class, 'debtor_show'])->name('invo_debtor')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
                        Route::get('/debtor_doctor/{id?}', [InvoiceController::class, 'doctor_show'])->name('invo_debtor_doctor')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist|Hr']);
                        //total invoices statistics
                        Route::get('/allstatcs/{specialty?}/{branch?}/{from?}/{to?}', [InvoiceController::class, 'allstatcs'])->name('invo_allstatcs')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
                        //get the day invoice for debit and credit
                        Route::get('/day_search/{date?}/{specialty?}/{branch?}', [InvoiceController::class, 'day_search'])->name('invo_day_search')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist|Operation_accountant']);
                        //get the month invoice for debit and credit
                        Route::get('/month_search/{date?}/{specialty?}/{branch?}', [InvoiceController::class, 'month_search'])->name('invo_month_search')->middleware(['role:Super-admin|Accountant|Branch-manager']);
                        //get the year invoice for debit and credit
                        Route::get('/year_search/{date?}/{specialty?}/{branch?}', [InvoiceController::class, 'year_search'])->name('invo_year_search')->middleware(['role:Super-admin|Accountant|Branch-manager']);

                        //for other invoice search such as doctor, services, and workers
                        Route::get('/invo_other_search', [InvoiceController::class, 'invo_other_search'])->name('invo_other_search')->middleware(['role:Super-admin|Accountant|Branch-manager']);
                        Route::get('/invo_other_search_store/{date?}/{service?}/{doctor?}/{worker?}/{branch?}', [InvoiceController::class, 'invo_other_search_store'])->name('invo_other_search_store')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                        //invoice print
                        Route::get('/invoice_print/{id}', [InvoiceController::class, 'invoice_print'])->name('invo_invoice_print')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                        //get all invoices search
                        Route::get('/show_all_invoice', [InvoiceController::class, 'show_all_invoices'])->name('inv_show_all_invoices')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
               });

        });
    });
