<script>
    // ----------------------------------------------------------------------------------

    $(document).ready(function() {

        //select one tooth
        $(document).on("click", ".click_tooth", function() {

            //get the tooth code
            code = $(this).data('tooth_code');

            //remove all selected active tooth

            //show selected in the selected tooth
            if (code === "all_teeth") {
                $('#dental_chart').find('.hover_tooth').removeClass('active');
                $('#dental_chart').find('.hover_tooth').addClass('active');
            } else if (code === "upper_jaw") {
                $('#chart_upper_teeth').find('.hover_tooth').removeClass('active');
                $('#chart_upper_teeth').find('.hover_tooth').addClass('active');
            } else if (code === "lower_jaw") {
                $('#chart_lower_teeth').find('.hover_tooth').removeClass('active');
                $('#chart_lower_teeth').find('.hover_tooth').addClass('active');
            } else {
                $('.hover_tooth').removeClass('active');
                $(this).find('.hover_tooth').addClass('active');
            }

            //pass the tooth code to the select modal
            $('#dental_code').val(code);
            $('#dental_min_cat_id').attr('data-code', code);

            $("#myModaloneTooth").modal("show");
        })

        //changing tooth treatment by select input
        $(document).on("change", "#dental_min_cat_id", function() {

            treatment = $(this).val();
            code = $(this).attr('data-code');

            if (code === "all_teeth") {
                $('#dental_chart').find('img').removeClass('active');
                $('#dental_chart').find('.' + treatment).addClass('active');
            } else if (code === "upper_jaw") {
                $('#chart_upper_teeth').find('img').removeClass('active');
                $('#chart_upper_teeth').find('.' + treatment).addClass('active');
            } else if (code === "lower_jaw") {
                $('#chart_lower_teeth').find('img').removeClass('active');
                $('#chart_lower_teeth').find('.' + treatment).addClass('active');
            } else {
                //remove all active imgs first
                $('[data-tooth_code="' + code + '"]').find('img').removeClass('active');
                //show the selected treatment tooth
                $('[data-tooth_code="' + code + '"]').find('.' + treatment).addClass('active');
            }

        })


    })


    //fetching dental service accroding to main dental cat

    fetchDentalService();

    //for country and cities ajax inputs
    function fetchDentalService(main_id = $('select[name="dental_min_cat_id"]').val()) {

        var url = "{{ route('sett.pat_fetch_dental_service', ':id') }}";
        url = url.replace(':id', main_id);

        if (main_id) {
            $.ajax({
                url: url,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    $('select[name="dental_service_id"]').empty();
                    $.each(data, function(key, value) {
                        $('select[name="dental_service_id"]').append('<option value="' +
                            value.id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('select[name="dental_service_id"]').empty();
        }

    }

    $('select[name="dental_min_cat_id"]').on('change', function(e) {
        var main_id = $(this).val();
        fetchDentalService(main_id)
    });





    //add new basic dental chart
    $(document).on('click', "#submit_basic_dental", function(e) {
        e.preventDefault();

        //run vlidation plugin
        $(".myform").valid();

        var dental_min_cat_id = $("select[name='dental_min_cat_id']").val();
        var dental_service_id = $("select[name='dental_service_id']").val();
        var dental_code = $("input[name='dental_code']").val();
        var note_dental = $("input[name='note_dental']").val();
        var patient_id = $("input[name='patient_id']").val();

        var dental_surfaces = [];
        $.each($("select[name='dental_surfaces'] option:selected"), function(index, element) {
            dental_surfaces.push($(element).val());
        })

        var url = "{{ route('sett.pat_store_basic_dental') }}";

        $(this).prop("disabled", true);
        // add spinner to button
        $(this).html(
            '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading...'
        );

        $.ajax({
            url: url,
            type: 'POST',
            dataType: "json",
            data: {
                '_token': "{{ csrf_token() }}",
                'patient_id': patient_id,
                'dent_main_cat_id': dental_min_cat_id,
                'services_cat_id': dental_service_id,
                'tooth': dental_code,
                'surface': dental_surfaces,
                'note': note_dental,
            },
            success: function(data) {
                $("#submit_basic_dental").prop("disabled", false);
                $("#submit_basic_dental").html('Send');

                if (data.tooth === "all_teeth") {
                    $('#dental_chart').find('.' + data.main_cat).addClass('active_dent_db');
                } else if (data.tooth === "upper_jaw") {
                    $('#chart_upper_teeth').find('.' + data.main_cat).addClass('active_dent_db');
                } else if (data.tooth === "lower_jaw") {
                    $('#chart_lower_teeth').find('.' + data.main_cat).addClass('active_dent_db');
                } else {
                    //show the selected treatment tooth
                    $('[data-tooth_code="' + data.tooth + '"]').find('.' + data.main_cat).addClass(
                        'active_dent_db');
                }

                if (data.status == true) {
                    toastr.success("The Action Has Added Successfully");
                    $('.modal').modal('hide');
                    $('#table_basic_dental').append(
                        '<tr id="dental_bas_' + data
                        .id + '">' +
                        '<td class="text-uppercase"><i class="fas fa-tooth"></i> ' + data
                        .tooth + '</td>' +
                        '<td>' + data.surface + '</td>' +
                        '<td>' + data.service_name + '</td>' +
                        '<td>' + data.doctor_name + '</td>' +
                        '<td>' + data.date + '</td>' +
                        '<td>' + '<span class="text-red me-2 delete_basic_tooth" data-id="' +
                        data.id + '" data-code="' + data.tooth +
                        '" data-main_cat="' + data.main_cat +
                        '"><i class="fas fa-trash clickable-item-pointer"></i></span>' +
                        '<span class="text-gray-300 clickable-item-pointer me-2 show_dental_note" data-note="' +
                        data
                        .note + '"><i class="fas fa-pen"></i> Note</span>' + '</td>' +
                        '</tr>'
                    )

                } else {
                    toastr.error("Sorry, We Could not Add The Action");
                }
            },
            error: function(err) {
                // remove spinner to button
                $("#submit_basic_dental").prop("disabled", false);
                $("#submit_basic_dental").html('Send');

                $('#dental_min_cat_id-ErrorMsg').text(err.responseJSON.errors.dent_main_cat_id);
                $('#dental_service_id-ErrorMsg').text(err.responseJSON.errors.services_cat_id);
                $('#dental_code-ErrorMsg').text(err.responseJSON.errors.tooth);
                $('#dental_surfaces-ErrorMsg').text(err.responseJSON.errors.surface);
                $('#note_dental-ErrorMsg').text(err.responseJSON.errors.note);
                toastr.error("Sorry, Something went wrong");
            },
        });

    });



    //add new basic dental chart
    $(document).on('click', ".delete_basic_tooth", function(e) {
        e.preventDefault();

        var id = $(this).data('id');
        var code = $(this).data('code');
        var main_cat = $(this).data('main_cat');

        $("#submit_delete_dental_bas").attr('data-id', id);
        $("#submit_delete_dental_bas").attr('data-code', code);
        $("#submit_delete_dental_bas").attr('data-main_cat', main_cat);

        $('#dental_bas_delete').modal("show");
    })

    $(document).on('click', "#submit_delete_dental_bas", function(e) {
        e.preventDefault();

        var id = $(this).attr('data-id');
        var code = $(this).attr('data-code');
        var main_cat = $(this).attr('data-main_cat');

        var url = "{{ route('sett.pat_delete_basic_dental') }}";

        $(this).prop("disabled", true);
        // add spinner to button
        $(this).html(
            '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading...'
        );

        $.ajax({
            url: url,
            type: 'POST',
            dataType: "json",
            data: {
                '_token': "{{ csrf_token() }}",
                'id': id,
            },
            success: function(data) {
                $("#submit_delete_dental_bas").prop("disabled", false);
                $("#submit_delete_dental_bas").html('Send');

                $("#dental_bas_" + id).remove();

                console.log(code);
                console.log(main_cat);

                if (code === "all_teeth") {
                    $('#dental_chart').find('.' + main_cat).removeClass('active_dent_db active');
                } else if (code === "upper_jaw") {
                    $('#chart_upper_teeth').find('.' + main_cat).removeClass(
                        'active_dent_db active');
                } else if (code === "lower_jaw") {
                    $('#chart_lower_teeth').find('.' + main_cat).removeClass(
                        'active_dent_db active');
                } else {
                    //show the selected treatment tooth
                    $('[data-tooth_code="' + code + '"]').find('.' + main_cat).removeClass(
                        'active_dent_db active');
                }

                if (data.status == true) {
                    toastr.success("The Action Has Deleted Successfully");
                    $('.modal').modal('hide');
                } else {
                    toastr.error("Sorry, We Could not Delete The Action");
                    $('.modal').modal('hide');
                }
            },
            error: function(err) {
                // remove spinner to button
                $("#submit_delete_dental_bas").prop("disabled", false);
                $("#submit_delete_dental_bas").html('Send');
                $('.modal').modal('hide');
                toastr.error("Sorry, Something went wrong");
            },
        });


    })
    //add new basic dental chart
    $(document).on('click', ".show_dental_note", function(e) {
        e.preventDefault();
        var note = $(this).data('note');
        $("#dental_note_cont").html(note);
        $('#dental_note').modal("show");
    })
</script>








{{-- for action dental chart --}}
{{-- ---------------------------------------------------------------------------------- --}}


<script>
    // ----------------------------------------------------------------------------------
    $(document).ready(function() {

        //select one tooth
        $(document).on("click", ".click_tooth_a", function() {

            //get the tooth code
            code = $(this).data('tooth_code_a');

            //remove all selected active tooth

            //show selected in the selected tooth
            if (code === "all_teeth") {
                $('#dental_chart_a').find('.hover_tooth').removeClass('active');
                $('#dental_chart_a').find('.hover_tooth').addClass('active');
            } else if (code === "upper_jaw") {
                $('#chart_upper_teeth_a').find('.hover_tooth').removeClass('active');
                $('#chart_upper_teeth_a').find('.hover_tooth').addClass('active');
            } else if (code === "lower_jaw") {
                $('#chart_lower_teeth_a').find('.hover_tooth').removeClass('active');
                $('#chart_lower_teeth_a').find('.hover_tooth').addClass('active');
            } else {
                $('.hover_tooth').removeClass('active');
                $(this).find('.hover_tooth').addClass('active');
            }

            //pass the tooth code to the select modal
            $('#dental_code_a').val(code);
            $('#dental_min_cat_id_action').attr('data-code', code);

            $("#myModaloneTooth_action").modal("show");
        })

        //changing tooth treatment by select input
        $(document).on("change", "#dental_min_cat_id_action", function() {

            treatment = $(this).val();
            code = $(this).attr('data-code');
            amount = $(this).attr('data-amount');

            if (code === "all_teeth") {
                $('#dental_chart_a').find('img').removeClass('active');
                $('#dental_chart_a').find('.' + treatment).addClass('active');
            } else if (code === "upper_jaw") {
                $('#chart_upper_teeth_a').find('img').removeClass('active');
                $('#chart_upper_teeth_a').find('.' + treatment).addClass('active');
            } else if (code === "lower_jaw") {
                $('#chart_lower_teeth_a').find('img').removeClass('active');
                $('#chart_lower_teeth_a').find('.' + treatment).addClass('active');
            } else {
                //remove all active imgs first
                $('[data-tooth_code_a="' + code + '"]').find('img').removeClass('active');
                //show the selected treatment tooth
                $('[data-tooth_code_a="' + code + '"]').find('.' + treatment).addClass('active');
            }

        })


    })


    //fetching dental service accroding to main dental cat

    fetchDentalService_a();

    //for country and cities ajax inputs
    function fetchDentalService_a(main_id = $('select[name="dental_min_cat_id_action"]').val()) {

        var url = "{{ route('sett.pat_fetch_dental_service', ':id') }}";
        url = url.replace(':id', main_id);

        if (main_id) {
            $.ajax({
                url: url,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    $('select[name="dental_service_id_action"]').empty();
                    $.each(data, function(key, value) {
                        $('select[name="dental_service_id_action"]').append('<option value="' +
                            value.id + '" data-amount="' + value.price + '" >' + value.name +
                            '</option>');
                    });

                    amount = data[0].price;
                    $('input[name="dental_amount_sub"]').val(amount);

                }
            });
        } else {
            $('select[name="dental_min_cat_id_action"]').empty();
        }

    }

    $('select[name="dental_min_cat_id_action"]').on('change', function(e) {
        var main_id = $(this).val();
        fetchDentalService_a(main_id)
    });

    //pass the service price to amount input
    $('select[name="dental_service_id_action"]').on('change', function(e) {
        var amount = $('#dental_service_id_action').find(':selected').data('amount');
        $('input[name="dental_amount_sub"]').val(amount);
    });


    //add new basic dental chart
    $(document).on('click', "#submit_basic_dental_action", function(e) {
        e.preventDefault();

        //run vlidation plugin
        $(".myform").valid();

        var dental_min_cat_id = $("select[name='dental_min_cat_id_action']").val();
        var dental_service_id = $("select[name='dental_service_id_action']").val();
        var dental_code = $("input[name='dental_code_a']").val();
        var note_dental = $("input[name='note_doctor_dental_action']").val();
        var patient_id = $("input[name='patient_id']").val();
        var last_appointment_id_dental = $("select[name='last_appointment_id_dental']").val();


        var amount = $("input[name='dental_amount_sub']").val();
        var invoice_id = $("select[name='dental_cat_invoice']").val();
        var inv_note_dental = $("input[name='inv_note_dental_act']").val();


        var dental_surfaces = [];
        $.each($("select[name='dental_surfaces_action'] option:selected"), function(index, element) {
            dental_surfaces.push($(element).val());
        })

        var url = "{{ route('sett.pat_store_action_dental') }}";

        $(this).prop("disabled", true);
        // add spinner to button
        $(this).html(
            '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading...'
        );

        $.ajax({
            url: url,
            type: 'POST',
            dataType: "json",
            data: {
                '_token': "{{ csrf_token() }}",
                'patient_id': patient_id,
                'dent_main_cat_id': dental_min_cat_id,
                'services_cat_id': dental_service_id,
                'tooth': dental_code,
                'surface': dental_surfaces,
                'note': note_dental,
                'last_appointment_id_dental': last_appointment_id_dental,
                'amount': amount,
                'invoice_id': invoice_id,
                'inv_note_dental': inv_note_dental,
            },
            success: function(data) {
                $("#submit_basic_dental_action").prop("disabled", false);
                $("#submit_basic_dental_action").html('Send');

                if (data.tooth === "all_teeth") {
                    $('#dental_chart_a').find('.' + data.main_cat).addClass('active_dent_db');
                } else if (data.tooth === "upper_jaw") {
                    $('#chart_upper_teeth_a').find('.' + data.main_cat).addClass('active_dent_db');
                } else if (data.tooth === "lower_jaw") {
                    $('#chart_lower_teeth_a').find('.' + data.main_cat).addClass('active_dent_db');
                } else {
                    //show the selected treatment tooth
                    $('[data-tooth_code_a="' + data.tooth + '"]').find('.' + data.main_cat)
                        .addClass(
                            'active_dent_db');
                }

                if (data.status == true) {
                    toastr.success("The Action Has Added Successfully");
                    $('.modal').modal('hide');
                    $('#table_basic_dental_action').append(
                        '<tr id="dental_bas_a_' + data
                        .id + '">' +
                        '<td class="text-uppercase"><i class="fas fa-tooth"></i> ' + data
                        .tooth + '</td>' +
                        '<td>' + data.surface + '</td>' +
                        '<td>' + data.service_name + '</td>' +
                        '<td>' + data.doctor_name + '</td>' +
                        '<td>' + data.amount +
                        '<small class="text-gray-300 text-xxxs">EGP</small></td>' +
                        '<td>' + data.date + '</td>' +
                        '<td>' +
                        '<span class="text-gray-300 me-2 status_action_tooth" data-id="' +
                        data.id +
                        '"><i class="fas fa-check clickable-item-pointer"></i></span>' +
                        '<span class="text-red me-2 delete_action_tooth" data-id="' +
                        data.id + '" data-code="' + data.tooth +
                        '" data-main_cat="' + data.main_cat +
                        '"><i class="fas fa-trash clickable-item-pointer"></i></span>' +
                        '<span class="text-gray-300 clickable-item-pointer me-2 show_dental_note" data-note="' +
                        data
                        .note + '"><i class="fas fa-pen"></i> Note</span>' + '</td>' +
                        '</tr>'
                    )

                } else {
                    toastr.error("Sorry, We Could not Add The Action");
                }
            },
            error: function(err) {
                // remove spinner to button
                $("#submit_basic_dental_action").prop("disabled", false);
                $("#submit_basic_dental_action").html('Send');

                $('#dental_min_cat_id_action-ErrorMsg').text(err.responseJSON.errors
                    .dent_main_cat_id);
                $('#dental_service_id_action-ErrorMsg').text(err.responseJSON.errors
                    .services_cat_id);
                $('#dental_code_a-ErrorMsg').text(err.responseJSON.errors.tooth);
                $('#dental_surfaces_action-ErrorMsg').text(err.responseJSON.errors.surface);
                $('#note_dental_a-ErrorMsg').text(err.responseJSON.errors.note);
                $('#last_appointment_id_dental-ErrorMsg').text(err.responseJSON.errors
                    .last_appointment_id_dental);
                $('#dental_amount_sub-ErrorMsg').text(err.responseJSON.errors.amount);
                $('#dental_cat_invoice-ErrorMsg').text(err.responseJSON.errors.invoice_id);

                toastr.error("Sorry, Something went wrong");
            },
        });

    });



    //add new basic dental chart
    $(document).on('click', ".delete_action_tooth", function(e) {
        e.preventDefault();

        var id = $(this).data('id');
        var code = $(this).data('code');
        var main_cat = $(this).data('main_cat');

        $("#submit_delete_dental_act").attr('data-id', id);
        $("#submit_delete_dental_act").attr('data-code', code);
        $("#submit_delete_dental_act").attr('data-main_cat', main_cat);

        $('#dental_action_delete').modal("show");
    })


    $(document).on('click', "#submit_delete_dental_act", function(e) {
        e.preventDefault();

        var id = $(this).attr('data-id');
        var code = $(this).attr('data-code');
        var main_cat = $(this).attr('data-main_cat');

        var url = "{{ route('sett.pat_delete_action_dental') }}";

        $(this).prop("disabled", true);
        // add spinner to button
        $(this).html(
            '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading...'
        );

        $.ajax({
            url: url,
            type: 'POST',
            dataType: "json",
            data: {
                '_token': "{{ csrf_token() }}",
                'id': id,
            },
            success: function(data) {
                $("#submit_delete_dental_act").prop("disabled", false);
                $("#submit_delete_dental_act").html('Send');

                $("#dental_bas_a_" + id).remove();

                if (code === "all_teeth") {
                    $('#dental_chart_a').find('.' + main_cat).removeClass('active_dent_db active');
                } else if (code === "upper_jaw") {
                    $('#chart_upper_teeth_a').find('.' + main_cat).removeClass(
                        'active_dent_db active');
                } else if (code === "lower_jaw") {
                    $('#chart_lower_teeth_a').find('.' + main_cat).removeClass(
                        'active_dent_db active');
                } else {
                    //show the selected treatment tooth
                    $('[data-tooth_code_a="' + code + '"]').find('.' + main_cat).removeClass(
                        'active_dent_db active');
                }

                if (data.status == true) {
                    toastr.success("The Action Has Deleted Successfully");
                    $('.modal').modal('hide');
                } else {
                    toastr.error("Sorry, We Could not Delete The Action");
                    $('.modal').modal('hide');
                }
            },
            error: function(err) {
                // remove spinner to button
                $("#submit_delete_dental_act").prop("disabled", false);
                $("#submit_delete_dental_act").html('Send');
                $('.modal').modal('hide');
                toastr.error("Sorry, Something went wrong");
            },
        });


    })

    //add new basic dental chart
    $(document).on('click', ".show_dental_note", function(e) {
        e.preventDefault();
        var note = $(this).data('note');
        $("#dental_note_cont").html(note);
        $('#dental_note').modal("show");
    })




    $(document).on('click', ".status_action_tooth", function(e) {
        e.preventDefault();

        var id = $(this).attr('data-id');

        var that = $(this);
        var url = "{{ route('sett.pat_status_action_dental') }}";

        $.ajax({
            url: url,
            type: 'POST',
            dataType: "json",
            data: {
                '_token': "{{ csrf_token() }}",
                'id': id,
                'status': status,
            },
            success: function(data) {

                if (data.status == 0) {
                    that.removeClass('text-green');
                    that.addClass('text-gray-300');
                } else {
                    that.removeClass('text-gray-300');
                    that.addClass('text-green');
                }
                toastr.success(data.msg);

            },
            error: function(err) {

            },
        });


    })
</script>