<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $lab->patient->name }} - {{ $lab->code }}</title>
    <link rel="stylesheet" href="{{ public_path('css/kv-mpdf-bootstrap.css') }}">

</head>

<body>

    <!-- Card Body -->

    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-5 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 25%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url({{ public_path('img/useravatar/' . $lab->patient->avatar) }})">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 75%;float: left;">
                        <p class="m-0 p-0 text-s">
                            Patient</p>
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            {{ $lab->patient->name }}</p>
                        <p class="m-0 p-0 text-s">{{ $lab->patient->username }}</p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2 px-0" style="display: inline;">
                <p class="text-s mb-0">Name</p>
                <p class="fw-bold2">
                    {{ $lab->service_item->name }}
                </p>
            </div>

            <div class="col-xs-2 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Branch</p>
                <p class="fw-bold2">{{ $lab->branch->name }}</p>
            </div>
            <div class="col-xs-2">
                <p class="text-s mb-0">Created</p>
                <p class="fw-bold2">{{ date('d M Y h:i a', strtotime($lab->created_at)) }}</p>
            </div>
        </div>

        <div>
            <div style="width: 99%; height: 720px;">
                <img src="{{ public_path('img/lab/' . $lab->xray_file) }}"
                    style="width: 99%; height: 720px; position: absolute;">
            </div>
        </div>

    </div>

</body>

</html>
