@extends('layouts.master')

@section('title', 'Edit Lab | Proxima - Medical Management app')

@section('title-topbar', 'Edit Lab')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />


@endsection


<!-- content insert -->
@section('content')

<div class="container-fluid px-0 px-md-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">{{ __('basic.dashboard') }}
                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.lab.index') }}">{{ __('basic.lab') }}
                | </a>
            <a class="text-gray-300">{{ __('patientappo.edit lab result') }}</a>
        </span>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-x-ray me-1"></i>
                {{ __('patientappo.edit lab result') }}</h6>
        </div>


        <!-- Card Body -->
        <div class="card-body px-4 px-md-5">

            <form id="myform" method="POST" action="{{ route('sett.lab.update', $lab->id) }}"
                enctype="multipart/form-data">

                @csrf
                @method('PUT')

                <div class="row mb-1">

                    <div class="col-12 col-md-7 mb-2 pt-3">

                        <div class="row mb-2">
                            <div class="d-flex mb-2 align-items-center">

                                <img class="rounded-circle avatar-lg me-3"
                                    src="{{ URL::asset('img/useravatar/' . $lab->patient->avatar) }}">
                                <div class="">
                                    <p class=" mb-0 text-xs text-gray-300">
                                        {{ __('basic.patient') }}</p>
                                    <a class="mb-1 fw-bold fs-5 text-gray-600"
                                        href="{{ route('sett.patient.show', $lab->patient->id) }}">
                                        {{ $lab->patient->name }}</a>
                                    <p class="mb-0 text-xs text-gray-400">{{ __('basic.id') }} <strong>
                                            {{ $lab->patient->id }}</strong>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row mb-2">
                            <div class="col">
                                <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.name') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ $lab->service_item->name }}
                                </p>
                            </div>
                            <div class="col">
                                <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.code') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ $lab->code }}
                                </p>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col">
                                <h6 class="text-gray-300 text-s mb-1">{{ __('basic.created') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ date('d M Y h:i a', strtotime($lab->created_at)) }}
                                </p>
                            </div>
                            <div class="col">
                                <h6 class="text-gray-300 text-s mb-1">{{ __('patientappo.appointment date') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ date('d M Y h:i a', strtotime($lab->appointment->start_at)) }}
                                </p>
                            </div>

                        </div>

                        <div class="row mb-2">
                            <div class="col">

                                @if ($lab->invoice_item->invoice->status == 0)
                                @php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.not paid');
                                @endphp
                                @elseif ($lab->invoice_item->invoice->status == 1)
                                @php
                                $text_color_invoice = 'pend-color-btn';
                                $msg_invoice = __('basic.pending');
                                @endphp
                                @elseif ($lab->invoice_item->invoice->status == 2)
                                @php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.paid');
                                @endphp
                                @endif

                                <h6 class="text-gray-300 text-s mb-2">{{ __('basic.payment status') }}</h6>
                                <span class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{ $msg_invoice
                                    }}</span>
                            </div>
                            <div class="col">
                                <h6 class="text-gray-300 text-s mb-1">{{ __('basic.payment code') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ $lab->invoice_item->invoice->code }}
                                </p>
                            </div>
                        </div>

                    </div>

                    <div class="col-12 col-md-5 align-self-center mb-2">
                        <div class="avatar-update-container">
                            <div class="picture picture-lab">
                                @if (!empty($lab->xray_file))
                                @php
                                $img_url = URL::asset('img/lab/' . $lab->xray_file);
                                @endphp
                                @else
                                @php
                                $img_url = URL::asset('img/dashboard/cloud-upload-1912186-1617655.png');
                                @endphp
                                @endif

                                <img src="{{ $img_url }}" class="picture-src" id="mib_PicturePreview" title="" />
                                <input type="file" name='x_ray_file' accept="image/*" id="mib_img_input">
                            </div>
                            <h6 class="text-gray-300">{{ __('basic.choose pic') }}</h6>

                            @error('x_ray_file')
                            <span class="error-msg-form">
                                {{ $message }}
                            </span>
                            @enderror
                        </div>
                    </div>


                </div>

                <hr>
                <div class="row mb-2">
                    <div class="col-12 col-md-6 mb-2">
                        <label class="form-label">{{ __('basic.doctor note') }}</label>
                        <div class="form-control-textarea overflow-auto">
                            {{ $lab->note_doctor }}</div>
                    </div>
                    <div class="col-12 col-md-6 mb-2">
                        <label class="form-label">{{ __('patientappo.lab note') }}
                            <small>({{ __('basic.optional') }})</small></label>
                        <textarea name="lab_note" class="form-control" placeholder="Write here your notes .." rows="4"
                            spellcheck="false">{{ $lab->note_lab }}</textarea>

                        @error('lab_note')
                        <span class="error-msg-form">
                            {{ $message }}
                        </span>
                        @enderror
                    </div>

                </div>

                <input type="hidden" name="responsible_doctor" class="form-control" value="{{ Auth::id() }}">

                <div class="d-flex justify-content-end mt-4 mb-2">
                    <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                        value="{{ __('basic.update') }}">
                </div>

            </form>
        </div>

    </div>

</div>

@endsection

<!-- js insert -->
@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
</script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
</script>

<!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
        var $validator = $('#myform').validate({
            rules: {
                first_name: {
                    minlength: 3,
                },
                second_name: {
                    minlength: 3,
                },
                email: {
                    email: true,
                },
                password: {
                    minlength: 7,
                    maxlength: 100,
                },
                password_confirmation: {
                    minlength: 7,
                    maxlength: 100,
                    equalTo: '#password',
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'gendar':
                        error.insertAfter($("#gendar-js-error-valid"));
                        break;
                    default:
                        error.insertAfter(element);
                }

            },
        });
</script>

@endsection