@extends('layouts.master')

@section('title', 'All Invoices | Proxima - Medical Management app')

@section('title-topbar', __('basic.smart search'))

<!-- css insert -->
@section('css')

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

@endsection

<!-- content insert -->

<!-- content insert -->
@section('content')

<div class="container-fluid px-md-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">{{ __('basic.dashboard') }}
                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.invoice.index') }}">{{
                __('basic.invoices') }} | </a>
            <a class="text-gray-300">{{ __('basic.smart search') }}</a>
        </span>
    </div>

    <div class="row">

        <div class="col me-0 me-md-3 mb-3 mb-md-0 px-0 ">

            <div class="position-relative" style="top: 0; left: 0; width: 100%; height: 100%;">

                <div class="bg-white b-r-s-cont shadow pb-4 position-sticky top-0">
                    <h6 class="mb-0 p-3 main-color-bg text-white" style="border-radius: 18px 18px 0px 0px;"><i
                            class="fas fa-filter"></i> {{ __('basic.search filter') }}</h6>

                    <form id="myform" class="mt-1" method="GET" action="{{ route('sett.inv_show_all_invoices') }}">
                        @csrf

                        <div class="accordion search-accordion" id="accordionExample">

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingSpec">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseSpec" aria-expanded="true" aria-controls="collapseOne">
                                        <i class="fas fa-stethoscope me-1"></i> {{ __('basic.specialty') }}
                                    </button>
                                </h2>
                                <div id="collapseSpec" class="accordion-collapse collapse show"
                                    aria-labelledby="headingSpec" data-bs-parent="#accordionExample">
                                    <div class="accordion-body py-0 px-3">

                                        <div class="form-group">
                                            @foreach ($specialty as $item)
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="{{ $item->id }}" type="radio"
                                                    name="specialty_srch" id="{{ $item->id }}">
                                                <label class="form-check-label" for="{{ $item->id }}">
                                                    {{ $item->name }}
                                                </label>
                                            </div>
                                            @endforeach
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingOne">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        <i class="fas fa-map-marker-alt me-1"></i> {{ __('basic.branch') }}
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body py-0 px-3">

                                        <div class="form-group">
                                            @foreach ($branch as $item)
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="{{ $item->id }}" type="radio"
                                                    name="branch_srch" id="{{ $item->id }}">
                                                <label class="form-check-label" for="{{ $item->id }}">
                                                    {{ $item->name }}
                                                </label>
                                            </div>
                                            @endforeach
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#country_side_search" aria-expanded="false"
                                        aria-controls="country_side_search">
                                        <i class="fas fa-receipt me-1"></i> Type
                                    </button>
                                </h2>
                                <div id="country_side_search" class="accordion-collapse collapse"
                                    aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                    <div class="accordion-body py-0 px-3">

                                        <div class="form-group">
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="0" type="radio" name="type_srch"
                                                    id="credit_type">
                                                <label class="form-check-label" for="credit_type">
                                                    Income
                                                </label>
                                            </div>
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="1" type="radio" name="type_srch"
                                                    id="debit_type">
                                                <label class="form-check-label" for="debit_type">
                                                    Expenses
                                                </label>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#city_side_search" aria-expanded="false"
                                        aria-controls="city_side_search">
                                        <i class="fas fa-dollar-sign me-1"></i> Status
                                    </button>
                                </h2>
                                <div id="city_side_search" class="accordion-collapse collapse"
                                    aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                    <div class="accordion-body py-0 px-3">

                                        <div class="form-group">
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="0" type="radio"
                                                    name="status_srch" id="notpaid_status">
                                                <label class="form-check-label" for="notpaid_status">
                                                    Not Paid
                                                </label>
                                            </div>
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="1" type="radio"
                                                    name="status_srch" id="pend_status">
                                                <label class="form-check-label" for="pend_status">
                                                    Pending
                                                </label>
                                            </div>
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="2" type="radio"
                                                    name="status_srch" id="insta_status">
                                                <label class="form-check-label" for="insta_status">
                                                    Installment
                                                </label>
                                            </div>
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="3" type="radio"
                                                    name="status_srch" id="paid_status">
                                                <label class="form-check-label" for="paid_status">
                                                    Paid
                                                </label>
                                            </div>
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="4" type="radio"
                                                    name="status_srch" id="paid_status">
                                                <label class="form-check-label" for="paid_status">
                                                    Refund
                                                </label>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="targetSpec">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseSpec_target" aria-expanded="false"
                                        aria-controls="collapseOne">
                                        <i class="fas fa-stethoscope me-1"></i> {{ __('basic.target') }}
                                    </button>
                                </h2>
                                <div id="collapseSpec_target" class="accordion-collapse collapse"
                                    aria-labelledby="targetSpec" data-bs-parent="#accordionExample">
                                    <div class="accordion-body py-0 px-3">
                                        <div class="form-group">
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="1" type="radio"
                                                    name="target_srch" id="target_old">
                                                <label class="form-check-label" for="target_old">
                                                    Old
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="2" type="radio"
                                                    name="target_srch" id="new_page_traget">
                                                <label class="form-check-label" for="new_page_target">
                                                    New page
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="3" type="radio"
                                                    name="target_srch" id="new_friend_traget">
                                                <label class="form-check-label" for="new_friend_target">
                                                    New friend
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="4" type="radio"
                                                    name="target_srch" id="offer_traget">
                                                <label class="form-check-label" for="offer_traget">
                                                    Offer
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="5" type="radio"
                                                    name="target_srch" id="upgrade_traget">
                                                <label class="form-check-label" for="upgrade_traget">
                                                    Upgrade
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="6" type="radio"
                                                    name="target_srch" id="other_traget">
                                                <label class="form-check-label" for="other_traget">
                                                    Other
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="7" type="radio"
                                                    name="target_srch" id="other_2_traget">
                                                <label class="form-check-label" for="other_2_traget">
                                                    Other 2
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#reference_side_search" aria-expanded="false"
                                        aria-controls="reference_side_search">
                                        <i class="fas fa-share-alt me-1"></i> {{ __('patientappo.resources') }}
                                    </button>
                                </h2>
                                <div id="reference_side_search" class="accordion-collapse collapse"
                                    aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                    <div class="accordion-body py-0 px-3">

                                        <div class="form-group">
                                            @foreach ($resources as $item)
                                            <div class="form-check mb-1">
                                                <input class="form-check-input" value="{{ $item->id }}" type="radio"
                                                    name="resource_srch" id="re{{ $item->id }}"
                                                    @if(request()->get('resource_srch') == $item->id) checked @endif>
                                                <label class="form-check-label" for="re{{ $item->id }}">
                                                    {{ $item->name }}
                                                </label>
                                            </div>
                                            @endforeach
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#month_side_search" aria-expanded="false"
                                        aria-controls="month_side_search">
                                        <i class="bi bi-calendar3-range me-1"></i> Months
                                    </button>
                                </h2>
                                <div id="month_side_search" class="accordion-collapse collapse"
                                    aria-labelledby="headingThree" data-bs-parent="#accordionExample">

                                    <div class="d-flex justify-content-center p-2 search_all_invoice">
                                        <div id="datepicker" data-date="12/03/2012"></div>
                                        <input type="hidden" name="month_year_srch" id="my_hidden_input">
                                    </div>

                                </div>
                            </div>

                        </div>

                        <div class="d-flex justify-content-center align-items-center mt-3">
                            <a class="text-gray-300 me-2" href="{{ route('sett.inv_show_all_invoices') }}">{{
                                __('basic.reset') }}</a>
                            <button class="btn btn-primary px-4">{{ __('basic.search') }}</button>
                        </div>
                    </form>

                </div>

            </div>

        </div>

        <div class="col-12 col-md-9">

            <div class="d-flex  mb-2">
                <p class="text-gray-400 me-2">{{ __('patientappo.total amount') }}
                    <span>{{ $invoices->sum('total_paid') }} <small class="text-gray-300 text-xxxs">
                            {{ __('basic.egp') }}</small></span>
                </p>

                <p class="text-gray-400">{{ __('patientappo.total patients') }}
                    <span>{{ count($invoices) }} <small class="text-gray-300 text-xxxs">
                            {{ __('basic.patients') }}</small></span>
                </p>
            </div>

            <div>
                @foreach ($invoices as $item)
                <div class="row align-items-center shadow b-r-s-cont bg-white p-2 mb-2">

                    <div class="col-12 col-md-5 d-flex align-items-center mb-2 mb-md-0">
                        @if ($item->receivable)
                        <img class="rounded-circle avatar-small2 me-3"
                            src="{{ URL::asset('img/useravatar/' . $item->receivable->avatar) }}">
                        @else
                        <div class="text-gray-300 me-3">
                            <i class="fas fa-id-card-alt fs-2 mb-1"></i>
                        </div>
                        @endif

                        <div class="">
                            <p class="mb-0 text-xs text-gray-300">
                                {{ date('d M Y', strtotime($item->created_at)) }}</p>

                            @if ($item->receivable)
                            <a href="{{ route('sett.invoice.show', $item->id) }}"
                                class="mb-1 fw-bold text-s text-gray-600">
                                {{ $item->receivable->name }}
                            </a>
                            @else
                            <div class="text-gray-300">
                                <span class="mb-0">No Receiver</span>
                            </div>
                            @endif

                            <p class="mb-0 text-xs text-gray-400"><strong>
                                    @if ($item->type == 0)
                                    Income
                                    @else
                                    Expenses
                                    @endif
                                </strong></p>
                        </div>
                    </div>

                    <div class="col text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.code') }}</h6>
                        <a href="{{ route('sett.invoice.show', $item->id) }}" class="link-cust-text text-gray-400">
                            <h6 class="text-s text-gray-500 text-truncate">{{ $item->code }}
                            </h6>
                        </a>
                    </div>

                    <div class="col text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.specialty') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">{{ $item->specialty->name }}
                        </h6>
                    </div>

                    <div class="col text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.branch') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">{{ $item->branch->name }}
                        </h6>
                    </div>

                    <div class="col text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.amount') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            @if ($item->total_paid)
                            {{ $item->total_paid }} <small class="text-gray-300 text-xxxs">
                                {{ __('basic.egp') }}</small>
                            @else
                            0
                            @endif

                        </h6>
                    </div>

                    <div class="col text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.status') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">

                            @if ($item->status == 0)
                            @php
                            $text_color_invoice = 'cancel-color-btn';
                            $msg_invoice = __('basic.not paid');
                            @endphp
                            @elseif ($item->status == 1)
                            @php
                            $text_color_invoice = 'pend-color-btn';
                            $msg_invoice = __('basic.pending');
                            @endphp
                            @elseif ($item->status == 2)
                            @php
                            $text_color_invoice = 'prog-color-btn';
                            $msg_invoice = __('basic.installment');
                            @endphp
                            @elseif ($item->status == 3)
                            @php
                            $text_color_invoice = 'done-color-btn';
                            $msg_invoice = __('basic.paid');
                            @endphp
                            @elseif ($item->status == 4)
                            @php
                            $text_color_invoice = 'cancel-color-btn';
                            $msg_invoice = __('basic.refund');
                            @endphp
                            @endif

                            <span class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{ $msg_invoice
                                }}</span>
                        </h6>
                    </div>

                </div>
                @endforeach
            </div>

            <div class="d-flex mt-4 justify-content-end">
                {{ $invoices->appends(request()->input())->links() }}
            </div>

        </div>
    </div>


</div>

@endsection


<!-- js insert -->
@section('js')

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>

<script>
    $(document).ready(function() {

            $('#datepicker').datepicker({
                todayHighlight: true,
                format: "mm-yyyy",
                viewMode: "months",
                minViewMode: "months",
                    autoclose: true,
            });
            $('#datepicker').on('changeDate', function() {
                $('#my_hidden_input').val(
                    $('#datepicker').datepicker('getFormattedDate')
                );
            });

            //--------------------- fetch appoingtments -------------------

        });
</script>

@endsection
