<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>
        @if ($invoice->receivable)
            {{ $invoice->receivable->name }}
        @else
            No receiver
        @endif - {{ $invoice->code }}
    </title>
    <link rel="stylesheet" href="{{ public_path('css/kv-mpdf-bootstrap.css') }}">

</head>

<body>

    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-5 text-truncate p-0" style="">
                <div class="w-10">
                    @if ($invoice->receivable)

                        <div class="p-0" style="width: 25%;float: left;">
                            <div class="rounded-circle avatar-m2 profile_img"
                                style="background-image: url({{ public_path('img/useravatar/' . $invoice->receivable->avatar) }})">
                            </div>
                        </div>

                        <div class="text-truncate p-0" style="width: 75%;float: left;">
                            <p class="m-0 p-0 text-s">
                                @if ($invoice->receivable_type === 'App\Models\Patient\Patient')
                                    Patient
                                @elseif ($invoice->receivable_type === 'App\Models\User')
                                    Doctor
                                @elseif ($invoice->receivable_type === 'App\Models\Invoice\Debtor')
                                    Debtor
                                @endif
                            </p>
                            <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                                {{ $invoice->receivable->name }}</p>
                            <p class="m-0 p-0 text-s">
                                {{ date('d M Y h:i a', strtotime($invoice->created_at)) }}
                            </p>
                        </div>
                    @else
                        The invoice is for no receiver
                    @endif

                </div>
            </div>

            <div class="col-xs-1 px-0" style="display: inline;">
                <p class="text-s mb-0">Type</p>
                <p class="fw-bold2">
                    @if ($invoice->type == 0)
                        Client
                    @else
                        Client
                    @endif
                </p>
            </div>

            <div class="col-xs-2 px-0" style="display: inline;">
                <p class="text-s mb-0">Specialty</p>
                <p class="fw-bold2">
                    {{ $invoice->specialty->name }}
                </p>
            </div>

            <div class="col-xs-1 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Branch</p>
                <p class="fw-bold2">{{ $invoice->branch->name }}</p>
            </div>

            <div class="col-xs-2">
                <p class="text-s mb-0">Paid At</p>
                <p class="fw-bold2">{{ date('d M Y h:i a', strtotime($invoice->paid_date)) }}</p>
            </div>
        </div>

        <br class="mb-5">

        @foreach ($invoice->invoice_items as $item)
            <div class="row px-0 mt-3">
                <div class="col-xs-6 px-0 text-center text-s2">
                    <i class="fas fa-stethoscope me-2"></i>
                    <span id="service_final_info text-l fw-bold">{{ $item->categorizable->name }}</span>
                </div>
                <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                    <div class="text-s2 fw-bold2">{{ $item->price }}<small class="text-gray-300 text-s">
                            EGP</small>
                    </div>
                </div>
            </div>
        @endforeach
        <hr>

        <div class="row px-0 px-md-3 px-lg-5 my-2">
            <div class="col-xs-6 px-0 text-center text-l text-s2">
                <i class="fas fa-coins me-2 text-gray-400"></i><span
                    id="service_final_info">{{ __('basic.subtotal') }}</span>
            </div>
            <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                <div class="text-s2">{{ $invoice->invoice_items->sum('price') }}<small class="text-gray-300 text-xxxs">
                        {{ __('basic.egp') }}</small>
                </div>
            </div>
        </div>

        <div class="row px-0 mb-2">
            <div class="col-xs-6 px-0 text-center text-l text-s2">
                <i class="fas fa-stethoscope me-2"></i>
                <span id="service_final_info text-l fw-bold">Discount</span>
            </div>
            <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                <div class="text-s2 fw-bold2">
                    @if (!empty($invoice->discount))
                        {{ $invoice->discount }}
                        <small class="text-gray-300 text-s"> EGP</small>
                    @else
                        0
                    @endif
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-xs-6 px-0 text-center text-l text-s2">
                <i class="fas fa-dollar-sign me-2"></i>
                <span id="service_final_info">{{ __('patientappo.final price') }}</span>
            </div>
            <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                <div class="text-s2 fw-bold" id="price_total_final_info_edit">
                    {{ $invoice->final_price }}<small class="text-gray-300 text-xxxs">
                        {{ __('basic.egp') }}</small>
                </div>
            </div>
        </div>

        {{-- for payments --}}
        @if (count($invoice->payment) > 0)

            <hr>

            @foreach ($invoice->payment as $item_p)
                @php
                    if ($item_p->method == 1) {
                        $method_payment = 'Cash';
                    } else {
                        $method_payment = 'Visa';
                    }
                @endphp
                <div class="row px-0 px-md-3 px-lg-5 mt-2">
                    <div class="col-xs-6 px-0 text-center text-l text-s2">
                        <i class="fas fa-pen me-2 link-cust-text text-gray-400 clickable-item-pointer"
                            data-bs-toggle="modal" data-bs-target="#edit_inv_payment_{{ $item_p->id }}"></i>

                        <i class="fas fa-dollar-sign me-1 text-gray-400"></i>
                        @if ($item_p->type == 2)
                            <span id="service_final_info"
                                class="pend-color">{{ date('d M Y', strtotime($item_p->installment_date)) }}
                                Installment
                            </span>
                        @else
                            <span id="service_final_info">{{ date('d M Y', strtotime($item_p->paid_date)) }}
                                via
                                {{ $method_payment }}
                            </span>
                        @endif
                        @if ($item_p->installment_date)
                            <p class="mb-0">Installment:
                                {{ date('d M Y', strtotime($item_p->installment_date)) }}
                            </p>
                        @endif
                        @if ($item_p->worker)
                            <p class="text-gray-400 mb-0">Shift:
                                {{ $item_p->worker->name }}
                            </p>
                        @endif
                    </div>
                    <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                        <div class="text-s2">{{ $item_p->amount }}<small class="text-gray-300 text-xxxs">
                                {{ __('basic.egp') }}</small>
                        </div>
                    </div>
                </div>
            @endforeach

            <div class="row px-0 px-md-3 px-lg-5 my-2">
                <div class="col-xs-6 px-0 text-center text-l text-s2">
                    <i class="fas fa-dollar-sign me-2"></i>
                    <span id="service_final_info">{{ __('basic.total payments') }}</span>
                </div>

                <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                    <div class="text-s2 fw-bold">
                        @if ($invoice->sum_payment)
                            {{ $invoice->sum_payment }}
                        @else
                            0
                        @endif
                        <small class=" text-xxxs"> {{ __('basic.egp') }}</small>
                    </div>
                </div>
            </div>

            @if ($invoice->status !== 3)
                <hr>
                <div class="row px-0 px-md-3 px-lg-5 my-2 mb-5">
                    <div class="col-xs-6 px-0 text-center text-l text-s2">
                        <i class="fas fa-money-check me-2 text-gray-400"></i>
                        <span id="service_final_info">{{ __('basic.remaining amount') }}</span>
                    </div>
                    <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                        <div class="text-s2 fw-bold2">
                            {{ $invoice->final_price - $invoice->sum_payment }}<small class="text-gray-300 text-xxxs">
                                {{ __('basic.egp') }}</small>
                        </div>
                    </div>
                </div>
            @endif
        @endif

        <div class="row align-items-center main-color-bg b-r-s-cont border-0 text-white b-r-s-cont px-0 py-4 mt-4">
            <div class="col-xs-5 text-blue-300 mb-md-0 ps-5">
                Here is the total price that you have paid including tax with discount applied
            </div>

            <div class="col-xs-5 text-center px-0">

                @if ($invoice->status == 0)
                    <p id="date_final_info" class="fs-2 fw-bold mb-0">
                        {{ __('basic.not paid') }}
                    </p>
                @elseif (in_array($invoice->status, [1, 2]))
                    <h6 class="text-xs mb-2 text-blue-300">{{ __('basic.remaining amount') }}</h6>
                    <p class="text-l text-white fw-bold2 mb-0">
                        {{ $invoice->final_price - $invoice->sum_payment }} <small class="text-blue-300 text-xxxs">
                            {{ __('basic.egp') }}</small>
                    </p>
                @else
                    <h6 class="text-xs mb-0 text-blue-300">{{ __('patientappo.amount to pay') }}</h6>
                    <p id="date_final_info" class="text-l text-white fw-bold2 mb-0">
                        {{ $invoice->final_price }} <small class="text-blue-300 text-xxxs">
                            {{ __('basic.egp') }}</small>
                    </p>
                @endif
            </div>

        </div>
    </div>

</body>

</html>
