@extends('layouts.master')

@section('title', 'New Invoice | Proxima - Medical Management app')

@section('title-topbar', 'Invoice')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

@endsection

@section('fixedcontent')
<!-- session successful message -->
@if (Session::has('success'))
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300">{{ Session::get('success') }}</p>
</div>
@endif
@endsection

<!-- content insert -->
@section('content')

<div class="container-fluid px-0 px-md-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.invoice.index') }}">Invoice | </a>
            <a class="text-gray-300">New Invoice</a>
        </span>
    </div>

    <div class="row">

        <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="year_invoice-tab" data-bs-toggle="tab" data-bs-target="#expenses"
                    type="button" role="tab" aria-controls="year_invoice" aria-selected="true" class="text-gray-500"><i
                        class="fas fa-dollar-sign me-1"></i>
                    Expenses</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" class="nav-link" id="home-tab" data-bs-toggle="tab" data-bs-target="#income"
                    type="button" role="tab" aria-controls="home" aria-selected="true" class="text-gray-500"><i
                        class="fas fa-money-check me-1"></i>
                    Income</button>
            </li>
        </ul>
    </div>

    <div class="tab-content" id="myTabContent">

        <div class="tab-pane fade show active" id="expenses" role="tabpanel" aria-labelledby="year_invoice">

            <div class="card card-input shadow mb-3 pb-3">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-dollar-sign me-1"></i> New Expenses</h6>
                </div>

                <!-- Card Body -->
                <div class="card-body px-4 px-md-5">

                    @foreach ($errors->all() as $error)
                    <div class="text-red"><i class="fas fa-exclamation me-1"></i> {{ $error }}</div>
                    @endforeach

                    <form id="myform" method="POST" action="{{ route('sett.invoice.store') }}"
                        enctype="multipart/form-data">
                        @csrf

                        <div class="row mb-1 justify-content-center">

                            <div class="col-12 col-md-10 col-lg-7">
                                <div class="row">

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Specialty
                                            <small>(required)</small></label>
                                        <select id="specialty_id"
                                            class="select2-no-search select2-hidden-accessible @error('specialty_id') is-invalid @enderror"
                                            name="specialty_id" required>
                                            @foreach ($specialty_cat as $iteam)
                                            <option value="{{ $iteam->id }}">
                                                {{ $iteam->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                        <div id="specialty_id-js-error-valid"></div>

                                        @error('specialty_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>



                                    @if(Auth::user()->branch_id == 0)
                                    <div class="col-12 mb-3">
                                        <label class="form-label">Branch
                                            <small>(required)</small></label>
                                        <select
                                            class="js-example-basic-single select2-hidden-accessible @error('debt_branch_id') is-invalid @enderror"
                                            name="debt_branch_id" required>
                                            @foreach ($branch as $iteam)
                                            <option value="{{ $iteam->id }}">{{ $iteam->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        @error('debt_branch_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>
                                    @else
                                    <input type="hidden" name="debt_branch_id" value="{{ Auth::user()->branch_id }}">
                                    @endif

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Item
                                            <small>(required)</small></label>
                                        <select id="expenses_item"
                                            class="js-example-basic-single select2-hidden-accessible @error('expenses_item') is-invalid @enderror"
                                            name="expenses_item" required>
                                            @foreach ($debt_cat as $iteam)
                                            <option value="{{ $iteam->id }}" data-price="{{ $iteam->price }}">
                                                {{ $iteam->name }}
                                            </option>
                                            @endforeach
                                            <option value="prodcut_inventory">Product</option>
                                        </select>
                                        <div id="expenses_item-js-error-valid"></div>

                                        @error('expenses_item')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3" id="prodcuts_inven_debit_cont" style="display: none">
                                        <label class="form-label">Product
                                            <small>(required)</small></label>
                                        <select id="prodcuts_inven_debit" disabled
                                            class="js-example-basic-single select2-hidden-accessible @error('prodcuts_inven_debit') is-invalid @enderror"
                                            name="prodcuts_inven_debit" required>
                                        </select>
                                        <div id="prodcuts_inven_debit-js-error-valid"></div>

                                        @error('prodcuts_inven_debit')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>


                                    <div class="col-12 mb-3">

                                        <label class="form-label">Partner
                                            <small>(optional)</small></label>
                                        <input id="debtor_receivable_id" type="text"
                                            class="form-control @error('debtor_id') is-invalid @enderror"
                                            placeholder="Write here debtor name ...">

                                        @error('debtor_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                        <input type="hidden" id="debtor_id" name="debtor_id" value="">

                                        <div id="debtor_search-eng-show-list"
                                            class="search-eng-results list-group p-4 bg-white b-r-l-b-cont"
                                            style="box-shadow: -1px 1rem 1rem 7px rgb(58 59 69 / 15%) !important; display:none; margin-top: -3px; border:1px solid #bcd8ff; border-top: 0px">
                                        </div>
                                    </div>


                                    <div class="col-12 mb-3">
                                        <label class="form-label">Doctor
                                            <small>(optional)</small></label>

                                        <input id="doctor_receivable_id" type="text"
                                            class="form-control @error('doctor_id') is-invalid @enderror"
                                            placeholder="Write here doctor name ...">

                                        @error('doctor_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                        <input type="hidden" id="doctor_id" name="doctor_id" value="">

                                        <div id="doctor_search-eng-show-list"
                                            class="search-eng-results list-group p-4 bg-white b-r-l-b-cont"
                                            style="box-shadow: -1px 1rem 1rem 7px rgb(58 59 69 / 15%) !important; display:none; margin-top: -3px; border:1px solid #bcd8ff; border-top: 0px">
                                        </div>
                                    </div>

                                    <div class="col-12 mb-3" id="stock_quantity_cont" style="display: none">
                                        <label class="form-label">Quantity</label>
                                        <input name="stock_quantity" id="stock_quantity"
                                            class="form-control @error('stock_quantity') is-invalid @enderror"
                                            type="number" disabled>
                                        @error('stock_quantity')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Price</label>
                                        <input name="exp_item_price" id="exp_item_price"
                                            class="form-control @error('exp_item_price') is-invalid @enderror"
                                            type="number">
                                        @error('exp_item_price')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Amount Paid
                                            <small>(required)</small></label>
                                        <input name="amount_paid" type="number"
                                            class="form-control @error('amount_paid') is-invalid @enderror"
                                            placeholder="How much is the deposit ..." required>

                                        @error('amount_paid')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.date') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="expenses_pay_date" type="text"
                                                class="form-control hasdatetimepicker @error('expenses_pay_date') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="expenses_pay_date_error" class="error-msg-form"></span>

                                        @error('expenses_pay_date')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12">
                                        <div class="mb-3">
                                            <label class="form-label">Note <small>(optional)</small></label>
                                            <textarea name="note" class="form-control"
                                                placeholder="Write here your notes .." rows="4"
                                                spellcheck="false">{{ old('note') }}</textarea>
                                        </div>
                                        @error('note')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Attached img
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <input class="form-control" name='attached_pic_expenses' accept="image/*"
                                            type="file" id="formFile">

                                        <div class="form-text text-gray-200">Attach an invoice img.
                                        </div>

                                        <span id="attached_pic_expenses_error" class="error-msg-form"></span>

                                        @error('attached_pic_expenses')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-2 mb-2">
                            <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="Send">
                        </div>

                    </form>
                </div>

            </div>
        </div>


        <div class="tab-pane fade" id="income" role="tabpanel" aria-labelledby="home-tab">


            <div class="card card-input shadow mb-3 pb-3">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-money-check me-1"></i> New Income</h6>
                </div>

                <!-- Card Body -->
                <div class="card-body px-4 px-md-5">

                    @foreach ($errors->all() as $error)
                    <div class="text-red"><i class="fas fa-exclamation me-1"></i> {{ $error }}
                    </div>
                    @endforeach
                    <form id="myform" method="POST" action="{{ route('sett.invo_store_income') }}"
                        enctype="multipart/form-data">

                        @csrf

                        <div class="row mb-1 justify-content-center">

                            <div class="col-12 col-md-10 col-lg-7">
                                <div class="row">

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Specialty
                                            <small>(required)</small></label>
                                        <select id="specialty_credit_id"
                                            class="select2-no-search select2-hidden-accessible @error('specialty_credit_id') is-invalid @enderror"
                                            name="specialty_credit_id" required>
                                            @foreach ($specialty_cat as $iteam)
                                            <option value="{{ $iteam->id }}">
                                                {{ $iteam->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                        <div id="specialty_credit_id-js-error-valid"></div>

                                        @error('specialty_credit_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Branch
                                            <small>(required)</small></label>
                                        <select
                                            class="js-example-basic-single select2-hidden-accessible @error('credit_branch_id') is-invalid @enderror"
                                            name="credit_branch_id" required>
                                            @foreach ($branch as $iteam)
                                            <option value="{{ $iteam->id }}">{{ $iteam->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        @error('credit_branch_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Item
                                            <small>(required)</small></label>
                                        <select id="service_item"
                                            class="js-example-basic-single select2-hidden-accessible @error('service_item') is-invalid @enderror"
                                            name="service_item" required>
                                            @foreach ($service_cat as $iteam)
                                            <option value="{{ $iteam->id }}" data-price="{{ $iteam->price }}">
                                                {{ $iteam->name }}
                                            </option>
                                            @endforeach
                                            <option value="prodcut_inventory">Product</option>
                                        </select>
                                        <div id="service_item-js-error-valid"></div>

                                        @error('service_item')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3" id="prodcuts_inven_credit_cont" style="display: none">
                                        <label class="form-label">Product
                                            <small>(required)</small></label>
                                        <select id="prodcuts_inven_credit" disabled
                                            class="js-example-basic-single select2-hidden-accessible @error('prodcuts_inven_credit') is-invalid @enderror"
                                            name="prodcuts_inven_credit" required>
                                        </select>
                                        <div id="prodcuts_inven_credit-js-error-valid"></div>

                                        @error('prodcuts_inven_credit')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Patient
                                            <small>(optional)</small></label>
                                        <input id="credit_receivable_id" type="text"
                                            class="form-control @error('patient_id') is-invalid @enderror"
                                            placeholder="Write here patient name ...">

                                        @error('patient_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                        <input type="hidden" id="patient_id" name="patient_id" value="">

                                        <div id="search-eng-show-list"
                                            class="search-eng-results list-group p-4 bg-white b-r-l-b-cont"
                                            style="box-shadow: -1px 1rem 1rem 7px rgb(58 59 69 / 15%) !important; display:none; margin-top: -3px; border:1px solid #bcd8ff; border-top: 0px">
                                        </div>
                                    </div>

                                    <div class="col-12 mb-3" id="credit_quantity_cont" style="display: none">
                                        <label class="form-label">Quantity</label>
                                        <input name="credit_quantity" id="credit_quantity"
                                            class="form-control @error('credit_quantity') is-invalid @enderror"
                                            type="number" disabled>
                                        @error('credit_quantity')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Price</label>
                                        <input id="credit_price" name="credit_price"
                                            class="form-control @error('credit_price') is-invalid @enderror"
                                            type="number">

                                        @error('credit_price')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Amount Paid
                                            <small>(required)</small></label>
                                        <input name="amount_paid_expenses" type="number"
                                            class="form-control @error('amount_paid_expenses') is-invalid @enderror"
                                            placeholder="The amount of deposit ...">

                                        @error('amount_paid_expenses')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.date') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="income_pay_date" type="text"
                                                class="form-control hasdatetimepicker @error('income_pay_date') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="income_pay_date_error" class="error-msg-form"></span>

                                        @error('income_pay_date')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12">
                                        <div class="mb-3">
                                            <label class="form-label">Note <small>(optional)</small></label>
                                            <textarea name="note_credit" class="form-control"
                                                placeholder="Write here your notes .." rows="4"
                                                spellcheck="false">{{ old('note_credit') }}</textarea>
                                        </div>
                                        @error('note_credit')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Attached img
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <input class="form-control" name='attached_pic_income' accept="image/*"
                                            type="file" id="formFile">

                                        <div class="form-text text-gray-200">Attach an invoice img.
                                        </div>

                                        <span id="attached_pic_income_error" class="error-msg-form"></span>

                                        @error('attached_pic_income')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-2 mb-2">
                            <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="Send">
                        </div>

                    </form>

                </div>

            </div>

        </div>
    </div>

</div>

@endsection

<!-- js insert -->
@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
</script>


<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
</script>

<!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
        var $validator = $('#myform').validate({
            rules: {
                password_confirmation: {
                    minlength: 7,
                    maxlength: 100,
                    equalTo: '#password',
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'gendar':
                        error.insertAfter($("#gendar-js-error-valid"));
                        break;
                    default:
                        error.insertAfter(element);
                }

            },
        });


        $(document).ready(function() {
            //debt
            var catagory_price = $('#expenses_item').find(':selected').data('price');

            $('#exp_item_price').val(catagory_price);

            $(document).on('change', '#expenses_item', function() {

                var catagory_price = $('#expenses_item').find(':selected').data('price');
                $('#exp_item_price').val(catagory_price);

            });

            //credit
            var catagory_price = $('#service_item').find(':selected').data('price');

            $('#credit_price').val(catagory_price);

            $(document).on('change', '#service_item', function() {

                var catagory_price = $('#service_item').find(':selected').data('price');
                $('#credit_price').val(catagory_price);

            });

        })


        //--------------------- search engine ajax -------------------

        $(document).ready(function() {

            //search patients Text to the server
            $("#credit_receivable_id").keyup(function() {
                let search_query = $(this).val();

                var url = "{{ route('sett.pat_patient_search', ':id') }}";
                url = url.replace(':id', search_query);

                if (search_query != "") {
                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $("#search-eng-show-list").show();

                            if (data !== "") {
                                var html = ''
                                $.each(data, function(key, value) {
                                    html +=
                                        '<div data-patient_id="' + value.id +
                                        '" data-patient_name="' + value.name +
                                        '" class="search-eng-a clickable-item-pointer list-group-item list-group-item-action border-1 text-gray-500" style="cursor: pointer;"><i class="fas fa-search text-gray-200 me-2"></i> ' +
                                        value.name + '</div>';
                                });
                                $('#search-eng-show-list').html(html);
                            }

                            if (data == "") {
                                $('#search-eng-show-list').html(
                                    '<a class="list-group-item list-group-item-action border-0"><i class="fas fa-search text-gray-200 me-2"></i>No Record</a>'
                                );
                            }
                        },
                    });
                } else {
                    $("#search-eng-show-list").empty();
                    $("#search-eng-show-list").hide();;
                }
            });

            //send the id from the patient search
            $(document).on("click", ".search-eng-a", function() {

                id = $(this).data('patient_id');
                name = $(this).data('patient_name');

                $('#patient_id').val(id);
                $('#credit_receivable_id').val(name);
                $("#search-eng-show-list").hide();;
            })


            //search patients Text to the server
            $("#debtor_receivable_id").keyup(function() {
                let search_query = $(this).val();

                var url = "{{ route('sett.invo_debtor_search', ':search_query') }}";
                url = url.replace(':search_query', search_query);

                if (search_query != "") {
                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $("#debtor_search-eng-show-list").show();

                            if (data !== "") {
                                var html = ''
                                $.each(data, function(key, value) {
                                    html +=
                                        '<div data-debtor_id="' + value.id +
                                        '" data-debtor_name="' + value.name +
                                        '" class="debtor_search-eng-a clickable-item-pointer list-group-item list-group-item-action border-1 text-gray-500" style="cursor: pointer;"><i class="fas fa-search text-gray-200 me-2"></i> ' +
                                        value.name + '</div>';
                                });
                                $('#debtor_search-eng-show-list').html(html);
                            }

                            if (data == "") {
                                $('#debtor_search-eng-show-list').html(
                                    '<a class="list-group-item list-group-item-action border-0"><i class="fas fa-search text-gray-200 me-2"></i>No Record</a>'
                                );
                            }
                        },
                    });
                } else {
                    $("#debtor_search-eng-show-list").empty();
                    $("#debtor_search-eng-show-list").hide();;
                }
            });

            //send the id from the patient search
            $(document).on("click", ".debtor_search-eng-a", function() {

                id = $(this).data('debtor_id');
                name = $(this).data('debtor_name');

                $('#debtor_id').val(id);
                $('#debtor_receivable_id').val(name);
                $("#debtor_search-eng-show-list").hide();;
            })


            //search doctor
            $("#doctor_receivable_id").keyup(function() {
                let search_query = $(this).val();

                var url = "{{ route('sett.invo_doctor_search', ':search_query') }}";
                url = url.replace(':search_query', search_query);

                if (search_query != "") {
                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {

                            $("#doctor_search-eng-show-list").show();

                            if (data !== "") {
                                var html = ''
                                $.each(data, function(key, value) {
                                    html +=
                                        '<div data-doctor_id="' + value.id +
                                        '" data-doctor_name="' + value.name +
                                        '" class="doctor_search-eng-a clickable-item-pointer list-group-item list-group-item-action border-1 text-gray-500" style="cursor: pointer;"><i class="fas fa-search text-gray-200 me-2"></i> ' +
                                        value.name + '</div>';
                                });
                                $('#doctor_search-eng-show-list').html(html);
                            }

                            if (data == "") {
                                $('#doctor_search-eng-show-list').html(
                                    '<a class="list-group-item list-group-item-action border-0"><i class="fas fa-search text-gray-200 me-2"></i>No Record</a>'
                                );
                            }
                        },
                    });
                } else {
                    $("#doctor_search-eng-show-list").empty();
                    $("#doctor_search-eng-show-list").hide();;
                }
            });

            //send the id from the doctor search
            $(document).on("click", ".doctor_search-eng-a", function() {

                id = $(this).data('doctor_id');
                name = $(this).data('doctor_name');

                $('#doctor_id').val(id);
                $('#doctor_receivable_id').val(name);
                $("#doctor_search-eng-show-list").hide();;
            })

            //fetch the prodcuts from inventory
            $(document).on("change", "#expenses_item", function() {

                if ($(this).val() === 'prodcut_inventory') {

                    $('#prodcuts_inven_debit_cont').show();
                    $('#stock_quantity_cont').show();

                    $('#prodcuts_inven_debit').prop('disabled', false);
                    $('#stock_quantity').prop('disabled', false);

                    var url = "{{ route('sett.inven_fetch_items_ajax') }}";

                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $('#services').empty();
                            $.each(data, function(key, value) {
                                $('#prodcuts_inven_debit').append(
                                    '' +
                                    '<option value="' + value.id + '">' + value
                                    .name + '</option>');
                            });
                        }
                    });

                } else {
                    $('#prodcuts_inven_debit_cont').hide();
                    $('#stock_quantity_cont').hide();

                    $('#prodcuts_inven_debit').prop('disabled', true);
                    $('#stock_quantity').prop('disabled', true);

                }

            })

            //fetch the prodcuts from inventory
            $(document).on("change", "#service_item", function() {

                if ($(this).val() === 'prodcut_inventory') {

                    $('#prodcuts_inven_credit_cont').show();
                    $('#credit_quantity_cont').show();

                    $('#prodcuts_inven_credit').prop('disabled', false);
                    $('#credit_quantity').prop('disabled', false);

                    var url = "{{ route('sett.inven_fetch_items_ajax') }}";

                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $('#services').empty();
                            $.each(data, function(key, value) {
                                $('#prodcuts_inven_credit').append(
                                    '' +
                                    '<option value="' + value.id + '">' + value
                                    .name + '</option>');
                            });
                        }
                    });

                } else {
                    $('#prodcuts_inven_credit_cont').hide();
                    $('#credit_quantity_cont').hide();

                    $('#prodcuts_inven_credit').prop('disabled', true);
                    $('#credit_quantity').prop('disabled', true);

                }

            })


        });
</script>

@endsection