@extends('layouts.master')

@section('title', 'Debtors | Proxima - Medical Management app')

@section('title-topbar', 'Debtors')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

@endsection

@section('fixedcontent')

<div id="add_buttn_fixed">
    <a data-bs-toggle="modal" data-bs-target="#new_record" class="text-white">
        <i class="fas fa-plus"></i>
    </a>
</div>

<!-- session successful message -->
@if (Session::has('success'))
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300">{{ Session::get('success') }}</p>
</div>
@endif

@endsection

<!-- content insert -->
@section('content')

<div class="container-fluid px-0 px-md-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-between mb-3">
        <span class="mb-0 me-1">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.inventory.index') }}">Inventory |
            </a>
            <a class="text-gray-300">Item Show</a>
        </span>

        @role('Super-admin|Hr')
        <div class="d-flex justify-content-center">
            <a href="{{ route('sett.inventory_item.edit', $inventory_item->id) }}"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-1"><i
                    class="fas fa-marker fa-sm text-gray-300 me-1"></i> Edit</a>

            <a class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                data-bs-target="#new_record"><i class="fas fa-plus fa-sm me-1"></i> New Recored</a>
        </div>

        <!-- Modal for paying -->
        <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                <form class="mb-0" action="{{ route('sett.inven_store_inventory_rec', $inventory_item->id) }}"
                    method="POST" style="display: contents">

                    @csrf

                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                                New record</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-5 py-3">

                            <div class="row">

                                <div class="col-12 mb-2">
                                    <label class="form-label">Type
                                        <small>(required)</small></label>
                                    <select
                                        class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible @error('type') is-invalid @enderror"
                                        id="type" name="type" required>
                                        <option value="0">Add</option>
                                        <option value="1">Withdraw</option>
                                    </select>

                                    <span id="type_error" class="error-msg-form"></span>

                                    @error('type')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror

                                </div>

                                <div class="col-12 mb-2">
                                    <label class="form-label">Quantity
                                        <small>(required)</small></label>
                                    <input name="quantity" type="number" class="form-control"
                                        placeholder="Write here the quantity .." required>
                                    <span id="amount_error" class="error-msg-form"></span>

                                    @error('quantity')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-12 mb-2">
                                    <label class="form-label">Price
                                        <small>(optional)</small></label>
                                    <input name="price" type="number" class="form-control"
                                        placeholder="Write here the price ..">
                                    <span id="amount_error" class="error-msg-form"></span>

                                    @error('price')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-12 mb-2">
                                    <label class="form-label">Responsible Worker
                                        <small>(required)</small></label>
                                    <select
                                        class="myselect2-record-insert select2-hidden-accessible @error('responsible_workers') is-invalid @enderror"
                                        id="responsible_workers" name="responsible_workers" required>
                                        @foreach ($workers as $item)
                                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>

                                    <span id="responsible_workers_error" class="error-msg-form"></span>

                                    @error('responsible_workers')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror

                                </div>

                                <hr class="my-2">

                                <div class="col-12 mb-2">
                                    <label class="form-label">Buying date
                                        <small>(required)</small></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                            </div>
                                        </div>
                                        <input name="buying_date" type="text" class="form-control hasdatetimepicker "
                                            placeholder="YYYY/MM/DD" required="" required>
                                    </div>
                                    <span id="buying_date" class="error-msg-form"></span>

                                    @error('buying_date')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-12 mb-2">
                                    <label class="form-label">Expiration date
                                        <small>(optional)</small></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                            </div>
                                        </div>
                                        <input name="expiration_date" type="text"
                                            class="form-control hasdatetimepicker " placeholder="YYYY/MM/DD">
                                    </div>
                                    <span id="expiration_date" class="error-msg-form"></span>

                                    @error('expiration_date')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>

                            </div>

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                    Mind</button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link main-color">Send</button>
                            </div>
                        </div>
                    </div>
                </form>

            </div>

        </div>
        @endrole


    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-box-open me-1"></i> Item Show</h6>
        </div>

        <!-- Card Body -->
        <div class="card-body px-4 px-md-5">

            <div class="row px-0 px-md-3 px-lg-5 pt-3">

                <div class="col-6 col-md-6 mb-2">
                    <div class="row mb-2">
                        <div class="d-flex mb-2 align-items-center px-0">
                            <i class="fas fa-receipt fs-1 me-2"></i>
                            <div class="">
                                <p class="mb-0 text-xs text-gray-300">
                                    {{ $inventory_item->service_inv_cat->name }}</p>
                                <a class="mb-1 fw-bold fs-5 text-gray-600">{{ $inventory_item->name }}</a>
                                <p class="mb-0 text-xs text-gray-400">Code <strong>
                                        {{ $inventory_item->code }}</strong>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-6 col-md-2 align-self-center">
                    <div class="">
                        <h6 class="text-gray-300 text-xs mb-1">Place</h6>
                        <p id="addre_final_info" class="text-gray-600 fs-6 fw-bold mb-0">
                            {{ $inventory_item->place }}
                        </p>
                    </div>
                </div>

                <div class="col-4 col-md-2 align-self-center">
                    <div class="">
                        <h6 class="text-gray-300 text-xs mb-1">Low quantity notify</h6>
                        <p id="addre_final_info" class="text-gray-600 fs-6 fw-bold mb-0">
                            {{ $inventory_item->quantity_notify }}
                        </p>
                    </div>
                </div>

                <div class="col-6 col-md-2 align-self-center">
                    <div class=" main-color-bg text-center b-r-s-cont p-2">
                        <h6 class="text-blue-300 text-xs mb-1">Quantity</h6>
                        <p id="addre_final_info" class="text-white fs-4 fw-bold mb-0">
                            {{ $inventory_item->current_quantity }} </p>
                    </div>
                </div>

            </div>

            <hr>

            <ul class="list-group patient-timeline">

                @foreach ($inventory_item->records as $item)
                @if ($item->type == 0)
                @php
                $type_text = 'Add';
                $text_color = 'done-color';
                @endphp
                @elseif ($item->type == 1)
                @php
                $type_text = 'Withdraw';
                $text_color = 'cancel-color';
                @endphp
                @endif

                <li class="row flex-nowrap list-group-item d-flex justify-content-between position-relative">

                    <i class="col patient-timeline-pointer fas fa-circle text-xxs mb-0 {{ $text_color }}"></i>

                    <div class="col-3 me-1">
                        <p class="text-xs text-gray-400 mb-0">
                            {{ date('d M Y', strtotime($item->buying_date)) }}</p>
                        <h6 class="text-s fw-bold  mb-0">{{ $type_text }}</h6>
                    </div>

                    <div class="col-3 align-self-center me-1">
                        <p class="text-xs text-gray-200 mb-0">Responsible</p>
                        <h6 class="text-s text-gray-400 pe-2"> {{ $item->responsible->name }}
                        </h6>
                    </div>

                    <div class="col-2 align-self-center me-1">
                        <p class="text-xs text-gray-200 mb-0">Quantity</p>
                        <h6 class="text-s text-gray-400 pe-2"> {{ $item->quantity }}
                        </h6>
                    </div>

                    <div class="col-2 align-self-center me-1">
                        <p class="text-xs text-gray-200 mb-0">Price</p>
                        <h6 class="text-s text-gray-400 pe-2"> {{ $item->price }}
                        </h6>
                    </div>

                    <div class="col-3 align-self-center me-1">
                        <p class="text-xs text-gray-200 mb-0">Expiration Date</p>
                        <h6 class="text-s text-gray-400"> {{ $item->expiration_date }}
                        </h6>
                    </div>

                </li>
                @endforeach

                <li class="row flex-nowrap list-group-item d-flex justify-content-between position-relative">

                    <i class="col patient-timeline-pointer fas fa-circle text-xxs mb-0 main-color"
                        style="top: 21px;"></i>

                    <div class="col me-1">
                        <p class="text-xs text-gray-400 mb-0">
                            {{ date('d M Y', strtotime($inventory_item->created_at)) }}</p>
                        <h6 class="text-s fw-bold mb-0">Created Item</h6>
                    </div>
                </li>

            </ul>

        </div>

    </div>

</div>

@endsection

<!-- js insert -->
@section('js')
<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {

            $(".myselect2-record-insert").select2({
                dropdownParent: $("#new_record")
            });

            //hide search
            $('.myselect2-record-insert-nosearch').select2({
                dropdownParent: $("#new_record"),
                minimumResultsForSearch: -1
            });

        })
</script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
</script>

@endsection