@extends('layouts.master')

@section('title', 'contact us')

<!-- css insert -->
@section('css')
    <style>


    </style>

@endsection

<!-- content insert -->
@section('content')

    <div class="card card-input shadow mb-4">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold">Users table</h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Dropdown Header:</div>
                    <a class="dropdown-item" href="#">Action</a>
                </div>
            </div>
        </div>

        <!-- Card Body -->
        <div class="card-body p-3 p-md-5">

            <div class="d-flex justify-content-center flex-wrap">

                <div class="mb-3 mb-md-0"
                    style="background-image: url('{{ asset('img/dashboard/system/human_front.jpg') }}'); width:255px; height:457px; position: relative;">

                    <canvas class="canvas" id="canvas" width="255" height="457"
                        style=" solid;position: absolute;top:0;left:0;"></canvas>

                    <div id="canvas-clear" class="btn btn-primary" style="position: absolute; bottom:40px; left:0px;"><i
                            class="fas fa-eraser"></i>
                    </div>

                    <div id="imgsave" class="btn btn-danger" style="position: absolute; bottom:0px; left:0px;"><i
                            id="icon_save" class="fas fa-check"></i>
                    </div>


                    <div style="position: absolute; bottom:100px; left:0px;">
                        <div class="d-flex mb-1">
                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle" data-color="#000000"
                                style="width:10px;height:10px;background:#000000;"></div>
                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle" data-color="#0cb6ed"
                                style="width:10px;height:10px;background:#0cb6ed;"></div>
                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle" data-color="#17c34e"
                                style="width:10px;height:10px;background:#17c34e;"></div>
                        </div>
                        <div class="d-flex">
                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle" data-color="#dc3545"
                                style="width:10px;height:10px;background:#dc3545;"></div>
                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle" data-color="#ffd807"
                                style="width:10px;height:10px;background:#ffd807;"></div>
                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle" data-color="#ff6d00"
                                style="width:10px;height:10px;background:#ff6d00;"></div>
                        </div>
                    </div>

                </div>

                <div
                    style="background-image: url('{{ asset('img/dashboard/system/human_back.jpg') }}'); width:255px; height:457px; position: relative;">
                    <canvas class="canvas" id="canvas_b" width="255" height="457"
                        style=" solid;position: absolute;top:0;left:0;"></canvas>

                    <div id="canvas-clear_b" class="btn btn-primary" style="position: absolute; bottom:40px; left:0px;"><i
                            class="fas fa-eraser"></i>
                    </div>

                    <div id="imgsave_b" class="btn btn-danger" style="position: absolute; bottom:0px; left:0px;"><i
                            id="icon_save_b" class="fas fa-check"></i>
                    </div>


                    <div style="position: absolute; bottom:100px; left:0px;">
                        <div class="d-flex mb-1">
                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                data-color="#000000" style="width:10px;height:10px;background:#000000;"></div>
                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                data-color="#0cb6ed" style="width:10px;height:10px;background:#0cb6ed;"></div>
                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                data-color="#17c34e" style="width:10px;height:10px;background:#17c34e;"></div>
                        </div>
                        <div class="d-flex">
                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                data-color="#dc3545" style="width:10px;height:10px;background:#dc3545;"></div>
                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                data-color="#ffd807" style="width:10px;height:10px;background:#ffd807;"></div>
                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                data-color="#ff6d00" style="width:10px;height:10px;background:#ff6d00;"></div>
                        </div>
                    </div>
                </div>
            </div>


            <form id="myform" method="POST" action="{{ route('sett.disease_draws.store') }}"
                enctype="multipart/form-data">
                @csrf
                <input name="front" id="front_input" type="hidden">
                <input name="back" id="back_input" type="hidden">
                <input type="submit">
            </form>

        </div>

        <!-- Card footer -->
        <div class="card-footer text-center ">

        </div>

    </div>

@endsection

<!-- js insert -->
@section('js')
    <script>
        var $canvas = $('#canvas');
        var $canvas_b = $('#canvas_b');
        var ctx = $canvas[0].getContext('2d');
        var ctx_b = $canvas_b[0].getContext('2d');
        var color = '#000000';
        var color_b = '#000000';

        $('.color-selector-draw').on('click', function(e) {
            color = $(this).data('color');
        });

        $('.color-selector-draw_b').on('click', function(e) {
            color_b = $(this).data('color');
        });

        //---- front draw ----
        $(document).ready(function() {
            var flag, dot_flag = false,
                prevX, prevY, currX, currY = 0,
                thickness = 4;

            $canvas.on('mousemove mousedown mouseup mouseout', function(e) {
                prevX = currX;
                prevY = currY;
                currX = e.clientX - canvas.getBoundingClientRect().left;
                currY = e.clientY - canvas.getBoundingClientRect().top;

                if (e.type == 'mousedown') {
                    flag = true;
                }
                if (e.type == 'mouseup' || e.type == 'mouseout') {
                    flag = false;
                }
                if (e.type == 'mousemove') {
                    if (flag) {
                        ctx.beginPath();
                        ctx.moveTo(prevX, prevY);
                        ctx.lineTo(currX, currY);
                        ctx.strokeStyle = color;
                        ctx.lineWidth = thickness;
                        ctx.stroke();
                        ctx.closePath();
                    }
                }
            });
        });

        // Set up touch events for mobile, etc
        canvas.addEventListener("touchstart", function(e) {
            mousePos = getTouchPos(canvas, e);
            var touch = e.touches[0];
            var mouseEvent = new MouseEvent("mousedown", {
                clientX: touch.clientX,
                clientY: touch.clientY
            });
            canvas.dispatchEvent(mouseEvent);
        }, false);
        canvas.addEventListener("touchend", function(e) {
            var mouseEvent = new MouseEvent("mouseup", {});
            canvas.dispatchEvent(mouseEvent);
        }, false);
        canvas.addEventListener("touchmove", function(e) {
            var touch = e.touches[0];
            var mouseEvent = new MouseEvent("mousemove", {
                clientX: touch.clientX,
                clientY: touch.clientY
            });
            canvas.dispatchEvent(mouseEvent);
        }, false);

        // Get the position of a touch relative to the canvas
        function getTouchPos(canvasDom, touchEvent) {
            var rect = canvasDom.getBoundingClientRect();
            return {
                x: touchEvent.touches[0].clientX - rect.left,
                y: touchEvent.touches[0].clientY - rect.top
            };
        }

        //Prevent scrolling when touching the canvas
        document.body.addEventListener("touchstart", function(e) {
            if (e.target == canvas) {
                e.preventDefault();
            }
        }, false);
        document.body.addEventListener("touchend", function(e) {
            if (e.target == canvas) {
                e.preventDefault();
            }
        }, false);
        document.body.addEventListener("touchmove", function(e) {
            if (e.target == canvas) {
                e.preventDefault();
            }
        }, false);


        //---- back draw ----
        $(document).ready(function() {
            var flag, dot_flag = false,
                prevX, prevY, currX, currY = 0,
                thickness = 4;

            $canvas_b.on('mousemove mousedown mouseup mouseout', function(e) {
                prevX = currX;
                prevY = currY;
                currX = e.clientX - canvas_b.getBoundingClientRect().left;
                currY = e.clientY - canvas_b.getBoundingClientRect().top;

                if (e.type == 'mousedown') {
                    flag = true;
                }
                if (e.type == 'mouseup' || e.type == 'mouseout') {
                    flag = false;
                }
                if (e.type == 'mousemove') {
                    if (flag) {
                        ctx_b.beginPath();
                        ctx_b.moveTo(prevX, prevY);
                        ctx_b.lineTo(currX, currY);
                        ctx_b.strokeStyle = color_b;
                        ctx_b.lineWidth = thickness;
                        ctx_b.stroke();
                        ctx_b.closePath();
                    }
                }
            });

            // Set up touch events for mobile, etc
            canvas_b.addEventListener("touchstart", function(e) {
                mousePos = getTouchPos(canvas_b, e);
                var touch = e.touches[0];
                var mouseEvent = new MouseEvent("mousedown", {
                    clientX: touch.clientX,
                    clientY: touch.clientY
                });
                canvas_b.dispatchEvent(mouseEvent);
            }, false);
            canvas_b.addEventListener("touchend", function(e) {
                var mouseEvent = new MouseEvent("mouseup", {});
                canvas_b.dispatchEvent(mouseEvent);
            }, false);
            canvas_b.addEventListener("touchmove", function(e) {
                var touch = e.touches[0];
                var mouseEvent = new MouseEvent("mousemove", {
                    clientX: touch.clientX,
                    clientY: touch.clientY
                });
                canvas_b.dispatchEvent(mouseEvent);
            }, false);

            // Get the position of a touch relative to the canvas
            function getTouchPos(canvasDom, touchEvent) {
                var rect = canvasDom.getBoundingClientRect();
                return {
                    x: touchEvent.touches[0].clientX - rect.left,
                    y: touchEvent.touches[0].clientY - rect.top
                };
            }

            //Prevent scrolling when touching the canvas
            document.body.addEventListener("touchstart", function(e) {
                if (e.target == canvas_b) {
                    e.preventDefault();
                }
            }, false);
            document.body.addEventListener("touchend", function(e) {
                if (e.target == canvas_b) {
                    e.preventDefault();
                }
            }, false);
            document.body.addEventListener("touchmove", function(e) {
                if (e.target == canvas_b) {
                    e.preventDefault();
                }
            }, false);

        });

        $('#canvas-clear').on('click', function(e) {
            c_width = $canvas.width();
            c_height = $canvas.height();
            ctx.clearRect(0, 0, c_width, c_height);
            $('#canvasimg').hide();
        });


        $('#canvas-clear_b').on('click', function(e) {
            c_width_b = $canvas_b.width();
            c_height_b = $canvas_b.height();
            ctx_b.clearRect(0, 0, c_width_b, c_height_b);
            $('#canvasimg_b').hide();
        });

        //save the canv draw to input
        $('#imgsave').on('click', function(e) {

            //var image = canvas.toDataURL("image/png").replace("image/png",); // here is the most important part because if you dont replace you will get a DOM 18 exception.
            var image = new Image();
            image.src = canvas.toDataURL("image/png");

            //document.getElementById("finalImg").src = image.src;
            document.getElementById("front_input").value = image.src;

            //change the save icon
            $('#icon_save').addClass('fa-check-double').removeClass('fa-check');

        });

        //save the canv draw to input
        $('#imgsave_b').on('click', function(e) {

            var image_b = new Image();
            image_b.src = canvas_b.toDataURL("image/png");
            document.getElementById("back_input").value = image_b.src;

            //change the save icon
            $('#icon_save_b').addClass('fa-check-double').removeClass('fa-check');
        });
    </script>

@endsection
