@extends('layouts.master')

@section('title', 'Create Op Follow up | Proxima - Medical Management app')

@section('title-topbar', 'Follow up')

<!-- css insert -->
@section('css')

@endsection


<!-- content insert -->
@section('content')

<div class="container-fluid px-0 px-md-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">{{ __('basic.dashboard') }}
                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.op_follow_up') }}">Op Follow up |
            </a>
            <a class="text-gray-300">{{ __('basic.new op follow up') }}</a>
        </span>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-capsules me-1"></i>
                {{ __('basic.new op follow up') }}</h6>
        </div>


        <!-- Card Body -->
        <div class="card-body px-4 px-md-5">

            <form id="myform" method="POST" action="{{ route('sett.op_follow_up_file_store', $id) }}">

                @csrf

                <div class="row mb-1 justify-content-center">

                    <div class="row mb-2">
                        <div class="col-12 col-md-8">
                            <div class="d-flex">
                                <i class="fas fs-1 fa-procedures me-2 align-self-center text-gray-400"></i>
                                <div>
                                    <p class="text-xxs mb-0 text-gray-300">
                                        {{ date('h:i a Y-m-d', strtotime($op->start_at)) }}</p>
                                    <h6 class="mb-0 fw-bold">{{ $op->service_item->name }}
                                    </h6>
                                    <p class="text-xxs mb-0 text-gray-300">Op place: {{ $op->place->name }}
                                        @isset($op->doctor->first_name)
                                        with
                                        docotr <span class="fw-bold">{{ $op->doctor->first_name }}</span>
                                        @endisset
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-4 text-center">
                            <p class="text-xs text-gray-200 mb-1">Patient</p>
                            <h6 class="text-s text-gray-400 text-truncate">
                                {{ $op->patient->first_name . ' ' . $op->patient->second_name }}
                                <input hidden name="patient_id" value="{{ $op->patient->id }}">
                            </h6>
                        </div>
                    </div>
                    <hr class="my-2">

                    <div class="col-12 col-md-10 col-lg-7">

                        <div class="row mb-2 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Responsible</label>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <p class="mb-0">{{ Auth::user()->first_name . ' ' . Auth::user()->second_name }}</p>
                                <input hidden name="resp_id" value="{{ Auth::user()->id }}">
                            </div>
                        </div>

                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <label class="form-label">Day 1
                                    <small>(required)</small></label>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="septum_scoring" checked="" type="checkbox" value="1"
                                        id="septum_scoring_up"><label for="septum_scoring_up"
                                        class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="d-flex justify-content-end mt-2 mb-2">
                    <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                        value="{{ __('basic.send') }}">
                </div>

            </form>
        </div>

    </div>

</div>

@endsection

<!-- js insert -->
@section('js')

<!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
        var $validator = $('#myform').validate({
            rules: {
                name: {
                    minlength: 3,
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'gendar':
                        error.insertAfter($("#gendar-js-error-valid"));
                        break;
                    default:
                        error.insertAfter(element);
                }

            },
        });
</script>

@endsection