@extends('layouts.master')

@section('title', 'All Appointments | Proxima - Medical Management app')

@section('title-topbar', 'All Appointments')


<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- -- datatables plugin -- -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">


<!-- datepicker time and date -->
<link rel="stylesheet" href="https://fastly.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="https://fastly.jsdelivr.net/npm/flatpickr@4.6.13/dist/plugins/monthSelect/style.min.css">


@endsection

<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-between mb-3">

        <span class="mb-0 me-1">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">{{ __('basic.dashboard') }}
                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.appointment.index') }}">{{
                __('basic.calendar') }} | </a>
            <a class="text-gray-300">{{ __('basic.all appointment') }}</a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">

            <a class="main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                data-bs-target="#new_record"><i class="fas fa-filter fa-sm me-1"></i> Filter</a>

            <!-- Modal for paying -->
            <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="{{ route('sett.all_appointments') }}" method="GET"
                        style="display: contents">

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                                    Search Filter</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Specialty
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="specialty" name="specialty">
                                            <option value="all">
                                                All
                                            </option>
                                            @foreach ($specialty_cat as $item)
                                            <option value="{{ $item->id }}" @if ($specialty==$item->id) selected @endif
                                                @if ($specialty == $item->id) selected @endif>
                                                {{ $item->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    @if (Auth::user()->branch_id == 0)
                                    <div class="col-12 mb-2">
                                        <label class="form-label">Branch
                                            <small>(optional)</small></label>
                                        <select class="myselect2-record-insert select2-hidden-accessible" id="branch"
                                            name="branch">
                                            <option value="all">
                                                All
                                            </option>
                                            @foreach ($branches as $item)
                                            <option value="{{ $item->id }}" @if ($branch==$item->id) selected @endif
                                                @if ($branch == $item->id) selected @endif>
                                                {{ $item->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @endif

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Status
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="status" name="status">
                                            <option value="all">
                                                All
                                            </option>
                                            <option value="0" @if ($status==0) selected @endif>
                                                {{ __('patientappo.not accepted') }}
                                            </option>
                                            <option value="1" @if ($status==1) selected @endif>
                                                {{ __('patientappo.accepted') }}
                                            </option>
                                            <option value="2" @if ($status==2) selected @endif>
                                                {{ __('patientappo.arrived') }}
                                            </option>
                                            <option value="3" @if ($status==3) selected @endif>
                                                {{ __('patientappo.with doctor') }}
                                            </option>
                                            <option value="4" @if ($status==4) selected @endif>
                                                {{ __('patientappo.done appointment') }}
                                            </option>
                                            <option value="5" @if ($status==5) selected @endif>
                                                {{ __('patientappo.not respond') }}
                                            </option>
                                            <option value="6" @if ($status==6) selected @endif>
                                                {{ __('patientappo.canceled') }}
                                            </option>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Worker
                                            <small>(optional)</small></label>
                                        <select class="myselect2-record-insert select2-hidden-accessible" id="worker"
                                            name="worker">
                                            <option value="all">
                                                All
                                            </option>
                                            @foreach ($users as $item)
                                            <option value="{{ $item->id }}" @if ($worker==$item->id) selected @endif>
                                                {{ $item->first_name . ' ' . $item->second_name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">From
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="day_srch" type="text"
                                                class="form-control datepicker_time_day bg-white" value="{{ $date }}"
                                                placeholder="YYYY/MM/DD" data-enable-time="true" required>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>

    </div>

    <div class="row">

        <div class="card card-input shadow mb-3 pb-3">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-map-marker-alt me-1"></i> All Appointments</h6>
            </div>


            <!-- Modal content -->
            <div class="modal-body px-4">

                <div class="table-responsive">
                    <table class="table display datatable-modal" id="p-lab-table" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th class="text-xs">{{ __('basic.code') }}</th>
                                <th class="text-xs">{{ __('basic.service') }}</th>
                                <th class="text-xs">{{ __('basic.name') }}</th>
                                <th class="text-xs text-center">{{ __('basic.branch') }}</th>
                                <th class="text-xs text-center">{{ __('basic.doctor') }}</th>
                                <th class="text-xs text-center">{{ __('basic.creator') }}</th>
                                <th class="text-xs text-center">{{ __('basic.last update person') }}</th>
                                <th class="text-xs text-center">{{ __('basic.start') }}</th>
                                <th class="text-xs text-center">{{ __('basic.end') }}</th>
                                <th class="text-xs text-center">{{ __('basic.status') }}</th>
                                <th class="text-xs text-center">{{ __('patientappo.pay status') }}
                                </th>
                                <th class="text-xs text-center">{{ __('patientappo.pay code') }}</th>
                                <th class="text-xs text-center">{{ __('basic.created') }}</th>
                                <th class="text-xs text-center">{{ __('basic.updated') }}</th>
                                <th class="text-xs text-center">{{ __('basic.handle') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($appointment as $item)
                            @if ($item->status == 0)
                            @php
                            $text_color = 'not_accepted-color-btn';
                            $msg = __('patientappo.not accepted');
                            @endphp
                            @elseif ($item->status == 1)
                            @php
                            $text_color = 'main-color-btn';
                            $msg = __('patientappo.accepted');
                            @endphp
                            @elseif ($item->status == 2)
                            @php
                            $text_color = 'active-color-btn';
                            $msg = __('patientappo.arrived');
                            @endphp
                            @elseif ($item->status == 3)
                            @php
                            $text_color = 'prog-color-btn';
                            $msg = __('patientappo.with doctor');
                            @endphp
                            @elseif ($item->status == 4)
                            @php
                            $text_color = 'done-color-btn';
                            $msg = __('patientappo.done appointment');
                            @endphp
                            @elseif ($item->status == 5)
                            @php
                            $text_color = 'pend-color-btn';
                            $msg = __('patientappo.not respond');
                            @endphp
                            @elseif ($item->status == 6)
                            @php
                            $text_color = 'cancel-color-btn';
                            $msg = __('patientappo.canceled');
                            @endphp
                            @endif

                            @if ($item->invoice_item)

                            @if ($item->invoice_item->invoice)

                            @if ($item->invoice_item->invoice->status == 0)
                            @php
                            $msg_invoice = __('basic.not paid');
                            $text_color_invoice = 'cancel-color-btn';
                            @endphp
                            @elseif ($item->invoice_item->invoice->status == 1)
                            @php
                            $text_color_invoice = 'pend-color-btn';
                            $msg_invoice = __('basic.pending');
                            @endphp
                            @elseif ($item->invoice_item->invoice->status == 2)
                            @php
                            $text_color_invoice = 'prog-color-btn';
                            $msg_invoice = __('basic.installment');
                            @endphp
                            @elseif ($item->invoice_item->invoice->status == 3)
                            @php
                            $text_color_invoice = 'done-color-btn';
                            $msg_invoice = __('basic.paid');
                            @endphp
                            @elseif ($item->invoice_item->invoice->status == 4)
                            @php
                            $msg_invoice = __('basic.refund');
                            $text_color_invoice = 'cancel-color-btn';
                            @endphp
                            @else
                            @php
                            $msg_invoice = "not selected";
                            $text_color_invoice = 'prog-color-btn';
                            @endphp
                            @endif
                            @else
                            @php
                            $msg_invoice = 'No fees';
                            $text_color_invoice = 'done-color-btn';
                            @endphp
                            @endif
                            @else
                            @php
                            $msg_invoice = 'No fees';
                            $text_color_invoice = 'done-color-btn';
                            @endphp
                            @endif


                            @if ($item->note_doctor)
                            @php
                            $icon_note = 'fa-user-check text-blue-400';
                            @endphp
                            @else
                            @php
                            $icon_note = 'fa-user-edit text-grey-400';
                            @endphp
                            @endif

                            <tr>
                                <td>{{ $item->code }}</td>
                                <td>{{ $item->service_item->name }}</td>
                                <td>
                                    @if($item->patient)
                                    <a class="link-cust-text text-gray-600"
                                        href="{{ route('sett.patient.show', $item->patient_id) }}">
                                        {{ $item->patient->name }}
                                    </a>
                                    @else
                                    Deleted Patient
                                    @endif

                                </td>
                                <td class="text-center">{{ $item->branch->name }}</td>
                                <td>
                                    @if($item->doctor)
                                    {{ $item->doctor->name }}
                                    @endif
                                </td>
                                <td>
                                    {{ $item->creator->name }}
                                </td>
                                <td>
                                    @if($item->last_update_person)
                                    {{ $item->last_update_person->name }}
                                    @endif
                                </td>
                                <td class="text-center">
                                    {{ date('Y-m-d', strtotime($item->start_at)) }} <br>
                                    {{ date('h:i a', strtotime($item->start_at)) }}</td>
                                <td class="text-center">
                                    {{ date('Y-m-d', strtotime($item->end_at)) }} <br>
                                    {{ date('h:i a', strtotime($item->end_at)) }}</td>
                                <td class="text-center"> <span
                                        class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg }}</span>
                                </td>
                                <td class="text-center"> <span
                                        class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{
                                        $msg_invoice }}</span>
                                </td>
                                <td class="text-center">
                                    @if ($item->invoice_item)
                                    {{ $item->invoice_item->invoice->code }}
                                    @endif
                                </td>
                                <td class="text-center">
                                    -{{ date('Y-m-d', strtotime($item->created_at)) }} <br>
                                    @if($item->creator)
                                    -{{ $item->creator->first_name . " " . $item->creator->second_name }}
                                    @endif
                                </td>
                                <td class="text-center">
                                    -{{ date('Y-m-d', strtotime($item->updated_at)) }} <br>
                                    @if($item->last_update_person)
                                    -{{ $item->last_update_person->first_name . " " .
                                    $item->last_update_person->second_name }}
                                    @endif
                                </td>


                                <td class="text-center d-flex justify-content-center">
                                    @role('Super-admin|Branch-manager')
                                    <a data-id="{{ $item->id }}"
                                        class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 appointment_delete_click"
                                        title="delete" data-effect="effect-scale"><i class="fas fa-trash"></i>
                                        {{ __('basic.delete') }}
                                    </a>
                                    @endrole
                                </td>

                            </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>

        </div>

    </div>


    <!-- appointment Modal delete -->
    <div class="modal fade" id="appointment_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        {{ __('basic.delete') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form action="{{ route('sett.appointment.destroy', 'test') }}" method="post">
                    {{ method_field('delete') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                appointment?</p><br>
                            <input type="hidden" name="appointment_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red">{{ __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    @endsection

    <!-- js insert -->
    @section('js')

    <script>
        //appointment modals delete
        $(".appointment_delete_click").on('click', function() {
            var id = $(this).data("id");

            $('input[name = "appointment_id_delete"]').val(id);

            $('.modal').modal('hide');
            $('#appointment_delete').modal('show');
        });
    </script>
    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.print.min.js"></script>
    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.colVis.min.js"></script>


    <!-- datapicker date and time -->
    <script src="https://fastly.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://fastly.jsdelivr.net/npm/flatpickr@4.6.13/dist/plugins/monthSelect/index.min.js"></script>


    <script>
        var table = $('#p-lab-table').DataTable({
                lengthChange: false,

                buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0'
                        }
                    },
                    buttons: [{
                            extend: 'copyHtml5',
                            footer: true
                        },
                        {
                            extend: 'excelHtml5',
                            footer: true
                        },
                        {
                            extend: 'pdfHtml5',
                            footer: true
                        },
                        {
                            extend: 'print',
                            footer: true
                        }
                    ]
                }
            }

        );
        table.buttons().container()
            .appendTo('#p-lab-table_wrapper .col-md-6:eq(0)');

                    //-------- datepicker time --------
        $('.datepicker_time_day').flatpickr({
                mode: "range",
                enableTime: false,
                dateFormat: "Y-m-d",
                locale: {
                    rangeSeparator: 'to'
                },
            });
    </script>

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {

                $(".myselect2-record-insert").select2({
                    dropdownParent: $("#new_record")
                });

                //hide search
                $('.myselect2-record-insert-nosearch').select2({
                    dropdownParent: $("#new_record"),
                    minimumResultsForSearch: -1
                });

            })
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "mm-yyyy",
                    viewMode: "months",
                    minViewMode: "months",
                    autoclose: true,
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>
    @php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2', '#dc3545', '#51b24b', '#a94bb2', '#4b8bb2', '#57b24b', '#a5b24b', '#b2804b', '#b24b4b',
    '#834bb2', '#b24b6a', '#574bb2', '#236368', '#232c68', '#682345', '#4b2368', '#234b68', '#306823', '#a39f39',
    '#a239a3', '#a33963', '#a33951', '#a33939', '#c73737', '#6837c7'];
    @endphp
    @endsection
