@extends('layouts.master')

@section('title', 'Users')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

@endsection

<!-- content insert -->
@section('content')
<div class="container-fluid px-2 ">
    <div class="card card-input shadow mb-4">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold">Users table</h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Dropdown Header:</div>
                    <a class="dropdown-item" href="#">Action</a>
                </div>
            </div>
        </div>

        <!-- Card Body -->
        <div class="card-body">
            <div class="row mb-2">
                <div class="col-6">
                    <label class="form-label">First Name <small>(required)</small></label>
                    <input name="firstname" type="text" class="form-control" placeholder="Ahmed...">
                </div>
                <div class="col-6">
                    <label class="form-label">Last Name <small>(required)</small></label>
                    <input name="lastname" type="text" class="form-control" placeholder="Test...">
                    <div class="form-text text-gray-200">We'll never share your email with anyone else.</div>
                </div>
            </div>

            <div class="form-group row">
                <label class="form-label col-md-4 col-form-label">Last Name
                    <small>(required)</small></label>
                <div class="col">
                    <input type="text" class="form-control" name="email-address" placeholder="Test...">
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">Notes <small>(optional)</small></label>
                <textarea name="notes" class="form-control" placeholder="Write here your notes .." rows="4"
                    spellcheck="false"></textarea>
            </div>

            <div class="mb-3">
                <label class="form-label">Last Name <small>(required)</small></label>
                <input class="form-control" type="file" id="formFile">

                <div class="form-text text-gray-200">We'll never share your email with anyone else.</div>
            </div>
            <div class="row mb-2">
                <div class="col-12 col-md-4 mb-2">
                    <label class="form-label">city <small>(required)</small></label>

                    <select id="multiselect" class="select2-hidden-accessible" multiple="" name="country"
                        aria-hidden="true" required>
                        <option selected>Open this select menu</option>
                        <option value="1">One</option>
                        <option value="2">Two</option>
                        <option value="3">Three</option>
                    </select>
                </div>
                <div class="col-12 col-md-4 mb-2">
                    <label class="form-label">city <small>(required)</small></label>
                    <select class="js-example-basic-single select2-no-search select2-hidden-accessible" name="country"
                        required>
                        <option selected>Open this select menu</option>
                        <option value="1">One</option>
                        <option value="2">Two</option>
                        <option value="3">Three</option>
                    </select>
                </div>
                <div class="col-12 col-md-4 mb-2">
                    <label class="form-label">city <small>(required)</small></label>
                    <select class="js-example-basic-single select2-hidden-accessible" name="country" required>
                        <option selected>Open this select menu</option>
                        <option value="1">One</option>
                        <option value="2">Two</option>
                        <option value="3">Three</option>
                    </select>
                </div>
            </div>

        </div>


        <!-- Card footer -->
        <div class="card-footer text-center ">
            <a class="text-xs link-cust-text text-gray-300" href="#">
                <i class="fas fa-chevron-down"></i> More
            </a>
        </div>

    </div>
</div>
@endsection

<!-- js insert -->
@section('js')


<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });

            //multi select
            $('#multiselect').select2();
            $('#multiselect').on('select2:opening select2:closing', function(event) {
                var $searchfield = $(this).parent().find('.select2-search__field');
                $searchfield.prop('disabled', true);
            });

        });
</script>

@endsection