<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCategoriesServiceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('categories_service', function (Blueprint $table) {
            $table->id();
            $table->integer('service_id');
            $table->bigInteger('serviceCategory_id')->unsigned();
            $table->foreign('service_id')->references('id')
                 ->on('service_items');
            $table->foreign('serviceCategory_id')->references('id')
                ->on('service_categories');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('categories_service');
    }
}
