<?php

namespace App\Models;

use App\Models\Branch\Branch;
use App\Models\Invoice\Invoice;
use App\Models\location\City;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;


class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'specialty_id',
        'branch_id',
        'email',
        'password',
        'first_name',
        'second_name',
        'avatar',
        'birthday',
        'gendar',
        'country',
        'city',
        'phone_number',
        'sec_phone_number',
        'started_work',
        'deactivate',
        'note',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    /*
        -------------- Relationships --------------
     */

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }


    public function cityuser()
    {
        return $this->belongsTo(City::class, 'city', 'id');
    }

    public function invoice()
    {
        return $this->morphOne(Invoice::class, 'receivable');
    }
    public function branches()
    {
        return $this->belongsToMany(Branch::class,'users_branches','user_id','branch_id' );
    }

}
