<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use App\Models\Patient\Patient;
use App\Models\Invoice\Invoice_item;
use App\Models\Patient\Dental\Dent_main_cat;
use App\Models\Patient\Treatment;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Session_pat extends Model
{
    use HasFactory;
    
    use HasFactory;

    protected $fillable = [
        'id',
        'dent_main_cat_id',
        'services_cat_id',
        'appointment_id',
        'doctor_id',
        'patient_id',
        'treatment_id',
        'tooth',
        'surface',
        'status',
        'date',
        'note',
    ];

    public function dent_main_cat()
    {
        return $this->belongsTo(Dent_main_cat::class, 'dent_main_cat_id', 'id');
    }
    
    public function service_item(){
        return $this->belongsTo(Service_item::class, 'services_cat_id', 'id');
    }

    public function appointmen()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id', 'id');
    }


    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id', 'id');
    }

    public function treatment()
    {
        return $this->belongsTo(Treatment::class, 'treatment_id', 'id');
    }


    public function invoice_item()
    {
        return $this->morphOne(Invoice_item::class, 'itemable');
    }



}