<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Eyeglasses_prescription extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'code',
        'patient_id',
        'appointment_id',
        'glass_right_sph',
        'glass_right_cyl',
        'glass_right_axis',
        'glass_left_sph',
        'glass_left_cyl',
        'glass_left_axis',
        'glass_right_n_plus',
        'glass_right_n',
        'glass_left_n_plus',
        'glass_left_n',
        'ipd',
        'note',
        'date',
    ];


    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }
}
