<?php

namespace App\Models\Invoice;

use App\Models\Branch\Branch;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Patient_wallet extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'type', //(0= add, 1= withdraw)
        'branch_id',
        'patient_id',
        'service_item_id',
        'balance_before_tran',
        'amount',
        'date',
        'note',
    ];

    public $timestamps = false;

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }
    
    public function service()
    {
        return $this->belongsTo(Service_item::class, 'service_item_id', 'id');
    }

}