<?php

namespace App\Models\Branch;

use App\Models\Invoice\Invoice_item;
use App\Models\Patient\Disease;
use App\Models\Patient\Disease_draw;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use App\Models\Patient\Specialty_cat;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Operation extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'specialty_id',
        'branch_id',
        'oper_place_id',
        'appointment_id',
        'patient_id',
        'doctor_id',
        'services_cat_id',
        'start_at',
        'end_at',
        'note',
        'creator_id',
        'status', //(not scheduled = 0, scheduled = 1, accepted = 2, done = 3, not respond = 4, postponed = 5, canceled = 6)
        'improvement_rate', //(from 0 to 5)
        'note_after_op',
    ];

    public function specialty()
    {
        return $this->belongsTo(Specialty_cat::class, 'specialty_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function place()
    {
        return $this->belongsTo(Oper_placecat::class, 'oper_place_id', 'id');
    }

    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id', 'id');
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id', 'id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id', 'id');
    }

    public function service_item()
    {
        return $this->belongsTo(Service_item::class, 'services_cat_id', 'id');
    }

    public function invoice_item()
    {
        return $this->morphOne(Invoice_item::class, 'itemable');
    }
    
    // -------- --------

    public function pre_op_draw()
    {
        return $this->morphOne(Disease_draw::class, 'calendable');
    }

    public function diseases()
    {
        return $this->morphMany(Disease::class, 'calendable');
    }

    public function gallery()
    {
        return $this->hasMany(Op_img::class, 'op_id', 'id');
    }

    public function during_op()
    {
        return $this->hasOne(Op_during::class, 'op_id', 'id');
    }
    
    public function follow_up()
    {
        return $this->hasOne(Op_follow_up::class, 'op_id', 'id');
    }
    
}