<?php

namespace App\Models\Branch;

use App\Models\Patient\Patient;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Op_during extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'op_id',
        'patient_id',
        'dorsum_hump_reduction_bony', 
        'dorsum_hump_reduction_septal',
        'dorsum_hump_reduction_cartilaginous',
        'dorsum_augmentation',
        'dorsum_caudal_resection',
        'septum_excision_except',
        'septum_total_excision_reconstruction',
        'septum_reconstruction',
        'septum_fixation_spine',
        'septum_fixation_nasal_bones',
        'septum_scoring',
        'osteotomies_med_oblique',
        'osteotomies_lateral',
        'osteotomies_multiple',
        'osteotomies_bone_carving',
        'upper_lats_on_lay_grafts',
        'upper_lats_total_reconstruction',
        'upper_lats_spreader_grafts',
        'upper_lats_spreader_flaps',
        'tip_plasty_hemidomal_suture',
        'tip_plasty_tip_defining_suture',
        'tip_plasty_tip_equalizing_suture',
        'tip_plasty_other_sutures',
        'cap_graft_non_crushed_cartilage',
        'cap_graft_crushed_cartilage',
        'cap_graft_soft_tissue_cartilage',
        'tip_plasty_shield_graft',
        'tip_plasty_columellar_strut',
        'tools_rose_head_drill',
        'tools_burr_head_drill',
        'tools_piezotome',
        'tools_hammer_chisel',
        'dorsal_graft',
        'conceal_cartilage_graft',
        'costal_cartilage_graft',
        'temporal_fascial_graft',
        'op_type', //text
        'tools_raspier',
        'nostril_reduction',
        'other_steps', //text
        'other_operations', //text
        'cephalic_resection_lat_crus_cartilage',
        'op_duration',// text hour
        'skin_type', //select
        'other_facial_problems', //text
        'length', //number
        'dorsal_width',  //number
        'rotation', //number
        'tip_projection',
        'alar_base', //number
        'other_note',
    ];
    
    public $timestamps = false;

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function opration()
    {
        return $this->belongsTo(Operation::class, 'op_id', 'id');
    }
    
}