<?php

namespace App\Models\Branch;

use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lab extends Model
{
    use HasFactory;
 
    protected $fillable = [
        'id',
        'code',
        'services_cat_id',
        'appointment_id',
        'patient_id',
        'branch_id',
        'resp_doctor_id',
        'xray_file',
        'status',
        'note_doctor',
        'note_lab',
        'created_at',
        'updated_at',
    ];   

    public function service_item()
    {
        return $this->belongsTo(Service_item::class, 'services_cat_id', 'id');
    }

    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'resp_doctor_id', 'id');
    }
    

    public function invoice_item()
    {
        return $this->morphOne(Invoice_item::class, 'itemable');
    }


}