<?php

namespace App\Models\Branch\Appointment;

use App\Models\Branch\Appointment;
use App\Models\Invoice\Invoice_item;
use App\Models\Patient\Cancel_reason_cat;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Rate_appointment extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'appointment_id',
        'type',
        'service',
        'doctor',
        'reception',
        'time',
        'cleanliness',
        'cancel_cat_id',
        'note',
        'saved', //not saved = 1, saved =2
        'appointment_date',
        'created_at',
        'updated_at',
    ];
    
    public function appointment()
    {
        return $this->hasMany(Appointment::class, 'id', 'appointment_id');
    }
  
    public function doctor_rate()
    {
        return $this->hasMany(Invoice_item::class, 'itemable_id', 'appointment_id')->where('itemable_type', 'App\Models\Branch\Appointment');
    }
    
    public function cancel()
    {
        return $this->belongsTo(Cancel_reason_cat::class, 'cancel_cat_id', 'id');
    }


}