<?php

namespace App\Http\Requests;

use App\Rules\CouponRule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\RequiredIf;

class PatientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if($this->search_patient_id != null && isset($this->search_patient_id)){
        return [
            'search_patient_id' => ['required', 'exists:patients,id'],
            'calander_date_day' => ['required',],
            'branch_id' => ['required', 'exists:branches,id'],
            'oper_place_id' => ['sometimes', 'required', 'exists:oper_placecats,id'],
            'service_id' => ['required', 'exists:service_items,id'],
            'coupon_id' => ['nullable', 'exists:coupons,id', new CouponRule($this->search_patient_id)],
        ];
        }
        else{
            return [
                'avatar' => ['image', 'mimes:jpeg,jpg,png', 'max:300'],
                'code' => ['nullable', 'numeric', 'min:7'],
                'first_name' => ['required','max:30'],
                'second_name' => ['required', 'max:60'],
                'mother_name' => ['nullable', 'max:60'],
                'email' => ['nullable', 'email:rfc,dns', ($this->email === $this->old_email) ? '' : 'unique:patients,email', 'max:255'],
                'password' => ['sometimes', 'required', 'confirmed', 'max:255'],
                'newpassword' => ['confirmed', 'max:255'],
                'gendar' => ['required'],
                'blood_type' => ['nullable', 'max:33'],
                'birthday' => ['required', 'date', 'date_format:Y-m-d'],
                'country_id' => ['required', 'exists:countries,id'],
                'city_id' => ['required', 'exists:cities,id'],
                'phone_number' => ['required', ($this->phone_number === $this->old_phone_number) ? '' : 'unique:patients,phone_number', 'max:30'],
                'sec_phone_number' => ['nullable', 'max:30'],
                'insurance' => ['nullable', 'max:30'],
                'from_recourse_id' => ['required','exists:from_recourses,id', 'numeric'],
                'appointment_note' => ['max:255'],
                'calander_date_day' => ['sometimes', 'required'],
                'branch_id' => ['sometimes', 'required', 'exists:branches,id'],
                'service_id' => ['sometimes', 'required', 'exists:service_items,id'],
                'coupon_id' => ['nullable', 'exists:coupons,id', new CouponRule($this->search_patient_id)],
            ];
        }

    }

    public function messages()
    {
        return [
            'country_id.numeric' => 'You have to choose from the list',
            'city_id.numeric' => 'You have to choose from the list',
            'search_patient_id.required' => 'You have not chosen a patient',
            'calander_date_day.required' => 'You have not chosen a date',
            'from_recourse_id.required' => 'Oops! It looks like you forgot to tell us how you found out about us. Please fill in the "How do you know us?" field."',

        ];
    }
}
