<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Models\Patient\Treatment;
use Illuminate\Http\Request;

class TreatmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            'patient_id' => ['required', 'exists:patients,id'],
            'last_appointment_id' => ['required', 'exists:appointments,id'],
            'treatment_cat' => ['required', 'exists:service_items,id'],
            'treatment_session' => ['required'],
            'treatment_start' => ['required', 'date', 'date_format:Y-m-d'],
        ]);

        $treatment = Treatment::create([
            'treatment_cat_id' => $request->input('treatment_cat'),
            'appointment_id' => $request->input('last_appointment_id'),
            'sessions' => $request->input('treatment_session'),
            'patient_id' => $request->input('patient_id'),
            'start' => $request->input('treatment_start'),
            'end' => $request->input('treatment_end'),
        ]);


        session()->flash('success', 'The Treatment has been created successfully');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'treatment_cat_update' => ['required', 'exists:service_items,id'],
            'treatment_session_update' => ['required'],
            'status_treatment_update' => ['required'],
            'treatment_start_update' => ['required', 'date', 'date_format:Y-m-d'],
        ]);

        $treatment_id = $request->input('treatment_id_update');

        $treatment = Treatment::find($treatment_id);

        $treatment->treatment_cat_id = $request->input('treatment_cat_update');
        $treatment->sessions = $request->input('treatment_session_update');
        $treatment->sessions_done = $request->input('treatment_session_done_update');
        $treatment->start = $request->input('treatment_start_update');
        $treatment->end = $request->input('treatment_end_update');
        $treatment->status = $request->input('status_treatment_update');

        $treatment->save();

        session()->flash('success', 'The medicine has been updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id = $request->input('treatment_id_delete');

        Treatment::find($id)->delete();

        session()->flash('success', 'The Treatment has been deleted');
        return redirect()->back();
    }
    
}
