<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Models\Patient\Medicine;
use App\Models\Patient\Prescription;
use Illuminate\Http\Request;

class MedicineController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $medicines = $request->input('medicine_pills_array');

        $this->validate($request, [
            'medicine_pills_array' => ['required', 'array', 'exists:medicine_cats,id'],
            'medicine_pills_array.*' => ['required', 'exists:medicine_cats,id'],
            'medicine_type_array' => ['required', 'array', 'exists:medicine_types,id'],
            'medicine_type_array.*' => ['required', 'exists:medicine_types,id'],
            'medicine_qty_array' => ['required', 'array'],
            'medicine_qty_array.*' => ['required'],
            'medicine_dose_array' => ['required', 'array'],
            'medicine_dose_array.*' => ['required'],
            'medicine_duration_array' => ['required', 'array'],
            'medicine_duration_array.*' => ['required'],
            'medicine_status_array' => ['required', 'array'],
            'medicine_status_array.*' => ['required'],
            'last_appointment_id_medi' => ['nullable', 'exists:appointments,id'],
        ]);

        $prescription = Prescription::create([
            'code' => "PRS-" . $this->generateRandomString(6),
            'appointment_id' => $request->input('last_appointment_id_medi'),
            'patient_id' => $request->input('patient_id'),
            'date' => date("Y-m-d"),
            'note' => $request->input('medicine_note'),
        ]);

        foreach ($medicines as $key => $item) {
            $medicine = Medicine::create([
                'prescription_id' => $prescription->id,
                'medicines_cats' => $item,
                'medicine_type_id' => $request->input('medicine_type_array')[$key],
                'patient_id' => $request->input('patient_id'),
                'qty' => $request->input('medicine_qty_array')[$key],
                'med_dose_id' => $request->input('medicine_dose_array')[$key],
                'med_duration_id' => $request->input('medicine_duration_array')[$key],
                'status' => $request->input('medicine_status_array')[$key],
            ]);
        }

        session()->flash('success', 'The medicines has been created successfully');
        return redirect()->back();
    }

    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

        $medicine = Medicine::select('id', 'medicines_cats', 'start', 'end', 'status')->where('patient_id', $id)
            ->with(['medicinescats' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('status', 'ASC')
            ->get();

        return $medicine;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'medicine_id_update' => ['required', 'exists:medicines,id'],
            'medicine_pills_update' => ['required', 'exists:medicine_cats,id'],
            'medicine_start_update' => ['required', 'date', 'date_format:Y-m-d'],
            'medicine_end_update' => ['required', 'date', 'date_format:Y-m-d'],
            'status_medicine_update' => ['required'],
        ]);

        $medicine_id = $request->input('medicine_id_update');

        $medicine = Medicine::find($medicine_id);

        $medicine->medicines_cats = $request->input('medicine_pills_update');
        $medicine->start = $request->input('medicine_start_update');
        $medicine->end = $request->input('medicine_end_update');
        $medicine->status = $request->input('status_medicine_update');

        $medicine->save();

        session()->flash('success', 'The medicine has been updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id = $request->input('prescription_id_delete');

        $prescription = Prescription::find($id);

        foreach ($prescription->medicines as $item) {
            Medicine::find($item->id)->delete();
        }

        $prescription->delete();

        session()->flash('success', 'The prescription has been deleted');
        return redirect()->back();
    }
}
