<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Models\Patient\Disease;
use App\Models\Patient\Disease_draw;
use App\Models\Patient\Eyeglasses_prescription;
use App\Models\Patient\Pat_examination;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Image;

class Eyeglasses_prescriptionsCont extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            'patient_id' => ['required', 'exists:patients,id'],
            'glass_right_sph' => ['nullable'],
            'glass_right_cyl' => ['nullable'],
            'glass_right_axis' => ['nullable'],
            'glass_left_sph' => ['nullable'],
            'glass_left_cyl' => ['nullable'],
            'glass_left_axis' => ['nullable'],
            'glass_right_n' => ['nullable'],
            'glass_left_n' => ['nullable'],
            'glass_ipd' => ['required'],
            'last_appointment_id_eyeglasses_pres' => ['nullable', 'exists:appointments,id'],
            'glass_date' => ['required'],
        ]);


        $examination = Eyeglasses_prescription::create([
            'code' => "EPR-" . $this->generateRandomString(6),
            'patient_id' => $request->input('patient_id'),
            'appointment_id' => $request->input('last_appointment_id_eyeglasses_pres'),
            'glass_right_sph' => $request->input('glass_right_sph'),
            'glass_right_cyl' => $request->input('glass_right_cyl'),
            'glass_right_axis' => $request->input('glass_right_axis'),
            'glass_left_sph' => $request->input('glass_left_sph'),
            'glass_left_cyl' => $request->input('glass_left_cyl'),
            'glass_left_axis' => $request->input('glass_left_axis'),
            'glass_right_n_plus' => $request->input('glass_right_n_select'),
            'glass_right_n' => $request->input('glass_right_n'),
            'glass_left_n_plus' => $request->input('glass_left_n_select'),
            'glass_left_n' => $request->input('glass_left_n'),
            'ipd' => $request->input('glass_ipd'),
            'date' => $request->input('glass_date'),
            'note' => $request->input('glass_note'),
        ]);

        session()->flash('success', 'The disease has been created successfully');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }


    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'disease_id_update' => ['required', 'exists:diseases,id'],
            'disease_cat_update' => ['required', 'exists:disease_cats,id'],
            'disease_start_update' => ['required', 'date', 'date_format:Y-m-d'],
            'disease_end_update' => ['nullable', 'date', 'date_format:Y-m-d'],
            'status_disease_update' => ['required'],
        ]);

        $disease_id = $request->input('disease_id_update');

        $medicine = Disease::find($disease_id);

        $medicine->disease_cats = $request->input('disease_cat_update');
        $medicine->start = $request->input('disease_start_update');
        $medicine->end = $request->input('disease_end_update');
        $medicine->status = $request->input('status_disease_update');

        $medicine->save();

        session()->flash('success', 'The medicine has been updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id = $request->input('eyeglass_id_delete');

        Eyeglasses_prescription::find($id)->delete();

        session()->flash('success', 'The eyeglasses prescription has been deleted');
        return redirect()->back();
    }
}