<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Models\Patient\Disease;
use App\Models\Patient\Disease_draw;
use App\Models\Patient\Pat_examination;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Image;

class DiseaseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $disease_cat = $request->input('disease_cat');

        $this->validate($request, [
            'patient_id' => ['required', 'exists:patients,id'],
            'disease_cat' => ['nullable', 'exists:disease_cats,id'],
            'disease_start' => ['required', 'date', 'date_format:Y-m-d'],
        ]);

        if ($request->input('exam-op-id')) {
            $this->validate($request, [
                'exam-op-id' => ['required', 'exists:operations,id'],
            ]);
            $calendable_id = $request->input('exam-op-id');
            $calendable_type = "App\Models\Branch\Operation";
        } else {
            $this->validate($request, [
                'last_appointment_id' => ['nullable', 'exists:appointments,id'],
            ]);
            if ($request->input('last_appointment_id')) {
                $calendable_id = $request->input('last_appointment_id');
                $calendable_type = "App\Models\Branch\Appointment";
            } else {
                $calendable_id = null;
                $calendable_type = null;
            }
        }

        $examination = Pat_examination::create([
            'type' => $request->input('examination_type'),
            'calendable_id' => $calendable_id,
            'calendable_type' => $calendable_type,
            'lid_od' => $request->input('lid_od'),
            'patient_id' => $request->input('patient_id'),
            'lid_od' => $request->input('lid_od'),
            'lid_os' => $request->input('lid_os'),
            'surface_od' => $request->input('surface_od'),
            'surface_os' => $request->input('surface_os'),
            'ac_od' => $request->input('ac_od'),
            'ac_os' => $request->input('ac_os'),
            'pupil_od' => $request->input('pupil_od'),
            'pupil_os' => $request->input('pupil_os'),
            'lens_od' => $request->input('lens_od'),
            'lens_os' => $request->input('lens_os'),
            'iris_od' => $request->input('iris_od'),
            'iris_os' => $request->input('iris_os'),
            'angle_od' => $request->input('angle_od'),
            'angle_os' => $request->input('angle_os'),
            'fundus_od' => $request->input('fundus_od'),
            'fundus_os' => $request->input('fundus_os'),
            'motility_od' => $request->input('motility_od'),
            'motility_os' => $request->input('motility_os'),
            'iop_od' => $request->input('iop_od'),
            'iop_os' => $request->input('iop_os'),
            'note' => $request->input('note_diseases'),
        ]);

        $last_appointment = Disease_draw::where('calendable_id', $calendable_id)
            ->where('calendable_type', $calendable_type)
            ->first();

        $front = $request->input('front');
        $back = $request->input('back');

        if ($last_appointment) {

            if (!empty($front)) {

                if ($last_appointment->front) {
                    //to remove the old avatar and also keep the default img
                    $imagePath_front = public_path('img/diseasedraw/' . $last_appointment->front);
                    if (File::exists($imagePath_front)) {
                        File::delete($imagePath_front);
                    }
                }
                //front
                $file_name = "DF" . $request->input('patient_id') . time() . '.' . 'png';
                $path = 'img/diseasedraw/' . $file_name;
                Image::make(file_get_contents($front))->save($path);

                $last_appointment->front = $file_name;
            }

            if (!empty($back)) {

                if ($last_appointment->back) {
                    //to remove the old avatar and also keep the default img
                    $imagePath_back = public_path('img/diseasedraw/' . $last_appointment->back);
                    if (File::exists($imagePath_back)) {
                        File::delete($imagePath_back);
                    }
                }
                //back
                $file_name_b = "DB" . $request->input('patient_id') . time() . '.' . 'png';
                $path_b = 'img/diseasedraw/' . $file_name_b;
                Image::make(file_get_contents($back))->save($path_b);

                $last_appointment->back = $file_name_b;
            }

            if (!empty($request->input('note_diseases'))) {
                $last_appointment->note = $request->input('note_diseases');
            }

            $last_appointment->save();
        } else {

            if (!empty($front)) {
                //front
                $file_name = "DF" . $request->input('patient_id') . time() . '.' . 'png';
                $path = 'img/diseasedraw/' . $file_name;
                Image::make(file_get_contents($front))->save($path);
            } else {
                $file_name = '';
            }

            if (!empty($back)) {
                //back
                $file_name_b = "DB" . $request->input('patient_id') . time() . '.' . 'png';
                $path_b = 'img/diseasedraw/' . $file_name_b;
                Image::make(file_get_contents($back))->save($path_b);
            } else {
                $file_name_b = '';
            }
            $disease_draw = Disease_draw::create([
                'pat_examination_id' => $examination->id,
                'calendable_id' => $calendable_id,
                'calendable_type' => $calendable_type,
                'patient_id' => $request->input('patient_id'),
                'front' => $file_name,
                'back' => $file_name_b,
                'note' => $request->input('note_diseases'),
            ]);
        }

        if ($disease_cat) {
            foreach ($disease_cat as $iteam) {
                $disease = Disease::create([
                    'pat_examination_id' => $examination->id,
                    'disease_cats' => $iteam,
                    'calendable_id' => $calendable_id,
                    'calendable_type' => $calendable_type,
                    'patient_id' => $request->input('patient_id'),
                    'start' => $request->input('disease_start'),
                ]);
            }
        }


        session()->flash('success', 'The disease has been created successfully');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'disease_id_update' => ['required', 'exists:diseases,id'],
            'disease_cat_update' => ['required', 'exists:disease_cats,id'],
            'disease_start_update' => ['required', 'date', 'date_format:Y-m-d'],
            'disease_end_update' => ['nullable', 'date', 'date_format:Y-m-d'],
            'status_disease_update' => ['required'],
        ]);

        $disease_id = $request->input('disease_id_update');

        $medicine = Disease::find($disease_id);

        $medicine->disease_cats = $request->input('disease_cat_update');
        $medicine->start = $request->input('disease_start_update');
        $medicine->end = $request->input('disease_end_update');
        $medicine->status = $request->input('status_disease_update');

        $medicine->save();

        session()->flash('success', 'The medicine has been updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id = $request->input('disease_id_delete');

        Disease::find($id)->delete();

        session()->flash('success', 'The Disease has been deleted');
        return redirect()->back();
    }
}
