<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Invoice\Expenses_item;
use App\Models\Patient\Service_category;
use App\Models\Patient\Service_item;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Service_categ extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (Auth::user()->hasRole('Super-admin')) {
            $service = Service_category::withTrashed()->get();

            return view('cats/service_categ.index', compact('service'));

        }
        else{
            $service = Service_category::all();
            return view('cats/service_categ.index', compact('service'));
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/service_categ.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:service_categories,name',
        ]);

        $service = Service_category::create([
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.service_category.index')
            ->with('success', 'The item has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service = Service_category::find($id);
        return view('cats/service_categ.edit', compact('service'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $service = Service_category::find($id);
        $service->name = $request->input('name');
        $service->save();

        return redirect()->route('sett.service_category.index')
            ->with('success', 'Item has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        Service_category::find($request->input('id_delete'))->delete();
        session()->flash('success', 'The item has been deleted');
        return redirect()->route('sett.service_category.index');
        /*$status = Service_item::where('service_category_id', $request->input('id_delete'))
            ->where('deactivate', 0)
            ->first();

        $status2 = Expenses_item::where('service_category_id', $request->input('id_delete'))
            ->first();
        if (empty($status) && empty($status2)) {

        } else {
            session()->flash('error_delete', 'The item has been used before');
            return redirect()->route('sett.service_category.index');
        }*/
    }
    public function restore(Request $request)
    {
        $service = Service_category::withTrashed()->find($request->input('id_restore'));
        $service->restore();
        session()->flash('success', 'The item has been restored');
        return redirect()->route('sett.service_category.index');
    }
}
