<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use App\Models\Admin\Worker_record;
use App\Models\Branch\Appointment;
use App\Models\Branch\Appointment\Rate_appointment;
use App\Models\Branch\Branch;
use App\Models\Branch\Inventory\Inventory_cat;
use App\Models\Branch\Inventory\Inventory_item;
use App\Models\Branch\Inventory\Inventory_item_record;
use App\Models\Branch\Rate;
use App\Models\Invoice\Coupon;
use App\Models\Invoice\Debtor;
use App\Models\Invoice\Expenses_item;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_cost_material;
use App\Models\Invoice\Invoice_item;
use App\Models\Invoice\Invoice_material;
use App\Models\Invoice\Patient_wallet;
use App\Models\Invoice\Payment;
use App\Models\Patient\From_recourse;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_category;
use App\Models\Patient\Service_inv_cat;
use App\Models\Patient\Service_item;
use App\Models\Patient\Specialty_cat;
use App\Models\User;
use App\Rules\CouponRule;
use App\Rules\PayCashVisa;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\Rule;
use Mpdf\Mpdf;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PDF;
use Illuminate\Support\Facades\File;
use Image;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $branches = Branch::select('id', 'name')->get();
        return view('invoice.index', compact('branches'));
    }

    //for invoice not pay in index table
    public function invoice_result_nopay_index($branch)
    {

        $branch = request()->branch;

        $invoice = Invoice::select('id', 'code', 'receivable_id', 'receivable_type', 'final_price', 'status', 'created_at')
            ->Where('branch_id', $branch)
            ->Where('status', 0)
            ->where('operation', 0)
            ->with(['receivable' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->orderBy('id', 'DESC')
            ->limit(10)
            ->get();

        return $invoice;
    }

    //for invoice that is paid in index table
    public function invoice_result_index($branch)
    {
        $branch = request()->branch;

        $lab = Invoice::select('id', 'code', 'receivable_id', 'receivable_type', 'final_price', 'status', 'created_at')
            ->Where('branch_id', $branch)
            ->Where('status', '!=', 0)
            ->where('operation', 0)
            ->with(['receivable' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->orderBy('id', 'DESC')
            ->limit(10)
            ->get();

        return $lab;
    }


    //select the searched patients via ajax
    public function invoice_search($search_query)
    {

        $search_query = request()->search_query;

        $invoice = Invoice::select('id', 'code', 'receivable_id', 'receivable_type', 'created_at')
            ->with(['receivable' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->where('code', 'like', "%{$search_query}%")
            ->orWhereHas('receivable', function ($query) use ($search_query) {
                $query->whereRaw("concat(first_name, ' ', second_name) like '%$search_query%' ");
            })
            ->orderBy('id', 'DESC')
            ->limit(5)
            ->get();

        return $invoice;
    }


    //search all patients depends on filters
    public function show_all_invoices(request $request)
    {

        $invoices = Invoice::select('id', 'code', 'type', 'specialty_id', 'receivable_id', 'receivable_type', 'branch_id', 'total_paid', 'status', 'created_at')
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('id', 'DESC');

        if ($request->input('branch_srch')) {
            $invoices = $invoices->where('branch_id', $request->input('branch_srch'));
        }

        if ($request->input('specialty_srch')) {
            $invoices = $invoices->where('specialty_id', $request->input('specialty_srch'));
        }

        if ($request->input('type_srch') !== null) {
            $invoices = $invoices->where('type', $request->input('type_srch'));
        }

        //paid or not
        if ($request->input('status_srch') !== null) {
            $invoices = $invoices->where('status', $request->input('status_srch'));
        }

        //target
        if ($request->input('target_srch') !== null) {
            $invoices = $invoices->where('target', $request->input('target_srch'));
        }

        if ($request->input('resource_srch') !== null) {
            $invoices = $invoices
                ->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                    $q->where('from_recourse_id', $request->input('resource_srch'));
                });
        }

        if ($request->input('month_year_srch') !== null) {
            $month_year = $request->input('month_year_srch');
            $month_year_explode = explode('-', $month_year);
            $month = $month_year_explode[0];
            $year = $month_year_explode[1];
            $invoices = $invoices->whereMonth('created_at', date($month))->whereYear('created_at', date($year));
        }


        $invoices = $invoices->paginate(8);

        $specialty = Specialty_cat::all();

        $branch = Branch::all();

        $resources = From_recourse::all();

        $branch = Branch::all();


        return view('invoice.show_all', compact('invoices', 'specialty', 'branch', 'resources'));
    }


    public function day_search($date = null, $specialty = "all", $branch = "all")
    {

        if ($date) {
            $date = $date;
        } else {
            $date = date('Y-m-d');
        }

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        //------------ all day invoices
        //income
        $invoice_income = Invoice::select('id', 'status', 'service_inv_cat_id', 'receivable_id', 'receivable_type', 'branch_id', 'items_price', 'discount', 'final_price', 'total_paid', 'total_cost', 'note', 'paid_date')
            ->where('type', 0)
            ->where('status', '!=', 0)
            ->where('operation', 0)
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('invoice_id', 'categorizable_id', 'categorizable_type', 'itemable_id', 'itemable_type', 'price','doctor_id')
                    ->with(['doctor' => function ($q) {
                        $q->select('id',DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['payment' => function ($q) use ($date) {
                $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date')
                    ->whereDate('paid_date', $date)
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->whereHas('payment', function ($q) use ($date) {
                return $q->where('type', 3)
                    ->whereDate('paid_date', $date);;
            })
            ->orderBy('status', 'ASC');

        if ($specialty !== "all") {
            $invoice_income = $invoice_income->where('specialty_id', $specialty);
        }

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $invoice_income = $invoice_income->where('branch_id', $branch);
            }
        } else {
            $invoice_income = $invoice_income->where('branch_id', Auth::user()->branch_id);
        }
        $invoice_income = $invoice_income->get();
        //dd($invoice_income->toArray());



        //expenses
        $invoice_expenses = Invoice::select('id', 'status', 'service_inv_cat_id', 'receivable_id', 'receivable_type', 'branch_id', 'items_price', 'discount', 'final_price', 'total_paid', 'note', 'paid_date')
            ->where('type', 1)
            ->where('status', '!=', 0)
            ->where('operation', 0)
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('invoice_id', 'categorizable_id', 'categorizable_type', 'price','doctor_id')
                ->with(['doctor' => function ($q) {
                    $q->select('id',DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                }])
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['payment' => function ($q) use ($date) {
                $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date')
                    ->whereDate('paid_date', $date)
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->whereHas('payment', function ($q) use ($date) {
                return $q->where('type', 3)
                    ->whereDate('paid_date', $date);;
            })
            ->orderBy('status', 'ASC');

        if ($specialty !== "all") {
            $invoice_expenses = $invoice_expenses->where('specialty_id', $specialty);
        }

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $invoice_expenses = $invoice_expenses->where('branch_id', $branch);
            }
        } else {
            $invoice_expenses = $invoice_expenses->where('branch_id', Auth::user()->branch_id);
        }

        $invoice_expenses = $invoice_expenses->get();


        //------------ all day operation
        //income
        $invoice_oper_income = Invoice::select('id', 'status', 'service_inv_cat_id', 'receivable_id', 'receivable_type', 'branch_id', 'items_price', 'discount', 'final_price', 'total_paid', 'note', 'paid_date')
            ->where('type', 0)
            ->where('status', '!=', 0)
            ->where('operation', 1)
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('invoice_id', 'categorizable_id', 'categorizable_type', 'price')
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['payment' => function ($q) use ($date) {
                $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date')
                    ->whereDate('paid_date', $date)
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->whereHas('payment', function ($q) use ($date) {
                return $q->where('type', 3)
                    ->whereDate('paid_date', $date);
            })
            ->orderBy('status', 'ASC');

        if ($specialty !== "all") {
            $invoice_oper_income = $invoice_oper_income->where('specialty_id', $specialty);
        }

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $invoice_oper_income = $invoice_oper_income->where('branch_id', $branch);
            }
        } else {
            $invoice_oper_income = $invoice_oper_income->where('branch_id', Auth::user()->branch_id);
        }

        $invoice_oper_income = $invoice_oper_income->get();

        //expenses
        $invoice_oper_expenses = Invoice::select('id', 'status', 'service_inv_cat_id', 'receivable_id', 'receivable_type', 'branch_id', 'items_price', 'discount', 'final_price', 'total_paid', 'note', 'paid_date')
            ->where('type', 1)
            ->where('status', '!=', 0)
            ->where('operation', 1)
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('invoice_id', 'categorizable_id', 'categorizable_type', 'price')
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['payment' => function ($q) use ($date) {
                $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date')
                    ->whereDate('paid_date', $date)
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->whereHas('payment', function ($q) use ($date) {
                return $q->where('type', 3)
                    ->whereDate('paid_date', $date);;
            })
            ->orderBy('status', 'ASC');

        if ($specialty !== "all") {
            $invoice_oper_expenses = $invoice_oper_expenses->where('specialty_id', $specialty);
        }

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $invoice_oper_expenses = $invoice_oper_expenses->where('branch_id', $branch);
            }
        } else {
            $invoice_oper_expenses = $invoice_oper_expenses->where('branch_id', Auth::user()->branch_id);
        }

        $invoice_oper_expenses = $invoice_oper_expenses->get();

        //wallet
        $wallet = Patient_wallet::whereDate('date', $date)
            ->with(['patient' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['service' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('type', 'ASC');

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $wallet = $wallet->where('branch_id', $branch);
            }
        } else {
            $wallet = $wallet->where('branch_id', Auth::user()->branch_id);
        }

        $wallet = $wallet->get();

        return view('invoice/dayinvoice', compact('specialty_cat', 'branches', 'date', 'specialty', 'branch', 'invoice_income', 'invoice_expenses', 'invoice_oper_income', 'invoice_oper_expenses', 'wallet'));
    }


    public function month_search($date = null, $specialty = "all", $branch = "all")
    {

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        if ($date) {
            $month_year = $date;
            $month_year_explode = explode('-', $month_year);
            $year = $month_year_explode[1];
            $month = $month_year_explode[0];
        } else {
            $year = Carbon::now()->year;
            $month = Carbon::now()->format('m');
            $date =  $month . '-' . $year;
        }

        $invoice_income = Invoice::select('id', 'total_paid')
            ->where('type', 0)
            ->where('status', '!=', 0)
            ->where('operation', 0)
            ->whereYear('paid_date', $year)
            ->whereMonth('paid_date', $month)
            ->sum('total_paid');

        $invoice_expenses = Invoice::select('id', 'total_paid')
            ->where('type', 1)
            ->where('status', '!=', 0)
            ->where('operation', 0)
            ->whereYear('paid_date', $year)
            ->whereMonth('paid_date', $month)
            ->sum('total_paid');

        //------------ all day invoices
        //income
        $invoice_income_inv = Invoice::select('id', 'status', 'service_inv_cat_id', 'receivable_id', 'receivable_type', 'branch_id', 'items_price', 'discount', 'final_price', 'total_paid', 'note', 'total_cost', 'paid_date')
            ->where('type', 0)
            ->where('status', '!=', 0)
            ->where('operation', 0)
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('invoice_id', 'categorizable_id', 'categorizable_type', 'itemable_id', 'itemable_type', 'price','doctor_id')
                    ->with(['doctor' => function ($q) {
                        $q->select('id',DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['payment' => function ($q) use ($year, $month) {
                $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date')
                    ->whereYear('paid_date', $year)
                    ->whereMonth('paid_date', $month)
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->whereHas('payment', function ($q) use ($year, $month) {
                return $q->where('type', 3)
                    ->whereYear('paid_date', $year)
                    ->whereMonth('paid_date', $month);
            })
            ->orderBy('status', 'ASC');

        if ($specialty !== "all") {
            $invoice_income_inv = $invoice_income_inv->where('specialty_id', $specialty);
        }

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $invoice_income_inv = $invoice_income_inv->where('branch_id', $branch);
            }
        } else {
            $invoice_income_inv = $invoice_income_inv->where('branch_id', Auth::user()->branch_id);
        }

        $invoice_income_inv_total = $invoice_income_inv->get();

        $invoice_income_inv = $invoice_income_inv->get();

        $total_income_cash = 0;
        $total_income_visa = 0;

        foreach ($invoice_income_inv_total as $item_in) {
            foreach ($item_in->payment as $item_in_p) {
                if ($item_in_p->method == 1) {
                    $payment_method_txt = __('basic.cash');
                    $total_income_cash += $item_in_p->amount;
                } elseif ($item_in_p->method == 2) {
                    $payment_method_txt = __('basic.visa');
                    $total_income_visa += $item_in_p->amount;
                }
            }
        }

        //income
        $invoice_expenses_inv = Invoice::select('id', 'status', 'service_inv_cat_id', 'receivable_id', 'receivable_type', 'branch_id', 'items_price', 'discount', 'final_price', 'total_paid', 'note', 'total_cost', 'paid_date')
            ->where('type', 1)
            ->where('status', '!=', 0)
            ->where('operation', 0)
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('invoice_id', 'categorizable_id', 'categorizable_type', 'itemable_id', 'itemable_type', 'price','doctor_id')
                    ->with(['doctor' => function ($q) {
                        $q->select('id',DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['payment' => function ($q) use ($year, $month) {
                $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date')
                    ->whereYear('paid_date', $year)
                    ->whereMonth('paid_date', $month)
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->whereHas('payment', function ($q) use ($year, $month) {
                return $q->where('type', 3)
                    ->whereYear('paid_date', $year)
                    ->whereMonth('paid_date', $month);
            })
            ->orderBy('status', 'ASC');

        if ($specialty !== "all") {
            $invoice_expenses_inv = $invoice_expenses_inv->where('specialty_id', $specialty);
        }

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $invoice_expenses_inv = $invoice_expenses_inv->where('branch_id', $branch);
            }
        } else {
            $invoice_expenses_inv = $invoice_expenses_inv->where('branch_id', Auth::user()->branch_id);
        }

        $invoice_expesnes_inv_total = $invoice_expenses_inv->get();

        $invoice_expenses_inv = $invoice_expenses_inv->get();

        $total_expenses_cash = 0;
        $total_expenses_visa = 0;

        foreach ($invoice_expesnes_inv_total as $item_ex) {
            foreach ($item_ex->payment as $item_ex_p) {
                if ($item_ex_p->method == 1) {
                    $total_expenses_cash += $item_ex_p->amount;
                } elseif ($item_ex_p->method == 2) {
                    $total_expenses_visa += $item_ex_p->amount;
                }
            }
        }

        //income
        $income_details_cat = Invoice::select('invoices.id', 'invoices.service_inv_cat_id', 'payments.amount', DB::raw('sum(payments.amount) as sums'))
            ->join('payments', 'invoices.id', '=', 'payments.invoice_id')
            ->with('service_inv_cat:id,name')
            ->where('invoices.type', 0)
            ->where('invoices.status', '!=', 0)
            ->where('invoices.operation', 0)
            ->where('payments.type', 3)
            ->whereYear('payments.paid_date', $year)
            ->whereMonth('payments.paid_date', $month)
            ->groupBy('service_inv_cat_id');

        if ($specialty !== "all") {
            $income_details_cat = $income_details_cat->where('invoices.specialty_id', $specialty);
        }

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $income_details_cat = $income_details_cat->where('invoices.branch_id', $branch);
            }
        } else {
            $income_details_cat = $income_details_cat->where('invoices.branch_id', Auth::user()->branch_id);
        }

        $income_details_cat = $income_details_cat->get();

        //expenses
        $expenses_details_cat = Invoice::select('invoices.id', 'invoices.service_inv_cat_id', 'payments.amount', DB::raw('sum(payments.amount) as sums'))
            ->join('payments', 'invoices.id', '=', 'payments.invoice_id')
            ->with('service_inv_cat:id,name')
            ->where('invoices.type', 1)
            ->where('invoices.status', '!=', 0)
            ->where('invoices.operation', 0)
            ->where('payments.type', 3)
            ->whereYear('payments.paid_date', $year)
            ->whereMonth('payments.paid_date', $month)
            ->groupBy('service_inv_cat_id');

        if ($specialty !== "all") {
            $expenses_details_cat = $expenses_details_cat->where('invoices.specialty_id', $specialty);
        }

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $expenses_details_cat = $expenses_details_cat->where('invoices.branch_id', $branch);
            }
        } else {
            $expenses_details_cat = $expenses_details_cat->where('invoices.branch_id', Auth::user()->branch_id);
        }

        $expenses_details_cat = $expenses_details_cat->get();

        //------------ all day totals by items
        //income
        // $income_details = Invoice_item::select('invoice_id', 'categorizable_id', 'categorizable_type', 'price', DB::raw('sum(paid) as sums'))
        //     ->with(['categorizable' => function ($q) {
        //         $q->select('id', 'name');
        //     }])
        //     ->whereHas('invoice', function ($q) use ($year, $month) {
        //         $q->where('status', '!=', 0)
        //             ->where('type', 0)
        //             ->where('operation', 0)
        //             ->whereHas('payment', function ($q) use ($year, $month) {
        //                 return $q->where('type', 3)
        //                     ->whereYear('paid_date', $year)
        //                     ->whereMonth('paid_date', $month);
        //             });
        //     })
        //     ->groupBy('categorizable_type', 'categorizable_id');

        // if ($specialty !== "all") {
        //     $income_details = $income_details->whereHas('invoice', function ($q) use ($specialty) {
        //         $q->where('specialty_id', $specialty);
        //     });
        // }

        // if ($branch !== "all") {
        //     $income_details = $income_details->whereHas('invoice', function ($q) use ($branch) {
        //         $q->where('branch_id', $branch);
        //     });
        // }

        // $income_details = $income_details->get();

        // //expenses
        // $expenses_details = Invoice_item::select('invoice_id', 'categorizable_id', 'categorizable_type', 'price', DB::raw('sum(paid) as sums'))
        //     ->with(['categorizable' => function ($q) {
        //         $q->select('id', 'name');
        //     }])
        //     ->whereHas('invoice', function ($q) use ($year, $month) {
        //         $q->where('status', '!=', 0)
        //             ->where('type', 1)
        //             ->where('operation', 0)
        //             ->whereHas('payment', function ($q) use ($year, $month) {
        //                 return $q->where('type', 3)
        //                     ->whereYear('paid_date', $year)
        //                     ->whereMonth('paid_date', $month);
        //             });
        //     })
        //     ->groupBy('categorizable_type', 'categorizable_id');

        // if ($specialty !== "all") {
        //     $expenses_details = $expenses_details->whereHas('invoice', function ($q) use ($specialty) {
        //         $q->where('specialty_id', $specialty);
        //     });
        // }

        // if ($branch !== "all") {
        //     $expenses_details = $expenses_details->whereHas('invoice', function ($q) use ($branch) {
        //         $q->where('branch_id', $branch);
        //     });
        // }

        // $expenses_details = $expenses_details->get();

        $income_details = "";
        $expenses_details = "";
        //------------ all day operation
        //income
        $invoice_oper_income = Invoice::select('id', 'status', 'service_inv_cat_id', 'receivable_id', 'receivable_type', 'branch_id', 'items_price', 'discount', 'final_price', 'total_paid', 'note', 'paid_date')
            ->where('type', 0)
            ->where('status', '!=', 0)
            ->where('operation', 1)
            ->whereHas('payment', function ($q) use ($year, $month) {
                return $q->where('type', 3)
                    ->whereYear('paid_date', $year)
                    ->whereMonth('paid_date', $month);
            })
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['worker' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('invoice_id', 'categorizable_id', 'categorizable_type', 'price')
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->orderBy('status', 'ASC');

        if ($specialty !== "all") {
            $invoice_oper_income = $invoice_oper_income->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $invoice_oper_income = $invoice_oper_income->where('branch_id', $branch);
        }

        $invoice_oper_income = $invoice_oper_income->get();

        //expenses
        $invoice_oper_expenses = Invoice::select('id', 'status', 'service_inv_cat_id', 'receivable_id', 'receivable_type', 'branch_id', 'items_price', 'discount', 'final_price', 'total_paid', 'note', 'paid_date')
            ->where('type', 1)
            ->where('status', '!=', 0)
            ->where('operation', 1)
            ->whereHas('payment', function ($q) use ($year, $month) {
                return $q->where('type', 3)
                    ->whereYear('paid_date', $year)
                    ->whereMonth('paid_date', $month);
            })
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['worker' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('invoice_id', 'categorizable_id', 'categorizable_type', 'price')
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->orderBy('status', 'ASC');

        if ($specialty !== "all") {
            $invoice_oper_expenses = $invoice_oper_expenses->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $invoice_oper_expenses = $invoice_oper_expenses->where('branch_id', $branch);
        }

        $invoice_oper_expenses = $invoice_oper_expenses->get();

        return view('invoice/monthinvoice', compact('specialty_cat', 'branches', 'date', 'specialty', 'branch', 'invoice_income', 'invoice_expenses', 'income_details_cat', 'expenses_details_cat', 'income_details', 'expenses_details', 'invoice_oper_income', 'invoice_oper_expenses', 'invoice_income_inv', 'invoice_expenses_inv', 'total_expenses_cash', 'total_expenses_visa', 'total_income_cash', 'total_income_visa'));
    }


    public function year_search($date = null, $specialty = "all", $branch = "all")
    {

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        if ($date) {
            $date = $date;
        } else {
            $date = Carbon::now()->year;
        }

        //for branches stats during year
        $service_inv_cat = Service_inv_cat::whereHas('invoice', function ($q) {
            $q->where('status', '!=', 0)
                ->where('type', 0);
        })
            ->get();

        $income_items = new Collection();

        foreach ($service_inv_cat as $item) {
            $query = Invoice::select('invoices.id', 'invoices.service_inv_cat_id', 'payments.amount', DB::raw('sum(payments.amount) as sums'), DB::raw("DATE_FORMAT(payments.paid_date,'%m') as monthKey"))
                ->join('payments', 'invoices.id', '=', 'payments.invoice_id')
                ->with('service_inv_cat:id,name')
                ->where('invoices.type', 0)
                ->where('invoices.status', '!=', 0)
                ->where('invoices.operation', 0)
                ->where('payments.type', 3)
                ->whereYear('payments.paid_date', $date)
                ->where('service_inv_cat_id', $item->id)
                ->groupBy('service_inv_cat_id');


            if ($specialty !== "all") {
                $query = $query->where('specialty_id', $specialty);
            }

            if ($branch !== "all") {
                $query = $query->where('branch_id', $branch);
            }
            $query = $query->get();

            $income_date_branches = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

            if (count($query) > 0) {
                foreach ($query as $order) {
                    $income_date_branches[$order->monthKey - 1] = $order->sums;
                }
                //$branch_name = $query[0]->branch->name;
                $income_items->push((object)[
                    'name' => $query[0]->service_inv_cat->name,
                    'total' => $income_date_branches,
                ]);
            }
        }


        //--------- expenses

        //for branches stats during year
        $service_inv_cat_expenses = Service_inv_cat::whereHas('invoice', function ($q) {
            $q->where('status', '!=', 0)
                ->where('type', 1);
        })
            ->get();

        $expenses_items = new Collection();

        foreach ($service_inv_cat_expenses as $item) {
            $query_exp = Invoice::select('invoices.id', 'invoices.service_inv_cat_id', 'payments.amount', DB::raw('sum(payments.amount) as sums'), DB::raw("DATE_FORMAT(payments.paid_date,'%m') as monthKey"))
                ->join('payments', 'invoices.id', '=', 'payments.invoice_id')
                ->with('service_inv_cat:id,name')
                ->where('invoices.type', 1)
                ->where('invoices.status', '!=', 0)
                ->where('invoices.operation', 0)
                ->where('payments.type', 3)
                ->whereYear('payments.paid_date', $date)
                ->where('service_inv_cat_id', $item->id)
                ->groupBy('service_inv_cat_id');

            if ($specialty !== "all") {
                $query_exp = $query_exp->where('specialty_id', $specialty);
            }

            if ($branch !== "all") {
                $query_exp = $query_exp->where('branch_id', $branch);
            }
            $query_exp = $query_exp->get();

            $expenses_date_branches = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

            if (count($query_exp) > 0) {
                foreach ($query_exp as $order_ex) {
                    $expenses_date_branches[$order_ex->monthKey - 1] = $order_ex->sums;
                }
                //$branch_name = $query[0]->branch->name;
                $expenses_items->push((object)[
                    'name' => $query_exp[0]->service_inv_cat->name,
                    'total' => $expenses_date_branches,
                ]);
            }
        }

        return view('invoice/yearinvoice', compact('specialty_cat', 'branches', 'date', 'specialty', 'branch', 'income_items', 'expenses_items'));
    }


    public function invo_other_search(Request $request)
    {

        $workers = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->whereHas(
                'roles',
                function ($q) {
                    $q->where('name', 'Receptionist');
                }
            )
            ->get();

        $doctors = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->whereHas(
                'roles',
                function ($q) {
                    $q->where('name', 'doctor');
                }
            )
            ->get();

        $services =  Service_item::select('id', 'name')->where('deactivate', 0)->get();
        $service_cats =  Service_category::select('id', 'name')->get();
       // dd($service_cats);
        $branches =  Branch::select('id', 'name')->get();

        return view('invoice/other_search.index', compact('workers', 'doctors', 'services', 'branches','service_cats'));
    }

    public function invo_other_search_store(Request $request, $date, $service = null, $doctor = null, $worker = null, $branch = null)
    {

        $this->validate($request, [
            'date' => ['required'],
            'branch' => ['required'],
        ]);

        $service = "all";
        if($request->has('service')){
            $service = $request->input('service');
            foreach ($service as $item) {
                if ($item == "all") {
                    $service = "all";
                    break;
                }
            }
        }

        $doctor = $request->input('doctor');
        $worker = $request->input('worker');
        $method = $request->input('method');
        $branch = $request->input('branch');

        //------------ date ------------
        $date = $request->input('date');

        $date_serc = explode('to', $date);
        $date_1_serc = $date_serc[0];
        if (isset($date_serc[1])) {
            $date_2_serc = $date_serc[1];
        } else {
            $date_2_serc = $date_serc[0];
        }

        //------------------------

        $invoice = Invoice_item::select('invoice_id', 'categorizable_id', 'categorizable_type', 'price', 'doctor_id')
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereHas('invoice', function ($q) use ($date_1_serc, $date_2_serc) {
                $q->where('operation', 0)
                    ->whereBetween('created_at', [
                        Carbon::createFromFormat('m-Y', $date_1_serc)->startOfMonth(), //2022-10-01 00:00:00.0
                        Carbon::createFromFormat('m-Y', $date_2_serc)->endOfMonth() // 2022-10-31 23:59:59.999999
                    ]);
            });

        if ($service !== "all") {
            $invoice = $invoice->whereIn('categorizable_id', $service)
                ->where('categorizable_type', "App\Models\Patient\Service_item");
        }

        if ($branch !== "all") {
            $invoice = $invoice->whereHas('invoice', function ($q) use ($branch) {
                $q->where('branch_id', $branch);
            });
        }

        $worker_type = "";

        if ($doctor !== "false" && $worker === "false") {
            $invoice = $invoice->where('doctor_id', $doctor);
            $worker_type = "doctor";
        };

        if ($worker !== "false" && $doctor === "false") {
            $invoice = $invoice->whereHas('invoice', function ($q) use ($worker) {
                $q->whereHas('payment', function ($q) use ($worker) {
                    return $q->where('responsible_worker', $worker);
                });
            });
            $worker_type = "worker";

        }

        if ($worker !== "false" && $doctor !== "false") {

            return redirect()->back();
        }


        if ($method !== "all") {
            $invoice = $invoice->with(['payment' => function ($q) use ($method) {
                $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date')
                    ->where('method', $method)
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }]);
        } else {
            $invoice = $invoice->with(['invoice' => function ($q) {
                $q->select('id', 'code','status', 'receivable_id', 'receivable_type', 'branch_id', 'note', 'discount', 'total_cost')
                    ->with(['receivable' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['payment' => function ($q) {
                        $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date')
                            ->with(['worker' => function ($q) {
                                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                            }]);
                    }]);
            }]);
        };


        $invoice = $invoice->get();

        //dd($invoice);
       /* foreach ($invoice as $item){
            dd($item->categorizable);
        };*/

        return view('invoice/other_search.show', compact('invoice', 'worker_type'));
    }

    public function allstatcs(Request $request)
    {

        if (!empty($request->input('specialty'))) {
            $specialty = $request->input('specialty');
        } else {
            $specialty = 'all';
        }
        if (!empty($request->input('branch'))) {
            $branch = $request->input('branch');
        } else {
            $branch = 'all';
        }
        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = 'all';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = 'all';
        }

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $credit = Invoice::select('invoices.id', 'invoices.service_inv_cat_id', 'payments.amount', DB::raw('sum(payments.amount) as sums'), DB::raw("DATE_FORMAT(payments.paid_date,'%m') as monthKey"))
            ->join('payments', 'invoices.id', '=', 'payments.invoice_id')
            ->with('service_inv_cat:id,name')
            ->where('invoices.type', 0)
            ->where('invoices.status', '!=', 0)
            ->where('invoices.operation', 0)
            ->where('payments.type', 3)
            ->whereYear('payments.paid_date', date('Y'))
            ->groupBy('monthKey');

        if ($specialty !== "all") {
            $credit = $credit->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $credit = $credit->where('branch_id', $branch);
        }

        $credit = $credit->get();

        $data_credit = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        foreach ($credit as $order) {
            $data_credit[$order->monthKey - 1] = $order->sums;
        }

        //----
        $total_credit = Invoice::where('type', 0)
            ->where('status', '!=', 0);

        if ($specialty !== "all") {
            $total_credit = $total_credit->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $total_credit = $total_credit->where('branch_id', $branch);
        }

        if ($from !== "all") {
            $total_credit = $total_credit->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_credit = $total_credit->whereYear('created_at', date('Y'));
        }


        $total_credit = $total_credit->sum('total_paid');

        //----------------------

        $debit = Invoice::select('invoices.id', 'invoices.service_inv_cat_id', 'payments.amount', DB::raw('sum(payments.amount) as sums'), DB::raw("DATE_FORMAT(payments.paid_date,'%m') as monthKey"))
            ->join('payments', 'invoices.id', '=', 'payments.invoice_id')
            ->with('service_inv_cat:id,name')
            ->where('invoices.type', 1)
            ->where('invoices.status', '!=', 0)
            ->where('invoices.operation', 0)
            ->where('payments.type', 3)
            ->whereYear('payments.paid_date', date('Y'))
            ->groupBy('monthKey');

        if ($specialty !== "all") {
            $debit = $debit->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $debit = $debit->where('branch_id', $branch);
        }

        $debit = $debit->get();
        $data_debit = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        foreach ($debit as $order) {
            $data_debit[$order->monthKey - 1] = $order->sums;
        }
        // ----

        $total_debit = Invoice::where('type', 1)
            ->where('status', '!=', 0);

        if ($specialty !== "all") {
            $total_debit = $total_debit->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $total_debit = $total_debit->where('branch_id', $branch);
        }

        if ($from !== "all") {
            $total_debit = $total_debit->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_debit = $total_debit->whereYear('created_at', date('Y'));
        }

        $total_debit = $total_debit->sum('total_paid');;

        // ----------------------

        $specialty_income = Invoice::select('specialty_id', DB::raw('sum(total_paid) as total'))
            ->groupBy('specialty_id')
            ->where('type', 0)
            ->where('status', '!=', 0)
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereYear('created_at', date('Y'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $specialty_income = $specialty_income->where('branch_id', $branch);
        }

        $specialty_income = $specialty_income->get();
        //--
        $specialty_income_month = Invoice::select('specialty_id', DB::raw('sum(total_paid) as total'))
            ->groupBy('specialty_id')
            ->where('type', 0)
            ->whereIn('status', [1, 2])
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $specialty_income_month = $specialty_income_month->where('branch_id', $branch);
        }

        if ($from !== "all") {
            $specialty_income_month = $specialty_income_month->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $specialty_income_month = $specialty_income_month->whereMonth('created_at', date('m'));
        }

        $specialty_income_month = $specialty_income_month->get();

        //------
        $specialty_expenses = Invoice::select('specialty_id', DB::raw('sum(total_paid) as total'))
            ->groupBy('specialty_id')
            ->where('type', 1)
            ->where('status', '!=', 0)
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereYear('created_at', date('Y'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $specialty_expenses = $specialty_expenses->where('branch_id', $branch);
        }

        $specialty_expenses = $specialty_expenses->get();
        //--

        $specialty_expenses_month = Invoice::select('specialty_id', DB::raw('sum(total_paid) as total'))
            ->groupBy('specialty_id')
            ->where('type', 1)
            ->where('status', '!=', 0)
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $specialty_expenses_month = $specialty_expenses_month->where('branch_id', $branch);
        }

        if ($from !== "all") {
            $specialty_expenses_month = $specialty_expenses_month->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $specialty_expenses_month = $specialty_expenses_month->whereMonth('created_at', date('m'));
        }

        $specialty_expenses_month = $specialty_expenses_month->get();

        // ----------------------

        $branch_income = Invoice::select('branch_id', DB::raw('sum(total_paid) as total'))
            ->groupBy('branch_id')
            ->where('type', 0)
            ->whereIn('status', [1, 2])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereYear('created_at', date('Y'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $branch_income = $branch_income->where('specialty_id', $specialty);
        }
        $branch_income = $branch_income->get();
        //--

        $branch_income_month = Invoice::select('branch_id', DB::raw('sum(total_paid) as total'))
            ->groupBy('branch_id')
            ->where('type', 0)
            ->whereIn('status', [1, 2])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $branch_income_month = $branch_income_month->where('specialty_id', $specialty);
        }

        if ($from !== "all") {
            $branch_income_month = $branch_income_month->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $branch_income_month = $branch_income_month->whereMonth('created_at', date('m'));
        }

        $branch_income_month = $branch_income_month->get();

        //------
        $branch_expenses = Invoice::select('branch_id', DB::raw('sum(total_paid) as total'))
            ->groupBy('branch_id')
            ->where('type', 1)
            ->whereIn('status', [1, 2])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereYear('created_at', date('Y'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $branch_expenses = $branch_expenses->where('specialty_id', $specialty);
        }

        $branch_expenses = $branch_expenses->get();
        //--
        $branch_expenses_month = Invoice::select('branch_id', DB::raw('sum(total_paid) as total'))
            ->groupBy('branch_id')
            ->where('type', 1)
            ->whereIn('status', [1, 2])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $branch_expenses_month = $branch_expenses_month->where('specialty_id', $specialty);
        }

        if ($from !== "all") {
            $branch_expenses_month = $branch_expenses_month->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $branch_expenses_month = $branch_expenses_month->whereMonth('created_at', date('m'));
        }

        $branch_expenses_month = $branch_expenses_month->get();

        // ----------------------

        $profit = Invoice_item::select('invoice_id', 'categorizable_id', 'categorizable_type', DB::raw('sum(paid) as sums'))
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(40)
            ->groupBy('categorizable_id', 'categorizable_type');

        if ($specialty !== "all") {
            $profit = $profit->whereHas('invoice', function ($q) use ($specialty) {
                $q->where('type', 0)->select('id')
                    ->whereIn('status', '!=', 0)
                    ->where('specialty_id', $specialty)
                    ->whereYear('paid_date', date('Y'));
            });
        } else {
            $profit = $profit->whereHas('invoice', function ($q) use ($specialty) {
                $q->where('type', 0)->select('id')
                    ->where('status', '!=', 0)
                    ->whereYear('paid_date', date('Y'));
            });
        }

        if ($branch !== "all") {
            $profit = $profit->whereHas('invoice', function ($q) use ($branch) {
                $q->where('type', 0)->select('id')
                    ->where('branch_id', $branch)
                    ->where('status', '!=', 0)
                    ->whereYear('paid_date', date('Y'));
            });
        } else {
            $profit = $profit->whereHas('invoice', function ($q) use ($specialty) {
                $q->where('type', 0)->select('id')
                    ->where('status', '!=', 0)
                    ->whereYear('paid_date', date('Y'));
            });
        }

        $profit = $profit->get();

        // ----------------------

        $expense = Invoice_item::select('invoice_id', 'categorizable_id', 'categorizable_type', DB::raw('sum(paid) as sums'))
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(40)
            ->groupBy('categorizable_id', 'categorizable_type');

        if ($specialty !== "all") {
            $expense = $expense->whereHas('invoice', function ($q) use ($specialty) {
                $q->where('type', 1)->select('id')
                    ->where('status', '!=', 0)
                    ->where('specialty_id', $specialty);
            });
        } else {
            $expense = $expense->whereHas('invoice', function ($q) use ($specialty) {
                $q->where('type', 1)->select('id')
                    ->where('status', '!=', 0);
            });
        }

        if ($branch !== "all") {
            $expense = $expense->whereHas('invoice', function ($q) use ($branch) {
                $q->where('type', 1)->select('id')
                    ->where('branch_id', $branch)
                    ->where('status', '!=', 0);
            });
        } else {
            $expense = $expense->whereHas('invoice', function ($q) use ($specialty) {
                $q->where('type', 1)->select('id')
                    ->where('status', '!=', 0);
            });
        }

        $expense = $expense->get();

        // ----------------------

        return view('invoice/allstatcs', compact('specialty_cat', 'branches',  'specialty', 'branch', 'data_credit', 'data_debit', 'total_credit', 'total_debit', 'specialty_income', 'specialty_income_month', 'specialty_expenses', 'specialty_expenses_month', 'branch_income', 'branch_income_month', 'branch_expenses', 'branch_expenses_month', 'profit', 'expense', 'branch', 'from', 'to',));
    }


    public function coupon_search($search_query, $patient_id, $total_price)
    {

        $search_query = request()->search_query;
        $coupon = Coupon::where('code', $search_query)->where('status', '1')->first();

        //if it is empty
        if (!$coupon) {
            $msg = "Sorry! invalid or expired coupon";
            return array('msg' => $msg);
        } else {
            $discount_amount = $coupon->discount($total_price);
            $coupon_id = $coupon->id;

            if ($patient_id === 'null') {
                $msg = "Coupon has been applied";
                $result = array('msg' => $msg, 'discount_amount' => $discount_amount, 'id' => $coupon_id);
                return $result;
            } else {

                $used_coupon = Invoice::where('coupon_id', $coupon_id)->where('receivable_id', $patient_id)->where('receivable_type', 'App\Models\Patient\Patient')->first();

                if (empty($used_coupon)) {
                    $msg = "Coupon has been applied";
                    $result = array('msg' => $msg, 'discount_amount' => $discount_amount, 'id' => $coupon_id);
                    return $result;
                } else {
                    $msg = "Sorry! You have used this coupon before";
                    return array('msg' => $msg);
                }
            }
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $specialty_cat = Specialty_cat::all();
        $branch = Branch::all();
        $debt_cat = Expenses_item::all();
        $debtor = Debtor::select('id', 'company_name',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))->get();
        $service_cat = Service_item::where('deactivate', 0)->get();

        return view('invoice.create', compact('specialty_cat', 'branch', 'debt_cat', 'debtor', 'service_cat'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    //store debt
    public function store(Request $request)
    {

        $this->validate($request, [
            'specialty_id' => ['required', 'exists:specialty_cats,id'],
            'prodcuts_inven_debit' => ['sometimes', 'required', 'exists:inventory_items,id'],
            'debtor_id' => ['nullable', 'exists:debtors,id'],
            'doctor_id' => ['nullable', 'exists:users,id'],
            'debt_branch_id' => ['required', 'exists:branches,id'],
            'debt_quantity' => ['sometimes', 'required'],
            'exp_item_price' => ['required'],
            'note' => ['max:255'],
            'amount_paid' => ['numeric', 'required'],
            'attached_pic_expenses' => ['image', 'mimes:jpeg,jpg,png', 'max:1000'],
        ]);

        $expenses_item_id = $request->input('expenses_item');

        //for seleceting the receiver
        if (!empty($request->input('debtor_id'))) {
            $receivable_id = $request->input('debtor_id');
            $receivable_type = "App\Models\Invoice\Debtor";
        } elseif (!empty($request->input('doctor_id'))) {
            $receivable_id = $request->input('doctor_id');
            $receivable_type = "App\Models\User";
        } else {
            $receivable_id = "";
            $receivable_type = "";
        }

        $exp_item_price = $request->input('exp_item_price');


        $debt_quantity = $request->input('stock_quantity');
        $total_price = ($exp_item_price * $debt_quantity);

        if ($expenses_item_id === 'prodcut_inventory') {
            $total_price_for_if = $total_price;
        } else {
            $total_price_for_if = $exp_item_price;
        }

        $amount_paid = $request->input('amount_paid');
        //if there is a deposit
        if ($amount_paid >= $total_price_for_if) {
            $total_paid = $total_price_for_if;
            $status = 3;
        } else {
            $total_paid = $amount_paid;
            $status = 1;
        }

        //for attaching invoice img
        if ($request->hasFile('attached_pic_expenses')) {

            $file_extension = $request->file('attached_pic_expenses')->getClientOriginalExtension();

            $file_name = "INV" . time() . '.' . $file_extension;

            $path = public_path('img/inv_attached/' . $file_name);

            Image::make($request->attached_pic_expenses)
                ->resize(450, null, function ($constraint) {
                    $constraint->aspectRatio();
                })
                ->save($path, 50);
        } else {
            $file_name = '';
        }

        //if the item is from the stock
        if ($expenses_item_id === 'prodcut_inventory') {

            $product_id = $request->input('prodcuts_inven_debit');
            $inve_item_que = Inventory_item::select('id', 'service_inv_cat_id', 'current_quantity')->find($product_id);

            $invoice = Invoice::create([
                'code' => "IN" . $this->generateRandomString(6),
                'type' => 1,
                'status' => $status,
                'service_inv_cat_id' => $inve_item_que->service_inv_cat_id,
                'specialty_id' => $request->input('specialty_id'),
                'receivable_id' => $receivable_id,
                'receivable_type' => $receivable_type,
                'branch_id' => $request->input('debt_branch_id'),
                'items_price' => $total_price,
                'final_price' => $total_price,
                'total_paid' => $total_paid,
                'paid_date' => $request->input('expenses_pay_date'),
                'note' => $request->input('note'),
                'attached_pic' => $file_name,
            ]);

            $payment = Payment::create([
                'invoice_id' => $invoice->id,
                'method' => 1,
                'amount' => $total_paid,
                'responsible_worker' => Auth::id(),
                'paid_date' => $request->input('expenses_pay_date'),
            ]);

            $invoice_item = Invoice_item::create([
                'invoice_id' => $invoice->id,
                'itemable_id' =>  $product_id,
                'itemable_type' => "App\Models\Branch\Inventory\Inventory_item",
                'categorizable_id' =>  $product_id,
                'categorizable_type' => "App\Models\Branch\Inventory\Inventory_item",
                'price' => $total_price,
                'sold_price' => $total_price,
                'paid' => $total_paid,
            ]);

            //to add the quantity in inventory
            $inve_item_que->increment('current_quantity', $debt_quantity);
            $invoice->save();

            //to add the inventory item recored
            $inventory_recored = Inventory_item_record::create([
                'responsible_id' => Auth::id(),
                'type' => 0,
                'item_id' =>  $product_id,
                'invoice_id' =>  $invoice->id,
                'quantity' => $debt_quantity,
                'price' => $total_price,
                'buying_date' => date("Y-m-d H:i:s"),
            ]);
        } else {

            $this->validate($request, [
                'expenses_item' => ['required', 'exists:expenses_items,id'],
            ]);

            $service_inv_cat = Expenses_item::select('id', 'service_inv_cat_id', 'price')->where('id', $expenses_item_id)->first();

            $invoice = Invoice::create([
                'code' => "IN" . $this->generateRandomString(6),
                'type' => 1,
                'status' => $status,
                'service_inv_cat_id' => $service_inv_cat->service_inv_cat_id,
                'specialty_id' => $request->input('specialty_id'),
                'receivable_id' => $receivable_id,
                'receivable_type' => $receivable_type,
                'branch_id' => $request->input('debt_branch_id'),
                'items_price' => $exp_item_price,
                'final_price' => $exp_item_price,
                'total_paid' => $total_paid,
                'paid_date' => $request->input('expenses_pay_date'),
                'note' => $request->input('note'),
                'attached_pic' => $file_name,
            ]);

            $payment = Payment::create([
                'invoice_id' => $invoice->id,
                'method' => 1,
                'amount' => $total_paid,
                'responsible_worker' => Auth::id(),
                'paid_date' => $request->input('expenses_pay_date'),
            ]);

            $invoice_item = Invoice_item::create([
                'invoice_id' => $invoice->id,
                'categorizable_id' => $expenses_item_id,
                'categorizable_type' => "App\Models\Invoice\Expenses_item",
                'price' => $exp_item_price,
                'sold_price' => $exp_item_price,
                'paid' => $total_paid,
            ]);
        }

        session()->flash('success', 'The Invoice has been created successfully');
        return redirect()->route('sett.invoice.show', $invoice->id);
    }

    public function store_income(Request $request)
    {

        $this->validate($request, [
            'specialty_credit_id' => ['required', 'exists:specialty_cats,id'],
            'prodcuts_inven_credit' => ['sometimes', 'required', 'exists:inventory_items,id'],
            'patient_id' => ['nullable', 'exists:patients,id'],
            'credit_branch_id' => ['required', 'exists:branches,id'],
            'credit_quantity' => ['sometimes', 'required'],
            'credit_price' => ['sometimes', 'required'],
            'amount_paid_expenses' => ['numeric', 'required'],
            'note_credit' => ['max:255'],
        ]);

        $service_cat_id = $request->input('service_item');

        if (!empty($request->input('patient_id'))) {
            $receivable_id = $request->input('patient_id');
            $receivable_type = "App\Models\Patient\Patient";
        } else {
            $receivable_id = "";
            $receivable_type = "";
        }

        $income_item_price = $request->input('credit_price');


        $income_quantity = $request->input('credit_quantity');
        $total_price = ($income_item_price * $income_quantity);

        if ($service_cat_id === 'prodcut_inventory') {
            $total_price_for_if = $total_price;
        } else {
            $total_price_for_if = $income_item_price;
        }

        $amount_paid = $request->input('amount_paid_expenses');

        //if there is a deposit
        if ($amount_paid >= $total_price_for_if) {
            $total_paid = $total_price_for_if;
            $status = 3;
        } else {
            $total_paid = $amount_paid;
            $status = 1;
        }


        if ($service_cat_id === 'prodcut_inventory') {

            $product_id = $request->input('prodcuts_inven_credit');
            $inve_item_que = Inventory_item::select('id', 'service_inv_cat_id', 'current_quantity')->find($product_id);

            $invoice = Invoice::create([
                'code' => "IN" . $this->generateRandomString(6),
                'status' => $status,
                'service_inv_cat_id' => $inve_item_que->service_inv_cat_id,
                'specialty_id' => $request->input('specialty_credit_id'),
                'receivable_id' => $receivable_id,
                'receivable_type' => $receivable_type,
                'branch_id' => $request->input('credit_branch_id'),
                'items_price' => $total_price,
                'final_price' => $total_price,
                'total_paid' => $total_paid,
                'paid_date' => $request->input('income_pay_date'),
                'note' => $request->input('note_credit'),
            ]);

            $payment = Payment::create([
                'invoice_id' => $invoice->id,
                'method' => 1,
                'amount' => $total_paid,
                'responsible_worker' => Auth::id(),
                'paid_date' => $request->input('income_pay_date'),
            ]);

            $invoice_item = Invoice_item::create([
                'invoice_id' => $invoice->id,
                'itemable_id' =>  $product_id,
                'itemable_type' => "App\Models\Branch\Inventory\Inventory_item",
                'categorizable_id' =>  $product_id,
                'categorizable_type' => "App\Models\Branch\Inventory\Inventory_item",
                'quantity' => $income_quantity,
                'price' => $total_price,
                'sold_price' => $total_price,
                'paid' => $total_paid,
            ]);

            //to add the quantity in inventory
            $inve_item_que->decrement('current_quantity', $income_quantity);
            $invoice->save();
            //to add the inventory item recored
            $inventory_recored = Inventory_item_record::create([
                'responsible_id' => Auth::id(),
                'type' => 1,
                'item_id' =>  $product_id,
                'invoice_id' =>  $invoice->id,
                'quantity' => $income_quantity,
                'price' => $total_price,
                'buying_date' => date("Y-m-d H:i:s"),
            ]);
        } else {

            $this->validate($request, [
                'service_item' => ['required', 'exists:service_items,id'],
            ]);

            $service_cat_price = Service_item::select('id', 'price', 'service_inv_cat_id', 'doctor_comm')->where('deactivate', 0)->where('id', $service_cat_id)->first();

            $doctor_comm = $service_cat_price->doctor_comm / 100 * $service_cat_price->price;

            $invoice = Invoice::create([
                'code' => "IN" . $this->generateRandomString(6),
                'status' => $status,
                'service_inv_cat_id' => $service_cat_price->service_inv_cat_id,
                'specialty_id' => $request->input('specialty_credit_id'),
                'receivable_id' => $receivable_id,
                'receivable_type' => $receivable_type,
                'branch_id' => $request->input('credit_branch_id'),
                'items_price' => $income_item_price,
                'final_price' => $income_item_price,
                'total_paid' => $total_paid,
                'total_cost' => $doctor_comm,
                'paid_date' => $request->input('income_pay_date'),
                'note' => $request->input('note_credit'),
            ]);

            $payment = Payment::create([
                'invoice_id' => $invoice->id,
                'method' => 1,
                'amount' => $total_paid,
                'responsible_worker' => Auth::id(),
                'paid_date' => $request->input('income_pay_date'),
            ]);

            $invoice_item = Invoice_item::create([
                'invoice_id' => $invoice->id,
                'categorizable_id' => $service_cat_id,
                'categorizable_type' => "App\Models\Patient\Service_item",
                'price' => $income_item_price,
                'sold_price' => $income_item_price,
                'doctor_comm' => $doctor_comm,
                'paid' => $total_paid,
            ]);
        }

        session()->flash('success', 'The Invoice has been created successfully');
        return redirect()->route('sett.invoice.show', $invoice->id);
    }

    public function add_items(Request $request, $invoice_id)
    {

        $this->validate($request, [
            'item_add' => ['exists:service_items,id'],
            'item_add_product' => ['exists:inventory_items,id'],
            'branch_id' => ['required', 'exists:branches,id'],
            'type_id' => ['required', Rule::in([0, 1])],
        ]);

        if ($request->input('item_add')) {
            foreach ($request->input('item_add') as $item) {

                $service_cat_id = Service_item::select('id', 'price')->find($item);

                $invoice_item = Invoice_item::create([
                    'invoice_id' => $invoice_id,
                    'categorizable_id' => $service_cat_id->id,
                    'categorizable_type' => "App\Models\Patient\Service_item",
                    'price' => $service_cat_id->price,
                    'sold_price' => $service_cat_id->price,
                ]);
            }
        }

        if ($request->input('item_add_product')) {
            foreach ($request->input('item_add_product') as $item) {

                $product_cat_id = Inventory_item::select('id', 'price')->find($item);

                $invoice_item = Invoice_item::create([
                    'invoice_id' => $invoice_id,
                    'categorizable_id' => $product_cat_id->id,
                    'categorizable_type' => "App\Models\Branch\Inventory\Inventory_item",
                    'price' => $product_cat_id->price,
                    'sold_price' => $product_cat_id->price,
                ]);

                //to add or withdraw the quantity in inventory
                $inventory_item_id = Inventory_item::select('id', 'current_quantity')
                    ->where('id', $item)
                    ->first();
                if ($request->input('type_id') == 0) {
                    $inventory_item_id->decrement('current_quantity', 1);
                } else {
                    $inventory_item_id->increment('current_quantity', 1);
                }
                $inventory_item_id->save();
            }
        }

        $final_price = 0;

        $invoice = Invoice::find($invoice_id);

        foreach ($invoice->invoice_items as $item) {
            $invoice_items = Invoice_item::find($item->id);
            $invoice_items->sold_price = $invoice_items->price;
            $invoice_items->save();
            $final_price += $item->price;
        }

        $invoice->items_price = $final_price;
        $invoice->final_price = $final_price;
        $invoice->discount = null;
        $invoice->save();

        session()->flash('success', 'The items has been added successfully');
        return redirect()->back();
    }

    public function invo_add_material(Request $request, $invoice_id)
    {

        $this->validate($request, [
            'invoice_item_material' => ['required', 'exists:invoice_items,id'],
            'inventory_add_material' => ['required', 'exists:inventory_items,id'],
            'material_qty' => ['required', 'numeric'],
        ]);

        $inventory = Inventory_item::select('price')->find($request->input('inventory_add_material'));
        $inventory_price = $request->input('material_qty') * $inventory->price;

        $inventory->decrement('current_quantity', $request->input('material_qty'));
        $inventory->save();

        $invoice = Invoice::find($invoice_id);
        $invoice->increment('total_cost', $inventory_price);
        $invoice->save();

        $invoice_material = Invoice_cost_material::create([
            'type' => 2,
            'invoice_id' => $invoice_id,
            'invoice_item_id' => $request->input('invoice_item_material'),
            'inventory_id' => $request->input('inventory_add_material'),
            'qty' => $request->input('material_qty'),
            'price' => $inventory->price,
        ]);


        session()->flash('success', 'The items has been added successfully');
        return redirect()->back();
    }

    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

        $services = Service_item::select('id', 'name')->where('deactivate', 0)->get();

        $invoice = Invoice::where('id', $id)
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['worker' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'price', 'sold_price', 'doctor_comm', 'paid')
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['materials' => function ($q) {
                $q->select('id', 'invoice_id', 'invoice_item_id', 'inventory_id', 'qty', 'price')
                    ->with(['inventory' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['costs' => function ($q) {
                $q->select('id', 'invoice_id', 'invoice_item_id', 'cost_cat_id', 'price')
                    ->with(['cost_cat' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['payment' => function ($q) {
                $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date', 'installment_date')
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->with(['coupon' => function ($q) {
                $q->select('id', 'code');
            }])
            ->orderBy('status', 'ASC')
            ->first();

        $products = Inventory_item::select('id', 'name')->where('branch_id', $invoice->branch_id)->get();

        if ($invoice->discount) {

            //to get the percentage of the disounct amount
            $discount_percentage =  ($invoice->discount * 100) / $invoice->items_price;
        } else {
            $discount_percentage = '';
        }

        return view('invoice.show', compact('services', 'products', 'invoice', 'discount_percentage'));
    }

    public function debtor_show($id)
    {

        $debtor = Debtor::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'), 'avatar', 'company_name')

            ->find($id);

        $invoice = Invoice::where('receivable_id', $id)
            ->where('receivable_type', 'App\Models\Invoice\Debtor')
            ->with(['invoice_items' => function ($q) {
                $q->select('invoice_id', 'categorizable_id', 'categorizable_type', 'price')
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('status', 'ASC')
            ->get();


        return view('invoice/debtors', compact('debtor', 'invoice'));
    }


    public function doctor_show($id)
    {

        $doctor = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'), 'avatar', 'phone_number', 'branch_id',)
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->find($id);

        $doctor_record = Worker_record::where('doctor_id', $id)
            ->orderBy('start', 'DESC')
            ->get();

        $invoice = Invoice::where('receivable_id', $id)
            ->where('receivable_type', 'App\Models\User')
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('status', 'ASC')
            ->get();

        $worker = User::find($id);

        $role = $worker->roles->pluck('name')[0];

        if ($role === 'Doctor') {
            $rate = Rate_appointment::select('id', 'appointment_id', 'doctor')
                ->where('type', 1)
                ->with(['doctor_rate' => function ($q) {
                    $q->select('id', 'itemable_id', 'itemable_type');
                }])
                ->whereHas('doctor_rate', function ($query) use ($id) {
                    return $query->where('doctor_id', $id);
                })
                ->avg('doctor');
        } elseif (in_array($role, ['Receptionist', 'Branch-manager'])) {
            $rate = Rate_appointment::select('id', 'appointment_id', 'reception')
                ->where('type', 1)
                ->with(['appointment' => function ($q) {
                    $q->select('id', 'creator_id');
                }])
                ->whereHas('appointment', function ($query) use ($id) {
                    return $query->where('creator_id', $id);
                })
                ->avg('reception');
        } else {
            $rate = 0;
        }

        return view('invoice/doctor_debt', compact('doctor', 'doctor_record', 'invoice', 'rate'));
    }


    //print
    public function invoice_print($id)
    {

        $invoice = Invoice::where('id', $id)
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['worker' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_items' => function ($q) {
                $q->select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'price', 'sold_price', 'doctor_comm', 'paid')
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['materials' => function ($q) {
                $q->select('id', 'invoice_id', 'invoice_item_id', 'inventory_id', 'qty', 'price')
                    ->with(['inventory' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['payment' => function ($q) {
                $q->select('id', 'invoice_id', 'type', 'method', 'amount', 'responsible_worker', 'paid_date', 'installment_date')
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->with(['coupon' => function ($q) {
                $q->select('id', 'code');
            }])
            ->orderBy('status', 'ASC')
            ->first();

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        $qrcode = base64_encode(QrCode::color(68, 95, 129)->size(80)->style('round')->eye('circle')->generate($invoice->code));

        $html = view('invoice.print', compact('invoice', 'qrcode'))->render();

        $mpdf = new Mpdf();

        $mpdf->SetHTMLHeader('<div class="header">
        <div class="row">
        <div class="col-xs-9 m-0 ps-3">
            <img src="' . $logo . '">
        </div>
        <div class="col-xs-2 text-center m-0 ps-3">
            <img src="data:image/svg;base64,' . $qrcode . '">
            <p class="mt-1 mb-0 text-s fw-bold2">' . $invoice->code . '</p>
        </div>
        </div>
        </div>
        ', 'O');
        $mpdf->SetHTMLFooter('<div class"text-center"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 17,
        ]);
        $mpdf->WriteHTML($html);
        $mpdf->output();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            //'pay' => ['required'],
        ]);

        $invoice = Invoice::find($id);

        $invoice->paid_date =  $request->input('pay_date');

        if ($request->input('status') == 0) {
            $invoice->total_paid =  0;
            $invoice->coupon_id =  null;
            $invoice->discount =  null;
            $invoice->final_price =  $invoice->items_price;
            $invoice->status = 0;
            $invoice->paid_date =  null;
            $invoice->target =  $request->input('target_update');

            Invoice::where('id', $invoice->refund_id)->delete();
            $invoice->refund_id =  null;

            foreach ($invoice->invoice_items as $item) {
                $invoice_items = Invoice_item::find($item->id);
                $invoice_items->paid = 0;
                $invoice_items->sold_price = $invoice_items->price;
                $invoice_items->save();
            }

            foreach ($invoice->materials as $item) {
                $inve_item = Inventory_item::select('id', 'service_inv_cat_id', 'current_quantity')->find($item->inventory_id);
                $inve_item->increment('current_quantity', $item->qty);
                $inve_item->save();
            }

            Inventory_item_record::where('invoice_id', $invoice->id)->delete();

            Payment::where('invoice_id', $id)->delete();
        }

        $invoice->save();

        session()->flash('success', 'The invoice has been paid successfully');
        return redirect()->back();
    }

    public function invoice_pay(Request $request, $id)
    {

        $invoice = Invoice::find($id);

        $this->validate($request, [
            'coupon_id' => ['nullable', 'exists:coupons,id', new CouponRule($invoice->receivable_id)],
            'invoice_id' => ['required', 'exists:invoices,id'],
            'doctor_discount' => ['nullable', 'numeric', 'between:1,100'],
        ]);

        $final_price = $invoice->final_price;

        $coupon_id = $request->input('coupon_id');

        //apply coupon and discount on final price first
        if (!empty($coupon_id)) {
            $coupon = Coupon::find($coupon_id);

            $discount_amount = $coupon->discount($final_price);

            $final_price = $final_price - $discount_amount;

            //to get the percentage of the disounct amount
            $amount_to_percentage =  ($discount_amount * 100) / $invoice->final_price;

            foreach ($invoice->invoice_items as $item) {
                $invoice_items = Invoice_item::find($item->id);
                $discount_item = ($amount_to_percentage / 100) * $invoice_items->price;
                $invoice_items->decrement('sold_price', $discount_item);
                $invoice_items->save();
            }
        } else {

            if ($request->input('doctor_discount') !== null || $request->input('doctor_discount_value') !== null) {

                if ($request->input('doctor_discount_value')) {
                    if ($request->input('doctor_discount_value') >= $invoice->items_price) {
                        $discount_percentage = 100;
                    } else {
                        $discount_percentage = ($request->input('doctor_discount_value') / $invoice->items_price) * 100;
                    }
                } else {
                    $discount_percentage = $request->input('doctor_discount');
                }

                $discount_amount = ($discount_percentage / 100) * $invoice->items_price;

                $final_price = $invoice->items_price - $discount_amount;

                foreach ($invoice->invoice_items as $item) {
                    $invoice_items = Invoice_item::find($item->id);
                    $discount_item = ($discount_percentage / 100) * $invoice_items->price;
                    $invoice_items->sold_price = $invoice_items->price - $discount_item;
                    $invoice_items->save();
                }
            } else {
                $discount_amount = null;
                $final_price = $final_price;
            }
        }

        $invoice->coupon_id = $coupon_id;

        //for edting the final price and total in invoice
        //if the discount higher than the final price make it paid and 0 in sold price in items
        if ($discount_amount >= $invoice->items_price) {

            $invoice->discount = $invoice->final_price;
            $invoice->final_price =  0;
            $invoice->total_paid =  0;
            $invoice->status = 3;
            $invoice->paid_date = Carbon::now()->toDateTimeString();

            foreach ($invoice->invoice_items as $item) {
                $invoice_items = Invoice_item::find($item->id);
                $invoice_items->paid = 0;
                $invoice_items->save();
            }
        }
        //to final pay the invoice if there is no discount lower than the final price
        else {

            $cash_pay = $request->input('cash_pay');
            $visa_pay = $request->input('visa_pay');

            $total_payment = $cash_pay + $visa_pay;

            $this->validate($request, [
                'cash_pay' => ['required_if:visa_pay,=,null', new PayCashVisa($cash_pay, $visa_pay, $final_price)],
                'visa_pay' => ['required_if:cash_pay,=,null', new PayCashVisa($cash_pay, $visa_pay, $final_price)],
            ]);

            if ($invoice->discount && $discount_amount == null) {
                $discount_amount = $invoice->discount;
            } else {
                $discount_amount = $discount_amount;
            }

            if ($cash_pay) {
                $payment = Payment::create([
                    'invoice_id' => $invoice->id,
                    'method' => 1,
                    'amount' => $cash_pay,
                    'responsible_worker' => Auth::id(),
                    'paid_date' => Carbon::now()->toDateTimeString(),
                ]);
            }

            if ($visa_pay) {
                $payment = Payment::create([
                    'invoice_id' => $invoice->id,
                    'method' => 2,
                    'amount' => $visa_pay,
                    'responsible_worker' => Auth::id(),
                    'paid_date' => Carbon::now()->toDateTimeString(),
                ]);
            }

            //increase the total paid in invoice
            $invoice->increment('total_paid', $total_payment);

            $invoice->target = $request->input('target');
            $invoice->discount = $discount_amount;
            $invoice->final_price =  $final_price;
            $invoice->total_paid = $total_payment;
            $invoice->paid_date = Carbon::now()->toDateTimeString();

            //if cash or visa is fully paid
            if ($total_payment == $final_price) {
                $invoice->status = 3;
                $invoice->paid_date = Carbon::now()->toDateTimeString();

                //to pay the full amount in invoice items
                foreach ($invoice->invoice_items as $item) {
                    $invoice_items_inv = Invoice_item::find($item->id);
                    $invoice_items_inv->paid = $invoice_items_inv->sold_price;
                    $invoice_items_inv->save();
                }

                //to add to the wallet
                if ($invoice->service_inv_cat_id == 9) {
                    $patient = Patient::find($invoice->receivable_id);
                    $wallet_reco = Patient_wallet::create([
                        'type' => 0,
                        'branch_id' => $invoice->branch_id,
                        'patient_id' => $invoice->receivable_id,
                        'invoice_id' => $invoice->id,
                        'balance_before_tran' =>  $patient->wallet,
                        'amount' =>  $final_price,
                        'date' => $invoice->created_at,
                        'note' => $invoice->note,
                    ]);
                    $patient->increment('wallet', $final_price);
                    $patient->save();
                }
            } else {
                $invoice->status = 1;
                $amount_to_percentage_deposit =  ($total_payment * 100) / $invoice->final_price;

                foreach ($invoice->invoice_items as $item) {
                    $invoice_items = Invoice_item::find($item->id);
                    $final_price_deposit_item = ($amount_to_percentage_deposit / 100) * $invoice_items->sold_price;
                    $invoice_items->paid = $final_price_deposit_item;
                    $invoice_items->save();
                }
            }
        }

        $invoice->save();

        //decrement and add record to inventory
        if ($invoice->materials) {
            foreach ($invoice->materials as $item) {

                $inve_item = Inventory_item::select('id', 'service_inv_cat_id', 'current_quantity')->find($item->inventory_id);
                $invoice_item = Invoice_item::find($item->invoice_item_id);

                $inve_item->decrement('current_quantity', $item->qty);
                $inve_item->save();

                $total_price = $item->price * $item->qty;

                //to add the inventory item recored
                $inventory_recored = Inventory_item_record::create([
                    'responsible_id' => $invoice_item->itemable->doctor_id,
                    'type' => 1,
                    'item_id' =>  $item->inventory_id,
                    'invoice_id' =>  $item->invoice_id,
                    'quantity' => $item->qty,
                    'price' => $total_price,
                    'buying_date' => date("Y-m-d H:i:s"),
                ]);
            }
        }

        session()->flash('success', 'The invoice has been paid successfully');
        return redirect()->back();
    }

    public function invoice_pay_installment(Request $request, $id)
    {

        $invoice = Invoice::find($id);

        $cash_pay = $request->input('cash_pay_insta');
        $visa_pay = $request->input('visa_pay_insta');
        $total_to_pay = $invoice->final_price - $invoice->payment->sum('amount');

        $total_payment = $cash_pay + $visa_pay;

        $this->validate($request, [
            'cash_pay_insta' => ['required_if:visa_pay_insta,=,null', new PayCashVisa($cash_pay, $visa_pay, $total_to_pay)],
            'visa_pay_insta' => ['required_if:cash_pay_insta,=,null', new PayCashVisa($cash_pay, $visa_pay, $total_to_pay)],
        ]);

        if ($total_to_pay == $total_payment) {
            $invoice->paid_date = Carbon::now()->toDateTimeString();
            $invoice->status = 3;
        }

        $invoice->increment('total_paid', $total_payment);
        $invoice->save();

        if ($cash_pay) {
            $payment = Payment::create([
                'invoice_id' => $invoice->id,
                'method' => 1,
                'amount' => $cash_pay,
                'responsible_worker' => Auth::id(),
                'paid_date' => Carbon::now()->toDateTimeString(),
            ]);
        }

        if ($visa_pay) {
            $payment = Payment::create([
                'invoice_id' => $invoice->id,
                'method' => 2,
                'amount' => $visa_pay,
                'responsible_worker' => Auth::id(),
                'paid_date' => Carbon::now()->toDateTimeString(),
            ]);
        }

        $amount_to_percentage =  ($total_payment * 100) / $invoice->final_price;

        foreach ($invoice->invoice_items as $item) {
            $invoice_items = Invoice_item::find($item->id);
            $final_price_item = ($amount_to_percentage / 100) * $invoice_items->sold_price;
            $invoice_items->increment('paid', $final_price_item);
            $invoice_items->save();
        }

        session()->flash('success', 'The payment has been added successfully');
        return redirect()->back();
    }

    public function insert_installment(Request $request, $id)
    {


        $this->validate($request, [
            'installment_date.*' => ['required'],
        ]);

        $invoice = Invoice::find($id);

        $insta = $request->input('installment_date');

        $insta_total = $invoice->final_price / count($insta);

        foreach ($insta as $key => $item) {
            $payment = Payment::create([
                'invoice_id' => $invoice->id,
                'type' => 2,
                'method' => 1,
                'amount' => $insta_total,
                'installment_date' => $request->input('installment_date')[$key],
            ]);
        }

        $invoice->status = 2;
        $invoice->save();

        session()->flash('success', 'The payment has been added successfully');
        return redirect()->back();
    }

    public function edit_inv_payment(Request $request, $id)
    {

        $this->validate($request, [
            'payment_date' => ['required', 'sometimes']
        ]);

        $payment = Payment::find($id);

        $payment->paid_date = $request->input('payment_date');
        $payment->installment_date = $request->input('installment_date');
        $payment->method = $request->input('payment_method');
        $payment->save();

        session()->flash('success', 'The payment date has been edited successfully');
        return redirect()->back();
    }

    public function pay_installment(Request $request, $id)
    {

        $payment = Payment::find($id);

        $payment->paid_date = Carbon::now()->toDateTimeString();
        $payment->type = 3;
        $payment->responsible_worker = Auth::id();
        $payment->save();

        $amount = $payment->amount;

        $invoice = Invoice::find($payment->invoice_id);
        $invoice->increment('total_paid', $amount);

        if ($invoice->final_price == $invoice->total_paid) {
            $invoice->status = 3;
            $invoice->paid_date = Carbon::now()->toDateTimeString();
        }

        $invoice->save();

        $amount_to_percentage =  ($amount * 100) / $invoice->final_price;

        foreach ($invoice->invoice_items as $item) {
            $invoice_items = Invoice_item::find($item->id);
            $final_price_item = ($amount_to_percentage / 100) * $invoice_items->sold_price;
            $invoice_items->increment('paid', $final_price_item);
            $invoice_items->save();
        }

        session()->flash('success', 'The payment has been added successfully');
        return redirect()->back();
    }


    public function today_installment($date = null)
    {

        if ($date) {
            $date = $date;
        } else {
            $date = date('Y-m-d');
        }

        $invoice = Payment::select('id', 'invoice_id', 'amount', 'responsible_worker', 'installment_date')
            ->where('type', 2)
            ->whereDate('installment_date', $date)
            ->with(['invoice' => function ($q) {
                $q->select('id', 'code', 'receivable_id', 'receivable_type')
                    ->with(['receivable' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->with(['invoice_items' => function ($q) {
                        $q->select('id', 'invoice_id', 'categorizable_id', 'categorizable_type',)
                            ->with(['categorizable' => function ($q) {
                                $q->select('id', 'name');
                            }]);
                    }]);
            }])
            ->with(['worker' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->get();

        return view('invoice/installment.index', compact('invoice'));
    }


    public function refund_inv(Request $request, $id)
    {

        $invoice = Invoice::find($id);
        $invoice->status = 4;

        $invoice_new = Invoice::create([
            'code' => "IN" . $this->generateRandomString(6),
            'type' => 1,
            'status' => 3,
            'service_inv_cat_id' => 11,
            'specialty_id' => $invoice->specialty_id,
            'receivable_id' => $invoice->receivable_id,
            'receivable_type' => $invoice->receivable_type,
            'branch_id' => $invoice->branch_id,
            'items_price' => $invoice->total_paid,
            'final_price' => $invoice->total_paid,
            'total_paid' => $invoice->total_paid,
            'paid_date' => Carbon::now()->toDateTimeString(),
            'note' => "Refund of invoice " . $invoice->code,
            'responsible_worker' => Auth::id(),
            'refund_id' => $invoice->id,
        ]);

        $invoice->refund_id = $invoice_new->id;


        $invoice_item = Invoice_item::create([
            'invoice_id' => $invoice_new->id,
            'categorizable_id' => 2,
            'categorizable_type' => "App\Models\Invoice\Expenses_item",
            'price' => $invoice->total_paid,
            'sold_price' => $invoice->total_paid,
            'paid' => $invoice->total_paid,
        ]);


        foreach ($invoice->payment as $item) {
            $payment = Payment::create([
                'invoice_id' => $invoice_new->id,
                'type' => $item->type,
                'method' => $item->method,
                'amount' => $item->amount,
                'responsible_worker' => $item->responsible_worker,
                'paid_date' => Carbon::now()->toDateTimeString(),
            ]);
        }


        $invoice->save();

        session()->flash('success', 'The payment has been added successfully');
        return redirect()->back();
    }


    public function delete_inv_material(Request $request, $id)
    {

        $cost_material = Invoice_cost_material::find($id);

        //if it is cost
        if ($cost_material->type == 1) {
            $total_cost = $cost_material->price;
        }
        //if it is material
        else {
            $total_cost = $cost_material->price * $cost_material->qty;
        }
        //get the total price for all qty

        $invoice_id = $cost_material->invoice_id;
        $invoice = Invoice::find($invoice_id);

        $invoice->decrement('total_cost', $total_cost);
        $invoice->save();

        $cost_material->delete();

        session()->flash('success', 'The Item has been deleted successfully');
        return redirect()->back();
    }

    public function delete_inv_payment(Request $request, $id)
    {

        $payment = Payment::find($id);

        $invoice_id = $payment->invoice_id;
        $invoice = Invoice::find($invoice_id);


        $invoice->decrement('total_paid', $payment->amount);
        $invoice->save();

        $amount_to_percentage =  ($payment->amount * 100) / $invoice->final_price;

        foreach ($invoice->invoice_items as $item) {
            $invoice_items = Invoice_item::find($item->id);
            $final_price_item = ($amount_to_percentage / 100) * $invoice_items->sold_price;
            $invoice_items->decrement('paid', $final_price_item);
            $invoice_items->save();
        }

        $payment->delete();

        session()->flash('success', 'The payment has been deleted successfully');
        return redirect()->back();
    }

    // edit the invoice items
    public function inv_edit_item(Request $request, $id)
    {

        $this->validate($request, [
            'original_price' => ['required', 'numeric']
        ]);

        $invoice_item = Invoice_item::find($id);

        $old_doctor_comm = $invoice_item->doctor_comm;

        $invoice_item->price = $request->input('original_price');
        $invoice_item->sold_price = $request->input('original_price');
        $invoice_item->doctor_comm = $request->input('doctor_comm');
        $invoice_item->save();

        $invoice = Invoice::find($invoice_item->invoice_id);

        $final_price = 0;

        foreach ($invoice->invoice_items as $item) {
            $invoice_items = Invoice_item::find($item->id);
            $invoice_items->sold_price = $invoice_items->price;
            $invoice_items->paid = 0;
            $invoice_items->save();
            $final_price += $item->price;
        }

        $invoice->items_price = $final_price;
        $invoice->final_price = $final_price;
        $invoice->status = 0;
        $invoice->discount = null;
        $invoice->paid_date = null;

        $invoice->decrement('total_cost', $old_doctor_comm);
        $invoice->save();
        $invoice->increment('total_cost', $request->input('doctor_comm'));
        $invoice->save();

        Payment::where('invoice_id', $invoice_item->invoice_id)->delete();

        session()->flash('success', 'The item has been edited successfully');
        return redirect()->back();
    }


    public function inv_edit_note(Request $request, $id)
    {
        $invoice = Invoice::find($id);
        $invoice->note = $request->input('note');
        $invoice->save();

        session()->flash('success', 'The note has been paid successfully');
        return redirect()->back();
    }


    public function invoice_edit_attched(Request $request, $id)
    {

        $this->validate($request, [
            'attached_pic_edit' => ['required', 'image', 'mimes:jpeg,jpg,png', 'max:1000'],
        ]);

        if ($request->hasFile('attached_pic_edit')) {

            $invoice = Invoice::find($id);

            //to remove the old img
            $imagePath = public_path('img/inv_attached/' . $invoice->attached_pic);
            if (File::exists($imagePath)) {
                File::delete($imagePath);
            }

            $file_extension = $request->file('attached_pic_edit')->getClientOriginalExtension();

            $file_name = "INV" . time() . '.' . $file_extension;

            $path = public_path('img/inv_attached/' . $file_name);

            Image::make($request->attached_pic_edit)
                ->resize(450, null, function ($constraint) {
                    $constraint->aspectRatio();
                })
                ->save($path, 50);

            $invoice->attached_pic = $file_name;
            $invoice->save();
        }


        session()->flash('success', 'The note has been paid successfully');
        return redirect()->back();
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function debtor_search($search_query)
    {

        $search_query = request()->search_query;

        $debtor = Debtor::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->orWhereRaw("concat(first_name, ' ', second_name) like '%$search_query%' ")
            ->orWhere('first_name', 'like', "%{$search_query}%")
            ->orWhere('second_name', 'like', "%{$search_query}%")
            ->orWhere('company_name', 'like', "%{$search_query}%")
            ->limit(10)
            ->get();

        return $debtor;
    }

    public function doctor_search($search_query)
    {

        $search_query = request()->search_query;

        $doctor = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->orWhereRaw("concat(first_name, ' ', second_name) like '%$search_query%' ")
            ->orWhere('first_name', 'like', "%{$search_query}%")
            ->orWhere('second_name', 'like', "%{$search_query}%")
            ->orWhere('phone_number', 'like', "%{$search_query}%")
            ->limit(10)
            ->get();

        return $doctor;
    }







    //-------------- Doctor commission --------------


    public function all_doctor_comm($date = null) // month
    {

        if ($date) {
            $month_year_explode = explode('-', $date);
            $year = $month_year_explode[1];
            $month = $month_year_explode[0];
        } else {
            $year = date('Y');
            $month = date('m');
        }

        $branches = Branch::select('id', 'name')->get();

        $comm = Invoice_item::select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'doctor_id', DB::raw('sum(doctor_comm) as sums'))
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereHas('invoice', function ($q) use ($year, $month) {
                $q->select('id', 'created_at')->where('type', 0)
                    ->where('status', '!=', 0)
                    ->whereYear('created_at', $year)
                    ->whereMonth('created_at', $month);
            })
            ->whereNotNull('doctor_id')

            ->groupBy('doctor_id')->get();
        $doctors_services = Invoice_item::select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'doctor_id', DB::raw('count(categorizable_id) as service_count'))
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereHas('invoice', function ($q) use ($year, $month) {
                $q->select('id', 'created_at')->where('type', 0)
                    ->where('status', '!=', 0)
                    ->whereYear('created_at', $year)
                    ->whereMonth('created_at', $month);
            })
            ->whereNotNull('doctor_id')

            ->groupBy('doctor_id','categorizable_id')->get()->groupBy('doctor.name');
            //dd($doctors_services);


        return view('invoice/doctor_comm.index', compact('comm', 'branches','doctors_services'));
    }


    public function all_doctor_comm_day($date = null)
    {

        if ($date) {
            $date = $date;
        } else {
            $date = date('Y-m-d');
        }

        $branches = Branch::select('id', 'name')->get();

        $comm = Invoice_item::select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'doctor_id', DB::raw('sum(doctor_comm) as sums'))
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereHas('invoice', function ($q) use ($date) {
                $q->select('id', 'created_at')->where('type', 0)
                    ->where('status', '!=', 0)
                    ->whereDate('created_at', $date);
            })
            ->whereNotNull('doctor_id')

            ->groupBy('doctor_id')->get();

        $doctors_services = Invoice_item::select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'doctor_id', DB::raw('count(categorizable_id) as service_count'))
        ->with(['categorizable' => function ($q) {
            $q->select('id', 'name');
        }])
        ->with(['doctor' => function ($q) {
            $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
        }])
        ->whereHas('invoice', function ($q) use ($date) {
            $q->select('id', 'created_at')->where('type', 0)
                ->where('status', '!=', 0)
                ->whereDate('created_at', $date);
        })
        ->whereNotNull('doctor_id')

        ->groupBy('doctor_id','categorizable_id')->get()->groupBy('doctor.name');
        return view('invoice/doctor_comm.index_day', compact('comm', 'branches','doctors_services'));
    }

    public function doctor_comm_service($date = null)
    {

        if ($date) {
            $date = $date;
        } else {
            $date = date('Y-m-d');
        }

        $branches = Branch::select('id', 'name')->get();

        $comm = Invoice_item::select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'sold_price', 'doctor_id', 'doctor_comm')
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereHas('invoice', function ($q) use ($date) {
                $q->select('id', 'created_at')->where('type', 0)
                    ->where('status', '!=', 0)
                    ->whereDate('created_at', $date);
            })
            ->whereNotNull('doctor_id')
            ->where('doctor_comm', '!=', 0)
            ->groupBy('invoice_id')
            ->get();
        $doctors_services = Invoice_item::select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'sold_price', 'doctor_id', DB::raw('count(categorizable_id) as service_count'))
        ->with(['categorizable' => function ($q) {
            $q->select('id', 'name');
        }])
        ->with(['doctor' => function ($q) {
            $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
        }])
        ->whereHas('invoice', function ($q) use ($date) {
            $q->select('id', 'created_at')->where('type', 0)
                ->where('status', '!=', 0)
                ->whereDate('created_at', $date);
        })
        ->whereNotNull('doctor_id')

        ->groupBy('doctor_id','categorizable_id')->get()->groupBy('doctor.name');
        return view('invoice/doctor_comm.index_day_service', compact('comm', 'branches','doctors_services'));
    }


    public function doctor_comm_service_month($date = null)
    {

        if ($date) {
            $month_year_explode = explode('-', $date);
            $year = $month_year_explode[1];
            $month = $month_year_explode[0];
        } else {
            $year = date('Y');
            $month = date('m');
        }

        $branches = Branch::select('id', 'name')->get();

        $comm = Invoice_item::select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'sold_price', 'doctor_id', 'doctor_comm')
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereHas('invoice', function ($q) use ($year, $month) {
                $q->select('id', 'created_at')->where('type', 0)
                    ->where('status', '!=', 0)
                    ->whereYear('created_at', $year)
                    ->whereMonth('created_at', $month);
            })
            ->whereNotNull('doctor_id')
            ->where('doctor_comm', '!=', 0)
            ->groupBy('invoice_id')
            ->get();
        $doctors_services = Invoice_item::select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'doctor_id', DB::raw('count(categorizable_id) as service_count'))
        ->with(['categorizable' => function ($q) {
            $q->select('id', 'name');
        }])
        ->with(['doctor' => function ($q) {
            $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
        }])
        ->whereHas('invoice', function ($q) use ($year, $month) {
            $q->select('id', 'created_at')->where('type', 0)
                ->where('status', '!=', 0)
                ->whereYear('created_at', $year)
                ->whereMonth('created_at', $month);
        })
        ->whereNotNull('doctor_id')

        ->groupBy('doctor_id','categorizable_id')->get()->groupBy('doctor.name');
        return view('invoice/doctor_comm.index_month_service', compact('comm', 'branches','doctors_services'));
    }



    public function doctor_profile_comm_service_month($id, $date = null)
    {

        if ($date) {
            $month_year_explode = explode('-', $date);
            $year = $month_year_explode[1];
            $month = $month_year_explode[0];
        } else {
            $year = date('Y');
            $month = date('m');
        }

        $comm = Invoice_item::select('id', 'invoice_id', 'categorizable_id', 'categorizable_type', 'sold_price', 'doctor_id', 'doctor_comm')
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereHas('invoice', function ($q) use ($year, $month) {
                $q->select('id', 'created_at')->where('type', 0)
                    ->where('status', '!=', 0)
                    ->whereYear('created_at', $year)
                    ->whereMonth('created_at', $month);
            })
            ->where('doctor_id', $id)
            ->whereNotNull('doctor_id')
            ->where('doctor_comm', '!=', 0)
            ->groupBy('invoice_id')
            ->get();

        return view('invoice/doctor_comm.index_month_service_profile', compact('comm', 'id'));
    }
}
