<?php

namespace App\Http\Controllers\Branch\Inventory;

use App\Http\Controllers\Controller;
use App\Models\Branch\Branch;
use App\Models\Branch\Inventory\Inventory_cat;
use App\Models\Branch\Inventory\Inventory_item;
use App\Models\Branch\Inventory\Inventory_item_record;
use App\Models\Invoice\Invoice;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class InventoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $branches = Branch::select('id','name')->get();
        return view('inventory.index', compact('branches'));
    }


    //select the searched patients via ajax
    public function inventory_search($search_query){

        $search_query = request()->search_query;

        $inventory = Inventory_item::select('id', 'code', 'name')
        ->Where('code', 'like', "%{$search_query}%")
        ->OrWhere('name', 'like', "%{$search_query}%")
        ->orderBy('id', 'DESC')
        ->limit(5)
        ->get();

        return $inventory;
    }


    //for invoice not pay in index table 
    public function inventory_finished($branch){
        $branch = request()->branch;     

        $inventory = Inventory_item::select('id', 'service_inv_cat_id', 'code', 'branch_id', 'name', 'place', 'current_quantity', 'quantity_notify')
        ->Where('branch_id', $branch)
        ->where('current_quantity', '0')
        ->with(['service_inv_cat' => function ($q) {
            $q->select('id', 'name');}])
        ->with(['branch' => function ($q) {
            $q->select('id', 'name');}])
        ->orderBy('id', 'DESC')
        ->limit(10)
        ->get();

        return $inventory;
    }

    //for invoice that is paid in index table 
    public function inventory_close_finish($branch)
    {
        $branch = request()->branch;     

        $inventory = Inventory_item::select('id', 'service_inv_cat_id', 'code', 'branch_id', 'name', 'place', 'current_quantity', 'quantity_notify')
        ->Where('branch_id', $branch)
        ->whereColumn('current_quantity', '<=', 'quantity_notify')
        ->Where('current_quantity', '!=', '0')
        ->with(['service_inv_cat' => function ($q) {
            $q->select('id', 'name');}])
        ->with(['branch' => function ($q) {
            $q->select('id', 'name');}])
        ->orderBy('id', 'DESC')
        ->limit(10)
        ->get();

        return $inventory;
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //$inventory_cat = Inventory_cat::all();
        $branches = Branch::all();
        return view('inventory.create', compact('branches', 'inventory_cat'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [ 
            'type' => ['required', 'exists:inventory_cats,id'],
            'branch' => ['required', 'exists:branches,id'],
            'name' => ['required', 'max:100'],
            'place' => ['nullable', 'max:40'],
            'quantity_notify' => ['required', 'numeric'],
        ]);

        $inventory = Inventory_item::create([
            'inventory_cat_id' =>  $request->input('type'),
            'code' => "IV" . $this->generateRandomString(6),
            'branch_id' =>  $request->input('branch'),
            'name' => $request->input('name'),
            'place' => $request->input('place'),
            'quantity_notify' => $request->input('quantity_notify'),
        ]); 

        session()->flash('success', 'The Item has been created successfully');
        return redirect()->route('sett.inventory.show', $inventory->id);
    }
    

    public function store_inventory_rec(Request $request, $item_id){
        
        $this->validate($request, [ 
            'type' => ['required', 'numeric'],
            'quantity' => ['required', 'numeric'],
            'price' => ['nullable', 'numeric'],
            'buying_date' => ['required', 'date_format:Y-m-d'],
            'expiration_date' => ['nullable', 'date_format:Y-m-d'],
        ]);

        $inventory_recored = Inventory_item_record::create([ 
            'responsible_id' => $request->input('responsible_workers'),
            'type' => $request->input('type'),
            'item_id' =>  $item_id,
            'quantity' => $request->input('quantity'),
            'price' => $request->input('price'),
            'buying_date' => $request->input('buying_date'),
            'expiration_date' => $request->input('expiration_date'),
        ]); 
        
        //for add quantity to the main item
        if($request->input('type') == 0){
            $inventory_item = Inventory_item::find($item_id);
            $inventory_item->increment('current_quantity', $request->input('quantity'));
            $inventory_item->save();
        //for withdraw
        }elseif ($request->input('type') == 1){
            $inventory_item = Inventory_item::find($item_id);
            $inventory_item->decrement('current_quantity', $request->input('quantity'));
            $inventory_item->save();
        }

        //not active
        if($request->input('type') == 1212){
            $invoice = Invoice::create([ 
                'code' => "IN" . $this->generateRandomString(6),
                'type' => "1",
                'categorizable_id' => $request->input('inevntory_item_id'),
                'categorizable_type' => "App\Models\Branch\Inventory\Inventory_item",
                'serviceable_id' => $inventory_recored->id,
                'serviceable_type' => "App\Models\Branch\Inventory\Inventory_item_record",
                'branch_id' => $request->input('branch'),
                'price' => $request->input('price'),
                'final_price' => $request->input('price'),
                'paid' => $request->input('price'),
                'status' => "1",
                'paid_date' => $request->input('buying_date'),
            ]); 
        }
        
        session()->flash('success', 'The item has been created successfully');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id){
        
        $inventory_item = Inventory_item::with(['service_inv_cat' => function ($q) {
            $q->select('id', 'name');}])
        ->with(['records' => function ($q) {
            $q->select('id', 'responsible_id', 'type','item_id', 'quantity' , 'price','buying_date','expiration_date', 'created_at')
            ->with(['responsible' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
            ->orderBy('buying_date', 'ASC')
            ;}])
        ->with(['branch' => function ($q) {
            $q->select('id', 'name');}])
        ->find($id);

        $workers = User::select('id',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
        ->get();

        return view('inventory.show', compact('inventory_item', 'workers'));
    }

    public function fetch_inven_items_ajax(){
        
        $inventory_item = Inventory_item::select('id', 'name')->get();
        return $inventory_item;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id){
        
        $inventory_item = Inventory_item::find($id);
        $inventory_cat = Inventory_cat::all();
        $branches = Branch::all();
        return view('inventory.edit', compact('inventory_item', 'branches', 'inventory_cat'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [ 
            'type' => ['required', 'exists:inventory_cats,id'],
            'branch' => ['required', 'exists:branches,id'],
            'name' => ['required', 'max:100'],
            'place' => ['nullable', 'max:40'],
            'quantity_notify' => ['required', 'numeric'],
        ]);

        $inventory_item = Inventory_item::find($id);
        $inventory_item->inventory_cat_id = $request->input('type');
        $inventory_item->branch_id = $request->input('branch');
        $inventory_item->name = $request->input('name');
        $inventory_item->quantity_notify = $request->input('quantity_notify');

        $inventory_item->save();

        session()->flash('success', 'The item has been edited successfully');
        return redirect()->route('sett.inventory.show', $id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}