<?php

namespace App\Http\Controllers\Branch\Cats;

use App\Http\Controllers\Controller;
use App\Models\Invoice\cost\Cost_cat;
use App\Models\Patient\Specialty_cat as PatientSpecialty_cat;
use Illuminate\Http\Request;

class Cost_cats extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        $cat = Cost_cat::select('id', 'name')->get();
        return view('cats/costcat.index', compact('cat'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/costcat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:cost_cats,name',
        ]);
        
        $specialty = Cost_cat::create([  
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.cost_cats.index')
            ->with('success', 'Cost Cat has created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $cat = Cost_cat::find($id);
        return view('cats/costcat.edit', compact('cat'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $cat = Cost_cat::find($id);
        $cat->name = $request->input('name');
        $cat->save();

        return redirect()->route('sett.cost_cats.index')
            ->with('success', 'Cost Cat has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}