<?php

namespace App\Http\Controllers\Branch\Cats;

use App\Http\Controllers\Controller;
use App\Models\Branch\Branch;
use App\Models\Branch\Unit;
use Illuminate\Http\Request;
use App\Models\Patient\Service_item;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class Branch_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $branch = Branch::get();
        return view('cats/branchcat.index', compact('branch'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $services = Service_item::all();
        return view('cats/branchcat.create', compact('services'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:branches,name',
            'branch_code' => 'required|max:3|unique:branches,code',
            'address' => 'required',
            'latitude' => 'required',
            'longitude' => 'required',
            'service' => 'nullable',
        ]);
        $branch = Branch::create([
            'name' => $request->input('name'),
            'code' => $request->input('branch_code'),
            'address' => $request->input('address'),
            'phone_number' => $request->input('phone_number'),
            'sec_phone_number' => $request->input('sec_phone_number'),
            'latitude' => $request->input('latitude'),
            'longitude' => $request->input('longitude'),
            'service_id' => $request->input('service'),
        ]);

        $unit = Unit::create([
            'branch_id' => $branch->id,
            'name' => 'Unit 1',
        ]);

        return redirect()->route('sett.branchcat.index')
            ->with('success', 'Branch has created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $branch = Branch::find($id);
        $services = Service_item::all();

        return view('cats/branchcat.edit', compact('branch','services'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'address' => 'required',
            'latitude' => 'required',
            'longitude' => 'required',
            'service' => 'nullable',

        ]);

        $branch = Branch::find($id);
        $branch->name = $request->input('name');
        $branch->address = $request->input('address');
        $branch->phone_number = $request->input('phone_number');
        $branch->sec_phone_number = $request->input('sec_phone_number');
        $branch->latitude = $request->input('latitude');
        $branch->longitude = $request->input('longitude');
        $branch->service_id = $request->input('service');
        $branch->save();

        return redirect()->route('sett.branchcat.index')
            ->with('success', 'Branch has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function fetchUsersBranchesAjax(Request $request)
    {
        $email = $request->input('email');
        $user;
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $user = User::where('email',$email)->firstOrFail();
        } else {
            $user = User::where('phone_number',$email)->firstOrFail();
        }
        $branchesIds = DB::table('users_branches')->select('branch_id')->where('user_id',$user->id)->get()->pluck('branch_id')->toArray();
        $userBranches;
        if (count($branchesIds)) {
            $userBranches = Branch::find($branchesIds);
        }
        else if ($user->branch_id != 0) {
            $userBranches = Branch::find($user->branch_id);
        }else {
            $userBranches = Branch::all();
        }
            
        return $userBranches;
    }
}
