<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use App\Http\Requests\PatientRequest;
use App\Http\Services\onlineAppo\zoomAppo;
use App\Http\Services\smsGateways\Victorylink;
use App\Http\Services\smsGateways\Whysms;
use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Branch\Unit;
use App\Models\Invoice\Coupon;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\location\City;
use App\Models\location\Country;
use App\Models\Patient\From_recourse;
use App\Models\Patient\Patient;
use App\Models\Patient\Pulse;
use App\Models\Patient\Pulse_area_cat;
use App\Models\Patient\Service_item;
use App\Models\Patient\Session_pat;
use App\Models\Patient\Specialty_cat;
use App\Models\User;
use Carbon\Carbon;
use DateInterval;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;
use Illuminate\Validation\Rule;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class AppointmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $specialties = Specialty_cat::all();
        $branches = Branch::select('id', 'name')->get();

        $appointmentG = [];
        $appointmentG = Appointment::select('services_cat_id', 'status', 'start_at')
            ->selectRaw('count(services_cat_id) as counts')
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->groupBy('services_cat_id', 'status')
            ->orderBy('services_cat_id')->get();


        return view('branch/appointment.index', compact('specialties', 'branches','appointmentG'));
    }

    public function withdoctor()
    {
        return view('branch/appointment.withdoctor');
    }

    public function withdoctor_data()
    {
        $appointment = Appointment::select('id', 'patient_id', 'doctor_id', 'start_at', 'end_at')
            ->Where('doctor_id', Auth::id())
            ->whereBetween('start_at', [Carbon::today()->subDay()->startOfDay(), Carbon::today()->endOfDay()])
            ->Where('status', '=', '3')
            ->with(['patient' => function ($q) {
                $q->select('id', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->orderBy('id', 'DESC')
            ->get();

        return $appointment;
    }

    public function withdoctor_service()
    {

        $patients = Appointment::select('id', 'patient_id', 'doctor_id', 'start_at', 'end_at')
            ->whereBetween('start_at', [Carbon::today()->subDay()->startOfDay(), Carbon::today()->endOfDay()])
            ->Where('doctor_id', Auth::id())
            ->Where('status', '=', '3')
            ->with(['patient' => function ($q) {
                $q->select('id', 'code', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
                    ->with('pulses', function ($q) {
                        $q->with(['service_item' => function ($q) {
                            $q->select('id', 'name');
                        }])
                            ->where('status', 0)
                            ->whereBetween('date', [Carbon::today()->subDay()->startOfDay(), Carbon::today()->endOfDay()]);
                    })
                    ->with('sessions', function ($q) {
                        $q->with(['service_item' => function ($q) {
                            $q->select('id', 'name');
                        }])
                            ->where('status', 0)
                            ->whereBetween('date', [Carbon::today()->subDay()->startOfDay(), Carbon::today()->endOfDay()]);
                    });
            }])
            ->orderBy('id', 'DESC')
            ->get();

        $pulses_area = Pulse_area_cat::all();


        return view('branch/appointment.withdoctor_service', compact('patients', 'pulses_area'));
    }

    public function withdoctor_service_save(Request $request)
    {

        $this->validate($request, [
            'pulses_id' => ['required', 'exists:pulses,id'],
            'fluence_update' => ['required'],
            'spot_size_update' => ['required'],
            'used_pulses_update' => ['required'],
        ]);


        foreach ($request->input('pulses_id') as $key => $item) {

            $pulses = Pulse::find($item);

            if ($pulses->type == 3) {
                $patient = Patient::select('id', 'balance')->find($pulses->patient_id);
                $patient->decrement('balance', $request->input('used_pulses_update')[$key]);
                $patient->save();
            }

            $pulses->status = 1;
            $pulses->fluence = $request->input('fluence_update')[$key];
            $pulses->spot_size = $request->input('spot_size_update')[$key];
            $pulses->used_pulses = $request->input('used_pulses_update')[$key];
            $pulses->save();
        }

        session()->flash('success', 'The session has been updated');
        return redirect()->back();
    }

    public function withdoctor_service_save_session(Request $request)
    {

        foreach ($request->input('session_id') as $key => $item) {
            $session = Session_pat::find($item);
            $session->status = $request->input('status')[$key];
            $session->save();
        }

        session()->flash('success', 'The session has been updated');
        return redirect()->back();
    }

    public function withdoctor_update(Request $request, $appointment_id)
    {

        $appointment = Appointment::find($appointment_id);
        $appointment->status = '4';
        $appointment->save();

        if ($appointment) {
            return response()->json([
                'querystatue' => true,
            ]);
        } else {
        }
    }

    public function arrived_patient_qr()
    {
        return view('branch/appointment.arrived_patient_qr');
    }

    public function arrived_patient_qr_update(Request $request, $paient_username)
    {

        $appointment_search = Appointment::select('id', 'patient_id', 'status')
            ->with(['patient' => function ($q) {
                $q->select('id', 'first_name');
            }])
            ->whereHas('patient', function ($query) use ($paient_username) {
                return $query->where('username', $paient_username);
            })
            ->whereDate('start_at', date('Y-m-d'))
            ->orderBy('id', 'DESC')
            ->first();

        if ($appointment_search) {
            $appointment = Appointment::find($appointment_search->id);
            $appointment->status = '2';
            $appointment->save();
        } else {
            $appointment = "";
        }

        if ($appointment) {
            return response()->json([
                'status' => true,
                'name' => $appointment->patient->first_name,
            ]);
        } else {
            return response()->json([
                'status' => false,
            ]);
        }
    }

    //week calender
    public function weekly_calender($yearin, $weekin)
    {

        $dt = new DateTime();

        if (request()->yearin == 'null' && request()->weekin == 'null') {
            $year = $dt->format('o');
            $week = $dt->format('W');
        } else {
            $year = $yearin;
            $week = $weekin;
        }

        return weeklyCalendar($year, $week);
    }

    public function sortable_calendar_update(Request $request, $id)
    {
        $item_orders = $request->input('item_orders');

        $orderlist = explode(',', $item_orders);

        foreach ($orderlist as $k => $order) {
            $appointment = Appointment::find($order);
            $appointment->calendar_index = $k;
            $appointment->save();
        }
    }

    //time slots
    public function weekly_calender_date($year, $month, $day, $specialty, $branch, $unit, $order, $search)
    {

        $year = request()->year;
        $month = request()->month;
        $day = request()->day;
        $branch = request()->branch;
        $unit = request()->unit;
        $order = request()->order;

        $current_day = $year . '-' . $month . '-' . $day;

        $result = '';

        //time slots
        $result .= '<div id="fetch-date-calendar-branch" class="row clickable-item-move" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" data-day_name="' . date('l', strtotime($current_day)) . '" >';

        $appointment = Appointment::select('id', 'patient_id', 'unit_id', 'status', 'services_cat_id', 'start_at')
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->with(['unit' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereDate('start_at', $current_day)
            ->Where('specialty_id', $specialty)
            ->Where('branch_id', $branch);

        if ($unit === 'all') {
            $appointment = $appointment->Where('unit_id', '!=', 0);
        } else {
            $appointment = $appointment->Where('unit_id', $unit);
        }

        if ($order == 'timeline') {
            $appointment = $appointment->orderBy('start_at', 'ASC');
        } elseif ($order == 'status') {
            $appointment = $appointment->orderBy('status', 'ASC');
        } elseif ($order == 'notaccepted') {
            $appointment = $appointment->Where('status', 0);
        } elseif ($order == 'accepted') {
            $appointment = $appointment->Where('status', 1);
        } elseif ($order == 'arrived') {
            $appointment = $appointment->whereIn('status', [2, 3]);
        } elseif ($order == 'first_arrive') {
            $appointment = $appointment->orderBy('calendar_index', 'ASC');
        } else {
            $appointment = $appointment->orderBy('calendar_index', 'ASC');
        }

        if ($search !== "null") {
            $appointment = $appointment->whereHas('patient', function ($q) use ($search) {
                $q->WhereRaw("concat(first_name, ' ', second_name) like '%$search%' ")
                    ->orWhere('first_name', 'like', "%{$search}%")
                    ->orWhere('second_name', 'like', "%{$search}%");
            });
        }

        $appointment = $appointment->get();

        //appointments
        if (count($appointment) > 0) {

            foreach ($appointment as $item) {

                $result .= '<div class="col-12 col-md-3 position-relative item_calendar_fetch mb-2"  data-id="' . $item->id . '">';
                //slots
                $result .= '<p class="text-xs text-gray-300 mb-0 fw-bold">' . date('h:i A', strtotime($item->start_at)) . '</p>';

                //appointment slots

                if ($item->status == 0) {
                    $statuscolor = 'timeslots_appointment_not_accepted';
                    $status_msg = __('patientappo.not accepted');
                } elseif ($item->status == 1) {
                    $statuscolor = 'timeslots_appointment_accepted';
                    $status_msg = __('patientappo.accepted');
                } elseif ($item->status == 2) {
                    $statuscolor = 'timeslots_appointment_arrived';
                    $status_msg = __('patientappo.arrived');
                } elseif ($item->status == 3) {
                    $statuscolor = 'timeslots_appointment_with_doctor';
                    $status_msg = __('patientappo.with doctor');
                } elseif ($item->status == 4) {
                    $statuscolor = 'timeslots_appointment_done';
                    $status_msg =  __('patientappo.done');
                } elseif ($item->status == 5) {
                    $statuscolor = 'timeslots_appointment-not-respond';
                    $status_msg = __('patientappo.not respond');
                } elseif ($item->status == 6) {
                    $statuscolor = 'timeslots_appointment_canceled';
                    $status_msg = __('patientappo.canceled');
                }

                $result .= '<div id="weekly_calendar_fetch_pat" class=" ' . $statuscolor . ' text-center my-2 align-items-center b-r-s-cont w-100 clickable-item-pointer justify-content-between" data-id="' . $item->id . '" data-status="' . $item->status . '" data-name="' . $item->patient->name .
                    '" data-avatar="' . $item->patient->avatar . '" data-phone_number="' . $item->patient->phone_number . '" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" >';

                $result .= '<img class="rounded-circle avatar-small me-2 calendar_slot_img" src="' . URL::asset('img/useravatar/' . $item->patient->avatar) . '">';

                $result .= '<div class="align-items-center">';

                $result .= '<div class="text-start d-flex justify-content-between mb-1">';
                $result .= '<h6 class="text-xxs mb-0 fw-normal">' . $item->service_item->name . '</h6>';
                $result .= '<h6 class="text-xxs mb-0 fw-normal">' . $item->unit->name . '</h6>';
                $result .= '</div>';

                $result .= '<h6 class="text-s mb-0 fw-normal fw-bold">' . $item->patient->name . '</h6>';
                $result .= '</div>';

                $result .= '<h6 class="text-xs text-center mb-0 fw-normal">' . $status_msg . '</h6>';

                $result .= '</div>';

                $result .= '</div>';
            }
        } else {
            $result .= '<div class="row">';
            $result .= '<div class="timeslots_appointment_show justify-content-center px-4 py-2 d-flex mb-3 align-items-center b-r-s-cont pt-0 pt-md-0">';
            $result .= '<a href="' . route('sett.appointment.create') . '" class="text-s mb-0 fw-normal text-gray-700">
                <div class="text-center">
                    <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-1"></i>
                    <p class="fw-light mb-0 fs-5 text-gray-400">' . __("basic.no bookings")  . '</p>
                </div>
            </a>';
            $result .= '</div>';
            $result .= '</div>';
        }

        $result .= '</div>';
        $appointment2 = Appointment::select('services_cat_id', 'status', 'start_at')
            ->selectRaw('count(services_cat_id) as counts')
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->whereDate('start_at', $current_day)
            ->Where('specialty_id', $specialty)
            ->Where('branch_id', $branch)
            ->groupBy('services_cat_id', 'status')
            ->orderBy('services_cat_id')->get()->toArray();
        $data = [
           'result' => $result,
           'appointmentG' => $appointment2
        ];
        return $data;
    }

    //time slots
    public function weekly_calender_date_timeline2($year, $month, $day, $specialty, $branch, $unit, $order)
    {

        $year = request()->year;
        $month = request()->month;
        $day = request()->day;
        $branch = request()->branch;
        $unit = request()->unit;
        $order = request()->order;

        $current_day = $year . '-' . $month . '-' . $day;

        $result = '';

        //time slots
        $result .= '<div id="fetch-date-calendar-branch" class="clickable-item-move" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" data-day_name="' . date('l', strtotime($current_day)) . '" >';

        $appointment = Appointment::select('id', 'patient_id', 'unit_id', 'status', 'services_cat_id', 'start_at')
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->with(['unit' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereDate('start_at', $current_day)
            ->Where('specialty_id', $specialty)
            ->Where('branch_id', $branch);

        if ($unit === 'all') {
            $appointment = $appointment->Where('unit_id', '!=', 0);
        } else {
            $appointment = $appointment->Where('unit_id', $unit);
        }

        if ($order == 'timeline') {
            $appointment = $appointment->orderBy('start_at', 'ASC');
        } elseif ($order == 'status') {
            $appointment = $appointment->orderBy('status', 'ASC');
        } elseif ($order == 'notaccepted') {
            $appointment = $appointment->Where('status', 0);
        } elseif ($order == 'accepted') {
            $appointment = $appointment->Where('status', 1);
        } elseif ($order == 'arrived') {
            $appointment = $appointment->whereIn('status', [2, 3]);
        } elseif ($order == 'first_arrive') {
            $appointment = $appointment->orderBy('calendar_index', 'ASC');
        } else {
            $appointment = $appointment->orderBy('calendar_index', 'ASC');
        }

        $appointment = $appointment->get();

        //appointments
        if (count($appointment) > 0) {

            foreach ($appointment as $item) {

                $result .= '<div class="row item_calendar_fetch"  data-id="' . $item->id . '">';

                //slots
                $result .= '<div class="col-12 col-lg-2 align-self-center">';
                $result .= '<p class="text-xs text-gray-300 mb-0">' . date('h:i A', strtotime($item->start_at)) . '</p>';
                $result .= '</div>';

                //appointment slots
                $result .= '<div class="col">';

                if ($item->status == 0) {
                    $statuscolor = 'timeslots_appointment_not_accepted';
                    $status_msg = __('patientappo.not accepted');
                } elseif ($item->status == 1) {
                    $statuscolor = 'timeslots_appointment_accepted';
                    $status_msg = __('patientappo.accepted');
                } elseif ($item->status == 2) {
                    $statuscolor = 'timeslots_appointment_arrived';
                    $status_msg = __('patientappo.arrived');
                } elseif ($item->status == 3) {
                    $statuscolor = 'timeslots_appointment_with_doctor';
                    $status_msg = __('patientappo.with doctor');
                } elseif ($item->status == 4) {
                    $statuscolor = 'timeslots_appointment_done';
                    $status_msg =  __('patientappo.done');
                } elseif ($item->status == 5) {
                    $statuscolor = 'timeslots_appointment-not-respond';
                    $status_msg = __('patientappo.not respond');
                } elseif ($item->status == 6) {
                    $statuscolor = 'timeslots_appointment_canceled';
                    $status_msg = __('patientappo.canceled');
                }


                $result .= '<div class="div d-flex">';

                $result .= '<div id="weekly_calendar_fetch_pat" class=" ' . $statuscolor . ' d-flex text-center my-2 align-items-center b-r-s-cont w-100 clickable-item-pointer justify-content-between" data-id="' . $item->id . '" data-status="' . $item->status . '" data-name="' . $item->patient->name .
                    '" data-avatar="' . $item->patient->avatar . '" data-phone_number="' . $item->patient->phone_number . '" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" >';

                $result .= '<div class="d-flex align-items-center ">';
                $result .= '<img class="rounded-circle avatar-small me-2" src="' . URL::asset('img/useravatar/' . $item->patient->avatar) . '">';
                $result .= '<div class="text-start">';
                $result .= '<h6 class="text-xxs mb-0 fw-normal">' . $item->service_item->name . '</h6>';
                $result .= '<h6 class="text-s mb-0 fw-normal ">' . $item->patient->name . '</h6>';
                $result .= '<h6 class="text-xxs mb-0 fw-normal">' . $item->unit->name . '</h6>';
                $result .= '</div></div>';

                $result .= '<h6 class="text-xs text-end mb-0 fw-normal ">' . $status_msg . '</h6>';
                $result .= '</div>';

                $result .= '</div>';
                $result .= '</div>';

                $result .= '</div>';
            }
        } else {
            $result .= '<div class="row">';
            $result .= '<div class="timeslots_appointment_show justify-content-center px-4 py-2 d-flex mb-3 align-items-center b-r-s-cont pt-0 pt-md-0">';
            $result .= '<a href="' . route('sett.appointment.create') . '" class="text-s mb-0 fw-normal text-gray-700">
                <div class="text-center">
                    <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-1"></i>
                    <p class="fw-light mb-0 fs-5 text-gray-400">' . __("basic.no bookings")  . '</p>
                </div>
            </a>';
            $result .= '</div>';
            $result .= '</div>';
        }

        $result .= '</div>';


        return $result;
    }

    //time slots
    public function weekly_calender_date2($year, $month, $day, $branch)
    {

        $year = request()->year;
        $month = request()->month;
        $day = request()->day;
        $branch = request()->branch;

        $current_day = $day . '-' . $month . '-' . $year;

        $duration = prox_sett('timeslotduration');
        $cleanup = prox_sett('timeslotcleanup');
        $start = prox_sett('timeslotstart');
        $end = prox_sett('timeslotend');

        $count_loop = timeslots($duration, $cleanup, $start, $end);


        $start = new DateTime($start);
        $end = new DateTime($end);
        $durationInterval = new DateInterval("PT" . $duration . "M");
        $cleanupInterval = new DateInterval("PT" . $cleanup . "M");
        $result = '';

        //time slots
        $result .= '<div id="fetch-date-calendar-branch" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" data-day_name="' . date('l', strtotime($current_day)) . '" >';

        for ($intStart = $start; $intStart < $end; $intStart->add($durationInterval)->add($cleanupInterval)) {

            $endPeriod = clone $intStart;
            $endPeriod->add($durationInterval);

            if ($endPeriod > $end) {
                break;
            }

            $time = $year . "-" .  $month . "-" . $day . " " . $intStart->format("H:i:s");

            $appointment = Appointment::select('id', 'patient_id', 'status')
                ->with(['patient' => function ($q) {
                    $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                }])
                ->where('start_at', $time)
                ->Where('branch_id', $branch)
                ->first();

            $result .= '<div class="row">';

            //slots
            $result .= '<div class="col-4 col-lg-3 align-self-center">';
            $result .= '<p class="text-xs text-gray-300">' . $intStart->format("h:i A") . '</p>';
            $result .= '</div>';

            //appointments
            if (!empty($appointment)) {

                if ($appointment->status == 0) {
                    $statuscolor = 'timeslots_appointment_not_accepted';
                    $status_msg = __('patientappo.not accepted');
                } elseif ($appointment->status == 1) {
                    $statuscolor = 'timeslots_appointment_accepted';
                    $status_msg = __('patientappo.accepted');
                } elseif ($appointment->status == 2) {
                    $statuscolor = 'timeslots_appointment_arrived';
                    $status_msg = __('patientappo.arrived');
                } elseif ($appointment->status == 3) {
                    $statuscolor = 'timeslots_appointment_with_doctor';
                    $status_msg = __('patientappo.with doctor');
                } elseif ($appointment->status == 4) {
                    $statuscolor = 'timeslots_appointment_done';
                    $status_msg =  __('patientappo.done');
                } elseif ($appointment->status == 5) {
                    $statuscolor = 'timeslots_appointment-not-respond';
                    $status_msg = __('patientappo.not respond');
                } elseif ($appointment->status == 6) {
                    $statuscolor = 'timeslots_appointment_canceled';
                    $status_msg = __('patientappo.canceled');
                }


                $result .= '<div class="col">';
                $result .= '<div id="weekly_calendar_fetch_pat" class="' . $statuscolor . ' d-flex text-center mb-3 align-items-center b-r-s-cont clickable-item-pointer justify-content-between" data-id="' . $appointment->id . '" data-status="' . $appointment->status . '" data-name="' . $appointment->patient->name .
                    '" data-avatar="' . $appointment->patient->avatar . '" data-phone_number="' . $appointment->patient->phone_number . '" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" data-start="' . $intStart->format("h:i A") . '" data-end="' . $endPeriod->format("h:i A") . '">';

                $result .= '<div class="d-flex align-items-center ">';
                $result .= '<img class="rounded-circle avatar-small me-2" src="' . URL::asset('img/useravatar/' . $appointment->patient->avatar) . '">';
                $result .= '<div class="">';
                $result .= '<h6 class="text-s mb-0 fw-normal ">' . $appointment->patient->name . '</h6>';
                $result .= '</div></div>';

                $result .= '<h6 class="text-xs text-end mb-0 fw-normal ">' . $status_msg . '</h6>';

                $result .= '</div>';
                $result .= '</div>';
            } else {
                $result .= '<div class="col">';
                $result .= '<div class="timeslots_appointment_show px-4 py-2 d-flex mb-3 align-items-center b-r-s-cont" style="background-color: #e5f4ff;">';
                $result .= '<a href="' . route('sett.appointment.create') . '" class="text-s mb-0 fw-normal text-gray-700"><i class="fas fa-clock me-2"></i>Available</a>';
                $result .= '</div>';
                $result .= '</div>';
            }

            $result .= '</div>';
        }
        $result .= '</div>';

        return $result;
    }

    //time slots
    public function weekly_calender_date3($year, $month, $day, $branch)
    {

        $year = request()->year;
        $month = request()->month;
        $day = request()->day;
        $branch = request()->branch;

        $current_day = $day . '-' . $month . '-' . $year;

        $duration = '60';
        $cleanup = '0';
        $start = '00:00';
        $end = '24:00';

        $count_loop = timeslots($duration, $cleanup, $start, $end);

        $start = new DateTime($start);
        $end = new DateTime($end);
        $durationInterval = new DateInterval("PT" . $duration . "M");
        $cleanupInterval = new DateInterval("PT" . $cleanup . "M");
        $result = '';

        //time slots
        $result .= '<div id="fetch-date-calendar-branch" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" data-day_name="' . date('l', strtotime($current_day)) . '" >';

        for ($intStart = $start; $intStart < $end; $intStart->add($durationInterval)->add($cleanupInterval)) {

            $endPeriod = clone $intStart;
            $endPeriod->add($durationInterval);

            if ($endPeriod > $end) {
                break;
            }

            $time = $year . "-" .  $month . "-" . $day . " " . $intStart->format("H:i:s");

            $appointment = Appointment::select('id', 'patient_id', 'status', 'start_at')
                ->with(['patient' => function ($q) {
                    $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                }])
                ->whereBetween('start_at', [
                    $time,
                    Carbon::parse($time)->addMinutes(59)
                ])
                ->Where('branch_id', $branch)
                ->get();

            $result .= '<div class="row">';

            //slots
            $result .= '<div class="col-12 col-lg-2 align-self-start">';
            $result .= '<p class="text-xs text-gray-300 fw-bold">' . $intStart->format("h:i A") . '</p>';
            $result .= '</div>';


            //appointments
            if (count($appointment) > 0) {

                $result .= '<div class="col">';

                foreach ($appointment as $item) {

                    if ($item->status == 0) {
                        $statuscolor = 'timeslots_appointment_not_accepted';
                        $status_msg = __('patientappo.not accepted');
                    } elseif ($item->status == 1) {
                        $statuscolor = 'timeslots_appointment_accepted';
                        $status_msg = __('patientappo.accepted');
                    } elseif ($item->status == 2) {
                        $statuscolor = 'timeslots_appointment_arrived';
                        $status_msg = __('patientappo.arrived');
                    } elseif ($item->status == 3) {
                        $statuscolor = 'timeslots_appointment_with_doctor';
                        $status_msg = __('patientappo.with doctor');
                    } elseif ($item->status == 4) {
                        $statuscolor = 'timeslots_appointment_done';
                        $status_msg =  __('patientappo.done');
                    } elseif ($item->status == 5) {
                        $statuscolor = 'timeslots_appointment-not-respond';
                        $status_msg = __('patientappo.not respond');
                    } elseif ($item->status == 6) {
                        $statuscolor = 'timeslots_appointment_canceled';
                        $status_msg = __('patientappo.canceled');
                    }

                    $result .= '<div class="div d-flex"><p class="text-xs text-gray-200 me-2 align-self-center">' . date('h:i', strtotime($item->start_at)) . ':</p>';

                    $result .= '<div id="weekly_calendar_fetch_pat" class=" ' . $statuscolor . ' d-flex text-center mb-3 align-items-center b-r-s-cont w-100 clickable-item-pointer justify-content-between" data-id="' . $item->id . '" data-status="' . $item->status . '" data-name="' . $item->patient->name .
                        '" data-avatar="' . $item->patient->avatar . '" data-phone_number="' . $item->patient->phone_number . '" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" data-start="' . $intStart->format("h:i A") . '" data-end="' . $endPeriod->format("h:i A") . '" >';

                    $result .= '<div class="d-flex align-items-center ">';
                    $result .= '<img class="rounded-circle avatar-small me-2" src="' . URL::asset('img/useravatar/' . $item->patient->avatar) . '">';
                    $result .= '<div class="">';
                    $result .= '<h6 class="text-s mb-0 fw-normal ">' . $item->patient->name . '</h6>';
                    $result .= '</div></div>';

                    $result .= '<h6 class="text-xs text-end mb-0 fw-normal ">' . $status_msg . '</h6>';
                    $result .= '</div>';

                    $result .= '</div>';
                }
                $result .= '</div>';
            } else {
                $result .= '<div class="col">';
                $result .= '<div class="timeslots_appointment_show px-4 py-2 d-flex mb-3 align-items-center b-r-s-cont" style="background-color: #e5f4ff;">';
                $result .= '<a href="' . route('sett.appointment.create') . '" class="text-s mb-0 fw-normal text-gray-700"><i class="fas fa-clock me-2"></i>' .  __('patientappo.available') . '</a>';
                $result .= '</div>';
                $result .= '</div>';
            }

            $result .= '</div><hr>';
        }
        $result .= '</div>';

        return $result;
    }

    public function weekly_calender_date_total_services($year, $month, $day, $specialty, $branch)
    {

        $current_day = $year . '-' . $month . '-' . $day;

        $serviceTotal = Appointment::select('services_cat_id', DB::raw('count(services_cat_id) as total'))
            ->groupBy('services_cat_id')
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->whereDate('start_at', $current_day)
            ->Where('specialty_id', $specialty)
            ->Where('branch_id', $branch)
            ->orderBy('total', 'DESC')
            ->get();

        $statusTotal = Appointment::select('status', DB::raw('count(status) as total'))
            ->groupBy('status')
            ->whereDate('start_at', $current_day)
            ->Where('specialty_id', $specialty)
            ->Where('branch_id', $branch)
            ->orderBy('total', 'DESC')
            ->get()->toArray();

        $statusTotal1 =  array_map(function($status){

            if($status['status'] == 0){
                $status['status'] = 'not accepted';
                return $status;
            }
            elseif ($status['status'] == 1) {
                $status['status'] = 'accepted ';
                return $status;
            }
            elseif ($status['status'] == 2) {
                $status['status'] = 'arrived ';
                return $status;
            }
            elseif ($status['status'] == 3) {
                $status['status'] = 'with doctor';
                return $status;
            }
            elseif ($status['status'] == 4) {
                $status['status'] = 'done ';
                return $status;
            }
            elseif ($status['status'] == 5) {
                $status['status'] = 'not responding';
                return $status;
            }
            elseif ($status['status'] == 6) {
                $status['status'] = ' canceled';
                return $status;
            }

        },$statusTotal);

        $total = [
            'serviceTotal' => $serviceTotal,
            'statusTotal' => $statusTotal1
        ];
        //dd($total);
        //dd($total);
        return $total;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        if (Auth::user()->branch_id !== 0) {
            $branches = $branches = Branch::where('id', Auth::user()->branch_id)->get();
        } else {
            $branches = Branch::all();
        }

        $countries = Country::orderBy('fav', 'DESC')->get();
        $from_recourses = From_recourse::all();
        $specialties = Specialty_cat::all();

        return view('branch/appointment.create', compact('branches', 'countries', 'from_recourses', 'specialties'));
    }

    //for select input ajax to send the cities beasd on the given country
    public function createcityajax($id)
    {

        return City::where('country_id', $id)->orderBy('fav', 'DESC')->get();
    }

    //fetch servcies besed on speicilty
    public function fetch_servicecat_ajax($specialty_id, $branch_id)
    {
        $service = Service_item::where('service_inv_cat_id', 1)
            ->where('deactivate', 0)
            ->whereHas('specialties' , function ($q) use($specialty_id)
            {
                $q->where('specialty_id', $specialty_id);
            })->orWhere('specialty_id', $specialty_id);


        $service = $service->whereIn('branch_id', [$branch_id, '0']);

        $service = $service->get();

        return $service;
    }

    //fetch servcies besed on speicilty
    public function fetch_unit_ajax($branch_id)
    {
        $unit = Unit::where('branch_id', $branch_id);

        $unit = $unit->get();

        return $unit;
    }

    //select the calander data and funcation via ajax in creating
    public function calander_appointment_ajax($month, $year, $specialty_id, $branch_id, $unit_id)
    {

        if (isset(request()->month) && isset(request()->year)) {
            $month = request()->month;
            $year = request()->year;
        } else {
            $dateComponents = getdate();
            $month = $dateComponents['mon'];
            $year = $dateComponents['year'];
        }

        $duration = prox_sett('timeslotduration');
        $cleanup = prox_sett('timeslotcleanup');
        $start = prox_sett('timeslotstart');
        $end = prox_sett('timeslotend');

        if (prox_sett('timeslotweekends') !== "null") {
            $weekends = unserialize(prox_sett('timeslotweekends'));
        } else {
            $weekends = array();
        }

        if ($unit_id !== 'null') {
            return build_calendar($month, $year, $specialty_id, $branch_id, $unit_id, $duration, $cleanup, $start, $end, $weekends);
        } else {
            return "<p class='text-white mb-0'>Sorry, there is no unit related to this branch</p>";
        }
    }

    //select the calander data and funcation via ajax in creating
    public function calander_show_slots_ajax($datetoday, $specialty_id, $branch_id, $unit_id)
    {

        $duration = prox_sett('timeslotduration');
        $cleanup = prox_sett('timeslotcleanup');
        $start = prox_sett('timeslotstart');
        $end = prox_sett('timeslotend');

        return showSlots($duration, $cleanup, $start, $end, $datetoday, $specialty_id, $branch_id, $unit_id);
    }

    //select the searched patients via ajax
    public function calander_patient_search($search_query)
    {
        $search_query = request()->search_query;

        $patient = Patient::select('id', 'avatar', 'recommendation', 'first_name', 'second_name', 'mother_name',  'phone_number', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->where(function ($query) use ($search_query) {
                $query->orWhereRaw("concat(first_name, ' ', second_name) like '%$search_query%' ")
                    ->orWhere('first_name', 'like', "%{$search_query}%")
                    ->orWhere('second_name', 'like', "%{$search_query}%")
                    ->orWhere('mother_name', 'like', "%{$search_query}%")
                    ->orWhere('new_id', 'like', "%{$search_query}%")
                    ->orWhere('code', 'like', "%{$search_query}%")
                    ->orWhere('phone_number', 'like', "%{$search_query}%");
            })
            ->limit(10);

        if (Auth::user()->branch_id !== 0) {
            $patient = $patient->where('first_branch_id', Auth::user()->branch_id);
        }

        $patient = $patient->get();

        return $patient;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PatientRequest $request)
    {
        // the validation is in (app/requests/PatientRequest)

        $patient_id = $request->input('search_patient_id');

        $calander_date_day = $request->input('calander_date_day');

        $calander_date_start = date("H:i", strtotime($request->input('calander_date_start')));

        //for only selecting start slot without end slot
        if ($request->input('calander_date_end')) {
            $calander_date_end = date("H:i", strtotime($request->input('calander_date_end')));
        } else {
            $duration = prox_sett('timeslotduration');
            $cleanup = prox_sett('timeslotcleanup');
            $calander_date_start_end =  $duration + $cleanup;
            $calander_date_end = Carbon::parse($calander_date_start)->addMinutes($calander_date_start_end);
            $calander_date_end = Carbon::parse($calander_date_start)->addMinutes($calander_date_start_end)->format("H:i");
        }

        $start_at = $calander_date_day . ' ' . $calander_date_start;
        $end_at = $calander_date_day . ' ' . $calander_date_end;

        $service_id = $request->input('service_id');
        $branch_id = $request->input('branch_id');
        $coupon_id = $request->input('coupon_id');

        $service_price = Service_item::select('id', 'name', 'service_inv_cat_id', 'price')
            ->where('deactivate', 0)
            ->where('id', $service_id)->first();

        //for online appointment
        if ($request->input('online_appointment')) {
            $online_appo = app(zoomAppo::class)->createZoom($service_price->name, $start_at);
            $online_start_url = $online_appo->start_url;
            $online_join_url = $online_appo->join_url;
        } else {
            $online_start_url = "";
            $online_join_url = "";
        }

        //for coupon
        if (!empty($coupon_id)) {
            $coupon = Coupon::find($coupon_id);
            $discount_amount = $coupon->discount($service_price->price);
            $final_price = $service_price->price - $discount_amount;
        } else {
            $discount_amount = null;
            $final_price = $service_price->price;
        }

        /*
        //make invoice paid if it is free service
        if($final_price == 0){
            $status_invoice = 2;
            $paid_date_inv = date("Y-m-d H:i:s");
        }else{
            $status_invoice = 0;
            $paid_date_inv = null;
        } */

        //if the patient exist
        if (!empty($patient_id)) {

            $appointment = Appointment::create([
                'code' => "AP" . $this->generateRandomString(6),
                'specialty_id' => $request->input('specialty_id'),
                'branch_id' => $branch_id,
                'unit_id' => $request->input('unit_id'),
                'patient_id' => $patient_id,
                'services_cat_id' => $service_id,
                'start_at' => $start_at,
                'end_at' => $end_at,
                'note' => $request->input('appointment_note'),
                'creator_id' => Auth::id(),
                'meet_start_url' => $online_start_url,
                'meet_join_url' => $online_join_url,
            ]);

            $patient = Patient::select('id', 'type', 'first_name', 'phone_number')->find($patient_id);
            $patient->type = 1;
            $patient->save();

            if ($final_price > 0) {

                $invoice = Invoice::create([
                    'code' => "IN" . $this->generateRandomString(6),
                    'service_inv_cat_id' => $service_price->service_inv_cat_id,
                    'specialty_id' => $request->input('specialty_id'),
                    'receivable_id' => $patient_id,
                    'receivable_type' => "App\Models\Patient\Patient",
                    'branch_id' => $branch_id,
                    'items_price' => $service_price->price,
                    'final_price' => $final_price,
                    'coupon_id' => $coupon_id,
                    'discount' => $discount_amount,
                ]);

                $invoice_item = Invoice_item::create([
                    'invoice_id' => $invoice->id,
                    'itemable_id' => $appointment->id,
                    'itemable_type' => "App\Models\Branch\Appointment",
                    'categorizable_id' => $service_id,
                    'categorizable_type' => "App\Models\Patient\Service_item",
                    'price' => $service_price->price,
                    'sold_price' => $final_price,
                ]);
            }
        }
        //if create a new user
        else {
            //insert img
            if ($request->hasFile('avatar')) {
                $file_extension = request()->avatar->getClientOriginalExtension();
                $file_name = $request->input('first_name') . time() . '.' . $file_extension;
                $path = 'img/useravatar';
                $request->avatar->move($path, $file_name);
            } else {
                $file_name = 'default-pp.png';
            }

            $patient_branch_id = $request->input('first_branch_id');
            $new_serial_number = serial_number('patient');
            $new_serial_number_branch = serial_number('patient', $patient_branch_id);
            $code_branch = Branch::select('id', 'code')->find($patient_branch_id);

            $patient = Patient::create([
                'type' => 1,
                'new_id' => $new_serial_number,
                'new_branch_id' => $new_serial_number_branch,
                'code' => $code_branch->code . "-" . $this->generateRandomString(6),
                'email' => $request->input('email'),
                'password' => bcrypt($request->input('password')),
                'first_branch_id' => $patient_branch_id,
                'first_name' => $request->input('first_name'),
                'second_name' => $request->input('second_name'),
                'mother_name' => $request->input('mother_name'),
                'avatar' => $file_name,
                'birthday' => $request->input('birthday'),
                'gendar' => $request->input('gendar'),
                'country_id' => $request->input('country_id'),
                'city_id' => $request->input('city_id'),
                'phone_number' => $request->input('phone_number'),
                'sec_phone_number' => $request->input('sec_phone_number'),
                'insurance' => $request->input('insurance'),
                'from_recourse_id' => $request->input('from_recourse_id'),
                'creator_id' => Auth::id(),
            ]);

            $appointment = Appointment::create([
                'code' => "AP" . $this->generateRandomString(6),
                'specialty_id' => $request->input('specialty_id'),
                'branch_id' => $branch_id,
                'unit_id' => $request->input('unit_id'),
                'patient_id' => $patient->id,
                'services_cat_id' => $service_id,
                'start_at' => $start_at,
                'end_at' => $end_at,
                'note' => $request->input('appointment_note'),
                'creator_id' => Auth::id(),
                'meet_start_url' => $online_start_url,
                'meet_join_url' => $online_join_url,
            ]);

            if ($final_price > 0) {
                $invoice = Invoice::create([
                    'code' => "IN" . $this->generateRandomString(6),
                    'service_inv_cat_id' => $service_price->service_inv_cat_id,
                    'specialty_id' => $request->input('specialty_id'),
                    'branch_id' => $branch_id,
                    'receivable_id' => $patient->id,
                    'receivable_type' => "App\Models\Patient\Patient",
                    'items_price' => $service_price->price,
                    'final_price' => $final_price,
                    'coupon_id' => $coupon_id,
                    'discount' => $discount_amount,
                ]);

                $invoice_item = Invoice_item::create([
                    'invoice_id' => $invoice->id,
                    'itemable_id' => $appointment->id,
                    'itemable_type' => "App\Models\Branch\Appointment",
                    'categorizable_id' => $service_id,
                    'categorizable_type' => "App\Models\Patient\Service_item",
                    'price' => $service_price->price,
                    'sold_price' => $final_price,
                ]);
            }
        }

        //-------- to send the sms message ---------
        $branch_sms = Branch::select('address')->find($branch_id);
        $branch_sms_address = $branch_sms->address;
        $clinicname = prox_sett('clinicname');

        Carbon::setLocale('ar');
        $appo_date_sms = Carbon::parse($appointment->start_at)->translatedFormat('l j F');

        $sms_mesg_cont = "شكرا لاختيارك د/سمير غرابة تم الحجز باسم $patient->first_name يوم $appo_date_sms";

        // app(Whysms::class)->sendSms($patient->phone_number, $sms_mesg_cont);
        // app(Victorylink::class)->sendSms($patient->phone_number, $sms_mesg_cont, 'ar');

        // -----------------

        session()->flash('success', 'The appointment has been created successfully');
        return redirect()->route('sett.appointment.show', $appointment->id);
    }


    public function follow_up_app_index(Request $request)
    {

        $this->validate($request, [
            'fw_appointment_id' => ['required', 'exists:appointments,id'],
            'followup_app_day' => ['required', 'numeric'],
        ]);

        $id = $request->input('fw_appointment_id');
        $days = $request->input('followup_app_day');

        $appointment = Appointment::find($id);

        $query = Appointment::create([
            'code' => "AP" . $this->generateRandomString(6),
            'specialty_id' => $appointment->specialty_id,
            'branch_id' => $appointment->branch_id,
            'unit_id' => $appointment->unit_id,
            'patient_id' => $appointment->patient_id,
            'doctor_id' => $appointment->doctor_id,
            'services_cat_id' => $appointment->services_cat_id,
            'start_at' => Carbon::parse($appointment->start_at)->addDays($days),
            'end_at' => Carbon::parse($appointment->end_at)->addDays($days),
            'creator_id' => Auth::id(),
            'note' => $request->input('appintment_note'),
        ]);


        $service_price = Service_item::select('id', 'name', 'service_inv_cat_id', 'price')->where('deactivate', 0)->where('id', $appointment->services_cat_id)->first();

        if ($service_price->price > 0) {

            $invoice = Invoice::create([
                'code' => "IN" . $this->generateRandomString(6),
                'service_inv_cat_id' => $service_price->service_inv_cat_id,
                'specialty_id' => $appointment->specialty_id,
                'receivable_id' => $appointment->patient_id,
                'receivable_type' => "App\Models\Patient\Patient",
                'branch_id' => $appointment->branch_id,
                'items_price' => $service_price->price,
                'final_price' => $service_price->price,
            ]);

            $invoice_item = Invoice_item::create([
                'invoice_id' => $invoice->id,
                'itemable_id' => $query->id,
                'itemable_type' => "App\Models\Branch\Appointment",
                'categorizable_id' => $service_price->id,
                'categorizable_type' => "App\Models\Patient\Service_item",
                'price' => $service_price->price,
                'sold_price' => $service_price->price,
            ]);
        }


        //-------- to send the sms message ---------
        //$branch_sms = Branch::select('address')->find($branch_id);
        //$branch_sms_address = $branch_sms->address;
        $clinicname = prox_sett('clinicname');

        Carbon::setLocale('ar');
        $appo_date_sms = Carbon::parse($appointment->start_at)->translatedFormat('l j F');

        //$sms_mesg_cont = "اهلا $patient->first_name في عيادات $clinicname تم تاكيد حجزك";

        //app(Victorylink::class)->sendSms($patient->phone_number, $sms_mesg_cont, 'ar');

        // -----------------

        session()->flash('success', 'The appointment has been created successfully');
        return redirect()->route('sett.appointment.show', $query->id);
    }

    public function past_appointment(Request $request)
    {

        $this->validate($request, [
            'branch_appo' => ['required', 'exists:branches,id'],
            'responsible_doc_app' => ['required', 'exists:users,id'],
            'patient_id' => ['required', 'exists:patients,id'],

        ]);

        $service_item_id = Service_item::select('id')->where('service_inv_cat_id', '1')->where('deactivate', 0)->first();

        $appointment = Appointment::create([
            'code' => "AP" . $this->generateRandomString(6),
            'specialty_id' => Auth::user()->specialty_id,
            'branch_id' => $request->input('branch_appo'),
            'patient_id' => $request->input('patient_id'),
            'doctor_id' => $request->input('responsible_doc_app'),
            'services_cat_id' => $service_item_id->id,
            'start_at' => $request->input('appo_date'),
            'end_at' => Carbon::parse($request->input('appo_date'))->addMinutes(15),
            'creator_id' => Auth::id(),
            'status' => 4,
        ]);

        session()->flash('success', 'The appointment has been added successfully');
        return redirect()->back();
    }


    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }


    //get the appointment info from the timeslot
    public function appointment_info_ajax($id)
    {

        $appointment = Appointment::select('id', 'patient_id', 'unit_id', 'doctor_id', 'services_cat_id', 'creator_id', 'last_update_person_id', 'status', 'start_at', 'end_at', 'note', 'meet_start_url', 'meet_join_url', 'created_at', 'updated_at')
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['last_update_person' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'code', 'status', 'discount', 'final_price');
                    }]);
            }])
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->with(['unit' => function ($q) {
                $q->select('id', 'name');
            }])
            ->where('id', $id)
            ->first();

        $doctors = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->whereHas(
                'roles',
                function ($q) {
                    $q->where('name', 'doctor');
                }
            )->get();

        $day_name = date('l', strtotime($appointment->start_at));
        $day_month = date('d', strtotime($appointment->start_at));

        $start = date('h:i a', strtotime($appointment->start_at));
        $end = date('h:i a', strtotime($appointment->end_at));

        $created = date('h:i a d M', strtotime($appointment->created_at));
        $updated = date('h:i a d M ', strtotime($appointment->updated_at));

        return compact('appointment', 'doctors', 'day_name', 'day_month', 'start', 'end', 'created', 'updated');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $appointment = Appointment::select('id', 'code', 'patient_id', 'branch_id', 'doctor_id', 'services_cat_id', 'creator_id', 'status', 'start_at', 'end_at', 'note', 'meet_start_url', 'meet_join_url')
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name', 'address');
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type', 'price')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'final_price');
                    }]);
            }])
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->find($id);

        $clinicname = prox_sett('clinicname');

        return view('branch/appointment.show', compact('appointment', 'clinicname'));
    }

    public function monthly_calendar_show()
    {
        $branches = Branch::all();
        return view('branch/appointment.monthly_calendar', compact('branches'));
    }


    public function monthly_calendar_data($year, $month, $specialty, $branch, $unit)
    {
        return monthly_calendar($month, $year, $specialty, $branch, $unit);
    }


    public function allstatcs(Request $request)
    {

        if (!empty($request->input('specialty'))) {
            $specialty = $request->input('specialty');
        } else {
            $specialty = 'all';
        }
        if (!empty($request->input('branch'))) {
            $branch = $request->input('branch');
        } else {
            $branch = 'all';
        }
        if (!empty($request->input('status'))) {
            $status = $request->input('status');
        } else {
            $status = 'all';
        }
        if (!empty($request->input('worker'))) {
            $worker = $request->input('worker');
        } else {
            $worker = 'all';
        }
        if (!empty($request->input('from'))) {
            $from = $request->input('from');
            if ($from !== 'all') {
                $from_explode = explode('-', $request->input('from'));
                $from_year = $from_explode[1];
            }
        } else {
            $from = 'all';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = 'all';
            $to = $request->input('from');
        }

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();
        $users = User::all();

        //---------- stat year
        $appointment_all = Appointment::select(
            DB::raw('count(id) as counts'),
            DB::raw("DATE_FORMAT(start_at,'%m') as monthKey")
        )
            ->groupBy('monthKey')
            ->orderBy('start_at', 'ASC');

        if ($specialty !== "all") {
            $appointment_all = $appointment_all->where('specialty_id', $specialty);
        }

        if ($from !== "all") {
            $appointment_all = $appointment_all->whereYear('start_at', $from_year);
        } else {
            $appointment_all = $appointment_all->whereYear('start_at', date('Y'));
        }

        if ($specialty !== "all") {
            $appointment_all = $appointment_all->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $appointment_all = $appointment_all->where('branch_id', $branch);
        }

        if ($status !== "all") {
            $appointment_all = $appointment_all->where('status', $status);
        }

        if ($worker !== "all") {
            $appointment_all = $appointment_all->where('creator_id', $worker);
        }

        $appointment_all = $appointment_all->get();

        $appointment_date = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        foreach ($appointment_all as $order) {
            $appointment_date[$order->monthKey - 1] = $order->counts;
        }

        // ----------------------
        //for branches stats during year
        $branches_name = Branch::whereHas('appointment')->get();
        $appointment = new Collection();

        foreach ($branches_name as $item) {
            $query = Appointment::select(
                'branch_id',
                DB::raw('count(branch_id) as counts'),
                DB::raw("DATE_FORMAT(start_at,'%m') as monthKey")
            )
                ->with(['branch' => function ($q) {
                    $q->select('id', 'name');
                }])
                ->where('branch_id', $item->id)
                ->groupBy('monthKey')
                ->orderBy('start_at', 'ASC');

            if ($from !== "all") {
                $query = $query->whereYear('start_at', $from_year);
            } else {
                $query = $query->whereYear('start_at', date('Y'));
            }

            if ($status !== "all") {
                $query = $query->where('status', $status);
            }

            if ($worker !== "all") {
                $query = $query->where('creator_id', $worker);
            }

            $query = $query->get();

            $appointment_date_branches = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

            foreach ($query as $order) {
                $appointment_date_branches[$order->monthKey - 1] = $order->counts;
            }

            if (count($query) > 0) {
                //$branch_name = $query[0]->branch->name;
                $appointment->push((object)[
                    'name' => $query[0]->branch->name,
                    'total' => $appointment_date_branches
                ]);
            }
        }

        // ----------------------

        if ($from !== "all") {
            $appointment_total = Appointment::whereYear('start_at', $from_year);
        } else {
            $appointment_total = Appointment::whereYear('start_at', date('Y'));
        }

        if ($specialty !== "all") {
            $appointment_total = $appointment_total->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $appointment_total = $appointment_total->where('branch_id', $branch);
        }

        if ($status !== "all") {
            $appointment_total = $appointment_total->where('status', $status);
        }

        if ($worker !== "all") {
            $appointment_total = $appointment_total->where('creator_id', $worker);
        }


        $appointment_total = $appointment_total->count();

        // ----------------------

        $specialty_order = Appointment::select('specialty_id', DB::raw('count(*) as total'))
            ->groupBy('specialty_id')
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $specialty_order = $specialty_order->where('branch_id', $branch);
        }

        if ($status !== "all") {
            $specialty_order = $specialty_order->where('status', $status);
        }

        if ($from !== "all") {
            $specialty_order = $specialty_order->whereYear('start_at', $from_year);
        } else {
            $specialty_order = $specialty_order->whereYear('start_at', date('Y'));
        }

        if ($worker !== "all") {
            $specialty_order = $specialty_order->where('creator_id', $worker);
        }

        $specialty_order = $specialty_order->get();

        //--

        $specialty_order_month = Appointment::select('specialty_id', DB::raw('count(*) as total'))
            ->groupBy('specialty_id')
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $specialty_order_month = $specialty_order_month->where('branch_id', $branch);
        }

        if ($from !== "all") {
            $specialty_order_month = $specialty_order_month->whereBetween('start_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $specialty_order_month = $specialty_order_month->whereMonth('start_at', date('m'));
        }

        if ($status !== "all") {
            $specialty_order_month = $specialty_order_month->where('status', $status);
        }

        if ($worker !== "all") {
            $specialty_order_month = $specialty_order_month->where('creator_id', $worker);
        }

        $specialty_order_month = $specialty_order_month->get();

        // ----------------------

        $branch_order = Appointment::select('branch_id', DB::raw('count(*) as total'))
            ->groupBy('branch_id')
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $branch_order = $branch_order->where('specialty_id', $specialty);
        }

        if ($from !== "all") {
            $branch_order = $branch_order->whereYear('start_at', $from_year);
        } else {
            $branch_order = $branch_order->whereYear('start_at', date('Y'));
        }

        if ($status !== "all") {
            $branch_order = $branch_order->where('status', $status);
        }

        if ($worker !== "all") {
            $branch_order = $branch_order->where('creator_id', $worker);
        }

        $branch_order = $branch_order->get();
        //---
        $branch_order_month = Appointment::select('branch_id', DB::raw('count(*) as total'))
            ->groupBy('branch_id')
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $branch_order_month = $branch_order_month->where('specialty_id', $specialty);
        }

        if ($from !== "all") {
            $branch_order_month = $branch_order_month->whereBetween('start_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $branch_order_month = $branch_order_month->whereMonth('start_at', date('m'));
        }

        if ($status !== "all") {
            $branch_order_month = $branch_order_month->where('status', $status);
        }

        if ($worker !== "all") {
            $branch_order_month = $branch_order_month->where('creator_id', $worker);
        }

        $branch_order_month = $branch_order_month->get();


        // ----------------------

        $creator = Appointment::select('creator_id', DB::raw('count(*) as total'))
            ->groupBy('creator_id')
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereNotNull('creator_id')
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $creator = $creator->where('specialty_id', $specialty);
        }

        if ($from !== "all") {
            $creator = $creator->whereYear('start_at', $from_year);
        } else {
            $creator = $creator->whereYear('start_at', date('Y'));
        }

        if ($branch !== "all") {
            $creator = $creator->where('branch_id', $branch);
        }

        if ($status !== "all") {
            $creator = $creator->where('status', $status);
        }

        if ($worker !== "all") {
            $creator = $creator->where('creator_id', $worker);
        }

        $creator = $creator->get();

        // ----------------------

        $doctor = Appointment::select('doctor_id', DB::raw('count(*) as total'))
            ->groupBy('doctor_id')
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereNotNull('doctor_id')
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $doctor = $doctor->where('specialty_id', $specialty);
        }

        if ($from !== "all") {
            $doctor = $doctor->whereYear('start_at', $from_year);
        } else {
            $doctor = $doctor->whereYear('start_at', date('Y'));
        }

        if ($branch !== "all") {
            $doctor = $doctor->where('branch_id', $branch);
        }

        if ($status !== "all") {
            $doctor = $doctor->where('status', $status);
        }

        if ($worker !== "all") {
            $doctor = $doctor->where('creator_id', $worker);
        }

        $doctor = $doctor->get();

        // ----------------------

        $creator_month = Appointment::select('creator_id', DB::raw('count(*) as total'))
            ->groupBy('creator_id')
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereNotNull('creator_id')
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $creator_month = $creator_month->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $creator_month = $creator_month->where('branch_id', $branch);
        }

        if ($from !== "all") {
            $creator_month = $creator_month->whereBetween('start_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $creator_month = $creator_month->whereMonth('start_at', date('m'));
        }

        if ($status !== "all") {
            $creator_month = $creator_month->where('status', $status);
        }

        if ($worker !== "all") {
            $creator_month = $creator_month->where('creator_id', $worker);
        }

        $creator_month = $creator_month->get();

        // ----------------------

        $doctor_month = Appointment::select('doctor_id', DB::raw('count(*) as total'))
            ->groupBy('doctor_id')
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereNotNull('doctor_id')
            ->whereMonth('start_at', date('m'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $doctor_month = $doctor_month->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $doctor_month = $doctor_month->where('branch_id', $branch);
        }


        if ($status !== "all") {
            $doctor_month = $doctor_month->where('status', $status);
        }

        if ($worker !== "all") {
            $doctor_month = $doctor_month->where('creator_id', $worker);
        }

        if ($from !== "all") {
            $doctor_month = $doctor_month->whereBetween('start_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $doctor_month = $doctor_month->whereMonth('start_at', date('m'));
        }

        $doctor_month = $doctor_month->get();

        return view('branch/appointment/allstatcs', compact('appointment_date', 'appointment', 'appointment_total', 'specialty_order', 'specialty_order_month', 'branch_order', 'branch_order_month', 'specialty_cat', 'specialty', 'branches', 'users', 'worker', 'status', 'branch', 'creator', 'doctor', 'creator_month', 'doctor_month', 'from', 'to'));
    }



    public function all_appointments(Request $request)
    {

        if (!empty($request->input('specialty'))) {
            $specialty = $request->input('specialty');
        } else {
            $specialty = 'all';
        }

        if (!empty($request->input('branch'))) {
            $branch = $request->input('branch');
        } else {
            $branch = 'all';
        }

        $status = $request->input('status');

        if (isset($status)) {
        } else {
            $status = 'all';
        }

        if (!empty($request->input('worker'))) {
            $worker = $request->input('worker');
        } else {
            $worker = 'all';
        }

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();
        $users = User::all();

        // -------------

        $appointment = Appointment::select('id', 'code', 'patient_id', 'branch_id', 'doctor_id', 'last_update_person_id', 'services_cat_id', 'creator_id', 'status', 'start_at', 'end_at', 'note')
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name', 'address');
            }])
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type', 'price')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'code', 'final_price');
                    }]);
            }])
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', 'first_name', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', 'first_name', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['last_update_person' => function ($q) {
                $q->select('id', 'first_name', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->orderBy('start_at', 'DESC');

        if ($specialty !== "all") {
            $appointment = $appointment->where('specialty_id', $specialty);
        }


        if (Auth::user()->branch_id !== 0) {
            $appointment = $appointment->where('branch_id', Auth::user()->branch_id);
        } else {
            if ($branch !== "all") {
                $appointment = $appointment->where('branch_id', $branch);
            }
        }

        if ($request->input('day_srch')) {
            $date = $request->input('day_srch');

            $date_serc = explode('to', $request->input('day_srch'));
            $date_1_serc = $date_serc[0];

            if (isset($date_serc[1])) {
                $date_2_serc = $date_serc[1];
            } else {
                $date_2_serc = $date_serc[0];
            }
            $appointment = $appointment->whereBetween('start_at', [
                Carbon::createFromFormat('Y-m-d', $date_1_serc)->startOfDay(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('Y-m-d', $date_2_serc)->endOfDay() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $date = Carbon::today();
            $appointment = $appointment->whereDate('start_at', $date);
        }

        if ($status !== "all") {
            $appointment = $appointment->where('status', $status);
        }

        if ($worker !== "all") {
            $appointment = $appointment->where('creator_id', $worker);
        }

        $appointment = $appointment->get();


        return view('branch/appointment/all_appointment', compact('appointment', 'specialty_cat', 'branches', 'users', 'date', 'specialty', 'branch', 'worker', 'status'));
    }


    public function witing_branch()
    {
        return view('branch/waiting');
    }

    public function witing_branch_data()
    {
        $appointment = Appointment::select('id', 'branch_id', 'patient_id', 'doctor_id', 'services_cat_id', 'start_at', 'status', 'queue_show')
            ->Where('branch_id', Auth::user()->branch_id)
            ->whereDate('start_at', date('Y-m-d'))
            ->Where('status', '!=', '1')
            ->Where('status', '!=', '4')
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['patient' => function ($q) {
                $q->select('id', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('status', 'DESC')
            ->get();

        return $appointment;
    }

    //for update queue show to be shown

    public function queue_show_update(Request $request, $appointment_id)
    {
        $appointment = Appointment::find($appointment_id);
        $appointment->queue_show = '1';
        $appointment->save();

        if ($appointment) {
            return response()->json([
                'querystatue' => true,
            ]);
        } else {
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $appointment = Appointment::select('id', 'specialty_id', 'branch_id', 'unit_id', 'services_cat_id', 'start_at',)->find($id);
        $specialties = Specialty_cat::all();
        $branches = Branch::all();
        $services = Service_item::where('service_inv_cat_id', 1)->where('deactivate', 0)->get();
        return view('branch/appointment.edit', compact('appointment', 'specialties', 'branches', 'services'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $appointment = Appointment::find($id);

        if ($appointment->invoice_item) {
            $invoice_id = $appointment->invoice_item->invoice->id;
            $invoice_status = $appointment->invoice_item->invoice->status;
        } else {
            $invoice_id = null;
            $invoice_status = 0;
        }


        if ($invoice_status == 0) {

            $branch_id = $request->input('branch_id');
            $service_id = $request->input('service_id');

            if ($invoice_id !== null) {
                $invoice = Invoice::find($invoice_id);
                $invoice->specialty_id = $request->input('specialty_id');
                $invoice->branch_id = $request->input('branch_id');
                $invoice->save();
            }

            $calander_date_day = $request->input('calander_date_day');

            $calander_date_start = date("H:i", strtotime($request->input('calander_date_start')));

            if ($request->input('calander_date_end')) {
                $calander_date_end = date("H:i", strtotime($request->input('calander_date_end')));
            } else {
                $duration = prox_sett('timeslotduration');
                $cleanup = prox_sett('timeslotcleanup');
                $calander_date_start_end =  $duration + $cleanup;
                $calander_date_end = Carbon::parse($calander_date_start)->addMinutes($calander_date_start_end);
                $calander_date_end = Carbon::parse($calander_date_start)->addMinutes($calander_date_start_end)->format("H:i");
            }

            $start_at = $calander_date_day . ' ' . $calander_date_start;
            $end_at = $calander_date_day . ' ' . $calander_date_end;

            $appointment->specialty_id = $request->input('specialty_id');
            $appointment->branch_id = $request->input('branch_id');
            $appointment->unit_id = $request->input('unit_id');
            $appointment->start_at = $start_at;
            $appointment->end_at = $end_at;
            $appointment->save();

            session()->flash('success', 'The appointment has been edited successfully');
            return redirect()->route('sett.appointment.index');
        }
    }


    public function update_status_doctor(Request $request, $appointment_id)
    {

        $this->validate($request, [
            'status' => ['required', Rule::in(['0', '1', '2', '3', '4', '5', '6'])],
            'doctor' => ['nullable', 'exists:users,id'],
        ]);

        $appointment = Appointment::find($appointment_id);
        $appointment->status = $request->input('status');
        $appointment->doctor_id = $request->input('doctor');
        $appointment->last_update_person_id = Auth::id();
        $appointment->note = $request->input('note');
        $appointment->save();

        if ($appointment) {
            return response()->json([
                'querystatue' => true,
            ]);
        } else {
        }
    }

    public function appointment_note(Request $request)
    {

        $appointment = Appointment::find($request->input('note_appointment_id'));

        $appointment->note_doctor = $request->input('note_appointment');

        $appointment->save();

        session()->flash('success', 'The Doctor Note has been added');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {

        $appointment = Appointment::find($request->appointment_id_delete);


        if ($appointment->diseases) {
            $appointment->diseases->delete();
        }
        if ($appointment->disease_draws) {
            $appointment->disease_draws()->delete();
        }
        if ($appointment->treatments) {
            $appointment->treatments()->delete();
        }
        if ($appointment->sessions) {
            $appointment->sessions()->delete();
        }
        if ($appointment->labs) {
            $appointment->labs()->delete();
        }
        if ($appointment->rate) {
            $appointment->rate()->delete();
        }
        if ($appointment->invoice_item) {

            $appointment->invoice_item->invoice()->delete();

            $appointment->invoice_item()->delete();
        }

        $appointment->delete();


        session()->flash('success', 'The appointment has been deleted');
        return redirect()->back();
    }





    public function rate_index()
    {

        return view('branch/rate');
    }

    public function rate_show()
    {

        $appointment_notdone = Appointment::whereIn('status', [2, 3, 4, 6])
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->doesnthave('rate')
            ->whereDate('start_at', date('Y-m-d'))
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->orderBy('start_at', 'DESC')
            ->get();

        return $appointment_notdone;
    }

    public function rate_update(Request $request, $appointment_id)
    {
        $appointment = Appointment::find($appointment_id);
        $appointment->rate = $request->input('rate_number');
        $appointment->save();

        if ($appointment) {
            return 'Thanks! for your feedback';
        } else {
        }
    }
}
