<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Patient\Patient;
use App\Models\Branch\Branch;
use App\Http\Controllers\Patient\PatientController;
class UpdatePatientCodes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'patient:update_codes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update Patients code from old fromat to numbers only';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(PatientController $patientController)
    {
        ini_set('max_execution_time', 180); // 3600 seconds = 60 minutes
        set_time_limit(180);

        $patients = Patient::all();
        foreach ($patients as $patient) {
            $code_branch = Branch::select('id', 'code')->find($patient->first_branch_id);
            $code = $patientController->rand_id($code_branch);
            $patient->code = $code;
            $patient->save();
        }
    }
}
