<?php

use App\Http\Controllers\admins\RoleController;
use App\Http\Controllers\admins\UsersController;
use App\Http\Controllers\Branch\Appointment\Rate_appointment;
use App\Http\Controllers\Branch\AppointmentController;
use App\Http\Controllers\Branch\Cats\Branch_cat;
use App\Http\Controllers\Branch\Cats\Cost_cats;
use App\Http\Controllers\Branch\Cats\Coupon_cat;
use App\Http\Controllers\Branch\Cats\Debtor_cat;
use App\Http\Controllers\Branch\Cats\Expenses_item;
use App\Http\Controllers\Branch\Cats\Oper_placecat;
use App\Http\Controllers\Branch\Cats\Specialty_cat;
use App\Http\Controllers\Branch\Cats\Unit_cat;
use App\Http\Controllers\Branch\ComplaintController;
use App\Http\Controllers\Branch\Inventory\Inventory_item;
use App\Http\Controllers\Branch\Inventory\InventoryController;
use App\Http\Controllers\Branch\InvoiceController;
use App\Http\Controllers\Branch\LabController;
use App\Http\Controllers\Branch\OperationController;
use App\Http\Controllers\Branch\RateController;
use App\Http\Controllers\Controller;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LandController;
use App\Http\Controllers\OutsideReports\SocialReports;
use App\Http\Controllers\Patient\Cats\Ask_for_cat;
use App\Http\Controllers\Patient\Cats\Ask_for_main_cat;
use App\Http\Controllers\Patient\Cats\Cancel_reason;
use App\Http\Controllers\Patient\Cats\Dent_main_cat;
use App\Http\Controllers\Patient\Cats\Examination_cat;
use App\Http\Controllers\Patient\Cats\Med_doseCont;
use App\Http\Controllers\Patient\Cats\Med_durationCont;
use App\Http\Controllers\Patient\Cats\Medicine_cat;
use App\Http\Controllers\Patient\Cats\Medicine_typeCont;
use App\Http\Controllers\Patient\Cats\Pulse_area_cat;
use App\Http\Controllers\Patient\Cats\Pulses_machine;
use App\Http\Controllers\Patient\Cats\Resource_cat;
use App\Http\Controllers\Patient\Cats\Service_inv_cat;
use App\Http\Controllers\Patient\Cats\Service_item;
use App\Http\Controllers\Patient\Cats\Treatment_cat;
use App\Http\Controllers\Patient\Disease_drawsController;
use App\Http\Controllers\Patient\DiseaseController;
use App\Http\Controllers\Patient\Eyeglasses_prescriptionsCont;
use App\Http\Controllers\Patient\MedicineController;
use App\Http\Controllers\Patient\Patient_dentalController;
use App\Http\Controllers\Patient\PatientController;
use App\Http\Controllers\Patient\PulseController;
use App\Http\Controllers\Patient\Service_package;
use App\Http\Controllers\Patient\SessionController;
use App\Http\Controllers\Patient\TreatmentController;
use App\Http\Controllers\Prox_option;
use App\Http\Controllers\Prox_setting;
use App\Models\Branch\Appointment_operation;
use App\Http\Controllers\Patient\Pat_investigationCont;
use App\Http\Controllers\PublicController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


//----- important if we want to show the webview -----
// Route::get('/', [LandController::class, 'index'])->name('landing');


 Route::get('/', function () {
     return view('auth.login');
 })->name('landing');


Route::get('/test', [Controller::class, 'test']);


// -----------------------------------------
//for Proxima system

//multi languages
Route::group(
     [
          'prefix' => LaravelLocalization::setLocale(),
          'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
     ],
     function () {

          // prescription print
          Route::get('/patient/prescription/{id}/{prescription_id?}', [PublicController::class, 'patient_print_pre'])->name('pat_patient_print_pre');
          Route::get('/patient/prescription315/{id}/{prescription_id?}', [PublicController::class, 'patient_print_pre_no_frame'])->name('pat_patient_print_pre_no_frame');

          //eyeglasses prescription print
          Route::get('/patient/eyeglass_presc_print/{id}/{eye_glass_id?}', [PublicController::class, 'eyeglasses_prescription_print'])->name('eyeglasses_prescription_print');

          Route::get('/patient/eyeglasses_presc_print487/{id}/{eye_glass_id?}', [PublicController::class, 'eyeglasses_presc_print_no_frame'])->name('eyeglasses_presc_print_no_frame');

          Route::get('/patient/eyeglasses_presc_print9410/{id}/{eye_glass_id?}', [PublicController::class, 'eyeglasses_presc_print_no_frame_a5'])->name('eyeglasses_presc_print_no_frame_a5');

        Route::prefix('prox')->name('sett.')->group(function () {

               //for the guest
               Route::get('/', function () {
                    return view('auth.login');
               })->middleware('guest');

               Auth::routes();

               //for the auth user
               Route::middleware('auth', 'activeuser', 'ValidWebUrl')->group(function () {

                    Route::get('/dashboard', [HomeController::class, 'index'])->name('home');

                    Route::resource('/admin', UsersController::class);
                    Route::get('/edit_profile_user', [UsersController::class, 'edit_profile_user'])->name('edit_profile_user');
                    Route::PUT('/edit_profile_user_store', [UsersController::class, 'edit_profile_user_store'])->name('edit_profile_user_store');

                    //note for the user in the dashboard
                    Route::PATCH('/note_ajax', [UsersController::class, 'note_ajax'])->name('ad_note_ajax');

                    Route::get('/createcityajax/{id}', [UsersController::class, 'createcityajax'])->name('createcityajax');
                    //get the services for appointment
                    Route::get('/fetch_from_resource_ajax/{branch_id}', [Resource_cat::class, 'fetchFrom_resourceAjax'])->name('app_fetch_from_resource_ajax');
                    Route::post('/fetch_services', [Service_item::class, 'fetchServices'])->name('app_fetch_services_ajax');

                    Route::group(['prefix' => 'ad', 'middleware' => ['role:Super-admin']], function () {
                         Route::resource('/options', Prox_setting::class);
                         Route::resource('/specialtycat', Specialty_cat::class);
                         Route::resource('/branchcat', Branch_cat::class);
                         Route::resource('/unitcat', Unit_cat::class);
                         Route::resource('/oper_placecat', Oper_placecat::class);
                         Route::resource('/dentmaincat', Dent_main_cat::class);
                         Route::resource('/treatmentcat', Treatment_cat::class);
                         Route::resource('/medicinecat', Medicine_cat::class);
                         Route::resource('/medicine_type', Medicine_typeCont::class);
                         Route::resource('/med_duration', Med_durationCont::class);
                         Route::resource('/med_dose', Med_doseCont::class);
                         Route::resource('/pulse_area_cat', Pulse_area_cat::class);
                         Route::resource('/pulses_machine', Pulses_machine::class);
                         Route::resource('/examinationcat', Examination_cat::class);
                         Route::resource('/eyeglasses_prescription', Eyeglasses_prescriptionsCont::class);
                         Route::resource('/pat_investigation', Pat_investigationCont::class);
                         Route::resource('/expenses_item', Expenses_item::class);
                         Route::resource('/debtorcat', Debtor_cat::class);
                         Route::resource('/service_inv_cat', Service_inv_cat::class);
                         Route::resource('/service_item', Service_item::class);
                         Route::resource('/cost_cats', Cost_cats::class);
                         Route::resource('/resourcecat', Resource_cat::class);
                         Route::resource('/askformaincat', Ask_for_main_cat::class);
                         Route::resource('/askforcat', Ask_for_cat::class);
                         Route::resource('/cancelreasoncat', Cancel_reason::class);
                         Route::resource('/couponcat', Coupon_cat::class);
                         Route::get('/google', [SocialReports::class, 'google'])->name('google');
                         Route::get('/livereport', [Prox_setting::class, 'livereport'])->name('livereport');
                         Route::get('/service_report', [Prox_setting::class, 'service_report'])->name('service_report');
                         Route::put('/service_item', [Service_item::class, 'restore'])->name('service_item.restore');
                    });

                    /*
          |--------------------------------------------------------------------------
          | Appointment Operations
          |--------------------------------------------------------------------------
          */

                    Route::group(['prefix' => 'appo', 'middleware' => ['role:Super-admin|Branch-manager|Receptionist|Call-center|Doctor|Operation|Operation_doctor']], function () {

                        //complaints
                         Route::resource('/complaint', ComplaintController::class);
                         Route::get('/complaint_show_ajax', [ComplaintController::class, 'complaint_show_ajax'])->name('comp_complaint_show_ajax');
                         Route::post('/complaint_save_ajax', [ComplaintController::class, 'complaint_save_ajax'])->name('comp_complaint_save_ajax');

                    });

                    /*
          |--------------------------------------------------------------------------
          | Invoice operations
          |--------------------------------------------------------------------------
          */

                    Route::prefix('invo')->group(function () {
                        //fetch inventory in service item creation and update
                        Route::get('/fetch_inventory/{branch_id}', [Service_item::class, 'fetch_inventory'])->name('fetch_inventory')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                    });

                    /*
          |--------------------------------------------------------------------------
          | inventory operations
          |--------------------------------------------------------------------------
          */

                    Route::group(['prefix' => 'inven', 'middleware' => ['role:Super-admin|Branch-manager|Stocker']], function () {

                         //get the latsest results
                         Route::get('/inventory_finished/{branch}', [InventoryController::class, 'inventory_finished'])->name('inven_inventory_finished');
                         //get the latsest results for no pay
                         Route::get('/inventory_close_finish/{branch}', [InventoryController::class, 'inventory_close_finish'])->name('inven_inventory_close_finish');

                         //search engine for inventory
                         Route::get('/inventory_search/{search_query}', [InventoryController::class, 'inventory_search'])->name('inven_inventory_search');

                         //catagory
                         Route::resource('/inventory_item', Inventory_item::class);

                         //to add new lab from the patient account
                         Route::post('/store_inventory_rec/{item_id}', [InventoryController::class, 'store_inventory_rec'])->name('inven_store_inventory_rec');

                         //search engine for inventory
                         Route::get('/fetch_inven_items_ajax', [InventoryController::class, 'fetch_inven_items_ajax'])->name('inven_fetch_items_ajax');

                         //main inventory
                         Route::resource('/inventory', InventoryController::class);
                    });


                    /*
          |--------------------------------------------------------------------------
          | Lab operations
          |--------------------------------------------------------------------------
          */

                    Route::prefix('lab')->group(function () {

                         //to add new lab from the patient account
                         Route::post('/lab/patient_add', [LabController::class, 'patient_add'])->name('lab_patient_add')->middleware(['role:Super-admin|Doctor']);

                         //search engine for lab
                         Route::get('/lab/lab_search/{search_query}', [LabController::class, 'lab_search'])->name('lab_lab_search')->middleware(['role:Super-admin|Lab']);

                         //get the latsest results
                         Route::get('/lab/lab_result_index/{branch}', [LabController::class, 'lab_result_index'])->name('lab_lab_result_index')->middleware(['role:Super-admin|Lab']);

                         //get the latsest results for no pay
                         Route::get('/lab/lab_result_nopay_index/{branch}', [LabController::class, 'lab_result_nopay_index'])->name('lab_lab_result_nopay_index')->middleware(['role:Super-admin|Lab']);

                         //lab print
                         Route::get('/lab/lab_print/{id}', [LabController::class, 'lab_print'])->name('lab_lab_print')->middleware(['role:Super-admin|Lab']);

                         //main lab controller
                         Route::resource('/lab', LabController::class)->middleware(['role:Super-admin|Lab']);
                    });

                    /*
          |--------------------------------------------------------------------------
          | Patient operations
          |--------------------------------------------------------------------------
          */

                    Route::prefix('pat')->group(function () {

                         //fetch city depends on country
                         Route::get('/patient/createcityajax/{id}', [PatientController::class, 'createcityajax'])->name('pat_createcityajax')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //search engine for patients
                         Route::get('/patient/patient_search/{search_query}', [PatientController::class, 'patient_search'])->name('pat_patient_search')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center|Operation|Operation_doctor']);

                         //update note ajax
                         Route::PATCH('/patient/note_ajax/{id}', [PatientController::class, 'note_ajax'])->name('pat_note_ajax')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //total patient statistics
                         Route::get('/patient/allstatcs/{branch?}/{from?}/{to?}', [PatientController::class, 'allstatcs'])->name('pat_allstatcs')->middleware(['role:Super-admin']);

                         //patient print
                         Route::get('/patient/patient_print/{id}', [PatientController::class, 'patient_print'])->name('pat_patient_print')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Operation']);
                         //ramad examination print
                         Route::get('/patient/ramad_examination_print/{id}', [PatientController::class, 'ramad_examination_print'])->name('ramad_examination_print')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Operation']);

                         Route::get('/patient/investigation_print/{id}/{cat}/{pat_investigation_id?}', [Pat_investigationCont::class, 'investigation_print'])->name('investigation_print')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Operation']);

                         Route::get('/patient/investigation_print5915/{id}/{cat}/{pat_investigation_id?}', [Pat_investigationCont::class, 'investigation_print_no_frame_a5'])->name('investigation_print_no_frame_a5')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Operation']);


                         //add new exmination, treatment, session, and etc from old and exsit appointment
                         Route::post('/add_all_pt_info_appo/{id}', [PatientController::class, 'add_all_pt_info_appo'])->name('pat_add_all_pt_info_appo');

                         //fetch new patients in index
                         Route::get('/new_patients_index/{branch}', [PatientController::class, 'new_patients_index'])->name('pat_inven_new_patients_index');

                         //get all appointment info in patient profile in appointments
                         Route::get('/get_all_info_pat_appo/{id}', [PatientController::class, 'get_all_info_pat_appo'])->name('pat_get_all_info_pat_appo');


                         //---- access via ajax ----
                         Route::get('/create_askfor_ajax/{id}', [PatientController::class, 'create_askfor_ajax'])->name('pat_create_askfor_ajax');
                         Route::post('/check_code_ajax', [PatientController::class, 'check_code_ajax'])->name('pat_check_code_ajax');
                         Route::get('/fetch_dental_service/{name}', [Patient_dentalController::class, 'fetch_dental_service'])->name('pat_fetch_dental_service');
                         Route::post('/store_basic_dental', [Patient_dentalController::class, 'store_basic_dental'])->name('pat_store_basic_dental');
                         Route::post('/delete_basic_dental', [Patient_dentalController::class, 'delete_basic_dental'])->name('pat_delete_basic_dental');

                         Route::post('/store_action_dental', [Patient_dentalController::class, 'store_action_dental'])->name('pat_store_action_dental');
                         Route::post('/delete_action_dental', [Patient_dentalController::class, 'delete_action_dental'])->name('pat_delete_action_dental');
                         Route::post('/status_action_dental', [Patient_dentalController::class, 'status_action_dental'])->name('pat_status_action_dental');


                         //send sms to the pattient
                         Route::get('/sms_form_profile/{id}', [PatientController::class, 'sms_form_profile'])->name('pat_sms_form_profile')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //Patient
                         //show for dental patients
                         Route::resource('/patient_dental', Patient_dentalController::class);
                         Route::resource('/patient', PatientController::class);


                         //print sticker
                         Route::post('/patient_print_sticker', [PatientController::class, 'patient_print_sticker'])->name('patient_print_sticker');
                         Route::get('update-code', function () {Artisan::call('patient:update_codes');});
                         Route::get('update-pulses', function () {Artisan::call('patient:update_pulses');});
                         Route::get('migrate', function () {
                            Artisan::call('migrate', array('--path' => 'database/migrations/2024_03_03_142218_add_index_to_invoices.php', '--force' => true));
                            Artisan::call('migrate', array('--path' => 'database/migrations/2024_02_28_173718_add_soft_delete_to_service_items.php', '--force' => true));
                            Artisan::call('migrate', array('--path' => 'database/migrations/2024_02_28_174027_add_soft_delete_to_inventory_items.php', '--force' => true));
                            Artisan::call('migrate', array('--path' => 'database/migrations/2024_02_28_174123_add_soft_delete_to_expenses_items.php', '--force' => true));

                        });

                         //slight edit
                         Route::PATCH('/pat_slight_edit', [PatientController::class, 'pat_slight_edit'])->name('pat_slight_edit')->middleware(['role:Super-admin|Branch-manager|Doctor']);

                         //medicine
                         Route::resource('/medicine', MedicineController::class)->middleware(['role:Super-admin|Branch-manager|Doctor']);

                         //disease
                         Route::resource('/disease', DiseaseController::class)->middleware(['role:Super-admin|Branch-manager|Doctor']);

                         //get all patients by filters
                         Route::get('/my_patients', [PatientController::class, 'my_patients'])->name('pat_my_patients')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //get all patients by filters
                         Route::get('/show_all', [PatientController::class, 'show_all_patients'])->name('pat_show_all_patients')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);
                         Route::get('/sms_done', [PatientController::class, 'sms_done'])->name('pat_sms_done')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //get all vip patients by filters
                         Route::get('/vip_patients', [PatientController::class, 'vip_patients'])->name('pat_vip_patients')->middleware(['role:Super-admin|Branch-manager|Receptionist|Call-center']);


                         //disease draws
                         Route::resource('/disease_draws', Disease_drawsController::class)->middleware(['role:Super-admin|Doctor']);

                         //treatment
                         Route::resource('/treatment', TreatmentController::class)->middleware(['role:Super-admin|Doctor']);

                         //session
                         Route::resource('/session', SessionController::class)->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);

                         //pulses
                         Route::resource('/pulses', PulseController::class)->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);
                         Route::get('/pulses_day_st/{date?}/{branch?}', [PulseController::class, 'pulses_day_st'])->name('pulses_day_st')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);
                         Route::get('/pulses_month_st/{date?}/{branch?}', [PulseController::class, 'pulses_month_st'])->name('pulses_month_st')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);
                         //packages
                         Route::resource('/service_package', Service_package::class)->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);
                         Route::get('/get_packgae_ajax/{patient_id}', [Service_package::class, 'get_packgae_ajax'])->name('get_packgae_ajax')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);

                         Route::post('/machine_rec_insert', [PulseController::class, 'machine_rec_insert'])->name('pul_machine_rec_insert');

                         //slight edit
                         Route::PATCH('/machine_rec_edit/{id}', [PulseController::class, 'machine_rec_edit'])->name('pul_machine_rec_edit')->middleware(['role:Super-admin|Branch-manager|Doctor']);
                         Route::get('/pulses_machines_ajax/{branch_id?}', [PulseController::class, 'pulses_machines_ajax'])->name('pulses_machines_ajax')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);

                         //session
                         Route::post('/add_wallet_balance/{id}', [PatientController::class, 'add_wallet_balance'])->name('pat_add_wallet_balance');

                         // newattachments
                         Route::post('/add_new_attachment', [PatientController::class, 'add_new_attachment'])->name('pat_add_new_attachment');
                         Route::delete('/delete_new_attachment', [PatientController::class, 'delete_new_attachment'])->name('pat_delete_new_attachment')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                    });

                    Route::prefix('rate')->group(function () {
                         Route::resource('/rate_appo', Rate_appointment::class);
                         Route::get('/index_cancel_rate', [Rate_appointment::class, 'index_cancel_rate'])->name('index_cancel_rate');
                         Route::get('/index_inactive_patient', [Rate_appointment::class, 'index_inactive_patient'])->name('index_inactive_patient');

                         Route::get('/ready_rate/{date?}', [Rate_appointment::class, 'ready_rate'])->name('ready_rate');
                         Route::get('/cancellation_appointments/{date?}', [Rate_appointment::class, 'cancellation_appointments'])->name('cancellation_appointments');

                         Route::get('/index_rate_note/{type_saved?}', [Rate_appointment::class, 'index_rate_note'])->name('index_rate_note');
                         Route::PATCH('/save_rate_note/{id}', [Rate_appointment::class, 'save_rate_note'])->name('save_rate_note');
                         Route::get('/bad_rate/{type}', [Rate_appointment::class, 'bad_rate'])->name('bad_rate');


                         Route::post('/store_patient_call_center', [PatientController::class, 'store_patient_call_center'])->name('store_patient_call_center');
                         Route::get('/create_patient_call_center', [PatientController::class, 'create_patient_call_center'])->name('create_patient_call_center');

                         Route::post('/add_lead_note/{patient_id}', [Rate_appointment::class, 'add_lead_note'])->name('add_lead_note');
                    });
               });
        });
     }
);
