<?php
/*
|--------------------------------------------------------------------------
| User interface (landing, login, register, profile)
|--------------------------------------------------------------------------
*/
use App\Http\Controllers\LandController;


Route::prefix('land')->name('patient_auth.')->group(function () {

     Route::middleware(['guest:patient'])->group(function () {
          Route::get('/login', [LandController::class, 'login'])->name('login')->middleware("throttle:10,2"); //it will send 10 request per 2 minute
          Route::post('/login_sub', [LandController::class, 'login_sub'])->name('login_sub');
          Route::get('/register', [LandController::class, 'register'])->name('register')->middleware("throttle:10,2");;
          Route::post('/store', [LandController::class, 'store'])->name('store');
          Route::get('/createcityajax/{id}', [LandController::class, 'createcityajax'])->name('createcityajax');
     });

     Route::middleware(['auth:patient'])->group(function () {
          Route::get('/profile', [LandController::class, 'profile'])->name('profile');
          Route::get('/appointment', [LandController::class, 'appointment'])->name('appointment')->middleware("throttle:10,2");;
          Route::get('/coupon_search/{search_query}/{patient_id}/{total_price}', [LandController::class, 'coupon_search']);
          Route::get('/calander_appointment_ajax/{month}/{year}/{specialty_id}/{branch_id}/{unit_id}', [LandController::class, 'calander_appointment_ajax'])->name('land_calander_appointment_ajax');
          //ajax for calander
          Route::get('/calander_show_slots_ajax/{datetoday}/{specialty_id}/{branch_id}/{unit_id}', [LandController::class, 'calander_show_slots_ajax'])->name('land_calander_show_slots_ajax');

          //get the services for appointment
          Route::get('/fetch_servicecat_ajax/{specialty_id}/{branch_id}', [LandController::class, 'fetch_servicecat_ajax'])->name('land_fetch_servicecat_ajax');

          //get the services for appointment
          Route::get('/land_fetch_unit_ajax/{branch_id}', [LandController::class, 'land_fetch_unit_ajax'])->name('land_fetch_unit_ajax');
          Route::post('/store_appointment', [LandController::class, 'store_appointment'])->name('store_appointment');
          Route::post('logout', [LandController::class, 'logout'])->name('logout');
     });

     //--- other non authictaction pages ---
     Route::get('contact', [LandController::class, 'contact'])->name('contact');
     Route::get('about', [LandController::class, 'about'])->name('about');
     Route::get('blogs', [LandController::class, 'blogs'])->name('blogs');
     Route::get('/appointment_public/{code}', [LandController::class, 'show_pat_appointment_public'])->name('land_show_pat_appointment_public');
     Route::get('/rate_appo_public/{code}', [LandController::class, 'rate_appo_public'])->name('land_rate_appo_public');
     Route::post('/rate_appo_public_store', [LandController::class, 'rate_appo_public_store'])->name('land_rate_appo_public_store');
});
