<?php
use App\Http\Controllers\admins\UsersController;
use App\Http\Controllers\admins\RoleController;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;


Route::group(
    [
         'prefix' => LaravelLocalization::setLocale(),
         'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
    ],
    function () {

        Route::prefix('prox')->name('sett.')->group(function () {

            /*
            |--------------------------------------------------------------------------
            | settings (users, roles, perimsstion) {{ route('sett.createcityajax') }}
            |--------------------------------------------------------------------------
            */
                Route::group(['prefix' => 'hr', 'middleware' => ['role:Super-admin|Hr']], function () {
                    Route::POST('/create_doctor_record', [UsersController::class, 'create_doctor_record'])->name('hr_create_doctor_record');
                    Route::resource('/admin', UsersController::class);
                    Route::get('/allstatcs', [UsersController::class, 'allstatcs'])->name('user_allstatcs');
                    Route::resource('/role', RoleController::class);
                    Route::get('/attendance/{worker_id}/{date?}', [UsersController::class, 'attendance'])->name('hr_attendance');
                    Route::get('/edit_attendance/{id}', [UsersController::class, 'edit_attendance'])->name('hr_edit_attendance');
                    Route::PUT('/edit_attendance_insert/{id}', [UsersController::class, 'edit_attendance_insert'])->name('hr_edit_attendance_insert');
            });

            Route::get('/worker_attendance', [UsersController::class, 'worker_attendance'])->name('hr_worker_attendance');
            Route::POST('/worker_attendance_insert', [UsersController::class, 'worker_attendance_insert'])->name('hr_worker_attendance_insert');
            Route::get('/my_attendance/{date?}', [UsersController::class, 'my_attendance'])->name('hr_my_attendance');
            Route::get('/create_attendance_admin', [UsersController::class, 'create_attendance_admin'])->name('hr_create_attendance_admin');
            Route::POST('/insert_attendance_admin', [UsersController::class, 'insert_attendance_admin'])->name('hr_insert_attendance_admin');

        });

    });


