<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $patient->first_name }} Profile</title>
    <link rel="stylesheet" href="{{ public_path('css/kv-mpdf-bootstrap.css') }}">

</head>

<body>

    <!-- Patient Info -->
    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-4 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 30%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url({{ public_path('img/useravatar/' . $patient->avatar) }})">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 70%;float: left;">
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            {{ $patient->first_name . ' ' . $patient->second_name }}</p>
                        <p class="m-0 p-0 text-xs">AFN <span class="fw-bold2">{{ $patient->new_id }}</span></p>
                        <p class="m-0 p-0 text-xs">BFN <span class="fw-bold2">{{ $patient->new_branch_id }}</span></p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Date</p>
                @if (count($patient->eyeglasses) > 0)
                <p class="fw-bold2">{{ $patient->eyeglasses[0]->date }}</p>
                @endif
            </div>

            <div class="col-xs-4 text-right">
                <img src="data:image/png;base64,{{ DNS2D::getBarcodePNG($booking_url,'QRCODE') }}" height="70"
                    width="70" /><br />
                <p class="m-0 p-0 text-xxs text-right">النسخة الالكترونية</p>
            </div>
        </div>


        <!-- Examination -->
        <div class="row justify-content-center mb-2">
            <div class="col-xs-6 p-0">
                <div class="border p-2 m-1 b-r-s-cont">
                    <img src="{{ public_path('img/dashboard/system/eye_axi.png') }}">

                    <!-- All exminations -->
                    <div class="row mb-3">
                        <div class="col-xs-12">

                            <div class="table-responsive">
                                <table class="table-responsive text-s table-bordered2 bordered w-100">
                                    <thead>
                                        <tr style="background-color: #e6e6e6;">
                                            <th class="text-s text-center" colspan="4">Right Eye</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-l fw-bold2">
                                        <tr style="background-color: #e6e6e6;">
                                            <td style="background-color: #e6e6e6;"></td>
                                            <td class="text-center fw-bold2">Sph.</td>
                                            <td class="text-center fw-bold2">Cyl.</td>
                                            <td class="text-center fw-bold2">Axis.</td>
                                        </tr>
                                        <tr>
                                            <td style="background-color: #e6e6e6;" class="text-center">D</td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0)
                                                {{ $patient->eyeglasses[0]->glass_right_sph }}
                                                @endif
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0)

                                                {{ $patient->eyeglasses[0]->glass_right_cyl }}

                                                @endif
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0)
                                                {{ $patient->eyeglasses[0]->glass_right_axis }}°
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="background-color: #e6e6e6;" class="text-center">N</td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0 &&
                                                $patient->eyeglasses[0]->glass_right_n != null)
                                                {{ $patient->eyeglasses[0]->glass_right_n }}
                                                @endif
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0 &&
                                                $patient->eyeglasses[0]->glass_right_n != null)

                                                {{ $patient->eyeglasses[0]->glass_right_cyl }}

                                                @endif
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0 &&
                                                $patient->eyeglasses[0]->glass_right_n != null)
                                                {{ $patient->eyeglasses[0]->glass_right_axis }}°
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-xs-6 p-0">
                <div class="border p-2 m-1 b-r-s-cont">
                    <img src="{{ public_path('img/dashboard/system/eye_axi.png') }}">


                    <!-- All exminations -->
                    <div class="row mb-3">
                        <div class="col-xs-12">

                            <div class="table-responsive">
                                <table class="table-responsive text-s table-bordered2 bordered w-100">
                                    <thead>
                                        <tr style="background-color: #e6e6e6;">
                                            <th class="text-s text-center" colspan="4">Left Eye</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-l fw-bold2">
                                        <tr style="background-color: #e6e6e6;">
                                            <td></td>
                                            <td class="text-center fw-bold2">Sph.</td>
                                            <td class="text-center fw-bold2">Cyl.</td>
                                            <td class="text-center fw-bold2">Axis.</td>
                                        </tr>
                                        <tr>
                                            <td style="background-color: #e6e6e6;" class="text-center">D</td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0)
                                                {{ $patient->eyeglasses[0]->glass_left_sph }}
                                                @endif
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0)
                                                {{ $patient->eyeglasses[0]->glass_left_cyl }}
                                                @endif
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0)
                                                {{ $patient->eyeglasses[0]->glass_left_axis }}°
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="background-color: #e6e6e6;" class="text-center">N</td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0 &&
                                                $patient->eyeglasses[0]->glass_left_n != null)
                                                {{ $patient->eyeglasses[0]->glass_left_n }}
                                                @endif
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0 &&
                                                $patient->eyeglasses[0]->glass_left_n != null)
                                                {{ $patient->eyeglasses[0]->glass_left_cyl }}
                                                @endif
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                @if (count($patient->eyeglasses) > 0 &&
                                                $patient->eyeglasses[0]->glass_left_n != null)
                                                {{ $patient->eyeglasses[0]->glass_left_axis }}°
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="row mb-2">

            <div class="col-xs-5">

                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr style="background-color: #e6e6e6;">
                                <th class="text-s2 text-center" colspan="">IPD mm</th>
                            </tr>
                        </thead>
                        <tbody class="text-s2 fw-bold2">
                            <tr style="background-color: #e6e6e6;">
                                <td class="text-l fw-bold2  text-center">
                                    @if (count($patient->eyeglasses) > 0)
                                    {{ $patient->eyeglasses[0]->ipd }}
                                    @else
                                    <h1 class="p-4 m-4"> </h1>
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>


        @if (count($patient->eyeglasses) > 0)
        <div class="text-right">
            <h5 class="fw-bold2">
                :ملاحظات الطبيب
            </h5>
            <p>
                {{ $patient->eyeglasses[0]->note }}
            </p>
        </div>
        @endif

        <div class="text-right">
            <h5 class="fw-bold2">
                :ملاحظات هامة
            </h5>
            <ul class="text-right" style="direction: rtl;">
                <li> نظارة المسافات للمشي وقيادة السيارة والتلفزيون, نظارة القراءة لكل الاشياء القريبة من
                    يدك
                </li>
                <li>يتم الاعتياد علي النظارة بعد اسبوع علي الاقل</li>
                <li>في حالة وجود استجماتيزم ستشعر في البداية ان الاسطح مائلة وغير مستوية وبعد الاعتياد علي النظارة سوف
                    يزول ذلك الشعور</li>
                <li>مراجعة النظارة خلال شهر</li>
            </ul>
        </div>

        @if (count($patient->eyeglasses) > 0)

        @if($patient->eyeglasses[0]->appointment)
        @if($patient->eyeglasses[0]->appointment->doctor)
        <h4 class="text-s">Responsible Doctor: {{ $patient->eyeglasses[0]->appointment->doctor->first_name }}</h4>
        @endif
        @endif

        @endif

    </div>


</body>

</html>