<!-- treatments and sessions -->
<div class="col-12 col-lg-4">
    <div class="card shadow mb-4">

        <div id="treat-session" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
            data-bs-interval="false">

            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="0"
                    aria-label="Slide 0"></button>
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="1"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="2" class="active"
                    aria-current="true" aria-label="Slide 2"></button>
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="3"
                    aria-label="Slide 3"></button>
            </div>

            <div class="carousel-inner">



                <!-- Current Examination -->
                <div class="carousel-item active">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">
                                {{ __('basic.eyeglasses')
                                }}</span>

                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 1">
                                {{ __('basic.prescription') }}</span>

                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="2" aria-label="Slide 2">
                                {{ __('basic.treatments') }}</span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="3" aria-label="Slide 3">
                                {{ __('patientappo.sessions') }}</span>

                        </div>
                        <div class="dropdown no-arrow position-absolute end-0">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_eyeglasses_prescription">{{ __('basic.add new') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    @if (!$patient->eyeglasses->isEmpty())
                    <div id="medicine_card_home" class="card-body align-items-center">

                        @foreach ($patient->eyeglasses as $item)
                        {{-- blade-formatter-disable-next-line --}}
                        @break($loop->index === 3)

                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-glasses me-2 fs-4 mb-0"></i>
                                <div class="text-truncate">
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        {{ $item->date }}
                                    </p>
                                </div>
                            </div>
                            <a href="{{ route('eyeglasses_prescription_print', [$patient->code, $item->code]) }}"
                                target="_blank">
                                <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l">{{
                                    __('basic.download')
                                    }}</span>
                            </a>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#add_eyeglasses_prescription">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">{{ __('basic.you can add new eyeglasses prescription') }}</p>
                        </a>
                    </div>
                    @endif

                    <!-- Card footer medicine -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#eyeglasses_prescription_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>

                </div><!-- end of medicens crousel -->



                <!-- Current Medicines -->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">{{ __('basic.prescription')
                                }}</span>

                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="2" aria-label="Slide 2">
                                {{ __('basic.treatments') }}</span>

                            <span
                                class="m-0 me-2 text-x link-cust-text me-2 text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="3" aria-label="Slide 3">
                                {{ __('patientappo.sessions') }}</span>

                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 0">
                                {{ __('basic.eyeglasses') }}</span>

                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addmedic">{{ __('patientappo.add medicine') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    @if (!$patient->prescriptions->isEmpty())
                    <div id="medicine_card_home" class="card-body align-items-center">

                        @foreach ($patient->prescriptions as $item)

                        {{-- blade-formatter-disable-next-line --}}
                        @break($loop->index === 3)
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-capsules me-2 fs-4 mb-0"></i>
                                <div class="text-truncate">
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        {{ $item->date }}
                                    </p>
                                </div>
                            </div>
                            <a href="{{ route('pat_patient_print_pre', [$patient->code, $item->code]) }}"
                                target="_blank">
                                <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l">{{
                                    __('basic.download')
                                    }}</span>
                            </a>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#addmedic">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">{{ __('patientappo.you can add new medicines') }}</p>
                        </a>
                    </div>

                    @endif

                    <!-- Card footer medicine -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#medicine_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>

                </div><!-- end of medicens crousel -->


                <!-- Current treatments -->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">{{ __('basic.treatments')
                                }}</span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="3" aria-label="Slide 3">
                                {{ __('patientappo.sessions') }}</span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 0">
                                {{ __('basic.eyeglasses') }}</span>

                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 1">
                                {{ __('basic.prescription') }}</span>

                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addtreatment">{{ __('patientappo.new treatment') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    @if (!$patient->treatments->isEmpty())
                    <div class="card-body pb-4">

                        @foreach ($patient->treatments as $item)
                        {{-- blade-formatter-disable-next-line --}}
                        @break($loop->index === 3)

                        @if ($item->status == 0)
                        @php
                        $text_color = 'main-color';
                        $msg = __('basic.in prog');
                        @endphp
                        @elseif ($item->status == 1)
                        @php
                        $text_color = 'done-color-btn';
                        $msg = __('patientappo.done');
                        @endphp
                        @endif

                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 {{ $text_color }}"></i>

                                <div class="text-truncate">
                                    <h6 class="text-s fw-bold text-gray-700  mb-0">
                                        {{ $item->treatment_cat->name }}</h6>
                                    <p class="text-xs text-gray-300 fw-bold mb-0">{{ $msg }}</p>
                                </div>
                            </div>

                            <div class="text-s text-gray-600 fw-bold">{{ $item->sessions }}<small
                                    class="text-gray-300 text-xxxs">
                                    Sesi</small>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#addtreatment">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">You can put your Treatment</p>
                        </a>
                    </div>
                    @endif

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300 clickable-item-pointer" data-bs-toggle="modal"
                            data-bs-target="#treatment_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>

                </div>

                <!----------- sessions start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">{{ __('patientappo.sessions')
                                }}</span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 0">
                                {{ __('basic.eyeglasses') }}</span>

                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 1">
                                {{ __('basic.prescription') }}</span>

                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 1">
                                {{ __('basic.treatments') }}</span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addsession">{{ __('patientappo.new session') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    @if (!$patient->sessions->isEmpty())
                    <div id="medicine_card_home" class="card-body align-items-center">

                        @foreach ($patient->sessions as $item)
                        {{-- blade-formatter-disable-next-line --}}
                        @break($loop->index === 3)

                        @if ($item->status == 0)
                        @php
                        $text_color = 'main-color';
                        $msg = __('patientappo.not done');
                        @endphp
                        @elseif ($item->status == 1)
                        @php
                        $text_color = 'done-color-btn';
                        $msg = __('patientappo.done');
                        @endphp
                        @endif

                        @if ($item->invoice_item)
                        @if ($item->invoice_item->invoice)
                        @if ($item->invoice_item->invoice->status == 0)
                        @php
                        $text_color_invoice = 'cancel-color-btn';
                        $msg_invoice = __('basic.not paid');
                        @endphp
                        @elseif ($item->invoice_item->invoice->status == 1)
                        @php
                        $text_color_invoice = 'pend-color-btn';
                        $msg_invoice = __('basic.pending');
                        @endphp
                        @elseif ($item->invoice_item->invoice->status == 2)
                        @php
                        $text_color_invoice = 'prog-color-btn';
                        $msg_invoice = __('basic.installment');
                        @endphp
                        @elseif ($item->invoice_item->invoice->status == 3)
                        @php
                        $text_color_invoice = 'done-color-btn';
                        $msg_invoice = __('basic.paid');
                        @endphp
                        @elseif ($item->invoice_item->invoice->status == 4)
                        @php
                        $text_color_invoice = 'cancel-color-btn';
                        $msg_invoice = __('basic.refund');
                        @endphp
                        @endif
                        @else
                        @php
                        $text_color_invoice = '';
                        $msg_invoice = '';
                        @endphp
                        @endif
                        @else
                        @php
                        $text_color_invoice = 'done-color-btn';
                        $msg_invoice = __('patientappo.old record');
                        @endphp
                        @endif
                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 {{ $text_color }}"></i>

                                <div class="text-truncate">
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        @if($item->service_item)
                                        {{ $item->service_item->name }}
                                        @endif
                                    </p>
                                    <p class="text-xs text-gray-300 fw-bold mb-0">{{ $msg }}</p>
                                </div>
                            </div>

                            <span class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{ $msg_invoice
                                }}</span>

                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#addsession">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">{{ __('patientappo.new session') }}</p>
                        </a>
                    </div>

                    @endif

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#session_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>

                </div>



            </div>


            <!-- Modal show all treatment -->
            <div class="modal fade" id="treatment_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                                Treatment</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-treatment" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs">{{ __('basic.id') }}</th>
                                            <th class="text-xs">{{ __('basic.name') }}</th>
                                            <th class="text-xs text-center">{{ __('basic.start') }}</th>
                                            <th class="text-xs text-center">{{ __('basic.end') }}</th>
                                            <th class="text-xs text-center">{{ __('patientappo.sessions') }}
                                            </th>
                                            <th class="text-xs text-center">
                                                {{ __('patientappo.sessions done') }}</th>
                                            <th class="text-xs text-center">{{ __('basic.status') }}</th>
                                            <th class="text-xs text-center">{{ __('basic.handle') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($patient->treatments as $item)
                                        @if ($item->status == 0)
                                        @php
                                        $text_color = 'active-color-btn';
                                        $msg = __('basic.in prog');
                                        @endphp
                                        @elseif ($item->status == 1)
                                        @php
                                        $text_color = 'done-color-btn';
                                        $msg = __('patientappo.done');
                                        @endphp
                                        @endif

                                        <tr>
                                            <td>{{ $item->id }}</td>
                                            <td class="">
                                                {{ $item->treatment_cat->name }}</td>
                                            <td>{{ $item->start }}</td>
                                            <td class="text-center">{{ $item->end }}</td>
                                            <td class="text-center">{{ $item->sessions }}</td>
                                            <td class="text-center">{{ $item->sessions_done }}</td>
                                            <td class="text-center"> <span
                                                    class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg
                                                    }}</span>
                                            </td>

                                            <td class="text-center">
                                                <a data-treatment_id="{{ $item->id }}"
                                                    data-treatment_cat_id="{{ $item->treatment_cat->id }}"
                                                    data-status_treatment="{{ $item->status }}"
                                                    data-sessions="{{ $item->sessions }}"
                                                    data-sessions_done="{{ $item->sessions_done }}"
                                                    data-start="{{ $item->start }}" data-end="{{ $item->end }}"
                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 treatment_edit_click"
                                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                                    {{ __('basic.edit') }} </a>

                                                <a data-treatment_id="{{ $item->id }}"
                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 treatment_newsession_click"
                                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                                    {{ __('patientappo.new session') }} </a>

                                                <a data-treatment_id="{{ $item->id }}"
                                                    class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 treatment_delete_click"
                                                    title="delete" data-effect="effect-scale"><i
                                                        class="fas fa-trash"></i>
                                                    {{ __('basic.delete') }}
                                                </a>

                                            </td>

                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                    __('basic.never mind') }}</button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link main-color">{{ __('basic.save
                                    changes') }}</button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal treatment insert data -->
            <div class="modal fade" id="addtreatment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                                {{ __('patientappo.new treatment') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form action="{{ route('sett.treatment.store') }}" method="post">
                            {{ method_field('POST') }}
                            {{ csrf_field() }}

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.treatment') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-treatment-insert select2-hidden-accessible @error('treatment_cat') is-invalid @enderror"
                                            id="treatment_cat" name="treatment_cat" required>
                                            @foreach ($treatment_cat as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="treatment_cat_error" class="error-msg-form"></span>

                                        @error('treatment_cat')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"> {{ __('patientappo.sessions') }}
                                            <small>({{ __('basic.required') }})</small></label>

                                        <input name="treatment_session" type="number"
                                            class="form-control @error('treatment_session') is-invalid @enderror"
                                            placeholder="How many session?" required>

                                        <span id="treatment_session_error" class="error-msg-form"></span>

                                        @error('treatment_session')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.start') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_start" type="text"
                                                class="form-control hasdatetimepicker @error('treatment_start') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="treatment_start_error" class="error-msg-form"></span>

                                        @error('treatment_start')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.end') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_end" type="text"
                                                class="form-control hasdatetimepicker @error('treatment_end') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD">
                                        </div>
                                        <span id="treatment_end_error" class="error-msg-form"></span>

                                        @error('treatment_end')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.appointment') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-treatment-insert select2-hidden-accessible @error('last_appointment_id') is-invalid @enderror"
                                            id="last_appointment_id_trea" name="last_appointment_id" required>
                                            @foreach ($patient->appointments as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->start_at }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        @error('last_appointment_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>
                                </div>

                                <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Add
                                        New</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- Modal treatment update data -->
            <div class="modal fade" id="treatment_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                Edit treatment</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="{{ route('sett.treatment.update', '21') }}" method="POST">
                            @csrf
                            @method('PUT')

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.treatment') }}
                                            <small>({{ __('basic.required') }})</small></label>

                                        <select
                                            class="myselect2-treatment-update select2-hidden-accessible @error('treatment_cat_update') is-invalid @enderror"
                                            id="treatment_cat_update" name="treatment_cat_update" required>
                                            @foreach ($treatment_cat as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="treatment_cat_update_error" class="error-msg-form"></span>

                                        @error('treatment_cat_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>


                                    <div class="col-12 mb-2">
                                        <label class="form-label"> {{ __('patientappo.sessions') }}
                                            <small>({{ __('basic.required') }})</small></label>

                                        <input name="treatment_session_update" type="number"
                                            class="form-control @error('treatment_session_update') is-invalid @enderror"
                                            placeholder="How many session?" required>

                                        <span id="treatment_session_update_error" class="error-msg-form"></span>

                                        @error('treatment_session_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Sessions Done
                                            <small>({{ __('basic.required') }})</small></label>

                                        <input name="treatment_session_done_update" type="number"
                                            class="form-control @error('treatment_session_done_update') is-invalid @enderror"
                                            placeholder="How many session?">

                                        <span id="treatment_session_done_update_error" class="error-msg-form"></span>

                                        @error('treatment_session_done_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.status') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="select2-no-search-treatment select2-hidden-accessible select2-no-search-treatment @error('status_treatment_update') is-invalid @enderror"
                                            id="status_treatment_update" name="status_treatment_update" required>
                                            <option value="0">
                                                {{ __('basic.in prog') }}
                                            </option>
                                            <option value="1">
                                                {{ __('patientappo.done') }}
                                            </option>
                                        </select>

                                        <span id="status_treatment_update_error" class="error-msg-form"></span>

                                        @error('status_treatment_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.start') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_start_update" type="text"
                                                class="form-control hasdatetimepicker @error('treatment_start_update') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="treatment_start_update_error" class="error-msg-form"></span>

                                        @error('treatment_start_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.end') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_end_update" type="text"
                                                class="form-control hasdatetimepicker @error('treatment_end_update') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>

                                        @error('treatment_end_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                        <span id="treatment_end_update_error" class="error-msg-form"></span>
                                    </div>


                                </div>

                                <input name="treatment_id_update" value="" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">{{
                                        __('basic.update') }}</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- treatment Modal delete -->
            <div class="modal fade" id="treatment_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                {{ __('basic.delete') }}</div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form action="{{ route('sett.treatment.destroy', 'test') }}" method="post">
                            {{ method_field('delete') }}
                            {{ csrf_field() }}

                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre
                                        you sure you want to delete
                                        this
                                        treatment?</p><br>
                                    <input type="hidden" name="treatment_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link text-red">{{
                                        __('basic.delete') }}
                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <!-- Modal show all session -->
            <div class="modal fade" id="session_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                                {{ __('patientappo.session') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-session" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs">{{ __('basic.date') }}</th>
                                            <th class="text-xs">{{ __('basic.name') }}</th>
                                            <th class="text-xs text-center">
                                                {{ __('patientappo.session status') }}</th>
                                            <th class="text-xs text-center">{{ __('patientappo.pay status') }}
                                            </th>
                                            <th class="text-xs text-center">{{ __('patientappo.pay Code') }}
                                            </th>
                                            <th class="text-xs text-center">{{ __('patientappo.treat id') }}
                                            </th>
                                            <th class="text-xs text-center">
                                                {{ __('patientappo.treat sessions') }}</th>
                                            <th class="text-xs text-center">{{ __('basic.handle') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($patient->sessions as $item)
                                        @if ($item->status == 0)
                                        @php
                                        $text_color = 'active-color-btn';
                                        $msg = __('patientappo.not done');
                                        @endphp
                                        @elseif ($item->status == 1)
                                        @php
                                        $text_color = 'done-color-btn';
                                        $msg = __('basic.done');
                                        @endphp
                                        @endif

                                        @if ($item->invoice_item)
                                        @if ($item->invoice_item->invoice)
                                        @if ($item->invoice_item->invoice->status == 0)
                                        @php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = __('basic.not paid');
                                        @endphp
                                        @elseif ($item->invoice_item->invoice->status == 1)
                                        @php
                                        $text_color_invoice = 'pend-color-btn';
                                        $msg_invoice = __('basic.pending');
                                        @endphp
                                        @elseif ($item->invoice_item->invoice->status == 2)
                                        @php
                                        $text_color_invoice = 'prog-color-btn';
                                        $msg_invoice = __('basic.installment');
                                        @endphp
                                        @elseif ($item->invoice_item->invoice->status == 3)
                                        @php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('basic.paid');
                                        @endphp
                                        @elseif ($item->invoice_item->invoice->status == 4)
                                        @php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = __('basic.refund');
                                        @endphp
                                        @endif
                                        @php
                                        $invoice_url = 'href=' . route('sett.invoice.show',
                                        $item->invoice_item->invoice->id);
                                        @endphp
                                        @else
                                        @php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('patientappo.old record');
                                        $invoice_url = '';
                                        @endphp
                                        @endif
                                        @else
                                        @php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('patientappo.old record');
                                        $invoice_url = '';
                                        @endphp
                                        @endif

                                        <tr>
                                            <td>{{ date('d M Y', strtotime($item->date)) }}</td>
                                            <td>{{ $item->service_item->name }}</td>
                                            <td class="text-center"> <span
                                                    class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg
                                                    }}</span>
                                            </td>
                                            <td class="text-center">
                                                <a {{ $invoice_url }}><span
                                                        class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{
                                                        $msg_invoice }}</span></a>
                                            </td>
                                            <td class="text-center">
                                                @if ($item->invoice_item)
                                                {{ $item->invoice_item->invoice->code }}
                                                @else
                                                {{ __('patientappo.old record') }}
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                @if (!empty($item->treatment->id))
                                                {{ $item->treatment->id }}
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                @if (!empty($item->treatment->sessions))
                                                {{ $item->treatment->sessions }}
                                                @endif
                                            </td>

                                            <td class="text-center">
                                                <a data-session_id="{{ $item->id }}"
                                                    data-status_session="{{ $item->status }}"
                                                    data-treat_id="@if (!empty($item->treatment->id)) {{ $item->treatment->id }} @endif"
                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 session_edit_click"
                                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                                    {{ __('basic.edit') }} </a>

                                                @if ($item->invoice_item)
                                                @if ($item->invoice_item->invoice->status == 0)
                                                <a data-session_id="{{ $item->id }}"
                                                    class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 session_delete_click"
                                                    title="delete" data-effect="effect-scale" data-bs-toggle="modal"
                                                    data-bs-target="#delete1"><i class="fas fa-trash"></i>
                                                    {{ __('basic.delete') }}
                                                </a>
                                                @endif
                                                @endif

                                            </td>

                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">
                                    {{ __('basic.never mind') }}</button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link main-color">{{ __('basic.save
                                    changes') }}</button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal session update data -->
            <div class="modal fade" id="session_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                Update Session</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="{{ route('sett.session.update', '21') }}" method="POST">
                            @csrf
                            @method('PUT')

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">


                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.status') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="select2-no-search-session select2-hidden-accessible select2-no-search-medicine @error('status_session_update') is-invalid @enderror"
                                            id="status_session_update" name="status_session_update" required>
                                            <option value="0">
                                                {{ __('patientappo.not done') }}
                                            </option>
                                            <option value="1">
                                                {{ __('patientappo.done') }}
                                            </option>
                                        </select>

                                        <span id="status_update_update_error" class="error-msg-form"></span>

                                        @error('status_update_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>


                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('patientappo.related to treatment') }}
                                            <small>( {{ __('basic.required') }})</small></label>

                                        <select
                                            class="myselect2-session-update select2-hidden-accessible @error('related_treatment_id_update') is-invalid @enderror"
                                            id="related_treatment_id_update" name="related_treatment_id_update">
                                            @foreach ($patient->treatments as $item)
                                            @if ($item->status == 0)
                                            <option value="{{ $item->id }}">
                                                {{ $item->treatment_cat->name . ' - ' . $item->start }}
                                            </option>
                                            @endif
                                            @endforeach
                                        </select>

                                        <span id="related_treatment_id_update_error" class="error-msg-form"></span>

                                        @error('related_treatment_id_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>


                                </div>

                                <input name="session_id_update" value="" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">{{
                                        __('basic.update') }}</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- session delete -->
            <div class="modal fade" id="session_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                {{ __('patientappo.session delete') }}</div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="{{ route('sett.session.destroy', 'test') }}" method="post">
                            {{ method_field('delete') }}
                            {{ csrf_field() }}

                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre
                                        you sure you want to delete
                                        this
                                        session?</p><br>
                                    <input type="hidden" name="session_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link text-red">{{
                                        __('basic.delete') }}
                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <!-- Modal add new session insert data -->
            <div class="modal fade" id="addsession" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="{{ route('sett.session.store') }}" method="post"
                        style="display: contents">
                        {{ method_field('POST') }}
                        {{ csrf_field() }}

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                    {{ __('patientappo.new session') }}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">
                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('patientappo.session') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-session-insert select2-hidden-accessible @error('session_cat_service') is-invalid @enderror"
                                            id="session_cat_service_insert" multiple name="session_cat_service[]"
                                            required>
                                            @foreach ($service_cat_ses as $item)
                                            <option value="{{ $item->id }}" data-price="{{ $item->price }}">
                                                {{ $item->name . ' - ' . $item->price . 'EGP' }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="session_cat_service_error" class="error-msg-form"></span>

                                        @error('session_cat_service')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">{{ __('basic.doctor') }}
                                            <small>({{ __('basic.required') }})</small></label>

                                        <select
                                            class="myselect2-session-insert select2-hidden-accessible @error('doc_session') is-invalid @enderror"
                                            id="doc_session" name="doc_session" required>
                                            @foreach ($doctors as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="doc_session_error" class="error-msg-form"></span>

                                        @error('doc_session')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.status') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-session-insert-nosearch select2-hidden-accessible @error('session_status') is-invalid @enderror"
                                            id="session_status" name="session_status" required>
                                            <option value="0">
                                                {{ __('patientappo.new record') }}
                                            </option>
                                            <option value="1">
                                                {{ __('patientappo.old record') }}
                                            </option>
                                        </select>

                                        <span id="session_status_error" class="error-msg-form"></span>

                                        @error('session_status')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('patientappo.related to treatment') }}
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <select
                                            class="myselect2-session-insert select2-hidden-accessible @error('related_treatment_id') is-invalid @enderror"
                                            id="related_treatment_id" name="related_treatment_id">
                                            <option disabled selected value> -- select treatment -- </option>
                                            @foreach ($patient->treatments as $item)
                                            @if ($item->status == 0)
                                            <option value="{{ $item->id }}">
                                                {{ $item->treatment_cat->name . ' - ' . $item->start }}
                                            </option>
                                            @endif
                                            @endforeach
                                        </select>

                                        <span id="related_treatment_id_error" class="error-msg-form"></span>

                                        @error('related_treatment_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.date') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="session_date" type="text"
                                                class="form-control hasdatetimepicker @error('session_date') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="session_date_error" class="error-msg-form"></span>

                                        @error('session_date')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <hr class="my-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.appointment') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-session-insert-nosearch select2-hidden-accessible @error('last_appointment_id') is-invalid @enderror"
                                            id="last_appointment_id_pulses" name="last_appointment_id" required>
                                            @foreach ($patient->appointments as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->start_at }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        @error('last_appointment_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.invoice') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-session-insert-nosearch @error('session_cat_service') is-invalid @enderror"
                                            id="session_cat_invoice_insert" name="session_cat_invoice" required>
                                            <option value="new">New Invoice</option>
                                            <option value="wallet">Wallet</option>
                                            @foreach ($patient->invoices as $item)
                                            @if ($item->status == 0)
                                            <option value="{{ $item->id }}">
                                                {{ $item->service_inv_cat . ' - ' . $item->final_price . 'EGP' }}
                                            </option>
                                            @endif
                                            @endforeach
                                        </select>

                                        <span id="session_cat_invoice_error" class="error-msg-form"></span>

                                        @error('session_cat_invoice')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.invoice note') }}
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <textarea name="invoice_note" class="form-control"
                                            placeholder="Write here your notes .." rows="4"
                                            spellcheck="false"></textarea>

                                        <span id="session_cat_invoice_error" class="error-msg-form"></span>

                                        @error('invoice_note')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>
                                </div>

                                <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Add
                                        New</button>
                                </div>
                            </div>

                        </div>
                    </form>

                </div>

            </div>



            <!----------------- show all glasses prescription ----------------->

            <!-- Modal Medicine insert data -->
            <div class="modal fade" id="add_eyeglasses_prescription" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-glasses me-1"></i>
                                {{ __('basic.new eyeglasses prescription') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form id="add_new_eyeglass_modal" class="mb-0"
                            action="{{ route('sett.eyeglasses_prescription.store') }}" method="post"
                            style="display: contents">
                            {{ method_field('POST') }}
                            {{ csrf_field() }}

                            <!-- Modal content -->
                            <div class="modal-body px-4 py-3">

                                <div class="row mb-2 justify-content-center">

                                    <div class="table-responsive">
                                        <table class="table table_border display" width="100%" cellspacing="0">
                                            <thead>
                                                <tr style="background-color: #e6e6e6;">
                                                    <td class=""></td>
                                                    <th class="text-xs text-center" colspan="3">Right Eye</th>
                                                    <th class="text-xs text-center" colspan="3">Left Eye</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr style="background-color: #e6e6e6;">
                                                    <td class=""></td>
                                                    <td class="text-center">Sph.</td>
                                                    <td class="text-center">Cyl.</td>
                                                    <td class="text-center">Axis.</td>
                                                    <td class="text-center">Sph.</td>
                                                    <td class="text-center">Cyl.</td>
                                                    <td class="text-center">Axis.</td>
                                                </tr>
                                                <tr>
                                                    <td class="">D:</td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0  w-100 select2-hidden-accessible @error('glass_right_sph') is-invalid @enderror"
                                                            id="glass_right_sph" name="glass_right_sph">
                                                            <option selected value=""></option>
                                                            @for($i = 0.25; $i <= 20.00; $i +=0.25) <option
                                                                value="-{{ number_format($i, 2) }}">
                                                                {{ "-" . number_format($i, 2) }}
                                                                </option>
                                                                @endfor
                                                                @for($i = 0.25; $i <= 20.00; $i +=0.25) <option
                                                                    value="+{{ number_format($i, 2) }}">
                                                                    {{ "+" . number_format($i, 2) }}
                                                                    </option>
                                                                    @endfor
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0   w-100 select2-hidden-accessible @error('glass_right_cyl') is-invalid @enderror"
                                                            id="glass_right_cyl" name="glass_right_cyl">
                                                            <option selected value=""></option>
                                                            @for($i = 0.25; $i <= 06.00; $i +=0.25) <option
                                                                value="-{{ number_format($i, 2) }}">
                                                                {{ "-" . number_format($i, 2) }}
                                                                </option>
                                                                @endfor
                                                                @for($i = 0.25; $i <= 06.00; $i +=0.25) <option
                                                                    value="+{{ number_format($i, 2) }}">
                                                                    {{ "+" . number_format($i, 2) }}
                                                                    </option>
                                                                    @endfor
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0   w-100 select2-hidden-accessible @error('glass_right_axis') is-invalid @enderror"
                                                            id="glass_right_axis" name="glass_right_axis">
                                                            <option selected value=""></option>
                                                            @for($i = 5; $i <= 180; $i +=5) <option value="{{ $i }}">
                                                                {{ $i }}
                                                                </option>
                                                                @endfor
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0  w-100 select2-hidden-accessible @error('glass_left_sph') is-invalid @enderror"
                                                            id="glass_left_sph" name="glass_left_sph">
                                                            <option selected value=""></option>
                                                            @for($i = 0.25; $i <= 20.00; $i +=0.25) <option
                                                                value="-{{ number_format($i, 2) }}">
                                                                {{ "-" . number_format($i, 2) }}
                                                                </option>
                                                                @endfor
                                                                @for($i = 0.25; $i <= 20.00; $i +=0.25) <option
                                                                    value="+{{ number_format($i, 2) }}">
                                                                    {{ "+" . number_format($i, 2) }}
                                                                    </option>
                                                                    @endfor
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0   w-100 select2-hidden-accessible @error('glass_left_cyl') is-invalid @enderror"
                                                            id="glass_left_cyl" name="glass_left_cyl">
                                                            <option selected value=""></option>
                                                            @for($i = 0.25; $i <= 06.00; $i +=0.25) <option
                                                                value="-{{ number_format($i, 2) }}">
                                                                {{ "-" . number_format($i, 2) }}
                                                                </option>
                                                                @endfor
                                                                @for($i = 0.25; $i <= 06.00; $i +=0.25) <option
                                                                    value="+{{ number_format($i, 2) }}">
                                                                    {{ "+" . number_format($i, 2) }}
                                                                    </option>
                                                                    @endfor
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0   w-100 select2-hidden-accessible @error('glass_left_axis') is-invalid @enderror"
                                                            id="glass_left_axis" name="glass_left_axis">
                                                            <option selected value=""></option>
                                                            @for($i = 5; $i <= 180; $i +=5) <option value="{{ $i }}">
                                                                {{ $i }}
                                                                </option>
                                                                @endfor
                                                        </select>
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class=""></td>
                                                    <td class="" colspan="3">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0  w-100 select2-hidden-accessible @error('glass_right_n_select') is-invalid @enderror"
                                                            id="glass_right_n_select" name="glass_right_n_select">
                                                            <option value="0" selected></option>
                                                            @for($i = 0.25; $i <= 20.00; $i +=0.25) <option
                                                                value="{{ number_format($i, 2) }}">
                                                                {{ "+" . number_format($i, 2) }}
                                                                </option>
                                                                @endfor
                                                        </select>
                                                    </td>

                                                    <td class="" colspan="3">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0  w-100 select2-hidden-accessible @error('glass_left_n_select') is-invalid @enderror"
                                                            id="glass_left_n_select" name="glass_left_n_select">
                                                            <option value="0" selected></option>
                                                            @for($i = 0.25; $i <= 20.00; $i +=0.25) <option
                                                                value="{{ number_format($i, 2) }}">
                                                                {{ "+" . number_format($i, 2) }}
                                                                </option>
                                                                @endfor
                                                        </select>
                                                    </td>
                                                </tr>


                                                <tr>
                                                    <td class="">N:</td>
                                                    <td class="" colspan="3">
                                                        <input id="glass_right_n" name="glass_right_n" type="text"
                                                            class="form-control w-100 border-0" readonly>
                                                    </td>

                                                    <td class="" colspan="3">
                                                        <input id="glass_left_n" name="glass_left_n" type="text"
                                                            class="form-control w-100 border-0" readonly>

                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <div class="d-flex align-items-center">
                                            <span class="me-2">IPD:</span>
                                            <input name="glass_ipd" type="text"
                                                class="form-control @error('glass_ipd') is-invalid @enderror"
                                                placeholder="Write here.." required>
                                        </div>

                                        @error('glass_ipd')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 col-md-8 mb-2">
                                        <label class="form-label">{{ __('basic.note') }}
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <textarea name="glass_note"
                                            class="form-control  @error('glass_note') is-invalid @enderror"
                                            placeholder="Write here your note .." rows="4"
                                            spellcheck="false"></textarea>
                                        <span id="glass_note_error" class="error-msg-form"></span>

                                        @error('glass_note')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 col-md-8 mb-2">
                                        <label class="form-label">{{ __('basic.date') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="glass_date" value="{{ date('Y-m-d') }}" type="text"
                                                class="form-control hasdatetimepicker @error('glass_date') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="glass_date" class="error-msg-form"></span>

                                        @error('glass_date')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 col-md-8 mb-4">
                                        <label class="form-label">{{ __('basic.appointment') }}
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <select
                                            class="myselect2-medicine-insert-nosearch select2-hidden-accessible @error('last_appointment_id_eyeglasses_pres') is-invalid @enderror"
                                            id="last_appointment_id_eyeglasses_pres"
                                            name="last_appointment_id_eyeglasses_pres">
                                            @foreach ($patient->appointments as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->start_at }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        @error('last_appointment_id_eyeglasses_pres')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>
                                </div>

                                <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">New Glasses
                                        Prescriptions</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- Modal show all  eyeglasses prescriptions -->
            <div class="modal fade" id="eyeglasses_prescription_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-glasses me-1"></i>
                                {{ __('basic.eyeglasses prescriptions') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            @foreach ($patient->eyeglasses as $item)
                            <div class="d-flex justify-content-between align-items-center mb-3">

                                <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                    <i class="fas fa-glasses me-2 fs-4 mb-0 "></i>

                                    <div class="text-truncate">
                                        <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                            {{ $item->date }}
                                        </p>
                                    </div>
                                </div>
                                <div>
                                    <a data-id="{{ $item->id }}"
                                        class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 eyeglass_delete_click"
                                        title="delete"><i class="fas fa-trash"></i>
                                    </a>
                                    <a href="{{ route('eyeglasses_prescription_print', [$patient->code, $item->code]) }}"
                                        target="_blank">
                                        <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l">{{
                                            __('basic.download') }}</span>
                                    </a>
                                </div>

                            </div>
                            @endforeach

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                    __('basic.never mind') }}</button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button id="new_attachment_modal" type="button"
                                    class="btn btn-default btn-link main-color">{{
                                    __('basic.new attachment')
                                    }}</button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal glass prescrations delete -->
            <div class="modal fade" id="eyeglasses_prescription_delete" tabindex="-1"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                {{ __('basic.delete') }}</div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="{{ route('sett.eyeglasses_prescription.destroy', " 123") }}"
                            method="post">
                            {{ method_field('delete') }}
                            {{ csrf_field() }}

                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre you sure you want to delete it?</p><br>
                                    <input type="hidden" name="eyeglass_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link text-red">{{
                                        __('basic.delete') }}
                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>


            <!----------------- show all medicines ----------------->

            <!-- Modal show all medicines -->
            <div class="modal fade" id="medicine_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                                {{ __('patientappo.current medicines') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">
                            @foreach ($patient->prescriptions as $item)
                            <div class="d-flex justify-content-between align-items-center mb-3">

                                <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                    <i class="fas fa-capsules me-2 fs-4 mb-0 "></i>

                                    <div class="text-truncate">
                                        <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                            {{ $item->date }}
                                        </p>
                                    </div>
                                </div>
                                <div>
                                    <a data-id="{{ $item->id }}"
                                        class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 medicine_delete_click"
                                        title="delete"><i class="fas fa-trash"></i>
                                    </a>
                                    <a href="{{ route('pat_patient_print_pre', [$patient->code, $item->code]) }}"
                                        target="_blank">
                                        <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l">{{
                                            __('basic.download') }}</span>
                                    </a>
                                </div>

                            </div>
                            @endforeach

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                    __('basic.never mind') }}</button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link main-color">{{ __('basic.save
                                    changes')
                                    }}</button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal Medicine insert data -->
            <div class="modal fade" id="addmedic" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                {{ __('patientappo.add new medicines') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form id="add_new_medicine_modal" class="mb-0" action="{{ route('sett.medicine.store') }}"
                            method="post" style="display: contents">
                            {{ method_field('POST') }}
                            {{ csrf_field() }}

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12" id="medicine_cont">


                                        <div class="table-responsive px-0" id="medicine_cont_table"
                                            style="display: none">
                                            <table class="table display datatable-modal border-0" width="100%"
                                                cellspacing="0">
                                                <thead>
                                                    <tr>
                                                        <th class="text-xs">{{ __('basic.name') }}</th>
                                                        <th class="text-xs text-center">{{ __('basic.status') }}</th>
                                                        <th class="text-xs text-center">{{ __('basic.doses') }}
                                                        </th>
                                                        <th class="text-xs text-center">{{ __('basic.duration') }}</th>
                                                        <th class="text-xs text-center"></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="medicine_cont_table_td">

                                                </tbody>
                                            </table>
                                        </div>


                                        <div class="text-center" id="medicine_cont_status">
                                            <h4><i class="fas fa-capsules"></i></h4>
                                            <h5 class=" text-gray-400">You have to add new medicines</h5>
                                        </div>

                                    </div>
                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.medicines') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-medicine-insert select2-hidden-accessible @error('medicine_pills') is-invalid @enderror"
                                            id="medicine_pills" name="medicine_pills" required>
                                            @foreach ($medicine_cat as $item)
                                            <option value="{{ $item->id }}" data-type="{{ $item->type->name }}"
                                                data-type_id="{{ $item->medicine_type_id }}">
                                                {{ $item->name . ' - ' . $item->price . 'EGP' }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="medicine_pills_error" class="error-msg-form"></span>

                                        @error('medicine_pills')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>


                                    <div class="col-12 mb-2">


                                        <div class="row align-items-center rtl mb-2">
                                            <div class="col-9"> <select
                                                    class="myselect2-medicine-insert-nosearch border-0 select2-hidden-accessible @error('medicine_qty') is-invalid @enderror"
                                                    id="medicine_qty" name="medicine_qty" required>
                                                    @for ($i = 1; $i < 20; $i++) <option value="{{ $i }}">
                                                        {{ $i }}
                                                        </option>
                                                        @endfor
                                                </select>
                                                @error('medicine_qty')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-3">
                                                <span class="fw-bold" id="medicine_type_text"></span>
                                            </div>
                                        </div>

                                        <div class="row align-items-center rtl mb-2">
                                            <div class="col-12"> <select
                                                    class="myselect2-medicine-insert border-0 select2-hidden-accessible @error('medicine_dose') is-invalid @enderror"
                                                    id="medicine_dose" name="medicine_dose" required>
                                                    @foreach ($med_does as $item)
                                                    <option value="{{ $item->id }}">
                                                        {{ $item->name }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                                @error('medicine_dose')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                        </div>
                                        <div class="row align-items-center rtl">
                                            <div class="col-3">
                                                <span class="fw-bold" id="medicine_type_text"> {{ __('basic.for') }}
                                                </span>
                                            </div>

                                            <div class="col-9"> <select
                                                    class="myselect2-medicine-insert border-0 select2-hidden-accessible @error('medicine_duration') is-invalid @enderror"
                                                    id="medicine_duration" name="medicine_duration" required>
                                                    @foreach ($med_durations as $item)
                                                    <option value="{{ $item->id }}">
                                                        {{ $item->name }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                                @error('medicine_duration')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <hr>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">{{ __('basic.status') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-medicine-insert-nosearch select2-hidden-accessible @error('medicine_status') is-invalid @enderror"
                                            id="medicine_status" name="medicine_status" required>
                                            <option value="0">
                                                {{ __('patientappo.on medicine') }}
                                            </option>
                                            <option value="1">
                                                {{ __('patientappo.no result') }}
                                            </option>
                                            <option value="2">
                                                {{ __('patientappo.done') }}
                                            </option>
                                        </select>

                                        <span id="medicine_status_error" class="error-msg-form"></span>

                                        @error('medicine_status')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    {{--
                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.start') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="medicine_start" type="text" id="medicine_start"
                                                class="form-control hasdatetimepicker @error('medicine_start') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="medicine_start_error" class="error-msg-form"></span>

                                        @error('medicine_start')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.end') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="medicine_end" type="text" id="medicine_end"
                                                class="form-control hasdatetimepicker @error('medicine_end') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>

                                        @error('medicine_end')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                        <span id="medicine_end_error" class="error-msg-form"></span>
                                    </div> --}}

                                     <p id="medicine_cont_status_text" class="text-red text-center"></p>

                                    <button id="add_new_medicine_prescription"
                                        class="main-color-btn border-0 b-r-l-cont p-3 mb-3"><i class="fas fa-plus"></i>
                                        Add new medicine Prescription</button>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.note') }}
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <textarea name="medicine_note"
                                            class="form-control  @error('medicine_note') is-invalid @enderror"
                                            placeholder="Write here your note .." rows="4"
                                            spellcheck="false"></textarea>
                                        <span id="medicine_note_error" class="error-msg-form"></span>

                                        @error('medicine_note')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>


                                    <div class="col-12">
                                        <label class="form-label">{{ __('basic.appointment') }}
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <select
                                            class="myselect2-medicine-insert-nosearch select2-hidden-accessible @error('last_appointment_id_medi') is-invalid @enderror"
                                            id="last_appointment_id_medi" name="last_appointment_id_medi">
                                            @foreach ($patient->appointments as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->start_at }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="last_appointment_id_medi_error" class="error-msg-form"></span>

                                        @error('last_appointment_id_medi')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                </div>

                                <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <div id="new_create_prescr_btn" class="btn btn-default btn-link main-color">Create
                                        New Prescription</div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- Modal Medicine update data -->
            <div class="modal fade" id="medicine_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                {{ __('patientappo.update medicines') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="{{ route('sett.medicine.update', '21') }}" method="POST">
                            @csrf
                            @method('PUT')

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Medicine
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-medicine-update select2-hidden-accessible @error('medicine_pills_update') is-invalid @enderror"
                                            id="medicine_pills_update" name="medicine_pills_update" required>
                                            @foreach ($medicine_cat as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->name . ' - ' . $item->price . 'EGP' }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="medicine_pills_update_error" class="error-msg-form"></span>

                                        @error('medicine_pills_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>


                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.status') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-medicine-update select2-hidden-accessible select2-no-search-medicine @error('status_medicine_update') is-invalid @enderror"
                                            id="status_medicine_update" name="status_medicine_update" required>
                                            <option value="0">
                                                On medicine
                                            </option>
                                            <option value="1">
                                                No result
                                            </option>
                                            <option value="2">
                                                Done
                                            </option>
                                        </select>

                                        <span id="status_update_update_error" class="error-msg-form"></span>

                                        @error('status_update_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.start') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="medicine_start_update" type="text"
                                                class="form-control hasdatetimepicker @error('medicine_start_update') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="medicine_start_update_error" class="error-msg-form"></span>

                                        @error('medicine_start_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.end') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="medicine_end_update" type="text"
                                                class="form-control hasdatetimepicker @error('medicine_end_update') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>

                                        @error('medicine_end_update')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                        <span id="medicine_end_update_error" class="error-msg-form"></span>
                                    </div>


                                </div>

                                <input name="medicine_id_update" value="" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Update</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- Modal delete -->
            <div class="modal fade" id="medicine_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                Medicine delete</div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="{{ route('sett.medicine.destroy', 'test') }}" method="post">
                            {{ method_field('delete') }}
                            {{ csrf_field() }}

                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">Are
                                        you sure you want to delete this prescription?</p><br>
                                    <input type="hidden" name="prescription_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link text-red">Delete
                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>