@extends('layouts.master')

@section('title', 'Lab result | Proxima - Medical Management app')

@section('title-topbar', 'Lab result')

<!-- css insert -->
@section('css')

@endsection


<!-- content insert -->
@section('content')

    <div class="container-fluid px-0 px-md-2 mt-3">

        <!-- page title link -->
        <div class="d-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">
                    {{ __('basic.dashboard') }} |</a>
                <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.lab.index') }}">
                    {{ __('basic.lab') }} | </a>
                <a class="text-gray-300">{{ __('patientappo.lab results') }}</a>
            </span>

            @if ($lab->invoice_item->invoice->status == 1)
                <div class="d-flex justify-content-center">
                    @if ($lab->status == 1)
                        <a href="{{ route('sett.lab_lab_print', $lab->id) }}"
                            class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2"><i
                                class="fas fa-download fa-sm text-gray-300 me-2"></i> {{ __('basic.print') }}</a>
                    @endif
                    <a href="{{ route('sett.lab.edit', $lab->id) }}"
                        class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i
                            class="fas fa-marker fa-sm text-gray-300 me-1"></i> {{ __('basic.edit') }}</a>

                </div>
            @endif

        </div>

        <div class="card card-input shadow mb-3 pb-3">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-x-ray me-1"></i>
                    {{ __('patientappo.lab result') }}
                </h6>
            </div>


            <!-- Card Body -->
            <div class="card-body px-4 px-md-5">

                <div class="row mb-1">

                    <div class="col-12 col-md-7 mb-2 pt-3 border-flex">

                        <div class="row mb-4">
                            <div class="col-8">
                                <div class="d-flex mb-2 align-items-center">

                                    <img class="rounded-circle avatar-lg me-3"
                                        src="{{ URL::asset('img/useravatar/' . $lab->patient->avatar) }}">
                                    <div class="">
                                        <p class=" mb-0 text-xs text-gray-300">
                                            {{ __('basic.patient') }}</p>
                                        <a class="mb-1 fw-bold fs-5 text-gray-600"
                                            href="{{ route('sett.patient.show', $lab->patient->id) }}">
                                            {{ $lab->patient->name }}</a>
                                        <p class="mb-0 text-xs text-gray-400">{{ __('basic.id') }} <strong>
                                                {{ $lab->patient->id }}</strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="container-fluid px-0 text-center">
                                    <div class="visible-print text-center">
                                        {!! QrCode::color(68, 95, 129)->size(80)->style('round')->eye('circle')->generate($lab->code) !!}
                                        <p class="mt-1 mb-0 text-s fw-bold text-gray-300">{{ $lab->code }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col">
                                <h6 class="text-gray-300 text-xs mb-1"> {{ __('basic.name') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ $lab->service_item->name }}
                                </p>
                            </div>
                            <div class="col">
                                <h6 class="text-gray-300 text-xs mb-1"> {{ __('basic.branch') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ $lab->branch->name }}
                                </p>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col">
                                <h6 class="text-gray-300 text-s mb-1"> {{ __('basic.created') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ date('d M Y h:i a', strtotime($lab->created_at)) }}
                                </p>
                            </div>
                            <div class="col">
                                <h6 class="text-gray-300 text-s mb-1"> {{ __('patientappo.appointment date') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ date('d M Y h:i a', strtotime($lab->appointment->start_at)) }}
                                </p>
                            </div>

                        </div>

                        <div class="row mb-2">
                            <div class="col">
                                @if ($lab->invoice_item->invoice->status == 0)
                                    @php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = __('basic.not paid');
                                    @endphp
                                @elseif ($lab->invoice_item->invoice->status == 1)
                                    @php
                                        $text_color_invoice = 'pend-color-btn';
                                        $msg_invoice = __('basic.pending');
                                    @endphp
                                @elseif ($lab->invoice_item->invoice->status == 2)
                                    @php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('basic.paid');
                                    @endphp
                                @endif

                                <h6 class="text-gray-300 text-s mb-2">{{ __('basic.payment status') }}</h6>
                                <span
                                    class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{ $msg_invoice }}</span>
                            </div>
                            <div class="col">
                                <h6 class="text-gray-300 text-s mb-1">{{ __('basic.payment code') }}</h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    {{ $lab->invoice_item->invoice->code }}
                                </p>
                            </div>
                        </div>

                    </div>

                    <div class="col-12 col-md-5 align-self-center mb-2">
                        <div class="avatar-update-container" style="cursor: auto !important;">


                            @if (!empty($lab->xray_file))
                                <div class="picture picture-lab mb-3">

                                    <img src="{{ URL::asset('img/lab/' . $lab->xray_file) }}" class="picture-src"
                                        id="mib_PicturePreview" title="" />
                                </div>
                                <a href="{{ URL::asset('img/lab/' . $lab->xray_file) }}">
                                    <span class="text-s badge rounded-pill active-color-btn badge-padd-l"><i
                                            class="fas fa-arrow-circle-down me-1"></i>{{ __('basic.download') }}</span>
                                </a>
                            @else
                                <div class="picture picture-lab mb-3">

                                    <img src="{{ URL::asset('img/dashboard/cloud-upload-1912186-1617655.png') }}"
                                        class="picture-src" id="mib_PicturePreview" title="" />
                                </div>

                                <a>
                                    <span class="text-s badge rounded-pill active-color-btn badge-padd-l"></i>No File
                                        Uploaded yet</span>
                                </a>
                            @endif

                        </div>
                    </div>


                </div>

                <hr>

                <div class="row mb-2">
                    <div class="col">
                        @if ($lab->status == 0)
                            @php
                                $text_color = 'cancel-color-btn';
                                $msg = 'Not Done';
                            @endphp
                        @elseif ($lab->status == 1)
                            @php
                                $text_color = 'done-color-btn';
                                $msg = 'Done';
                            @endphp
                        @endif

                        <h6 class="text-gray-300 text-s mb-2">{{ __('basic.status') }}</h6>
                        <span class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg }}</span>
                    </div>
                    <div class="col">
                        <h6 class="text-gray-300 text-s mb-1">{{ __('basic.responsible doctor') }}</h6>
                        <p class="text-gray-600 text-s fw-bold">
                            @isset($lab->doctor->name)
                                {{ $lab->doctor->name }}
                            @endisset
                        </p>
                    </div>
                </div>

                <hr>

                <div class="row mb-2">
                    <div class="col-12 col-md-6 mb-2">
                        <label class="form-label">{{ __('basic.doctor note') }}</label>
                        <div class="form-control-textarea overflow-auto">
                            {{ $lab->note_doctor }}</div>
                    </div>
                    <div class="col-12 col-md-6 mb-2">
                        <label class="form-label">{{ __('patientappo.lab note') }}</label>
                        <div class="form-control-textarea overflow-auto">
                            {{ $lab->note_lab }}</div>
                    </div>

                </div>
            </div>

        </div>

    </div>

@endsection

<!-- js insert -->
@section('js')

@endsection
