@extends('layouts.master')

@section('title', 'Statistics | Proxima - Medical Management app')

@section('title-topbar', 'Statistics')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">
<link rel="stylesheet"
    href="https://nightly.datatables.net/fixedheader/css/fixedHeader.dataTables.css?_=f0de745b101295e88f1504c17177ff49.css"
    type="text/css" />

@endsection

<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">

        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.invoice.index') }}">Invoice | </a>
            <a class="text-gray-300">Year invoices</a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">
            <div class="cont-branch-calendar me-2">
                <select id="select-specialty-calendar"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    <option value="all">
                        All
                    </option>
                    @foreach ($specialty_cat as $item)
                    <option value="{{ $item->id }}" @if ($specialty==$item->id) selected @endif>
                        {{ $item->name }}
                    </option>
                    @endforeach
                </select>
            </div>

            <div class="cont-branch-calendar me-2">
                <select id="select-branch-calendar"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    <option value="all">
                        All
                    </option>
                    @foreach ($branches as $item)
                    <option value="{{ $item->id }}" @if ($branch==$item->id) selected @endif>
                        {{ $item->name }}
                    </option>
                    @endforeach
                </select>
            </div>

            <div class="calendar-datepicker">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                    </div>
                    <input id="calendar-date-input" type="text" value="{{ $date }}"
                        class="form-control hasdatetimepicker " placeholder="YYYY">
                </div>
            </div>
        </div>

    </div>

    <div class="row mb-4">
        <ul class="nav nav-tabs nav-tabs-nobg nav-tabs-cat justify-content-center pe-0" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.invo_day_search') }}" class="nav-link" id="year_invoice-tab">
                    {{ __('basic.daily st') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.invo_month_search') }}" class="nav-link" id="specialty-tab">
                    {{ __('basic.monthly st') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.invo_year_search') }}" class="nav-link active" id="specialty-tab">
                    {{ __('basic.yearly st') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.invo_allstatcs') }}" class="nav-link" id="specialty-tab">
                    {{ __('basic.statistics') }}</a>
            </li>
        </ul>
    </div>

    <div class="tab-content" id="myTabContent">

        <div class="tab-pane fade show active" id="year_invoice" role="tabpanel" aria-labelledby="year_invoice">

            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Total yearly Income</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="row">
                                <div class="col-12 mb-4">
                                    <canvas id="income_line">
                                        <!-- the code and its style is printed from js -->
                                    </canvas>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <table class="table display datatable-modal" id="table-income-totals-cat"
                                            width="100%" cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th class="text-xs text-center">Name</th>
                                                    <th class="text-xs text-center">Jan</th>
                                                    <th class="text-xs text-center">Feb</th>
                                                    <th class="text-xs text-center">Mar</th>
                                                    <th class="text-xs text-center">Apr</th>
                                                    <th class="text-xs text-center">May</th>
                                                    <th class="text-xs text-center">Jun</th>
                                                    <th class="text-xs text-center">Jul</th>
                                                    <th class="text-xs text-center">Aug</th>
                                                    <th class="text-xs text-center">Sep</th>
                                                    <th class="text-xs text-center">Oct</th>
                                                    <th class="text-xs text-center">Nov</th>
                                                    <th class="text-xs text-center">Dec</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                @php
                                                $m1 = 0;
                                                $m2 = 0;
                                                $m3 = 0;
                                                $m4 = 0;
                                                $m5 = 0;
                                                $m6 = 0;
                                                $m7 = 0;
                                                $m8 = 0;
                                                $m9 = 0;
                                                $m10 = 0;
                                                $m11 = 0;
                                                $m12 = 0;
                                                @endphp
                                                @foreach ($income_items as $item)
                                                <tr>
                                                    <td class="text-center text-truncate">
                                                        {{ $item->name }}
                                                    </td>
                                                    @foreach ($item->total as $item_total)
                                                    <td class="text-center">
                                                        @php

                                                        @endphp
                                                        {{ $item_total }} <small class="text-gray-300 text-xxxs">
                                                            EGP</small>
                                                    </td>
                                                    @endforeach

                                                    @php
                                                    $m1 += $item->total[0];
                                                    $m2 += $item->total[1];
                                                    $m3 += $item->total[2];
                                                    $m4 += $item->total[3];
                                                    $m5 += $item->total[4];
                                                    $m6 += $item->total[5];
                                                    $m7 += $item->total[6];
                                                    $m8 += $item->total[7];
                                                    $m9 += $item->total[8];
                                                    $m10 += $item->total[9];
                                                    $m11 += $item->total[10];
                                                    $m12 += $item->total[11];
                                                    @endphp
                                                </tr>
                                                @endforeach


                                            </tbody>

                                            <tfoot>
                                                <tr>
                                                    <th class="text-center fw-bold text-s">TOTAL</th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m1 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m2 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m3 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m4 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m5 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m6 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m7 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m8 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m9 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m10 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m11 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m12 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                    </div>

                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Total yearly Expenses</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="row">
                                <div class="col-12 mb-4">
                                    <canvas id="expenses_line">
                                        <!-- the code and its style is printed from js -->
                                    </canvas>
                                </div>
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <table class="table display datatable-modal" id="table-expenses-totals-cat"
                                            width="100%" cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th class="text-xs text-center">Name</th>
                                                    <th class="text-xs text-center">Jan</th>
                                                    <th class="text-xs text-center">Feb</th>
                                                    <th class="text-xs text-center">Mar</th>
                                                    <th class="text-xs text-center">Apr</th>
                                                    <th class="text-xs text-center">May</th>
                                                    <th class="text-xs text-center">Jun</th>
                                                    <th class="text-xs text-center">Jul</th>
                                                    <th class="text-xs text-center">Aug</th>
                                                    <th class="text-xs text-center">Sep</th>
                                                    <th class="text-xs text-center">Oct</th>
                                                    <th class="text-xs text-center">Nov</th>
                                                    <th class="text-xs text-center">Dec</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                @php
                                                $m1 = 0;
                                                $m2 = 0;
                                                $m3 = 0;
                                                $m4 = 0;
                                                $m5 = 0;
                                                $m6 = 0;
                                                $m7 = 0;
                                                $m8 = 0;
                                                $m9 = 0;
                                                $m10 = 0;
                                                $m11 = 0;
                                                $m12 = 0;
                                                @endphp
                                                @foreach ($expenses_items as $item)
                                                <tr>
                                                    <td class="text-center text-truncate">
                                                        {{ $item->name }}
                                                    </td>
                                                    @foreach ($item->total as $item_total)
                                                    <td class="text-center">
                                                        @php

                                                        @endphp
                                                        {{ $item_total }} <small class="text-gray-300 text-xxxs">
                                                            EGP</small>
                                                    </td>
                                                    @endforeach

                                                    @php
                                                    $m1 += $item->total[0];
                                                    $m2 += $item->total[1];
                                                    $m3 += $item->total[2];
                                                    $m4 += $item->total[3];
                                                    $m5 += $item->total[4];
                                                    $m6 += $item->total[5];
                                                    $m7 += $item->total[6];
                                                    $m8 += $item->total[7];
                                                    $m9 += $item->total[8];
                                                    $m10 += $item->total[9];
                                                    $m11 += $item->total[10];
                                                    $m12 += $item->total[11];
                                                    @endphp
                                                </tr>
                                                @endforeach
                                            </tbody>

                                            <tfoot>
                                                <tr>
                                                    <th class="text-center fw-bold text-s">TOTAL</th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m1 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m2 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m3 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m4 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m5 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m6 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m7 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m8 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m9 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m10 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m11 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s2">
                                                        {{ $m12 }} <small class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>


        <div class="tab-pane fade" id="specialty_stat" role="tabpanel" aria-labelledby="specialty-tab">

            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Income totals cat</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">


                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Expenses totals cat</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">



                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Income totals by items</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Expenses totals by items
                            </h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="operation_tab" role="tabpanel" aria-labelledby="operation-tab">


            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i>Operation income invoices
                            </h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i>Operation expenses invoices
                            </h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">


                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>


    @endsection


    <!-- js insert -->
    @section('js')

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
                $('.js-example-basic-single').select2();
                //hide search
                $('.select2-no-search').select2({
                    minimumResultsForSearch: -1
                });
            });
    </script>

    <script>
        $(document).ready(function() {

                //--------------------- selectors -------------------
                $(document).on('change', '#select-specialty-calendar, #select-branch-calendar', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-specialty-calendar').val();
                    var date2 = $('#select-branch-calendar').val();

                    var url = "{{ route('sett.invo_year_search', [':date_input', ':date', ':date2']) }}";

                    url = url.replace(':date_input', date_input).replace(':date', date).replace(':date2',
                        date2);

                    var url = url;
                    window.location.href = url;
                });
                $(document).on('change', '#calendar-date-input', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-specialty-calendar').val();
                    var date2 = $('#select-branch-calendar').val();

                    var url = "{{ route('sett.invo_year_search', [':date_input', ':date', ':date2']) }}";

                    url = url.replace(':date_input', date_input).replace(':date', date).replace(':date2',
                        date2);

                    window.location.href = url;
                });
            });
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "yyyy",
                    viewMode: "years",
                    minViewMode: "years"
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>
    @php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2'];
    @endphp
    <script>
        // Area Chart for each branch
            var ctx = document.getElementById("income_line");
            var myLineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [
                        @php
                            $i = 0;
                        @endphp
                        @foreach ($income_items as $item)
                            {
                                label: "{{ $item->name }}",
                                lineTension: 0.5,
                                backgroundColor: '{{ $chart_color[$i] }}',
                                borderColor: '{{ $chart_color[$i] }}',
                                pointRadius: 3,
                                pointBackgroundColor: '{{ $chart_color[$i] }}',
                                pointBorderColor: '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                                pointHoverRadius: 3,
                                pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                                pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                                pointHitRadius: 10,
                                pointBorderWidth: 2,
                                data: [
                                    @foreach ($item->total as $item4)
                                        {{ $item4 . ',' }}
                                    @endforeach
                                ],
                            },
                        @endforeach

                    ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: true
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });

            // Area Chart for each branch
            var ctx = document.getElementById("expenses_line");
            var myLineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [
                        @php
                            $i = 0;
                        @endphp
                        @foreach ($expenses_items as $item)
                            {
                                label: "{{ $item->name }}",
                                lineTension: 0.5,
                                backgroundColor: '{{ $chart_color[$i] }}',
                                borderColor: '{{ $chart_color[$i] }}',
                                pointRadius: 3,
                                pointBackgroundColor: '{{ $chart_color[$i] }}',
                                pointBorderColor: '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                                pointHoverRadius: 3,
                                pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                                pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                                pointHitRadius: 10,
                                pointBorderWidth: 2,
                                data: [
                                    @foreach ($item->total as $item4)
                                        {{ $item4 . ',' }}
                                    @endforeach
                                ],
                            },
                        @endforeach

                    ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: true
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });
    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>
    <script
        src="https://nightly.datatables.net/fixedheader/js/dataTables.fixedHeader.js?_=f0de745b101295e88f1504c17177ff49">
    </script>

    <script>
        $(document).ready(function() {

                var table = $('#table-income-all').DataTable({
                        lengthChange: false,
                        "pageLength": 10,
                        "order": [
                            [0, "ASC"]
                        ],
                        buttons: {
                            dom: {
                                button: {
                                    className: 'btn btn-table-export me-0' //Primary class for all buttons
                                }
                            },
                            buttons: [{
                                    extend: 'copyHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'excelHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'print',
                                    footer: true
                                }
                            ]
                        }
                    }

                );
                table.buttons().container()
                    .appendTo('#table-income-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-operation-income-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-income-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-operation-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-expenses-all_wrapper .col-md-6:eq(0)');

            });
    </script>

    @endsection